/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.EuHouToolbar;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import ij.util.Tools;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class Executer
implements Runnable {
    private static String previousCommand;
    private String command;
    private Thread thread;
    private static ResourceBundle menubun;
    private static ResourceBundle etiq;

    public Executer(String cmd) {
        this.command = cmd;
    }

    public Executer(String cmd, ImagePlus ignored) {
        if (cmd.startsWith("Repeat")) {
            this.command = previousCommand;
            IJ.setKeyUp(16);
        } else {
            this.command = cmd;
            if (!cmd.equals("Undo") && !cmd.equals("Close")) {
                previousCommand = cmd;
            }
        }
        IJ.resetEscape();
        this.thread = new Thread((Runnable)this, cmd);
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
        menubun = IJ.getBundle();
    }

    @Override
    public void run() {
        block10: {
            if (this.command == null) {
                return;
            }
            try {
                if (Recorder.record) {
                    Recorder.setCommand(this.command);
                    this.runCommand(this.command);
                    Recorder.saveCommand();
                } else {
                    this.runCommand(this.command);
                }
            }
            catch (Throwable e) {
                IJ.showStatus("");
                IJ.showProgress(1.0);
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp != null) {
                    imp.unlock();
                }
                String msg = e.getMessage();
                if (e instanceof OutOfMemoryError) {
                    IJ.outOfMemory(this.command);
                }
                if (e instanceof RuntimeException && msg != null && msg.equals("Macro canceled")) break block10;
                CharArrayWriter caw = new CharArrayWriter();
                PrintWriter pw = new PrintWriter(caw);
                e.printStackTrace(pw);
                String s = caw.toString();
                if (IJ.isMacintosh()) {
                    if (s.indexOf("ThreadDeath") > 0) {
                        return;
                    }
                    s = Tools.fixNewLines(s);
                }
                if (IJ.getInstance() != null) {
                    new TextWindow("Exception", s, 350, 250);
                }
                IJ.log(s);
            }
        }
    }

    void runCommand(String cmd) {
        Hashtable table = Menus.getCommands();
        String className = new String();
        String[] cN = new String[2];
        EuHouToolbar etb = new EuHouToolbar();
        String PhotometerGood = "";
        String ClearPhotometerGood = "";
        String PhotometrySettingsGood = "";
        String menubunGood = "";
        String addPluginItemGood = "";
        System.out.println("Executer avant if1 cmd: " + cmd);
        try {
            System.out.println("Executer 1");
            PhotometerGood = menubun.getString("Photometer");
        }
        catch (Exception exp) {
            // empty catch block
        }
        try {
            System.out.println("Executer 2");
            ClearPhotometerGood = menubun.getString("ClearPhotometer");
        }
        catch (Exception exp) {
            // empty catch block
        }
        try {
            System.out.println("Executer 3");
            PhotometrySettingsGood = menubun.getString("PhotometrySettings");
        }
        catch (Exception exp) {
            // empty catch block
        }
        try {
            System.out.println("Executer 4");
            addPluginItemGood = EuHouToolbar.addPluginItem(cmd);
            System.out.println("Executer addPluginItemGood: " + addPluginItemGood);
        }
        catch (Exception exp) {
            // empty catch block
        }
        try {
            System.out.println("Executer 5");
            menubunGood = menubun.getString(cmd);
            System.out.println("Executer menubunGood: " + menubunGood);
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (cmd.equals(PhotometerGood) || cmd.equals("Photometer")) {
            EuHouToolbar.getInstance().photometerButtonAction();
        } else if (cmd.equals(ClearPhotometerGood) || cmd.equals("ClearPhotometer")) {
            EuHouToolbar.getInstance();
            EuHouToolbar.clearPhotometer();
        } else if (cmd.equals(PhotometrySettingsGood) || cmd.equals("PhotometrySettings")) {
            EuHouToolbar.getInstance().settingsAction();
        } else if (table.get(cmd) != null) {
            className = (String)table.get(cmd);
        } else if (addPluginItemGood != "") {
            className = (String)table.get(addPluginItemGood);
        } else if (menubunGood != "") {
            className = (String)table.get(menubunGood);
        }
        System.out.println("Executer apres if cmd: " + cmd + " , className: " + className);
        if (className != null) {
            String arg = "";
            if (className.endsWith("\")")) {
                int argStart = className.lastIndexOf("(\"");
                System.out.println("arg :" + arg);
                if (argStart > 0) {
                    arg = className.substring(argStart + 2, className.length() - 2);
                    className = className.substring(0, argStart);
                }
            }
            if (IJ.shiftKeyDown() && className.startsWith("ij.plugin.Macro_Runner")) {
                IJ.open(IJ.getDirectory("plugins") + arg);
                IJ.setKeyUp(16);
            } else {
                IJ.runPlugIn(cmd, className, arg);
            }
        } else {
            if (MacroInstaller.runMacroCommand(cmd)) {
                return;
            }
            String path = Prefs.getHomeDir() + File.separator + "luts" + File.separator + cmd + ".lut";
            File f = new File(path);
            if (f.exists()) {
                IJ.open(path);
            } else {
                IJ.error(etiq.getString("UnrecCmdErr") + " " + cmd);
            }
        }
    }

    public static String getCommand() {
        return previousCommand;
    }
}

