/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.Opener;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;

public class VirtualStack
extends ImageStack {
    static final int INITIAL_SIZE = 100;
    String path;
    int nSlices;
    String[] names;

    public VirtualStack(int width, int height, ColorModel cm, String path) {
        super(width, height, cm);
        this.path = path;
        this.names = new String[100];
    }

    public void addSlice(String name) {
        if (name == null) {
            throw new IllegalArgumentException("'name' is null!");
        }
        ++this.nSlices;
        if (this.nSlices == this.names.length) {
            String[] tmp = new String[this.nSlices * 2];
            System.arraycopy(this.names, 0, tmp, 0, this.nSlices);
            this.names = tmp;
        }
        this.names[this.nSlices - 1] = name;
    }

    @Override
    public void addSlice(String sliceLabel, Object pixels) {
    }

    @Override
    public void addSlice(String sliceLabel, ImageProcessor ip) {
    }

    @Override
    public void addSlice(String sliceLabel, ImageProcessor ip, int n) {
    }

    @Override
    public void deleteSlice(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.nSlices < 1) {
            return;
        }
        for (int i = n; i < this.nSlices; ++i) {
            this.names[i - 1] = this.names[i];
        }
        this.names[this.nSlices - 1] = null;
        --this.nSlices;
    }

    @Override
    public void deleteLastSlice() {
        if (this.nSlices > 0) {
            this.deleteSlice(this.nSlices);
        }
    }

    @Override
    public Object getPixels(int n) {
        ImageProcessor ip = this.getProcessor(n);
        if (ip != null) {
            return ip.getPixels();
        }
        return null;
    }

    @Override
    public void setPixels(Object pixels, int n) {
    }

    @Override
    public ImageProcessor getProcessor(int n) {
        ImagePlus imp = new Opener().openImage(this.path, this.names[n - 1]);
        if (imp == null) {
            return null;
        }
        int w = imp.getWidth();
        int h = imp.getHeight();
        int type = imp.getType();
        ColorModel cm = imp.getProcessor().getColorModel();
        return imp.getProcessor();
    }

    @Override
    public int getSize() {
        return this.nSlices;
    }

    @Override
    public String getSliceLabel(int n) {
        return this.names[n - 1];
    }

    @Override
    public Object[] getImageArray() {
        return null;
    }

    @Override
    public void setSliceLabel(String label, int n) {
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public void trim() {
    }

    public String getDirectory() {
        return this.path;
    }

    public String getFileName(int n) {
        return this.names[n - 1];
    }
}

