/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Undo;
import ij.gui.HistogramWindow;
import ij.gui.ImageWindow;
import ij.gui.PlotWindow;
import ij.macro.Interpreter;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.MenuItem;
import java.util.Vector;

public class WindowManager {
    private static Vector imageList = new Vector();
    private static Vector nonImageList = new Vector();
    private static ImageWindow currentWindow;
    private static Frame frontWindow;
    private static ImagePlus tempCurrentImage;
    public static boolean checkForDuplicateName;

    private WindowManager() {
    }

    public static void setCurrentWindow(ImageWindow win) {
        ImagePlus imp;
        if (win == null || win.isClosed() || win.getImagePlus() == null) {
            return;
        }
        WindowManager.setWindow(win);
        tempCurrentImage = null;
        if (win == currentWindow || imageList.size() == 0) {
            return;
        }
        if (currentWindow != null && (imp = currentWindow.getImagePlus()) != null) {
            imp.trimProcessor();
            imp.saveRoi();
        }
        Undo.reset();
        currentWindow = win;
        Menus.updateMenus();
    }

    public static ImageWindow getCurrentWindow() {
        return currentWindow;
    }

    static int getCurrentIndex() {
        return imageList.indexOf(currentWindow);
    }

    public static ImagePlus getCurrentImage() {
        if (tempCurrentImage != null) {
            return tempCurrentImage;
        }
        if (currentWindow != null) {
            return currentWindow.getImagePlus();
        }
        if (frontWindow != null && frontWindow instanceof ImageWindow) {
            return ((ImageWindow)frontWindow).getImagePlus();
        }
        if (imageList.size() > 0) {
            ImageWindow win = (ImageWindow)imageList.elementAt(imageList.size() - 1);
            return win.getImagePlus();
        }
        return Interpreter.getLastBatchModeImage();
    }

    public static int getWindowCount() {
        int count = imageList.size();
        if (count == 0 && tempCurrentImage != null) {
            count = 1;
        }
        return count;
    }

    public static int getImageCount() {
        int count = imageList.size();
        if ((count += Interpreter.getBatchModeImageCount()) == 0 && tempCurrentImage != null) {
            count = 1;
        }
        return count;
    }

    public static Frame getFrontWindow() {
        return frontWindow;
    }

    public static synchronized int[] getIDList() {
        int[] batchModeImages;
        int nBatchImages;
        int nWindows = imageList.size();
        if (nWindows + (nBatchImages = (batchModeImages = Interpreter.getBatchModeImageIDs()).length) == 0) {
            return null;
        }
        int[] list = new int[nWindows + nBatchImages];
        for (int i = 0; i < nBatchImages; ++i) {
            list[i] = batchModeImages[i];
        }
        int index = 0;
        for (int i = nBatchImages; i < nBatchImages + nWindows; ++i) {
            ImageWindow win = (ImageWindow)imageList.elementAt(index++);
            list[i] = win.getImagePlus().getID();
        }
        return list;
    }

    public static synchronized Frame[] getNonImageWindows() {
        Object[] list = new Frame[nonImageList.size()];
        nonImageList.copyInto(list);
        return list;
    }

    public static synchronized ImagePlus getImage(int imageID) {
        if (imageID > 0) {
            imageID = WindowManager.getNthImageID(imageID);
        }
        if (imageID == 0 || WindowManager.getImageCount() == 0) {
            return null;
        }
        ImagePlus imp2 = Interpreter.getBatchModeImage(imageID);
        if (imp2 != null) {
            return imp2;
        }
        ImagePlus imp = null;
        for (int i = 0; i < imageList.size(); ++i) {
            ImageWindow win = (ImageWindow)imageList.elementAt(i);
            imp2 = win.getImagePlus();
            if (imageID != imp2.getID()) continue;
            imp = imp2;
            break;
        }
        if (imp == null && tempCurrentImage != null && tempCurrentImage.getID() == imageID) {
            return tempCurrentImage;
        }
        return imp;
    }

    public static synchronized int getNthImageID(int n) {
        if (n <= 0) {
            return 0;
        }
        if (Interpreter.isBatchMode()) {
            int[] list = WindowManager.getIDList();
            if (n > list.length) {
                return 0;
            }
            return list[n - 1];
        }
        if (n > imageList.size()) {
            return 0;
        }
        ImageWindow win = (ImageWindow)imageList.elementAt(n - 1);
        if (win != null) {
            return win.getImagePlus().getID();
        }
        return 0;
    }

    public static synchronized ImagePlus getImage(String title) {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            return null;
        }
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp == null || !imp.getTitle().equals(title)) continue;
            return imp;
        }
        return null;
    }

    public static synchronized void addWindow(Frame win) {
        if (win == null) {
            return;
        }
        if (win instanceof ImageWindow) {
            WindowManager.addImageWindow((ImageWindow)win);
        } else {
            Menus.insertWindowMenuItem(win);
            nonImageList.addElement(win);
        }
    }

    private static void addImageWindow(ImageWindow win) {
        ImagePlus imp = win.getImagePlus();
        if (imp == null) {
            return;
        }
        WindowManager.checkForDuplicateName(imp);
        imageList.addElement(win);
        Menus.addWindowMenuItem(imp);
        WindowManager.setCurrentWindow(win);
    }

    static void checkForDuplicateName(ImagePlus imp) {
        String name;
        if (checkForDuplicateName && WindowManager.isDuplicateName(name = imp.getTitle())) {
            imp.setTitle(WindowManager.getUniqueName(name));
        }
        checkForDuplicateName = false;
    }

    static boolean isDuplicateName(String name) {
        int n = imageList.size();
        for (int i = 0; i < n; ++i) {
            ImageWindow win = (ImageWindow)imageList.elementAt(i);
            String name2 = win.getImagePlus().getTitle();
            if (!name.equals(name2)) continue;
            return true;
        }
        return false;
    }

    public static String getUniqueName(String name) {
        int lastDash;
        String name2 = name;
        String extension = "";
        int len = name2.length();
        int lastDot = name2.lastIndexOf(".");
        if (lastDot != -1 && len - lastDot < 6 && lastDot != len - 1) {
            extension = name2.substring(lastDot, len);
            name2 = name2.substring(0, lastDot);
        }
        if ((lastDash = name2.lastIndexOf("-")) != -1 && name2.length() - lastDash < 4) {
            name2 = name2.substring(0, lastDash);
        }
        for (int i = 1; i <= 99; ++i) {
            String name3 = name2 + "-" + i + extension;
            if (WindowManager.isDuplicateName(name3)) continue;
            return name3;
        }
        return name;
    }

    public static String makeUniqueName(String name) {
        return WindowManager.isDuplicateName(name) ? WindowManager.getUniqueName(name) : name;
    }

    public static synchronized void removeWindow(Frame win) {
        if (win instanceof ImageWindow) {
            WindowManager.removeImageWindow((ImageWindow)win);
        } else {
            int index = nonImageList.indexOf(win);
            ImageJ ij = IJ.getInstance();
            if (index >= 0) {
                Menus.removeWindowMenuItem(index);
                nonImageList.removeElement(win);
            }
        }
        WindowManager.setWindow(null);
    }

    private static void removeImageWindow(ImageWindow win) {
        int index = imageList.indexOf(win);
        if (index == -1) {
            return;
        }
        if (imageList.size() > 1) {
            int newIndex = index - 1;
            if (newIndex < 0) {
                newIndex = imageList.size() - 1;
            }
            WindowManager.setCurrentWindow((ImageWindow)imageList.elementAt(newIndex));
        } else {
            currentWindow = null;
        }
        imageList.removeElementAt(index);
        tempCurrentImage = null;
        int nonImageCount = nonImageList.size();
        if (nonImageCount > 0) {
            ++nonImageCount;
        }
        Menus.removeWindowMenuItem(nonImageCount + index);
        Menus.updateMenus();
        Undo.reset();
    }

    public static void setWindow(Frame win) {
        frontWindow = win;
    }

    public static synchronized boolean closeAllWindows() {
        while (imageList.size() > 0) {
            if (!((ImageWindow)imageList.elementAt(0)).close()) {
                return false;
            }
            IJ.wait(100);
        }
        ImageJ ij = IJ.getInstance();
        if (ij != null && ij.quitting() && IJ.getApplet() == null) {
            return true;
        }
        Frame[] list = WindowManager.getNonImageWindows();
        for (int i = 0; i < list.length; ++i) {
            Frame frame = list[i];
            if (frame instanceof PlugInFrame) {
                ((PlugInFrame)frame).close();
                continue;
            }
            if (frame instanceof TextWindow) {
                ((TextWindow)frame).close();
                continue;
            }
            frame.setVisible(false);
            frame.dispose();
        }
        return true;
    }

    public static void putBehind() {
        ImageWindow win;
        if (IJ.debugMode) {
            IJ.log("putBehind");
        }
        if (imageList.size() < 1 || currentWindow == null) {
            return;
        }
        int index = imageList.indexOf(currentWindow);
        int count = 0;
        do {
            if (--index < 0) {
                index = imageList.size() - 1;
            }
            win = (ImageWindow)imageList.elementAt(index);
            if (++count != imageList.size()) continue;
            return;
        } while (win instanceof HistogramWindow || win instanceof PlotWindow);
        WindowManager.setCurrentWindow(win);
        win.toFront();
        Menus.updateMenus();
    }

    public static void setTempCurrentImage(ImagePlus imp) {
        tempCurrentImage = imp;
    }

    public static ImagePlus getTempCurrentImage() {
        return tempCurrentImage;
    }

    public static Frame getFrame(String title) {
        for (int i = 0; i < nonImageList.size(); ++i) {
            Frame frame = (Frame)nonImageList.elementAt(i);
            if (!title.equals(frame.getTitle())) continue;
            return frame;
        }
        int[] wList = WindowManager.getIDList();
        int len = wList != null ? wList.length : 0;
        for (int i = 0; i < len; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp == null || !imp.getTitle().equals(title)) continue;
            return imp.getWindow();
        }
        return null;
    }

    public static Vector getImageWindows() {
        return imageList;
    }

    public static synchronized void activateWindow(String title) {
        for (int j = 4; j < Menus.window.getItemCount(); ++j) {
            try {
                if (!((CheckboxMenuItem)Menus.window.getItem(j)).getState()) continue;
                WindowManager.activateWindow(title, Menus.window.getItem(j));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static synchronized void activateWindow(String menuItemLabel, MenuItem item) {
        for (int i = 0; i < nonImageList.size(); ++i) {
            Frame win = (Frame)nonImageList.elementAt(i);
            String title = win.getTitle();
            if (!menuItemLabel.equals(title)) continue;
            win.toFront();
            ((CheckboxMenuItem)item).setState(false);
            if (Recorder.record) {
                Recorder.record("selectWindow", title);
            }
            return;
        }
        int lastSpace = menuItemLabel.lastIndexOf(32);
        if (lastSpace > 0) {
            menuItemLabel = menuItemLabel.substring(0, lastSpace);
        }
        for (int i = 0; i < imageList.size(); ++i) {
            int start;
            ImageWindow win = (ImageWindow)imageList.elementAt(i);
            String title = win.getImagePlus().getTitle();
            if (!menuItemLabel.equals(title)) continue;
            WindowManager.setCurrentWindow(win);
            win.toFront();
            int index = imageList.indexOf(win);
            int n = Menus.window.getItemCount();
            for (int j = start = 5 + Menus.windowMenuItems2; j < n; ++j) {
                MenuItem mi = Menus.window.getItem(j);
                ((CheckboxMenuItem)mi).setState(j - start == index);
            }
            if (!Recorder.record) break;
            Recorder.record("selectWindow", title);
            break;
        }
    }

    public static synchronized void repaintImageWindows() {
        int[] list = WindowManager.getIDList();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            ImageWindow win;
            ImagePlus imp2 = WindowManager.getImage(list[i]);
            if (imp2 == null || (win = imp2.getWindow()) == null) continue;
            win.repaint();
        }
    }

    static void showList() {
        if (IJ.debugMode) {
            for (int i = 0; i < imageList.size(); ++i) {
                ImageWindow win = (ImageWindow)imageList.elementAt(i);
                ImagePlus imp = win.getImagePlus();
                IJ.log(i + " " + imp.getTitle() + (win == currentWindow ? "*" : ""));
            }
            IJ.log(" ");
        }
    }
}

