/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.PhotometerParams;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.Recorder;
import ij.process.Photometer;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class EuHouToolbar
extends Canvas
implements MouseListener,
MouseMotionListener {
    public static final int OPEN = 0;
    public static final int SAVE = 1;
    public static final int UNDO = 2;
    public static final int PLOT_PROFILE = 3;
    public static final int BRIGHTNESS_CONTRAST = 4;
    public static final int NONE = 100;
    private static final int NUM_TOOLS = 5;
    private static final int SIZE = 42;
    private static final int SIZECORR = 10;
    private static final int OFFSET = 5;
    private Dimension ps = new Dimension(210, 42);
    private boolean[] down;
    private static int current;
    private int x;
    private int y;
    private int xOffset;
    private int yOffset;
    private long mouseDownTime;
    private Graphics g;
    private static EuHouToolbar instance;
    private String[] names = new String[5];
    private Image[] icons = new Image[5];
    private String[] command = new String[]{"Open", "Save", "Undo", "PlotProfile", EuHouToolbar.addPluginItem("adjust01")};
    private int pc;
    private String icon;
    private MacroInstaller macroInstaller;
    private static Color foregroundColor;
    private static Color backgroundColor;
    private Color gray = ImageJ.backgroundColor;
    private Color brighter = this.gray.brighter();
    private Color darker = new Color(246, 160, 60);
    private Color evenDarker = new Color(150, 100, 40);
    private ResourceBundle table;
    private boolean drag = false;
    private static Photometer photometer;

    public static String addPluginItem(String s) {
        int openBracket;
        int index;
        String st = Prefs.getString(s);
        String command = st.substring(1, (index = st.lastIndexOf(44)) - 1);
        if (command.endsWith("]") && (openBracket = command.lastIndexOf(91)) > 0) {
            command = command.substring(0, openBracket);
        }
        return command;
    }

    public EuHouToolbar() {
        this.down = new boolean[5];
        ClassLoader cl = this.getClass().getClassLoader();
        for (int i = 0; i < 5; ++i) {
            URL path = cl.getResource("images/haut-" + i + ".png");
            if (path != null) {
                this.icons[i] = Toolkit.getDefaultToolkit().getImage(path);
                continue;
            }
            path = cl.getResource("images/none.png");
            this.icons[i] = Toolkit.getDefaultToolkit().getImage(path);
        }
        this.resetButtons();
        this.setForeground(foregroundColor);
        this.setBackground(this.gray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        instance = this;
        this.table = ResourceBundle.getBundle("ij/i18n/ToolBundle", IJ.getLocale());
    }

    public static EuHouToolbar getInstance() {
        return instance;
    }

    private void drawButtons(Graphics g) {
        for (int i = 0; i < 5; ++i) {
            this.drawButton(g, i);
        }
    }

    private void fill3DRect(Graphics g, int x, int y, int width, int height, boolean raised) {
        if (raised) {
            g.setColor(this.gray);
        } else {
            g.setColor(this.darker);
        }
        g.fillRect(x + 1, y + 1, width - 1, height - 1);
        g.setColor(this.brighter);
        g.drawLine(x, y, x, y + height - 1);
        g.drawLine(x, y, x + width - 1, y);
        g.setColor(raised ? this.evenDarker : this.brighter);
        g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
    }

    private void drawButton(Graphics g, int tool) {
        this.fill3DRect(g, tool * 42 + 1, 1, 42, 42, !this.down[tool]);
        g.setColor(Color.black);
        int x = tool * 42 + 5;
        int y = 5;
        if (this.down[tool]) {
            ++x;
            ++y;
        }
        this.g = g;
        if (this.icons[tool] != null) {
            g.drawImage(this.icons[tool], x, y, this);
        }
    }

    private void showMessage(int tool) {
        switch (tool) {
            case 0: {
                IJ.showStatus(this.table.getString("OpenHint"));
                return;
            }
            case 1: {
                IJ.showStatus(this.table.getString("SaveHint"));
                return;
            }
            case 2: {
                IJ.showStatus(this.table.getString("UndoHint"));
                return;
            }
            case 3: {
                IJ.showStatus(IJ.getBundle().getString("PlotProfile"));
                return;
            }
            case 4: {
                IJ.showStatus(this.table.getString("BrightnessContrastHint"));
                return;
            }
        }
        IJ.showStatus("");
    }

    private void resetButtons() {
        for (int i = 0; i < 5; ++i) {
            this.down[i] = false;
        }
    }

    @Override
    public void paint(Graphics g) {
        this.drawButtons(g);
    }

    @Override
    public void update(Graphics g) {
        for (int i = 0; i < 5; ++i) {
            if (!g.hitClip(i * 42, 0, 42, 42)) continue;
            this.drawButton(g, i);
        }
    }

    public void setTool(int tool) {
        if (tool < 0 || tool >= 5) {
            return;
        }
        this.setTool2(tool);
    }

    private void setTool2(int tool) {
        if (tool < 0 || tool >= 5) {
            return;
        }
        current = tool;
        this.showMessage(current);
        Hashtable table = Menus.getCommands();
        if (this.command[tool] != null) {
            String Cmd;
            try {
                Cmd = IJ.getBundle().getString(this.command[tool]);
            }
            catch (MissingResourceException e) {
                Cmd = this.command[tool];
            }
            if (Cmd == "options01") {
                IJ.doCommand(Prefs.getCommand(Cmd));
            } else {
                IJ.doCommand(Cmd);
            }
            if (Recorder.record && tool != 0) {
                Recorder.record(Cmd);
            }
        }
        if (IJ.isMacOSX()) {
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.drag) {
            return;
        }
        int x = e.getX();
        int newTool = x / 42;
        if (newTool > 4) {
            return;
        }
        boolean doubleClick = newTool == current && System.currentTimeMillis() - this.mouseDownTime <= 500L;
        this.mouseDownTime = System.currentTimeMillis();
        if (!doubleClick) {
            this.setTool2(newTool);
        }
        this.down[newTool] = false;
        Graphics g = this.getGraphics();
        this.drawButton(g, newTool);
        g.dispose();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.drag = false;
        int x = e.getX();
        if ((x /= 42) > 4) {
            return;
        }
        this.down[x] = !this.down[x];
        Graphics g = this.getGraphics();
        this.drawButton(g, x);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.showMessage(100);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.drag = true;
        int x = e.getX();
        if ((x /= 42) > 4) {
            return;
        }
        this.down[x] = false;
        Graphics g = this.getGraphics();
        this.drawButton(g, x);
        g.dispose();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        this.showMessage(x /= 42);
    }

    @Override
    public Dimension getSize() {
        return this.ps;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.ps;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.ps;
    }

    public void photometerButtonAction() {
        IJ.setTool(0);
        Enumeration en = WindowManager.getImageWindows().elements();
        photometer = Photometer.getInstance();
        if (photometer == null) {
            photometer = new Photometer();
        } else {
            photometer.activate();
        }
        while (en.hasMoreElements()) {
            ImageCanvas c = ((ImageWindow)en.nextElement()).getCanvas();
            c.addMouseListener(photometer);
        }
    }

    public void settingsAction() {
        PhotometerParams s = PhotometerParams.getInstance();
        if (s == null) {
            s = new PhotometerParams();
        } else {
            s.show();
        }
    }

    public static void clearPhotometer() {
        if (Photometer.getInstance() != null) {
            Photometer.clear();
        }
    }

    static {
        foregroundColor = Prefs.getColor("fcolor", Color.black);
        backgroundColor = Prefs.getColor("bcolor", Color.white);
        photometer = null;
    }
}

