/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.NewImage;
import ij.gui.Plot;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.plugin.RadioSpectrum_Reader;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class PlotWindow
extends ImageWindow
implements ActionListener,
ClipboardOwner {
    public static final int CIRCLE = 0;
    private boolean drawPending;
    public static final int X = 1;
    public static final int LINE = 2;
    private static final int LEFT_MARGIN = 50;
    private static final int RIGHT_MARGIN = 20;
    private static final int TOP_MARGIN = 20;
    private static final int BOTTOM_MARGIN = 30;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 200;
    private static final String MIN = "pp.min";
    private static final String MAX = "pp.max";
    private static final String PLOT_WIDTH = "pp.width";
    private static final String PLOT_HEIGHT = "pp.height";
    private static final String OPTIONS = "pp.options";
    private static final int SAVE_X_VALUES = 1;
    private static final int AUTO_CLOSE = 2;
    public static boolean interpolate;
    static boolean noGridLines;
    private int frameWidth;
    private int frameHeight;
    private int xloc;
    private int yloc;
    private int flags;
    private Rectangle frame = null;
    private float[] xValues;
    private float[] yValues;
    private float[] xInitValues;
    private float[] yInitValues;
    private float[] yValuesBaseLine;
    private float[] yValuesMergeGaussFit;
    private double[] gaussFitResult;
    private int nbgauss;
    private float[] errorBars;
    private int nPoints;
    private double xScale;
    private double yScale;
    private double xMin;
    private double xMax;
    private double xInitMin;
    private double xInitMax;
    private double yMin;
    private double yMax;
    private Button list;
    private Button save;
    private Button copy;
    private Button setting;
    private Button setScale;
    private Button option;
    private Button setScaleRadio;
    private Button baseline;
    private Button subtract;
    private Button gauss;
    private Label Xcoord;
    private Label Ycoord;
    private static String defaultDirectory;
    private String xLabel;
    private String yLabel;
    private Font font = new Font("Helvetica", 0, 12);
    private boolean fixedYScale;
    private ImageProcessor ip;
    private static int options;
    private int lineWidth = Line.getWidth();
    private int defaultDigits = -1;
    private boolean realNumbers;
    private int xdigits;
    private int ydigits;
    private boolean modifListener = false;
    private int oldX = -1;
    private int oldY = -1;
    private int oldindex = -1;
    private int[] Xpoints;
    private int[] Ypoints;
    public static boolean saveXValues;
    public static boolean autoClose;
    public static int plotWidth;
    public static int plotHeight;
    private Plot plot;
    private ImagePlus origin = null;
    private Roi region;
    private static boolean horizontal;
    public static boolean RadioSpectra;
    public static boolean Base_Line;
    public static boolean Base_Line_subtracted;
    public static boolean ZERO_LINE;
    public static final int X_NUMBERS = 1;
    public static final int Y_NUMBERS = 2;
    public static final int X_TICKS = 4;
    public static final int Y_TICKS = 8;
    public static final int X_GRID = 16;
    public static final int Y_GRID = 32;
    public static final int X_FORCE2GRID = 64;
    public static final int Y_FORCE2GRID = 128;
    public static final int DEFAULT_FLAGS = 51;
    public static final int MAX_INTERVALS = 12;
    public static final int MIN_X_GRIDWIDTH = 60;
    public static final int MIN_Y_GRIDWIDTH = 40;
    public static final int TICK_LENGTH = 3;
    public final Color gridColor = new Color(0xC0C0C0);
    private Vector labels = new Vector();
    private Vector xlabs = new Vector();
    private Vector ylabs = new Vector();

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, float[] xInitValues, float[] yInitValues) {
        super(NewImage.createByteImage(title, plotWidth + 50 + 20, plotHeight + 20 + 30, 1, 4), false);
        IJ.showProgress(0.1);
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.xValues = xValues;
        this.yValues = yValues;
        this.xInitValues = xInitValues;
        this.yInitValues = yInitValues;
        double[] a = Tools.getMinMax(xValues);
        this.xMin = a[0];
        this.xMax = a[1];
        a = Tools.getMinMax(xInitValues);
        this.xInitMin = a[0];
        this.xInitMax = a[1];
        a = Tools.getMinMax(yValues);
        this.yMin = a[0];
        this.yMax = a[1];
        this.fixedYScale = false;
        this.nPoints = xValues.length;
        this.nbgauss = -1;
        this.gaussFitResult = new double[18];
        Panel buttons = new Panel();
        buttons.setLayout(new GridLayout(3, 3));
        this.list = new Button(IJ.getBundle().getString("List"));
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.save = new Button(IJ.getBundle().getString("Save"));
        this.save.addActionListener(this);
        buttons.add(this.save);
        this.copy = new Button(IJ.getBundle().getString("Copy"));
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.setting = new Button(IJ.getBundle().getString("Prop"));
        this.setting.addActionListener(this);
        buttons.add(this.setting);
        if (RadioSpectra) {
            String s = Base_Line_subtracted || Base_Line ? IJ.getPluginBundle().getString("Reset") : IJ.getBundle().getString("Set_Scale");
            this.setScaleRadio = new Button(s);
            this.setScaleRadio.addActionListener(this);
            buttons.add(this.setScaleRadio);
            if (Base_Line) {
                this.subtract = new Button(IJ.getPluginBundle().getString("subtractRS"));
                this.subtract.addActionListener(this);
                buttons.add(this.subtract);
            } else if (Base_Line_subtracted) {
                this.gauss = new Button(IJ.getPluginBundle().getString("GaussianFit"));
                this.gauss.addActionListener(this);
                buttons.add(this.gauss);
            } else {
                this.baseline = new Button(IJ.getPluginBundle().getString("baseline"));
                this.baseline.addActionListener(this);
                buttons.add(this.baseline);
            }
        } else {
            this.setScale = new Button(IJ.getBundle().getString("Set_Scale"));
            this.setScale.addActionListener(this);
            buttons.add(this.setScale);
            this.option = new Button(IJ.getPluginBundle().getString("ProOptTitle"));
            this.option.addActionListener(this);
            buttons.add(this.option);
        }
        buttons.add(new Label(""));
        this.Xcoord = new Label("     ");
        this.Xcoord.setFont(new Font("Monospaced", 0, 12));
        buttons.add(this.Xcoord);
        this.Ycoord = new Label("     ");
        this.Ycoord.setFont(new Font("Monospaced", 0, 12));
        buttons.add(this.Ycoord);
        this.add(buttons);
        this.pack();
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues), Tools.toFloat(xValues), Tools.toFloat(yValues));
        horizontal = false;
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, float[] xInitValues, float[] yInitValues, ImagePlus origin) {
        this(title, xLabel, yLabel, xValues, yValues, xInitValues, yInitValues);
        this.origin = origin;
        horizontal = false;
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        this(title, xLabel, yLabel, xValues, yValues, xValues, yValues);
        horizontal = false;
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, ImagePlus origin) {
        this(title, xLabel, yLabel, xValues, yValues);
        this.origin = origin;
        horizontal = false;
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, float[] yValuesBaseLine, ImagePlus origin) {
        this(title, xLabel, yLabel, xValues, yValues, origin);
        if (Base_Line_subtracted) {
            this.yValuesMergeGaussFit = yValuesBaseLine;
        } else {
            this.yValuesBaseLine = yValuesBaseLine;
        }
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, double[] gaussFitResult, int nbgauss, ImagePlus origin) {
        this(title, xLabel, yLabel, xValues, yValues, origin);
        this.gaussFitResult = gaussFitResult;
        this.nbgauss = nbgauss;
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues, ImagePlus origin) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues));
        horizontal = false;
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, boolean horiz, ImagePlus origin, Roi region) {
        this(title, xLabel, yLabel, xValues, yValues, origin);
        this.modifListener = true;
        this.region = (Roi)region.clone();
        horizontal = horiz;
        RadioSpectra = false;
        if (horizontal) {
            int xOrigine = ((Line)region).getX();
            int i = 0;
            while (i < xValues.length) {
                int n = i++;
                this.xValues[n] = this.xValues[n] + (float)xOrigine;
            }
            double[] a = Tools.getMinMax(xValues);
            this.xMin = a[0];
            this.xMax = a[1];
            a = Tools.getMinMax(this.xInitValues);
            this.xInitMin = a[0];
            this.xInitMax = a[1];
        }
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, float[] xInitValues, float[] yInitValues, boolean horiz, ImagePlus origin, Roi region) {
        this(title, xLabel, yLabel, xValues, yValues, false, origin, region);
        horizontal = horiz;
        this.xInitValues = xInitValues;
        this.yInitValues = yInitValues;
        double[] a = Tools.getMinMax(xInitValues);
        this.xInitMin = a[0];
        this.xInitMax = a[1];
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues, boolean horiz, ImagePlus origin, Roi region) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues), horiz, origin, region);
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.xInitValues = this.xInitValues;
        this.yInitValues = this.yInitValues;
        this.flags = this.flags;
        if (xValues == null || yValues == null) {
            xValues = new double[1];
            yValues = new double[1];
            xValues[0] = -1.0;
            yValues[0] = -1.0;
        }
        this.xValues = Tools.toFloat(xValues);
        this.yValues = Tools.toFloat(yValues);
        double[] a = Tools.getMinMax(xValues);
        this.xMin = a[0];
        this.xMax = a[1];
        a = Tools.getMinMax(this.xInitValues);
        this.xInitMin = a[0];
        this.xInitMax = a[1];
        a = Tools.getMinMax(yValues);
        this.yMin = a[0];
        this.yMax = a[1];
        this.fixedYScale = false;
        this.nPoints = xValues.length;
        this.drawPending = true;
        System.out.println("this one is actually being used");
    }

    PlotWindow(Plot plot, ImagePlus imp) {
        super(imp);
        this.plot = plot;
        this.draw();
        System.out.println("Plot Window 12");
    }

    public void setLimits(double xMin, double xMax, double yMin, double yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.fixedYScale = true;
    }

    public void addPoints(float[] x, float[] y, int shape, Color c) {
        this.setup();
        switch (shape) {
            case 0: 
            case 1: {
                for (int i = 0; i < x.length; ++i) {
                    int xt = 50 + (int)(((double)x[i] - this.xMin) * this.xScale);
                    int yt = 20 + this.frameHeight - (int)(((double)y[i] - this.yMin) * this.yScale);
                    this.drawShape(shape, xt, yt, 5);
                }
                break;
            }
            case 2: {
                int[] xts = new int[x.length];
                int[] yts = new int[y.length];
                for (int i = 0; i < x.length; ++i) {
                    xts[i] = 50 + (int)(((double)x[i] - this.xMin) * this.xScale);
                    yts[i] = 20 + this.frameHeight - (int)(((double)y[i] - this.yMin) * this.yScale);
                }
                this.setColor(c);
                this.drawPolyline(this.ip, xts, yts, x.length);
                this.setColor(Color.black);
            }
        }
    }

    public void addPoints(float[] x, float[] y, int shape) {
        this.addPoints(x, y, shape, Color.black);
    }

    public void addPoints(double[] x, double[] y, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
    }

    void drawShape(int shape, int x, int y, int size) {
        int xbase = x - size / 2;
        int ybase = y - size / 2;
        if (shape == 1) {
            this.ip.drawLine(xbase, ybase, xbase + size, ybase + size);
            this.ip.drawLine(xbase + size, ybase, xbase, ybase + size);
        } else {
            this.ip.drawLine(x - 1, y - 2, x + 1, y - 2);
            this.ip.drawLine(x - 1, y + 2, x + 1, y + 2);
            this.ip.drawLine(x + 2, y + 1, x + 2, y - 1);
            this.ip.drawLine(x - 2, y + 1, x - 2, y - 1);
        }
    }

    public void addErrorBars(float[] errorBars) {
        if (errorBars.length != this.nPoints) {
            throw new IllegalArgumentException("errorBars.length != npoints");
        }
        this.errorBars = errorBars;
    }

    public void addLabel(double x, double y, String label) {
        this.setup();
        int xt = 50 + (int)(x * (double)this.frameWidth);
        int yt = 20 + (int)(y * (double)this.frameHeight);
        this.ip.drawString(label, xt, yt);
        this.labels.add(label);
        this.xlabs.add(new Integer(xt));
        this.ylabs.add(new Integer(yt));
    }

    public void setColor(Color c) {
        this.setup();
        if (!(this.ip instanceof ColorProcessor)) {
            this.ip = this.ip.convertToRGB();
            this.ip.setLineWidth(this.lineWidth);
            this.ip.setFont(this.font);
            this.ip.setAntialiasedText(true);
        }
        this.ip.setColor(c);
    }

    public void setLineWidth(int lineWidth) {
        this.setup();
        this.ip.setLineWidth(lineWidth);
        this.lineWidth = lineWidth;
    }

    public void changeFont(Font font) {
        this.setup();
        this.ip.setFont(font);
        this.font = font;
    }

    public void draw() {
        this.drawPlot();
        if (this.ip instanceof ColorProcessor) {
            this.imp.setProcessor(null, this.ip);
        } else {
            this.imp.updateAndDraw();
        }
        IJ.showProgress(1.1);
    }

    void setup() {
        if (this.ip != null) {
            return;
        }
        this.ip = this.imp.getProcessor();
        this.ip.setColor(Color.black);
        if (this.lineWidth > 3) {
            this.lineWidth = 3;
        }
        this.ip.setLineWidth(this.lineWidth);
        this.ip.setFont(this.font);
        this.ip.setAntialiasedText(true);
        if (this.frameWidth == 0) {
            this.frameWidth = plotWidth;
            this.frameHeight = plotHeight;
        }
        this.frame = new Rectangle(50, 20, this.frameWidth, this.frameHeight);
        this.xScale = this.xMax - this.xMin == 0.0 ? 1.0 : (double)this.frame.width / (this.xMax - this.xMin);
        this.yScale = this.yMax - this.yMin == 0.0 ? 1.0 : (double)this.frame.height / (this.yMax - this.yMin);
    }

    int getDigits(double n1, double n2) {
        if ((double)Math.round(n1) == n1 && (double)Math.round(n2) == n2) {
            return 0;
        }
        double n = (n1 = Math.abs(n1)) < (n2 = Math.abs(n2)) && n1 > 0.0 ? n1 : n2;
        double diff = Math.abs(n2 - n1);
        if (diff > 0.0 && diff < n) {
            n = diff;
        }
        int digits = 1;
        if (n < 10.0) {
            digits = 2;
        }
        if (n < 0.01) {
            digits = 3;
        }
        if (n < 0.001) {
            digits = 4;
        }
        if (n < 1.0E-4) {
            digits = 5;
        }
        return digits;
    }

    @Override
    public void mouseClicked(int x, int y) {
        String xRB = "";
        String yRB = "";
        if (this.region != null) {
            int n = ((Line)this.region).getX();
        }
        if (this.frame == null) {
            return;
        }
        if (this.frame.contains(x, y)) {
            System.out.println("PlotWindow mousemoved 1");
            int index = (int)((double)(x - this.frame.x) / ((double)this.frame.width / (double)this.xValues.length));
            if (index > 0 && index < this.xValues.length) {
                double xv = this.xValues[index];
                double yv = this.yValues[index];
                xRB = IJ.d2s(xv, 4);
                yRB = IJ.d2s(yv, this.getDigits(yv, 4.0));
            }
            IJ.write("\t" + xRB + "\t" + yRB);
        }
    }

    @Override
    public void mouseMoved(int x, int y) {
        if (this.frame == null) {
            return;
        }
        int xOrigine = 0;
        if (this.region != null && horizontal) {
            xOrigine = ((Line)this.region).getX();
        }
        if (this.frame.contains(this.oldX - 1, this.oldY)) {
            this.ip.setColor(Color.white);
            Roi region = this.imp.getRoi();
            this.imp.setRoi(this.frame);
            this.ip.fill();
            this.imp.setRoi(region);
            this.ip.setColor(Color.black);
            this.drawPolyline(this.ip, this.Xpoints, this.Ypoints, this.nPoints);
            this.ip.setColor(Color.black);
            this.ip.drawRect(this.frame.x, this.frame.y, this.frame.width + 1, this.frame.height + 1);
            this.ip.setAntialiasedText(true);
            Enumeration e = this.labels.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                int xxx = (Integer)this.xlabs.elementAt(i);
                int yyy = (Integer)this.ylabs.elementAt(i++);
                this.ip.drawString((String)e.nextElement(), xxx, yyy);
            }
            if (this.imp != null) {
                this.imp.updateAndDraw();
            }
        }
        if (this.frame.contains(x, y)) {
            int index = (int)((double)(x - this.frame.x) / ((double)this.frame.width / (double)this.xValues.length));
            this.ip.setColor(Color.gray.brighter());
            this.ip.drawLine(x, this.frame.y, x, this.frame.y + this.frameHeight);
            this.ip.drawLine(this.frame.x, this.Ypoints[index], this.frame.x + this.frameWidth, this.Ypoints[index]);
            this.ip.setColor(Color.black);
            this.ip.drawRect(this.frame.x, this.frame.y, this.frame.width + 1, this.frame.height + 1);
            this.imp.updateAndDraw();
            if (index > 0 && index < this.xValues.length) {
                double xv = this.xValues[index];
                double yv = this.yValues[index];
                String lab = "X=" + IJ.d2s(xv, 4);
                this.Xcoord.setText(lab);
                lab = "Y=" + IJ.d2s(yv, this.getDigits(yv, 4.0));
                this.Ycoord.setText(lab);
                if (this.origin != null && this.region != null && this.region.getType() == 5) {
                    this.origin.getWindow().getCanvas().setRoi(this.region);
                    Line lr = (Line)this.region;
                    if (horizontal) {
                        xv -= (double)xOrigine;
                    }
                    double c = xv / this.origin.getRoi().getLength();
                    int xi = lr.x1 + (int)(c * (double)(lr.x2 - lr.x1));
                    int yi = lr.y1 + (int)(c * (double)(lr.y2 - lr.y1));
                    this.origin.getWindow().getCanvas().setPoint(xi, yi, this.region);
                }
                this.oldindex = index;
            }
        } else {
            this.Xcoord.setText("");
            this.Ycoord.setText("");
        }
        this.oldX = x;
        this.oldY = y;
        if (this.yValuesBaseLine != null) {
            this.addPoints(this.xValues, this.yValuesBaseLine, 2, Color.red);
        }
        if (this.yValuesMergeGaussFit != null) {
            this.addPoints(this.xValues, this.yValuesMergeGaussFit, 2, Color.red);
        }
        this.displayGaussianFit();
        if (ZERO_LINE) {
            this.addPoints(this.xValues, new float[this.xValues.length], 2, Color.blue);
        }
        this.drawTick(this.ip);
    }

    void drawPlot() {
        this.setup();
        if (this.yValuesBaseLine != null) {
            this.addPoints(this.xValues, this.yValuesBaseLine, 2, Color.red);
        }
        if (this.yValuesMergeGaussFit != null) {
            this.addPoints(this.xValues, this.yValuesMergeGaussFit, 2, Color.red);
        }
        this.displayGaussianFit();
        if (ZERO_LINE) {
            this.addPoints(this.xValues, new float[this.xValues.length], 2, Color.blue);
        }
        int xOrigine = 0;
        if (this.region != null && horizontal) {
            xOrigine = ((Line)this.region).getX();
        }
        this.Xpoints = new int[this.nPoints];
        this.Ypoints = new int[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            double value = this.yValues[i];
            double xvalue = this.xValues[i];
            if (value < this.yMin) {
                value = this.yMin;
            }
            if (value > this.yMax) {
                value = this.yMax;
            }
            this.Xpoints[i] = 50 + (int)((xvalue - this.xMin) * this.xScale);
            this.Ypoints[i] = 20 + this.frame.height - (int)((value - this.yMin) * this.yScale);
        }
        this.drawPolyline(this.ip, this.Xpoints, this.Ypoints, this.nPoints);
        IJ.showProgress(0.4);
        if (this.errorBars != null) {
            int[] xpoints = new int[2];
            int[] ypoints = new int[2];
            for (int i = 0; i < this.nPoints; ++i) {
                xpoints[0] = xpoints[1] = 50 + (int)(((double)this.xValues[i] - this.xMin) * this.xScale);
                ypoints[0] = 20 + this.frame.height - (int)(((double)this.yValues[i] - this.yMin - (double)this.errorBars[i]) * this.yScale);
                ypoints[1] = 20 + this.frame.height - (int)(((double)this.yValues[i] - this.yMin + (double)this.errorBars[i]) * this.yScale);
                this.drawPolyline(this.ip, xpoints, ypoints, 2);
            }
        }
        if (this.ip instanceof ColorProcessor) {
            this.ip.setColor(Color.black);
        }
        this.ip.drawRect(this.frame.x, this.frame.y, this.frame.width + 1, this.frame.height + 1);
        int digits = this.getDigits(this.yMax, this.yMin);
        String s = IJ.d2s(this.yMax, digits);
        int sw = this.ip.getStringWidth(s);
        if (sw + 4 > 50) {
            this.ip.drawString(s, 4, 16);
        } else {
            this.ip.drawString(s, 50 - this.ip.getStringWidth(s) - 4, 30);
        }
        s = IJ.d2s(this.yMin, digits);
        sw = this.ip.getStringWidth(s);
        if (sw + 4 > 50) {
            this.ip.drawString(s, 4, 20 + this.frame.height);
        } else {
            this.ip.drawString(s, 50 - this.ip.getStringWidth(s) - 4, 20 + this.frame.height);
        }
        IJ.showProgress(0.8);
        FontMetrics fm = this.ip.getFontMetrics();
        int x = 50;
        int y = 20 + this.frame.height + fm.getAscent() + 6;
        digits = this.getDigits(this.xMin, this.xMax);
        this.ip.drawString(IJ.d2s(this.xMin, digits), x, y);
        s = IJ.d2s(this.xMax, digits);
        this.ip.drawString(s, x + this.frame.width - this.ip.getStringWidth(s) + 6, y);
        this.ip.drawString(this.xLabel, 50 + (this.frame.width - this.ip.getStringWidth(this.xLabel)) / 2, y + 3);
        this.drawYLabel(this.yLabel, 50, 20, this.frame.height, fm);
        this.drawTick(this.ip);
    }

    public void mouseExited(MouseEvent e) {
        this.origin.getWindow().getCanvas().setPoint(-1, -1, null);
    }

    void drawPolyline(ImageProcessor ip, int[] x, int[] y, int n) {
        ip.moveTo(x[0], y[0]);
        for (int i = 0; i < n; ++i) {
            ip.lineTo(x[i], y[i]);
        }
    }

    void drawYLabel(String yLabel, int x, int y, int height, FontMetrics fm) {
        if (yLabel.equals("")) {
            return;
        }
        int w = fm.stringWidth(yLabel) + 5;
        int h = fm.getHeight() + 5;
        ImageProcessor label = new ByteProcessor(w, h);
        ((ImageProcessor)label).setColor(Color.white);
        label.fill();
        ((ImageProcessor)label).setColor(Color.black);
        label.setFont(this.font);
        label.setAntialiasedText(true);
        int descent = fm.getDescent();
        label.drawString(yLabel, 0, h - descent);
        label = label.rotateLeft();
        int y2 = y + (height - this.ip.getStringWidth(yLabel)) / 2;
        if (y2 < y) {
            y2 = y;
        }
        int x2 = x - h - 2;
        this.ip.insert(label, x2, y2);
    }

    void showList() {
        String headings;
        StringBuffer sb = new StringBuffer();
        this.initDigits();
        if (this.errorBars != null) {
            headings = saveXValues ? "X\tY\tErrorBar" : "Y\tErrorBar";
            for (int i = 0; i < this.nPoints; ++i) {
                if (saveXValues) {
                    sb.append(IJ.d2s(this.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.yValues[i], this.ydigits) + "\t" + IJ.d2s(this.errorBars[i], this.ydigits) + "\n");
                    continue;
                }
                sb.append(IJ.d2s(this.yValues[i], this.ydigits) + "\t" + IJ.d2s(this.errorBars[i], this.ydigits) + "\n");
            }
        } else {
            headings = saveXValues ? "X\tY" : "Y";
            for (int i = 0; i < this.nPoints; ++i) {
                if (saveXValues) {
                    sb.append(IJ.d2s(this.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.yValues[i], this.ydigits) + "\n");
                    continue;
                }
                sb.append(IJ.d2s(this.yValues[i], this.ydigits) + "\n");
            }
        }
        TextWindow tw = new TextWindow(IJ.getBundle().getString("PlotValues"), headings, sb.toString(), 200, 400);
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void drawTick(ImageProcessor ip) {
        int n;
        double j;
        double dtmp;
        double taille = this.xMax - this.xMin;
        taille = Math.abs(taille);
        double k = 1.0;
        double kk = 0.0;
        while (kk != k) {
            kk = k;
            dtmp = taille / k;
            if (dtmp <= 5.0) {
                k /= 10.0;
            }
            if (!(dtmp >= 100.0)) continue;
            k *= 10.0;
        }
        int itmp = (int)Math.round(this.xMin / k);
        for (j = (double)itmp * k; j < this.xMax; j += k) {
            if (!(j > this.xMin) || !(j < this.xMax)) continue;
            n = 2;
            dtmp = j / k;
            itmp = (int)dtmp;
            if ((itmp %= 10) == 0) {
                n = 6;
            }
            ip.moveTo(50 + (int)((j - this.xMin) * this.xScale), 20 + this.frame.height - n);
            ip.lineTo(50 + (int)((j - this.xMin) * this.xScale), 20 + this.frame.height);
        }
        taille = Math.abs(this.yMax - this.yMin);
        k = 1.0;
        kk = 0.0;
        while (kk != k) {
            kk = k;
            dtmp = taille / k;
            if (dtmp <= 5.0) {
                k /= 10.0;
            }
            if (!(dtmp >= 100.0)) continue;
            k *= 10.0;
        }
        itmp = (int)Math.round(this.yMin / k);
        for (j = (double)itmp * k; j < this.yMax; j += k) {
            if (!(j > this.yMin) || !(j < this.yMax)) continue;
            n = 2;
            dtmp = j / k;
            itmp = (int)dtmp;
            if ((itmp %= 10) == 0) {
                n = 6;
            }
            ip.moveTo(50, 20 + this.frame.height - (int)((j - this.yMin) * this.yScale));
            ip.lineTo(50 + n, 20 + this.frame.height - (int)((j - this.yMin) * this.yScale));
        }
    }

    void saveAsText() {
        String directory;
        FileDialog fd = new FileDialog((Frame)this, IJ.getBundle().getString("SaveAsText"), 1);
        if (defaultDirectory != null) {
            fd.setDirectory(defaultDirectory);
        }
        fd.show();
        String name = fd.getFile();
        defaultDirectory = directory = fd.getDirectory();
        fd.dispose();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.error("" + e);
            return;
        }
        IJ.wait(250);
        IJ.showStatus(IJ.getBundle().getString("SavePlotValues"));
        this.initDigits();
        for (int i = 0; i < this.nPoints; ++i) {
            if (saveXValues) {
                pw.println(IJ.d2s(this.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.yValues[i], this.ydigits));
                continue;
            }
            pw.println(IJ.d2s(this.yValues[i], this.ydigits));
        }
        pw.close();
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void copyToClipboard() {
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error(IJ.getBundle().getString("ClipCopyErr"));
            return;
        }
        IJ.showStatus(IJ.getBundle().getString("CopyPlotValues"));
        this.initDigits();
        CharArrayWriter aw = new CharArrayWriter(this.nPoints * 4);
        PrintWriter pw = new PrintWriter(aw);
        for (int i = 0; i < this.nPoints; ++i) {
            if (saveXValues) {
                pw.print(IJ.d2s(this.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.yValues[i], this.ydigits) + "\n");
                continue;
            }
            pw.print(IJ.d2s(this.yValues[i], this.ydigits) + "\n");
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus(text.length() + " " + IJ.getBundle().getString("CharCopied"));
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void initDigits() {
        this.ydigits = Analyzer.getPrecision();
        if (this.ydigits == 0) {
            this.ydigits = 2;
        }
        if (this.ydigits != this.defaultDigits) {
            this.realNumbers = false;
            for (int i = 0; i < this.xValues.length; ++i) {
                if ((float)((int)this.xValues[i]) == this.xValues[i]) continue;
                this.realNumbers = true;
            }
            this.defaultDigits = this.ydigits;
        }
        this.xdigits = this.realNumbers ? this.ydigits : 0;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        ImagePlus imp2 = WindowManager.getCurrentImage();
        if (b == this.list) {
            this.showList();
        } else if (b == this.save) {
            this.saveAsText();
        } else if (b == this.setting) {
            this.setPlotScale(imp2);
        } else if (b == this.setScaleRadio) {
            Base_Line_subtracted = false;
            this.setRadioSpectrumScale();
        } else if (b == this.baseline) {
            this.setRadioSpectrumBaseline();
        } else if (b == this.gauss) {
            if (this.nbgauss < 5) {
                this.gaussFitting();
            } else {
                IJ.error(IJ.getBundle().getString("error3"));
            }
        } else if (b == this.subtract) {
            this.subtractBaseline();
        } else if (b == this.setScale) {
            IJ.runPlugIn("ij.plugin.filter.ScaleDialog", "");
            IJ.runPlugIn("ij.plugin.filter.Profiler", "");
            if (imp2 != null) {
                this.close();
            }
        } else if (b == this.option) {
            IJ.runPlugIn("ij.plugin.filter.Profiler", "set");
            IJ.runPlugIn("ij.plugin.filter.Profiler", "");
            if (imp2 != null) {
                this.close();
            }
        } else {
            this.copyToClipboard();
        }
    }

    public float[] getYValues() {
        return this.yValues;
    }

    public static void savePreferences(Properties prefs) {
        double min = ProfilePlot.getFixedMin();
        double max = ProfilePlot.getFixedMax();
        if ((min != 0.0 || max != 0.0) && min < max) {
            prefs.put(MIN, Double.toString(min));
            prefs.put(MAX, Double.toString(max));
        }
        if (plotWidth != 450 || plotHeight != 200) {
            prefs.put(PLOT_WIDTH, Integer.toString(plotWidth));
            prefs.put(PLOT_HEIGHT, Integer.toString(plotHeight));
        }
        int options = 0;
        if (saveXValues) {
            options |= 1;
        }
        if (autoClose) {
            options |= 2;
        }
        prefs.put(OPTIONS, Integer.toString(options));
    }

    @Override
    public boolean close() {
        boolean b = super.close();
        if (this.origin != null) {
            try {
                this.origin.getWindow().getCanvas().setPoint(-1, -1, null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return b;
    }

    double niceNumber(double v) {
        double base = Math.pow(10.0, Math.floor(Math.log(v) / Math.log(10.0) - 1.0E-6));
        if (v > 5.0000001 * base) {
            return 10.0 * base;
        }
        if (v > 2.0000001 * base) {
            return 5.0 * base;
        }
        return 2.0 * base;
    }

    void drawTicksEtc() {
        String s;
        double v;
        int i;
        int digits;
        int fontAscent = this.ip.getFontMetrics().getAscent();
        int fontMaxAscent = this.ip.getFontMetrics().getMaxAscent();
        if ((this.flags & 0x15) != 0) {
            int i2;
            int i1;
            double step = Math.abs((double)Math.max(this.frame.width / 12, 60) / this.xScale);
            step = this.niceNumber(step);
            if ((this.flags & 0x40) != 0) {
                i1 = (int)Math.floor(Math.min(this.xMin, this.xMax) / step + 1.0E-10);
                i2 = (int)Math.ceil(Math.max(this.xMin, this.xMax) / step - 1.0E-10);
                this.xMin = (double)i1 * step;
                this.xMax = (double)i2 * step;
                this.xScale = (double)this.frame.width / (this.xMax - this.xMin);
            } else {
                i1 = (int)Math.ceil(Math.min(this.xMin, this.xMax) / step - 1.0E-10);
                i2 = (int)Math.floor(Math.max(this.xMin, this.xMax) / step + 1.0E-10);
            }
            digits = -((int)Math.floor(Math.log(step) / Math.log(10.0) + 1.0E-6));
            if (digits < 0) {
                digits = 0;
            }
            int y1 = 20;
            int y2 = 20 + this.frame.height;
            int yNumbers = y2 + fontAscent + 7;
            for (i = 0; i <= i2 - i1; ++i) {
                v = (double)(i + i1) * step;
                int x = (int)Math.round((v - this.xMin) * this.xScale) + 50;
                if ((this.flags & 0x10) != 0) {
                    this.ip.setColor(this.gridColor);
                    this.ip.drawLine(x, y1, x, y2);
                    this.ip.setColor(Color.black);
                }
                if ((this.flags & 4) != 0) {
                    this.ip.drawLine(x, y1, x, y1 + 3);
                    this.ip.drawLine(x, y2, x, y2 - 3);
                }
                if ((this.flags & 1) == 0) continue;
                s = IJ.d2s(v, digits);
                this.ip.drawString(s, x - this.ip.getStringWidth(s) / 2, yNumbers);
            }
        }
        int maxNumWidth = 0;
        if ((this.flags & 0x2A) != 0) {
            int i2;
            int i1;
            double step = Math.abs((double)Math.max(this.frame.width / 12, 40) / this.yScale);
            step = this.niceNumber(step);
            if ((this.flags & 0x40) != 0) {
                i1 = (int)Math.floor(Math.min(this.yMin, this.yMax) / step + 1.0E-10);
                i2 = (int)Math.ceil(Math.max(this.yMin, this.yMax) / step - 1.0E-10);
                this.yMin = (double)i1 * step;
                this.yMax = (double)i2 * step;
                this.yScale = (double)this.frame.height / (this.yMax - this.yMin);
            } else {
                i1 = (int)Math.ceil(Math.min(this.yMin, this.yMax) / step - 1.0E-10);
                i2 = (int)Math.floor(Math.max(this.yMin, this.yMax) / step + 1.0E-10);
            }
            int digits2 = -((int)Math.floor(Math.log(step) / Math.log(10.0) + 1.0E-6));
            if (digits2 < 0) {
                digits2 = 0;
            }
            int x1 = 50;
            int x2 = 50 + this.frame.width;
            for (i = 0; i <= i2 - i1; ++i) {
                v = (double)(i + i1) * step;
                int y = 20 + this.frame.height - (int)Math.round((v - this.yMin) * this.yScale);
                if ((this.flags & 0x20) != 0) {
                    this.ip.setColor(this.gridColor);
                    this.ip.drawLine(x1, y, x2, y);
                    this.ip.setColor(Color.black);
                }
                if ((this.flags & 8) != 0) {
                    this.ip.drawLine(x1, y, x1 + 3, y);
                    this.ip.drawLine(x2, y, x2 - 3, y);
                }
                if ((this.flags & 2) == 0) continue;
                s = IJ.d2s(v, digits2);
                int w = this.ip.getStringWidth(s);
                if (w > maxNumWidth) {
                    maxNumWidth = w;
                }
                this.ip.drawString(s, 50 - w - 4, y + fontMaxAscent / 2 + 1);
            }
        }
        if ((this.flags & 2) == 0) {
            int digits3 = this.getDigits(this.yMin, this.yMax);
            String s2 = IJ.d2s(this.yMax, digits3);
            int sw = this.ip.getStringWidth(s2);
            if (sw + 4 > 50) {
                this.ip.drawString(s2, 4, 16);
            } else {
                this.ip.drawString(s2, 50 - this.ip.getStringWidth(s2) - 4, 30);
            }
            s2 = IJ.d2s(this.yMin, digits3);
            sw = this.ip.getStringWidth(s2);
            if (sw + 4 > 50) {
                this.ip.drawString(s2, 4, 20 + this.frame.height);
            } else {
                this.ip.drawString(s2, 50 - this.ip.getStringWidth(s2) - 4, 20 + this.frame.height);
            }
        }
        FontMetrics fm = this.ip.getFontMetrics();
        int x = 50;
        int y = 20 + this.frame.height + fm.getAscent() + 6;
        if ((this.flags & 1) == 0) {
            digits = this.getDigits(this.xMin, this.xMax);
            this.ip.drawString(IJ.d2s(this.xMin, digits), x, y);
            String s3 = IJ.d2s(this.xMax, digits);
            this.ip.drawString(s3, x + this.frame.width - this.ip.getStringWidth(s3) + 6, y);
        } else {
            y += fm.getAscent();
        }
        this.drawXLabel(this.xLabel, 270, 235, 0, fm);
        this.drawYLabel(this.yLabel, 50 - maxNumWidth - 4, 20, this.frame.height, fm);
    }

    public void setPlotScale(ImagePlus imp2) {
        double xvalue;
        double yvalue;
        int i;
        int n = 2;
        if (RadioSpectrum_Reader.SCALETYPE == 0) {
            n = 0;
        }
        GenericDialog gd = new GenericDialog(IJ.getBundle().getString("Properties"), this);
        gd.addStringField("     X label :", this.xLabel, this.xLabel.length());
        gd.addNumericField("             X min : ", this.xMin, n);
        gd.addNumericField("             X max : ", this.xMax, n);
        gd.addStringField("     Y label :", this.yLabel, this.yLabel.length());
        gd.addNumericField("             Y min : ", this.yMin, 2);
        gd.addNumericField("             Y max : ", this.yMax, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String xLab = gd.getNextString();
        double xMi = gd.getNextNumber();
        double xMa = gd.getNextNumber();
        String yLab = gd.getNextString();
        double yMi = gd.getNextNumber();
        double yMa = gd.getNextNumber();
        if (xMi < this.xInitMin || xMi > this.xInitMax) {
            xMi = this.xInitMin;
        }
        if (xMa > this.xInitMax || xMa < this.xInitMin) {
            xMa = this.xInitMax;
        }
        int ii = 0;
        int nInitPoints = this.xInitValues.length;
        for (i = 0; i < nInitPoints; ++i) {
            yvalue = this.yInitValues[i];
            xvalue = this.xInitValues[i];
            if (!(xvalue >= xMi) || !(xvalue <= xMa)) continue;
            ++ii;
        }
        double[] newxValues = new double[ii];
        double[] newyValues = new double[ii];
        ii = 0;
        for (i = 0; i < nInitPoints; ++i) {
            yvalue = this.yInitValues[i];
            xvalue = this.xInitValues[i];
            if (!(xvalue >= xMi) || !(xvalue <= xMa)) continue;
            newyValues[ii] = yvalue;
            newxValues[ii] = xvalue;
            ++ii;
        }
        PlotWindow pw = imp2 == null ? new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + " " + this.origin.getShortTitle() + (this.origin.getStackSize() > 1 ? "#" + this.origin.getCurrentSlice() : ""), xLab, yLab, Tools.toFloat(newxValues), Tools.toFloat(newyValues), this.xInitValues, this.yInitValues, horizontal, this.origin, this.region) : new PlotWindow(this.getTitle(), xLab, yLab, Tools.toFloat(newxValues), Tools.toFloat(newyValues), this.xInitValues, this.yInitValues, this.origin);
        pw.setLimits(xMi, xMa, yMi, yMa);
        pw.draw();
        this.close();
    }

    public void setRadioSpectrumScale() {
        double wave0 = RadioSpectrum_Reader.wave_ref;
        GenericDialog gd = new GenericDialog(IJ.getBundle().getString("Set_Scale"), this);
        String[] scales = new String[]{IJ.getPluginBundle().getString("ChannelRS"), IJ.getPluginBundle().getString("VelocityRS"), IJ.getPluginBundle().getString("FrequencyRS"), IJ.getPluginBundle().getString("WavelengthRS")};
        gd.addChoice(" ", scales, IJ.getPluginBundle().getString("ChannelRS"));
        if (RadioSpectrum_Reader.optique) {
            gd.addNumericField(IJ.getPluginBundle().getString("Wave_ref"), wave0, 3, 10, "nm");
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int index = gd.getNextChoiceIndex();
        if (RadioSpectrum_Reader.optique) {
            RadioSpectrum_Reader.wave_ref = wave0 = gd.getNextNumber();
        }
        FileInfo fi = this.origin.getOriginalFileInfo();
        RadioSpectrum_Reader.SCALETYPE = index;
        IJ.runPlugIn("ij.plugin.RadioSpectrum_Reader", fi.directory + fi.fileName);
        this.close();
    }

    public void setRadioSpectrumBaseline() {
        int i;
        int n = 2;
        if (RadioSpectrum_Reader.SCALETYPE == 0) {
            n = 0;
        }
        GenericDialog gd = new GenericDialog("baseline", this);
        double x1 = 0.0;
        double x2 = 0.0;
        double x3 = 0.0;
        double x4 = 0.0;
        int order = 1;
        gd.addMessage(IJ.getPluginBundle().getString("chooseInter"));
        gd.addMessage("                " + IJ.getPluginBundle().getString("Finter"));
        gd.addNumericField("              Xmin = ", x1, n);
        gd.addNumericField("              Xmax = ", x2, n);
        gd.addMessage("                " + IJ.getPluginBundle().getString("Sinter"));
        gd.addNumericField("              Xmin = ", x3, n);
        gd.addNumericField("              Xmax = ", x4, n);
        gd.addMessage(IJ.getPluginBundle().getString("chooseOder"));
        gd.addNumericField("             " + IJ.getPluginBundle().getString("order") + " = ", order, 0);
        gd.addCheckbox(IJ.getPluginBundle().getString("DisplayZero"), ZERO_LINE);
        gd.showDialog();
        x1 = gd.getNextNumber();
        x2 = gd.getNextNumber();
        x3 = gd.getNextNumber();
        x4 = gd.getNextNumber();
        order = (int)gd.getNextNumber();
        ZERO_LINE = gd.getNextBoolean();
        if (gd.wasCanceled()) {
            return;
        }
        if (x1 > x2) {
            this.change(x1, x2);
        }
        if (x3 > x4) {
            this.change(x3, x4);
        }
        if (order > 4) {
            order = 4;
        }
        if (order < 1) {
            order = 1;
        }
        if (x1 < this.xInitMin || x1 > this.xInitMax) {
            x1 = this.xInitMin;
        }
        if (x2 > this.xInitMax || x2 < this.xInitMin) {
            x2 = this.xInitMax;
        }
        if (x3 < this.xInitMin || x3 > this.xInitMax) {
            x3 = this.xInitMin;
        }
        if (x4 > this.xInitMax || x4 < this.xInitMin) {
            x4 = this.xInitMax;
        }
        int nbp = 0;
        for (int i2 = 0; i2 < this.xValues.length; ++i2) {
            if (!((double)this.xValues[i2] > x1 & (double)this.xValues[i2] < x2) && !((double)this.xValues[i2] > x3 & (double)this.xValues[i2] < x4)) continue;
            ++nbp;
        }
        float[] xbase = new float[nbp];
        float[] ybase = new float[nbp];
        float[] bLine = new float[order + 1];
        int ii = 0;
        for (i = 0; i < this.xValues.length; ++i) {
            if (!((double)this.xValues[i] > x1 & (double)this.xValues[i] < x2) && !((double)this.xValues[i] > x3 & (double)this.xValues[i] < x4)) continue;
            xbase[ii] = this.xValues[i];
            ybase[ii] = this.yValues[i];
            ++ii;
        }
        Tools.fittingData(xbase, ybase, bLine);
        this.yValuesBaseLine = new float[this.xValues.length];
        for (i = 0; i < this.xValues.length; ++i) {
            float poly = bLine[order];
            for (int j = 0; j < order; ++j) {
                poly = poly * this.xValues[i] + bLine[order - j - 1];
            }
            this.yValuesBaseLine[i] = poly;
        }
        Base_Line = true;
        FileInfo fi = this.origin.getOriginalFileInfo();
        PlotWindow pw = new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + "  " + fi.fileName, this.xLabel, this.yLabel, this.xValues, this.yValues, this.yValuesBaseLine, this.origin);
        pw.draw();
        this.close();
    }

    void change(double x1, double x2) {
        double l = x1;
        x1 = x2;
        x2 = l;
    }

    public void subtractBaseline() {
        for (int i = 0; i < this.xValues.length; ++i) {
            int n = i;
            this.yValues[n] = this.yValues[n] - this.yValuesBaseLine[i];
        }
        Base_Line = false;
        Base_Line_subtracted = true;
        PlotWindow pw = new PlotWindow(this.getTitle(), this.xLabel, this.yLabel, this.xValues, this.yValues, this.xInitValues, this.yInitValues, this.origin);
        pw.draw();
        this.close();
    }

    public void gaussFitting() {
        int n = 2;
        boolean erase = false;
        if (RadioSpectrum_Reader.SCALETYPE == 0) {
            n = 0;
        }
        GenericDialog gd = new GenericDialog(IJ.getPluginBundle().getString("GaussianfitTitle"), this);
        double x1 = 0.0;
        double x2 = 0.0;
        double ampl = 0.0;
        double center = 0.0;
        double width = 0.0;
        boolean order = true;
        gd.addMessage(IJ.getPluginBundle().getString("ChooseParam"));
        gd.addMessage("                " + IJ.getPluginBundle().getString("interval"));
        gd.addNumericField("              Xmin = ", x1, n);
        gd.addNumericField("              Xmax = ", x2, n);
        gd.addMessage("                ");
        gd.addNumericField("              " + IJ.getPluginBundle().getString("amplitudeRS") + " = ", ampl, n);
        gd.addNumericField("              " + IJ.getPluginBundle().getString("centerRS") + " = ", center, n);
        gd.addNumericField("              " + IJ.getPluginBundle().getString("widthRS") + " = ", width, n);
        gd.addCheckbox(IJ.getPluginBundle().getString("eraseRS"), erase);
        gd.showDialog();
        x1 = gd.getNextNumber();
        x2 = gd.getNextNumber();
        ampl = gd.getNextNumber();
        center = gd.getNextNumber();
        width = gd.getNextNumber();
        erase = gd.getNextBoolean();
        if (gd.wasCanceled()) {
            return;
        }
        if (x1 > x2) {
            this.change(x1, x2);
        }
        int nbp = 0;
        for (int i = 0; i < this.xValues.length; ++i) {
            if (!((double)this.xValues[i] > x1 & (double)this.xValues[i] < x2)) continue;
            ++nbp;
        }
        float[] xgauss = new float[nbp];
        float[] ygauss = new float[nbp];
        int ii = 0;
        for (int i = 0; i < this.xValues.length; ++i) {
            if (!((double)this.xValues[i] > x1 & (double)this.xValues[i] < x2)) continue;
            xgauss[ii] = this.xValues[i];
            ygauss[ii] = this.yValues[i];
            ++ii;
        }
        double[] a = new double[]{ampl, center, width};
        int err = RadioSpectrum_Reader.gaussianFitSpectralLine(xgauss, ygauss, a);
        if (err != 0) {
            if (!erase) {
                ++this.nbgauss;
            }
            this.gaussFitResult[3 * this.nbgauss] = a[0];
            this.gaussFitResult[3 * this.nbgauss + 1] = a[1];
            this.gaussFitResult[3 * this.nbgauss + 2] = a[2];
            FileInfo fi = this.origin.getOriginalFileInfo();
            PlotWindow pw = new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + "  " + fi.fileName, this.xLabel, this.yLabel, this.xValues, this.yValues, this.gaussFitResult, this.nbgauss, this.origin);
            pw.draw();
            RadioSpectrum_Reader.addResult(this.origin, a);
            this.close();
        }
    }

    public void displayGaussianFit() {
        float[] ytmp = new float[this.xValues.length];
        for (int i = 0; i < this.nbgauss + 1; ++i) {
            Tools.Fgauss(this.xValues, this.gaussFitResult, i, ytmp);
            this.addPoints(this.xValues, ytmp, 2, Color.red);
        }
    }

    public void mergeGaussFitting() {
        GenericDialog gd = new GenericDialog("merge Gaussians fits of spectral line", this);
        gd.addMessage("do you want merge ?");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        float[][] ytmp = new float[this.nbgauss + 1][this.xValues.length];
        for (int i = 0; i < this.nbgauss + 1; ++i) {
            Tools.Fgauss(this.xValues, this.gaussFitResult, i, ytmp[i]);
        }
        this.yValuesMergeGaussFit = new float[this.xValues.length];
        for (int j = 0; j < this.xValues.length; ++j) {
            float max = ytmp[0][j];
            for (int i = 1; i < this.nbgauss + 1; ++i) {
                float tmpmax = Math.abs(ytmp[i][j] - this.yValues[j]);
                if (!(tmpmax < Math.abs(max - this.yValues[j]))) continue;
                max = ytmp[i][j];
            }
            this.yValuesMergeGaussFit[j] = max;
        }
        FileInfo fi = this.origin.getOriginalFileInfo();
        PlotWindow pw = new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + "  " + fi.fileName, this.xLabel, this.yLabel, this.xValues, this.yValues, this.yValuesMergeGaussFit, this.origin);
        pw.draw();
        this.close();
    }

    public void setJustification(int justification) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    void drawXLabel(String yLabel, int x, int y, int height, FontMetrics fm) {
        if (yLabel.equals("")) {
            return;
        }
        int w = fm.stringWidth(yLabel) + 5;
        int h = fm.getHeight() + 5;
        ByteProcessor label = new ByteProcessor(w, h);
        ((ImageProcessor)label).setColor(Color.white);
        label.fill();
        ((ImageProcessor)label).setColor(Color.black);
        label.setFont(this.font);
        label.setAntialiasedText(true);
        int descent = fm.getDescent();
        label.drawString(yLabel, 0, h - descent);
        int y2 = y + (height - this.ip.getStringWidth(yLabel)) / 2;
        if (y2 < y) {
            y2 = y;
        }
        int x2 = Math.max(x - h, 0);
        this.ip.insert(label, x2, y2);
    }

    static {
        defaultDirectory = null;
        plotWidth = 450;
        plotHeight = 200;
        RadioSpectra = false;
        Base_Line = false;
        Base_Line_subtracted = false;
        ZERO_LINE = false;
        IJ.register(PlotWindow.class);
        options = Prefs.getInt(OPTIONS, 1);
        saveXValues = (options & 1) != 0;
        autoClose = (options & 2) != 0;
        plotWidth = Prefs.getInt(PLOT_WIDTH, 450);
        plotHeight = Prefs.getInt(PLOT_HEIGHT, 200);
    }
}

