/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.measure.Calibration;
import java.awt.BorderLayout;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class StackWindow
extends ImageWindow
implements Runnable,
AdjustmentListener,
ActionListener,
MouseWheelListener {
    protected Scrollbar channelSelector;
    protected Scrollbar sliceSelector;
    protected Scrollbar frameSelector;
    protected Thread thread;
    protected volatile boolean done;
    protected volatile int slice;
    boolean viewIn5D;
    int nChannels = 1;
    int nSlices = 1;
    int nFrames = 1;
    int c = 1;
    int z = 1;
    int t = 1;

    public StackWindow(ImagePlus imp) {
        this(imp, null);
    }

    public StackWindow(ImagePlus imp, boolean accessibleImage) {
        this(imp, new ImageCanvas(imp), accessibleImage);
    }

    public StackWindow(ImagePlus imp, ImageCanvas ic) {
        this(imp, ic, true);
    }

    public StackWindow(ImagePlus imp, ImageCanvas ic, boolean accessibleImage) {
        super(imp, ic, accessibleImage);
        int stackSize;
        ImageStack s = imp.getStack();
        this.nSlices = stackSize = s.getSize();
        this.viewIn5D = imp.getOpenAsHyperVolume();
        imp.setOpenAsHyperVolume(false);
        if (this.viewIn5D) {
            int[] dim = imp.getDimensions();
            this.nChannels = dim[2];
            this.nSlices = dim[3];
            this.nFrames = dim[4];
        }
        if (this.nSlices == stackSize) {
            this.viewIn5D = false;
        }
        this.addMouseWheelListener(this);
        ImageJ ij = IJ.getInstance();
        if (this.nChannels > 1) {
            this.channelSelector = new Scrollbar(0, 1, 1, 1, this.nChannels + 1);
            Panel panel = new Panel(new BorderLayout(2, 0));
            this.add(this.channelSelector);
            if (ij != null) {
                this.channelSelector.addKeyListener(ij);
            }
            this.channelSelector.addAdjustmentListener(this);
            this.channelSelector.setFocusable(false);
            this.channelSelector.setUnitIncrement(1);
            this.channelSelector.setBlockIncrement(1);
        }
        if (this.nSlices > 1) {
            this.sliceSelector = new Scrollbar(0, 1, 1, 1, this.nSlices + 1);
            this.add(this.sliceSelector);
            if (ij != null) {
                this.sliceSelector.addKeyListener(ij);
            }
            this.sliceSelector.addAdjustmentListener(this);
            this.sliceSelector.setFocusable(false);
            int blockIncrement = this.nSlices / 10;
            if (blockIncrement < 1) {
                blockIncrement = 1;
            }
            this.sliceSelector.setUnitIncrement(1);
            this.sliceSelector.setBlockIncrement(blockIncrement);
        }
        if (this.nFrames > 1) {
            this.frameSelector = new Scrollbar(0, 1, 1, 1, this.nFrames + 1);
            this.add(this.frameSelector);
            if (ij != null) {
                this.frameSelector.addKeyListener(ij);
            }
            this.frameSelector.addAdjustmentListener(this);
            this.frameSelector.setFocusable(false);
            int blockIncrement = this.nFrames / 10;
            if (blockIncrement < 1) {
                blockIncrement = 1;
            }
            this.frameSelector.setUnitIncrement(1);
            this.frameSelector.setBlockIncrement(blockIncrement);
        }
        this.pack();
        this.show();
        int previousSlice = imp.getCurrentSlice();
        imp.setSlice(1);
        if (previousSlice > 1 && previousSlice <= stackSize) {
            imp.setSlice(previousSlice);
        }
        this.thread = new Thread((Runnable)this, "SliceSelector");
        this.thread.start();
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.running2) {
            if (e.getSource() == this.channelSelector) {
                this.c = this.channelSelector.getValue();
            } else if (e.getSource() == this.sliceSelector) {
                this.z = this.sliceSelector.getValue();
            } else if (e.getSource() == this.frameSelector) {
                this.t = this.frameSelector.getValue();
            }
            this.slice = (this.t - 1) * this.nChannels * this.nSlices + (this.z - 1) * this.nChannels + this.c;
            this.notify();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this.viewIn5D) {
            return;
        }
        StackWindow stackWindow = this;
        synchronized (stackWindow) {
            int slice = this.imp.getCurrentSlice() + event.getWheelRotation();
            if (slice < 1) {
                slice = 1;
            } else if (slice > this.imp.getStack().getSize()) {
                slice = this.imp.getStack().getSize();
            }
            this.imp.setSlice(slice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        if (!super.close()) {
            return false;
        }
        StackWindow stackWindow = this;
        synchronized (stackWindow) {
            this.done = true;
            this.notify();
        }
        return true;
    }

    public void showSlice(int index) {
        if (index >= 1 && index <= this.imp.getStackSize()) {
            this.imp.setSlice(index);
        }
    }

    public void updateSliceSelector() {
        if (this.viewIn5D) {
            return;
        }
        int stackSize = this.imp.getStackSize();
        int max = this.sliceSelector.getMaximum();
        if (max != stackSize + 1) {
            this.sliceSelector.setMaximum(stackSize + 1);
        }
        this.sliceSelector.setValue(this.imp.getCurrentSlice());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.done) {
            StackWindow stackWindow = this;
            synchronized (stackWindow) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.done) {
                return;
            }
            if (this.slice <= 0) continue;
            int s = this.slice;
            this.slice = 0;
            if (s == this.imp.getCurrentSlice()) continue;
            this.imp.setSlice(s);
        }
    }

    @Override
    public String createSubtitle() {
        String s = super.createSubtitle();
        if (!this.viewIn5D) {
            return s;
        }
        s = "";
        if (this.nChannels > 1) {
            s = s + "c:" + this.c + "/" + this.nChannels;
            s = this.nSlices == 1 && this.nFrames == 1 ? s + "; " : s + " ";
        }
        if (this.nSlices > 1) {
            s = s + "z:" + this.z + "/" + this.nSlices;
            s = this.nFrames == 1 ? s + "; " : s + " ";
        }
        if (this.nFrames > 1) {
            s = s + "t:" + this.t + "/" + this.nFrames;
            s = s + "; ";
        }
        if (this.running2) {
            return s;
        }
        int type = this.imp.getType();
        Calibration cal = this.imp.getCalibration();
        s = cal.scaled() ? s + IJ.d2s((double)this.imp.getWidth() * cal.pixelWidth, 2) + "x" + IJ.d2s((double)this.imp.getHeight() * cal.pixelHeight, 2) + " " + cal.getUnits() + " (" + this.imp.getWidth() + "x" + this.imp.getHeight() + "); " : s + this.imp.getWidth() + "x" + this.imp.getHeight() + " pixels; ";
        int size = this.imp.getWidth() * this.imp.getHeight() * this.imp.getStackSize() / 1024;
        switch (type) {
            case 0: 
            case 3: {
                s = s + "8-bit";
                break;
            }
            case 1: {
                s = s + "16-bit";
                size *= 2;
                break;
            }
            case 2: {
                s = s + "32-bit";
                size *= 4;
                break;
            }
            case 4: {
                s = s + "RGB";
                size *= 4;
            }
        }
        if (this.imp.isInvertedLut()) {
            s = s + " (inverting LUT)";
        }
        if (size >= 10000) {
            s = s + "; " + (int)Math.round((double)size / 1024.0) + "MB";
        } else if (size >= 1024) {
            double size2 = (double)size / 1024.0;
            s = s + "; " + IJ.d2s(size2, (double)((int)size2) == size2 ? 0 : 1) + "MB";
        } else {
            s = s + "; " + size + "K";
        }
        return s;
    }

    public boolean is5D() {
        return this.viewIn5D;
    }
}

