/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.plugin.PlugIn;
import java.applet.Applet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class BrowserLauncher
implements PlugIn {
    private static Class mrjFileUtilsClass;
    private static Method openURL;
    private static boolean error;

    @Override
    public void run(String theURL) {
        System.out.println(theURL);
        String urlEuHou = "http://www.euhou.net/";
        if (error) {
            return;
        }
        theURL = theURL == null || theURL.equals("") ? urlEuHou : urlEuHou + theURL;
        Applet applet = IJ.getApplet();
        if (applet != null) {
            try {
                applet.getAppletContext().showDocument(new URL(theURL), "_blank");
                System.out.println("ok 1");
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        try {
            BrowserLauncher.openURL(theURL);
            System.out.println("ok 2");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static void openURL(String url) throws IOException {
        String errorMessage = "";
        if (IJ.isMacOSX()) {
            try {
                Method aMethod = mrjFileUtilsClass.getDeclaredMethod("sharedWorkspace", new Class[0]);
                Object aTarget = aMethod.invoke((Object)mrjFileUtilsClass, new Object[0]);
                openURL.invoke(aTarget, new URL(url));
            }
            catch (Exception e) {
                errorMessage = "" + e;
            }
        } else {
            if (IJ.isWindows()) {
                String cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                if (System.getProperty("os.name").startsWith("Windows 2000")) {
                    cmd = "rundll32 shell32.dll,ShellExec_RunDLL " + url;
                }
                Process process = Runtime.getRuntime().exec(cmd);
                try {
                    process.waitFor();
                    process.exitValue();
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            String[] browsers = new String[]{"netscape", "firefox", "konqueror", "mozilla", "opera", "epiphany", "lynx"};
            String browserName = null;
            try {
                for (int count = 0; count < browsers.length && browserName == null; ++count) {
                    String[] c = new String[]{"which", browsers[count]};
                    if (Runtime.getRuntime().exec(c).waitFor() != 0) continue;
                    browserName = browsers[count];
                }
                if (browserName == null) {
                    IJ.error("BrowserLauncher", "Could not find a browser");
                } else {
                    Runtime.getRuntime().exec(new String[]{browserName, url});
                }
            }
            catch (Exception e) {
                throw new IOException("Exception while launching browser: " + e.getMessage());
            }
        }
    }

    private static void loadClasses() {
        if (IJ.isMacOSX()) {
            try {
                if (new File("/System/Library/Java/com/apple/cocoa/application/NSWorkspace.class").exists()) {
                    URLClassLoader classLoader = new URLClassLoader(new URL[]{new File("/System/Library/Java").toURL()});
                    mrjFileUtilsClass = Class.forName("com.apple.cocoa.application.NSWorkspace", true, classLoader);
                } else {
                    mrjFileUtilsClass = Class.forName("com.apple.cocoa.application.NSWorkspace");
                }
                openURL = mrjFileUtilsClass.getDeclaredMethod("openURL", URL.class);
            }
            catch (Exception e) {
                IJ.log("BrowserLauncher" + e);
                error = true;
            }
        }
    }

    static {
        BrowserLauncher.loadClasses();
    }
}

