/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import java.applet.Applet;
import java.awt.Frame;
import java.io.File;

public class Commands
implements PlugIn {
    @Override
    public void run(String cmd) {
        System.out.println("Commands.run :" + cmd);
        if (cmd.equals("new")) {
            System.out.println("Commands.new");
            new NewImage();
        } else if (cmd.equals("open")) {
            if (Prefs.useJFileChooser && !IJ.macroRunning()) {
                System.out.println("Commands.run2");
                new Opener().openMultiple();
            } else {
                System.out.println("Commands.run3");
                new Opener().open();
            }
        } else if (cmd.equals("close")) {
            System.out.println("Commands.run4");
            this.close();
        } else if (cmd.equals("save")) {
            System.out.println("Commands.run5");
            this.save();
        } else if (cmd.equals("ij")) {
            System.out.println("Commands.run6");
            ImageJ ij = IJ.getInstance();
            if (ij != null) {
                System.out.println("Commands.run7");
                ij.toFront();
            }
        } else if (cmd.equals("tab")) {
            System.out.println("Commands.run8");
            WindowManager.putBehind();
        } else if (cmd.equals("quit")) {
            System.out.println("Commands.run9");
            ImageJ ij = IJ.getInstance();
            if (ij != null) {
                System.out.println("Commands.run10");
                ij.quit();
            }
        } else if (cmd.equals("revert")) {
            System.out.println("Commands.run11");
            this.revert();
        } else if (cmd.equals("undo")) {
            System.out.println("Commands.run12");
            this.undo();
        } else if (cmd.equals("startup")) {
            System.out.println("Commands.run13");
            this.openStartupMacros();
        }
    }

    void revert() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.revert();
        } else {
            IJ.noImage();
        }
    }

    void save() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            new FileSaver(imp).save();
        } else {
            IJ.noImage();
        }
    }

    void undo() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            Undo.undo();
        } else {
            IJ.noImage();
        }
    }

    void close() {
        ImagePlus imp = WindowManager.getCurrentImage();
        Frame frame = WindowManager.getFrontWindow();
        if (frame == null || Interpreter.isBatchMode() && frame instanceof ImageWindow) {
            this.closeImage(imp);
        } else if (frame instanceof PlugInFrame) {
            ((PlugInFrame)frame).close();
        } else if (frame instanceof TextWindow) {
            ((TextWindow)frame).close();
        } else {
            this.closeImage(imp);
        }
    }

    void closeImage(ImagePlus imp) {
        if (imp == null) {
            IJ.noImage();
            return;
        }
        imp.close();
        if (Recorder.record) {
            Recorder.record("close");
            Recorder.setCommand(null);
        }
    }

    void openStartupMacros() {
        Applet applet = IJ.getApplet();
        if (applet != null) {
            IJ.run("URL...", "url=http://rsb.info.nih.gov/ij/applet/StartupMacros.txt");
        } else {
            String path = IJ.getDirectory("macros") + "/StartupMacros.txt";
            File f = new File(path);
            if (!f.exists()) {
                IJ.error("\"StartupMacros.txt\" not found in ImageJ/macros/");
            } else {
                IJ.open(path);
            }
        }
    }
}

