/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Plot;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.FITS_Reader;
import ij.plugin.FitsDecoder;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import skyview.data.CoordinateFormatter;
import skyview.geometry.Util;
import skyview.geometry.WCS;

public class FITS
extends ImagePlus
implements PlugIn {
    private static ResourceBundle bun = IJ.getPluginBundle();
    private WCS wcs;
    private BasicHDU[] BHDU;
    private static FITS instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String arg) {
        FileOutputStream fis = null;
        try {
            BasicHDU[] bhdu;
            Fits myFits;
            FileInfo fi;
            FitsDecoder fd;
            String fileName;
            ImagePlus imp;
            block150: {
                instance = this;
                this.wcs = null;
                imp = null;
                OpenDialog od = new OpenDialog("Open FITS...", arg);
                String directory = od.getDirectory();
                fileName = od.getFileName();
                if (fileName == null) {
                    return;
                }
                IJ.showStatus("Opening: " + directory + fileName);
                IJ.log("Opening: " + directory + fileName);
                fd = new FitsDecoder(directory, fileName);
                fi = null;
                try {
                    fi = fd.getInfo();
                }
                catch (IOException e) {
                    // empty catch block
                }
                myFits = new Fits(directory + fileName);
                bhdu = null;
                try {
                    bhdu = myFits.read();
                }
                catch (Exception e) {
                    FITS_Reader reader = new FITS_Reader();
                    reader.run(arg);
                    if (reader.getProcessor() != null) {
                        reader.show();
                    }
                    if (!IJ.debug) break block150;
                    System.out.println("PB reading fits");
                }
            }
            int dim = bhdu[0].getAxes().length;
            try {
                int wi = 0;
                int he = 0;
                int de = 0;
                if (dim < 2 && fi != null) {
                    wi = fi.width;
                    he = fi.height;
                    de = 1;
                } else {
                    wi = bhdu[0].getAxes()[dim - 1];
                    he = bhdu[0].getAxes()[dim - 2];
                    de = dim > 2 ? bhdu[0].getAxes()[dim - 3] : 1;
                }
                if (IJ.debug) {
                    System.out.println("Dim= " + dim + "  -- Height= " + he + " pixels -- Width= " + wi + " pixels");
                }
                int bit = bhdu[0].getBitPix();
                Header H = bhdu[0].getHeader();
                String s = new String("");
                if (bhdu[0].getObject() != null) {
                    s = s + IJ.getBundle().getString("OBJECT") + ": " + bhdu[0].getObject() + "\n";
                }
                if (bhdu[0].getTelescop() != null) {
                    s = s + IJ.getBundle().getString("TELESCOP") + ": " + bhdu[0].getTelescop() + "\n";
                }
                if (bhdu[0].getInstrum() != null) {
                    s = s + IJ.getBundle().getString("INSTRUM") + ": " + bhdu[0].getInstrum() + "\n";
                }
                if (bhdu[0].getFilter() != null) {
                    s = s + IJ.getBundle().getString("FILTER") + ": " + bhdu[0].getFilter() + "\n";
                }
                if (bhdu[0].getObserver() != null) {
                    s = s + IJ.getBundle().getString("OBSERVER") + ": " + bhdu[0].getObserver() + "\n";
                }
                if (bhdu[0].getExptime() != null) {
                    s = s + IJ.getBundle().getString("EXPTIME") + ": " + bhdu[0].getExptime() + "\n";
                }
                if (bhdu[0].getDateObs() != null) {
                    s = s + IJ.getBundle().getString("DATE-OBS") + ": " + bhdu[0].getDateObs() + "\n";
                }
                if (bhdu[0].getUT() != null) {
                    s = s + IJ.getBundle().getString("UT") + ": " + bhdu[0].getUT() + "\n";
                }
                if (bhdu[0].getUTC() != null) {
                    s = s + IJ.getBundle().getString("UT") + ": " + bhdu[0].getUTC() + "\n";
                }
                if (bhdu[0].getRA() != null) {
                    s = s + IJ.getBundle().getString("RA") + ": " + bhdu[0].getRA() + "\n";
                }
                if (bhdu[0].getDEC() != null) {
                    s = s + IJ.getBundle().getString("DEC") + ": " + bhdu[0].getDEC() + "\n";
                }
                s = s + "\n\n*************************************************************\n";
                if (IJ.debug) {
                    System.out.println("Header: \n" + s);
                }
                ImageData imgData = null;
                if (bhdu[0].getData() != null) {
                    imgData = (ImageData)bhdu[0].getData();
                } else if (IJ.debug) {
                    System.out.println("No data in fits !");
                }
                if (wi > 0 && he > 0) {
                    if (de == 1) {
                        float[] yValues;
                        Object itab;
                        ImageProcessor ip = null;
                        if (IJ.debug) {
                            System.out.println("Bits " + bhdu[0].getBitPix() + " " + wi + " " + he);
                        }
                        if (bhdu[0].getNAXIS() == 2) {
                            float[] imgtab;
                            FloatProcessor imgtmp;
                            if (bhdu[0].getBitPix() == 16) {
                                itab = (short[][])imgData.getKernel();
                                int idx = 0;
                                imgtmp = new FloatProcessor(wi, he);
                                imgtab = new float[wi * he];
                                for (int y = 0; y < he; ++y) {
                                    for (int x = 0; x < wi; ++x) {
                                        imgtab[idx] = (float)bhdu[0].getBZero() + (float)bhdu[0].getBScale() * (float)itab[y][x];
                                        ++idx;
                                    }
                                }
                                imgtmp.setPixels(imgtab);
                                imgtmp.resetMinAndMax();
                                if (he == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(wi, 100);
                                }
                                if (wi == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(100, he);
                                }
                                if (IJ.debug) {
                                    System.out.println("ip " + imgtmp + " imp " + this);
                                }
                                ip = imgtmp;
                                ip.flipVertical();
                                this.setProcessor(fileName, ip);
                            } else if (bhdu[0].getBitPix() == 8) {
                                itab = (byte[][])imgData.getKernel();
                                int idx = 0;
                                imgtmp = new FloatProcessor(wi, he);
                                imgtab = new float[wi * he];
                                for (int y = 0; y < he; ++y) {
                                    for (int x = 0; x < wi; ++x) {
                                        if (itab[x][y] < 0) {
                                            short[] sArray = itab[x];
                                            int n = y;
                                            sArray[n] = (byte)(sArray[n] + 256);
                                        }
                                        imgtab[idx] = (float)bhdu[0].getBZero() + (float)bhdu[0].getBScale() * (float)itab[y][x];
                                        ++idx;
                                    }
                                }
                                imgtmp.setPixels(imgtab);
                                imgtmp.resetMinAndMax();
                                if (he == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(wi, 100);
                                }
                                if (wi == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(100, he);
                                }
                                if (IJ.debug) {
                                    System.out.println("ip " + imgtmp + " imp " + this);
                                }
                                ip = imgtmp;
                                ip.flipVertical();
                                this.setProcessor(fileName, ip);
                            } else if (bhdu[0].getBitPix() == 32) {
                                itab = (int[][])imgData.getKernel();
                                int idx = 0;
                                imgtmp = new FloatProcessor(wi, he);
                                imgtab = new float[wi * he];
                                for (int y = 0; y < he; ++y) {
                                    for (int x = 0; x < wi; ++x) {
                                        imgtab[idx] = (float)bhdu[0].getBZero() + (float)bhdu[0].getBScale() * (float)itab[y][x];
                                        ++idx;
                                    }
                                }
                                imgtmp.setPixels(imgtab);
                                imgtmp.resetMinAndMax();
                                if (he == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(wi, 100);
                                }
                                if (wi == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(100, he);
                                }
                                ip = imgtmp;
                                ip.flipVertical();
                                this.setProcessor(fileName, ip);
                            } else if (bhdu[0].getBitPix() == -32) {
                                itab = (float[][])imgData.getKernel();
                                int idx = 0;
                                imgtmp = new FloatProcessor(wi, he);
                                imgtab = new float[wi * he];
                                for (int y = 0; y < he; ++y) {
                                    for (int x = 0; x < wi; ++x) {
                                        imgtab[idx] = (float)bhdu[0].getBZero() + (float)bhdu[0].getBScale() * itab[y][x];
                                        ++idx;
                                    }
                                }
                                imgtmp.setPixels(imgtab);
                                imgtmp.resetMinAndMax();
                                if (he == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(wi, 100);
                                }
                                if (wi == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(100, he);
                                }
                                ip = imgtmp;
                                ip.flipVertical();
                                this.setProcessor(fileName, ip);
                                System.out.print("-32 bits " + ip + " " + this + " " + bhdu[0].getBZero() + " " + bhdu[0].getBScale() + " " + itab);
                                System.out.print("Status " + bhdu[0].getSTATUS());
                                if (bhdu[0].getSTATUS() != null && bhdu[0].getSTATUS().equals("SPECTRUM") && bhdu[0].getNAXIS() == 2) {
                                    if (IJ.debug) {
                                        System.out.println("spectre optique");
                                    }
                                    float[] xValues = new float[wi];
                                    float[] yValues2 = new float[wi];
                                    for (int y = 0; y < wi; ++y) {
                                        yValues2[y] = itab[0][y];
                                        if (!(yValues2[y] < 0.0f)) continue;
                                        yValues2[y] = 0.0f;
                                    }
                                    String unitY = "Intensity ";
                                    unitY = bun.getString("IntensityRS") + " ";
                                    String unitX = "Longueur d'onde ";
                                    unitX = bun.getString("WavelengthRS") + " ";
                                    float CRVAL1 = 0.0f;
                                    float CRPIX1 = 0.0f;
                                    float CDELT1 = 0.0f;
                                    if (bhdu[0].getCRVAL1() != null) {
                                        CRVAL1 = Float.parseFloat(bhdu[0].getCRVAL1());
                                    }
                                    if (bhdu[0].getCRPIX1() != null) {
                                        CRPIX1 = Float.parseFloat(bhdu[0].getCRPIX1());
                                    }
                                    if (bhdu[0].getCDELT1() != null) {
                                        CDELT1 = Float.parseFloat(bhdu[0].getCDELT1());
                                    }
                                    for (int x = 0; x < wi; ++x) {
                                        xValues[x] = CRVAL1 + ((float)x - CRPIX1) * CDELT1;
                                    }
                                    float odiv = 1.0f;
                                    if ((double)CRVAL1 < 1.0E-6) {
                                        odiv = 1000000.0f;
                                        unitX = unitX + "(\u00b5m)";
                                    } else {
                                        unitX = unitX + "ADU";
                                    }
                                    for (int x = 0; x < wi; ++x) {
                                        xValues[x] = xValues[x] * odiv;
                                    }
                                    Plot P = new Plot(IJ.getBundle().getString("PlotWinTitle") + " " + fileName, "X: " + unitX, "Y: " + unitY, xValues, yValues2);
                                    P.draw();
                                }
                            } else {
                                if (IJ.debug) {
                                    System.out.println("other case ");
                                }
                                ip = imp.getProcessor();
                            }
                        } else if (bhdu[0].getNAXIS() == 3 && bhdu[0].getAxes()[dim - 2] == 1 && bhdu[0].getAxes()[dim - 3] == 1) {
                            if (IJ.debug) {
                                System.out.println("Spectre radio Onsala");
                            }
                            itab = (short[][][])imgData.getKernel();
                            float[] xValues = new float[wi];
                            yValues = new float[wi];
                            for (int y = 0; y < wi; ++y) {
                                yValues[y] = (float)bhdu[0].getBZero() + (float)bhdu[0].getBScale() * (float)itab[0][0][y];
                            }
                            String unitY = "Intensity ";
                            unitY = bun.getString("IntensityRS") + " ";
                            String unitX = "Freq ";
                            unitX = bun.getString("FrequencyRS") + " ";
                            float CRVAL1 = 0.0f;
                            float CRPIX1 = 0.0f;
                            float CDELT1 = 0.0f;
                            if (bhdu[0].getCRVAL1() != null) {
                                CRVAL1 = Float.parseFloat(bhdu[0].getCRVAL1());
                            }
                            if (bhdu[0].getCRPIX1() != null) {
                                CRPIX1 = Float.parseFloat(bhdu[0].getCRPIX1());
                            }
                            if (bhdu[0].getCDELT1() != null) {
                                CDELT1 = Float.parseFloat(bhdu[0].getCDELT1());
                            }
                            for (int x = 0; x < wi; ++x) {
                                xValues[x] = CRVAL1 + ((float)x - CRPIX1) * CDELT1;
                            }
                            int div = 1;
                            if (CRVAL1 > 2.0E9f) {
                                div = 1000000000;
                                unitX = unitX + "(Ghz)";
                            } else if (CRVAL1 > 1.0E9f) {
                                div = 1000000;
                                unitX = unitX + "(Mhz)";
                            } else if (CRVAL1 > 1000000.0f) {
                                div = 1000;
                                unitX = unitX + "(Khz)";
                            } else {
                                unitX = unitX + "(Hz)";
                            }
                            for (int x = 0; x < wi; ++x) {
                                xValues[x] = xValues[x] / (float)div;
                            }
                            Plot P = new Plot(IJ.getBundle().getString("PlotWinTitle") + " " + fileName, "X: " + unitX, "Y: " + unitY, xValues, yValues);
                            P.draw();
                            FloatProcessor imgtmp = new FloatProcessor(wi, he);
                            imgtmp.setPixels(yValues);
                            imgtmp.resetMinAndMax();
                            if (he == 1) {
                                imgtmp = (FloatProcessor)imgtmp.resize(wi, 100);
                            }
                            if (wi == 1) {
                                imgtmp = (FloatProcessor)imgtmp.resize(100, he);
                            }
                            ip = imgtmp;
                            ip.flipVertical();
                            this.setProcessor(fileName, ip);
                        }
                        if (bhdu[0].getTelescop() != null && bhdu[0].getTelescop().equals("SRT-PARIS")) {
                            if (IJ.debug) {
                                System.out.println("For radiotelescope UPMC/OBSPM spectra");
                            }
                            short[] Upmcitab = (short[])imgData.getKernel();
                            float[] xValues = new float[wi];
                            yValues = new float[wi];
                            for (int y = 0; y < wi; ++y) {
                                yValues[y] = Upmcitab[y];
                            }
                            String unitY = "Intensity ";
                            unitY = bun.getString("IntensityRS") + " ";
                            String unitX = "Freq ";
                            unitX = bun.getString("FrequencyRS") + " ";
                            float CRVAL1 = 0.0f;
                            float CRPIX1 = 0.0f;
                            float CDELT1 = 0.0f;
                            if (bhdu[0].getCRVAL1() != null) {
                                CRVAL1 = Float.parseFloat(bhdu[0].getCRVAL1());
                            }
                            if (bhdu[0].getCRPIX1() != null) {
                                CRPIX1 = Float.parseFloat(bhdu[0].getCRPIX1());
                            }
                            if (bhdu[0].getCDELT1() != null) {
                                CDELT1 = Float.parseFloat(bhdu[0].getCDELT1());
                            }
                            for (int x = 0; x < wi; ++x) {
                                xValues[x] = (CRVAL1 + ((float)x - CRPIX1) * CDELT1) / 1000000.0f;
                            }
                            FloatProcessor Upmcimgtmp = new FloatProcessor(wi, he);
                            Upmcimgtmp.setPixels(yValues);
                            Upmcimgtmp.resetMinAndMax();
                            Upmcimgtmp = (FloatProcessor)Upmcimgtmp.resize(wi, 100);
                            ip = Upmcimgtmp;
                            ip.flipVertical();
                            this.setProcessor(fileName, ip);
                            double OliFrqMin = 1419.9;
                            double OliFrqMax = 1420.9;
                            if (IJ.debug) {
                                System.out.println(OliFrqMin + "  " + OliFrqMax);
                            }
                            int x = 1;
                            while ((double)xValues[x] < OliFrqMin) {
                                ++x;
                            }
                            float Olicut = yValues[x];
                            if (IJ.debug) {
                                System.out.println("X= " + x + "  X(x)= " + xValues[x] + " Y(x)= " + Olicut);
                            }
                            while ((double)xValues[x] < OliFrqMax) {
                                ++x;
                            }
                            if (IJ.debug) {
                                System.out.println("X= " + x + " X(x)= " + xValues[x] + " Y(x)= " + yValues[x - 1]);
                            }
                            Olicut = (Olicut + yValues[x - 1]) / 2.0f;
                            for (int y = 0; y < wi; ++y) {
                                if (!(yValues[y] < Olicut)) continue;
                                yValues[y] = Olicut;
                            }
                            unitX = unitX + "(MHz)";
                            Plot P = new Plot(IJ.getBundle().getString("PlotWinTitle") + " " + fileName, "X: " + unitX, "Y: " + unitY, xValues, yValues);
                            P.draw();
                        }
                        if (ip == null) {
                            ip = imp.getProcessor();
                            ip.flipVertical();
                            this.setProcessor(fileName, ip);
                        }
                    } else {
                        ImageStack stack = imp.getStack();
                        for (int i = 1; i <= stack.getSize(); ++i) {
                            stack.getProcessor(i).flipVertical();
                        }
                        this.setStack(fileName, stack);
                    }
                    if (fd != null) {
                        this.setProperty("Info", s + fd.getHeaderInfo());
                    }
                    if (fi != null) {
                        this.setFileInfo(fi);
                    }
                    this.show();
                } else {
                    IJ.error("This does not appear to be a FITS file. " + wi + " " + he);
                }
                IJ.showStatus("");
                File file = new File("tmp.fits");
                fis = new FileOutputStream(file);
                DataOutputStream dos = new DataOutputStream(fis);
                myFits.write(dos);
                try {
                    this.wcs = new WCS(H);
                    if (IJ.debug) {
                        System.out.println("Reading the Wcs");
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(FITS.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (FitsException ex) {
                Logger.getLogger(FITS.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(FITS.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        catch (Exception e) {
            if (IJ.debug) {
                System.out.println("This is the exception case " + e);
            }
            if (this != null) {
                return;
            }
            OpenDialog od = new OpenDialog("Open FITS...", arg);
            String directory = od.getDirectory();
            String fileName = od.getFileName();
            if (fileName == null) {
                return;
            }
            IJ.showStatus("Opening: " + directory + fileName);
            FitsDecoder fd = new FitsDecoder(directory, fileName);
            FileInfo fi = null;
            try {
                fi = fd.getInfo();
            }
            catch (IOException er) {
                // empty catch block
            }
            if (fi != null && fi.width > 0 && fi.height > 0 && fi.offset > 0) {
                FileOpener fo = new FileOpener(fi);
                ImagePlus imp = fo.open(false);
                if (fi.nImages == 1) {
                    ImageProcessor ip = imp.getProcessor();
                    ip.flipVertical();
                    this.setProcessor(fileName, ip);
                } else {
                    ImageStack stack = imp.getStack();
                    for (int i = 1; i <= stack.getSize(); ++i) {
                        stack.getProcessor(i).flipVertical();
                    }
                    this.setStack(fileName, stack);
                }
                Calibration cal = imp.getCalibration();
                if (fi.fileType == 1 && fd.getBscale() == 1.0 && fd.getBzero() == 32768.0) {
                    cal.setFunction(20, null, "Gray Value");
                }
                if (fi.fileType == 1 && fd.getBscale() == 1.0 && fd.getBzero() == 0.0) {
                    cal.setFunction(20, null, "Gray Value");
                }
                this.setCalibration(cal);
                this.setProperty("Info", fd.getHeaderInfo());
                try {
                    BasicHDU[] bhduExc = null;
                    Fits myFits = null;
                    myFits = new Fits(directory + File.separator + fileName);
                    bhduExc = myFits.read();
                    Header HH = bhduExc[0].getHeader();
                    this.wcs = new WCS(HH);
                    if (IJ.debug) {
                        System.out.println("Reading the Wcs in the exception");
                    }
                    String s = new String("");
                    if (bhduExc[0].getObject() != null) {
                        s = s + IJ.getBundle().getString("OBJECT") + ": " + bhduExc[0].getObject() + "\n";
                    }
                    if (bhduExc[0].getTelescop() != null) {
                        s = s + IJ.getBundle().getString("TELESCOP") + ": " + bhduExc[0].getTelescop() + "\n";
                    }
                    if (bhduExc[0].getInstrum() != null) {
                        s = s + IJ.getBundle().getString("INSTRUM") + ": " + bhduExc[0].getInstrum() + "\n";
                    }
                    if (bhduExc[0].getFilter() != null) {
                        s = s + IJ.getBundle().getString("FILTER") + ": " + bhduExc[0].getFilter() + "\n";
                    }
                    if (bhduExc[0].getObserver() != null) {
                        s = s + IJ.getBundle().getString("OBSERVER") + ": " + bhduExc[0].getObserver() + "\n";
                    }
                    if (bhduExc[0].getExptime() != null) {
                        s = s + IJ.getBundle().getString("EXPTIME") + ": " + bhduExc[0].getExptime() + "\n";
                    }
                    if (bhduExc[0].getDateObs() != null) {
                        s = s + IJ.getBundle().getString("DATE-OBS") + ": " + bhduExc[0].getDateObs() + "\n";
                    }
                    if (bhduExc[0].getUT() != null) {
                        s = s + IJ.getBundle().getString("UT") + ": " + bhduExc[0].getUT() + "\n";
                    }
                    if (bhduExc[0].getUTC() != null) {
                        s = s + IJ.getBundle().getString("UT") + ": " + bhduExc[0].getUTC() + "\n";
                    }
                    if (bhduExc[0].getRA() != null) {
                        s = s + IJ.getBundle().getString("RA") + ": " + bhduExc[0].getRA() + "\n";
                    }
                    if (bhduExc[0].getDEC() != null) {
                        s = s + IJ.getBundle().getString("DEC") + ": " + bhduExc[0].getDEC() + "\n";
                    }
                    s = s + "\n\n*************************************************************\n";
                    this.setProperty("Info", s + fd.getHeaderInfo());
                }
                catch (Exception ee) {
                    // empty catch block
                }
                this.setFileInfo(fi);
                if (arg.equals("")) {
                    this.show();
                }
            } else if (this == null) {
                IJ.error("This does not appear to be a FITS file.");
            }
            IJ.showStatus("");
        }
    }

    public static String getkeyword(String keyword, String path) throws IOException {
        ImagePlus imp = null;
        imp = new ImagePlus(path);
        FileInfo fi = imp.getFileInfo();
        ImageProcessor ip = imp.getProcessor();
        File file = new File(path);
        RandomAccessFile f = new RandomAccessFile(file, "r");
        f.seek(0L);
        String s = FITS.getString(80, f);
        while (!s.startsWith("END")) {
            if (s.startsWith(keyword)) {
                f.close();
                return s;
            }
            s = FITS.getString(80, f);
        }
        f.close();
        s = "";
        return s;
    }

    @Override
    public String getLocationAsString(int x, int y) {
        String s;
        if (this.wcs != null) {
            double[] in = new double[]{x, (double)(this.getProcessor().getHeight() - y) - 1.0};
            double[] out = this.wcs.inverse().transform(in);
            double[] coord = new double[2];
            Util.coord(out, coord);
            CoordinateFormatter cf = new CoordinateFormatter();
            String[] ra = cf.sexagesimal(Math.toDegrees(coord[0]) / 15.0, 8).split(" ");
            String[] dec = cf.sexagesimal(Math.toDegrees(coord[1]), 8).split(" ");
            s = "x=" + x + ",y=" + y + " (RA=" + ra[0] + "h" + ra[1] + "m" + ra[2] + "s,  DEC=" + dec[0] + "\u00b0 " + dec[1] + "' " + dec[2] + "\"" + ")";
        } else {
            s = "x=" + x + " y=" + y;
        }
        if (this.getStackSize() > 1) {
            s = s + " z=" + (this.getCurrentSlice() - 1);
        }
        return s;
    }

    static String getString(int length, RandomAccessFile f) throws IOException {
        byte[] b = new byte[length];
        f.read(b);
        return new String(b);
    }

    public BasicHDU[] getBHDU() {
        return this.BHDU;
    }

    public static FITS getInstance() {
        return instance;
    }
}

