/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.io.FileInfo;
import ij.plugin.RadioSpectrum_Reader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FitsDecoder {
    private String directory;
    private String fileName;
    private DataInputStream f;
    private StringBuffer info = new StringBuffer(512);
    private double bscale = 1.0;
    private double bzero = 0.0;
    private double restfreq = 0.0;
    private double crval1 = 0.0;
    private double crval2 = 0.0;
    private double crval3 = 0.0;
    private double cdelt1 = 0.0;
    private double cdelt2 = 0.0;
    private double cdelt3 = 0.0;
    private double crpix1 = 0.0;
    private double deltav = 0.0;
    private double velolsr = 0.0;
    private double crpix2 = 0.0;
    private double naxis1 = 0.0;
    private double naxis2 = 0.0;
    private double crpix3 = 0.0;
    private String ctype1 = "";
    private String cunit1 = "";
    private String Telescop = "";

    public FitsDecoder(String directory, String fileName) {
        this.directory = directory;
        this.fileName = fileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileInfo getInfo() throws IOException {
        FileInfo fi = new FileInfo();
        fi.fileFormat = 4;
        fi.fileName = this.fileName;
        fi.directory = this.directory;
        fi.width = 0;
        fi.height = 1;
        fi.offset = 0;
        fi.url = "";
        DataInputStream stream = null;
        if (this.directory.startsWith("http")) {
            IJ.log("Reading over the Internet " + this.directory + " " + this.fileName);
            try {
                stream = new DataInputStream(new URL(this.directory + this.fileName).openStream());
                fi.url = this.directory;
            }
            catch (IOException ex) {
                Logger.getLogger(RadioSpectrum_Reader.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                stream = new DataInputStream(new FileInputStream(this.directory + this.fileName));
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(RadioSpectrum_Reader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (stream == null) {
            return null;
        }
        this.f = stream;
        String s = this.getString(80);
        this.info.append(s + "\n");
        if (!s.startsWith("SIMPLE")) {
            this.f.close();
            return null;
        }
        int count = 1;
        do {
            block55: {
                block56: {
                    int bitsPerPixel;
                    block59: {
                        block58: {
                            block57: {
                                ++count;
                                s = this.getString(80);
                                this.info.append(s + "\n");
                                if (!s.startsWith("BITPIX")) break block56;
                                bitsPerPixel = this.getInteger(s);
                                if (bitsPerPixel != 8) break block57;
                                fi.fileType = 0;
                                break block55;
                            }
                            if (bitsPerPixel != 16) break block58;
                            fi.fileType = 1;
                            break block55;
                        }
                        if (bitsPerPixel != -16) break block59;
                        fi.fileType = 1;
                        break block55;
                    }
                    if (bitsPerPixel == 32) {
                        fi.fileType = 3;
                        break block55;
                    } else if (bitsPerPixel == -32) {
                        fi.fileType = 4;
                        break block55;
                    } else {
                        if (bitsPerPixel != -64) {
                            IJ.error("BITPIX must be 8, 16, 32, -32 (float) or -64 (double).");
                            this.f.close();
                            return null;
                        }
                        fi.fileType = 16;
                    }
                    break block55;
                }
                if (s.startsWith("NAXIS1")) {
                    fi.width = this.getInteger(s);
                } else if (s.startsWith("NAXIS2")) {
                    fi.height = this.getInteger(s);
                } else if (s.startsWith("NAXIS3")) {
                    fi.nImages = this.getInteger(s);
                } else if (s.startsWith("BSCALE")) {
                    this.bscale = this.getFloat(s);
                } else if (s.startsWith("BZERO")) {
                    this.bzero = this.getFloat(s);
                } else if (s.startsWith("RESTFREQ")) {
                    this.restfreq = this.getFloat(s);
                } else if (s.startsWith("CRVAL1")) {
                    this.crval1 = this.getFloat(s);
                } else if (s.startsWith("CRVAL2")) {
                    this.crval2 = this.getFloat(s);
                } else if (s.startsWith("CRVAL3")) {
                    this.crval3 = this.getFloat(s);
                } else if (s.startsWith("CDELT1")) {
                    this.cdelt1 = this.getFloat(s);
                } else if (s.startsWith("CDELT1")) {
                    this.cdelt1 = this.getFloat(s);
                } else if (s.startsWith("CDELT2")) {
                    this.cdelt2 = this.getFloat(s);
                } else if (s.startsWith("CDELT3")) {
                    this.cdelt3 = this.getFloat(s);
                } else if (s.startsWith("VELO-LSR") || s.startsWith("VLSR")) {
                    this.velolsr = this.getFloat(s);
                } else if (s.startsWith("DELTAV")) {
                    this.deltav = this.getFloat(s);
                } else if (s.startsWith("CRPIX1")) {
                    this.crpix1 = this.getFloat(s);
                } else if (s.startsWith("CRPIX2")) {
                    this.crpix2 = this.getFloat(s);
                } else if (s.startsWith("CRPIX3")) {
                    this.crpix3 = this.getFloat(s);
                } else if (s.startsWith("CTYPE1")) {
                    this.ctype1 = s.trim();
                } else if (s.startsWith("CUNIT1")) {
                    this.cunit1 = s.trim();
                } else if (s.startsWith("TELESCOP")) {
                    this.Telescop = s.trim();
                }
            }
            if (count <= 360 || fi.width != 0) continue;
            this.f.close();
            return null;
        } while (!s.startsWith("END"));
        this.f.close();
        fi.offset = 2880 + 2880 * ((count * 80 - 1) / 2880);
        return fi;
    }

    String getString(int length) throws IOException {
        byte[] b = new byte[length];
        this.f.read(b);
        return new String(b);
    }

    int getInteger(String s) {
        s = s.substring(10, 30);
        s = s.trim();
        return Integer.parseInt(s);
    }

    double getFloat(String s) {
        Double d;
        s = s.substring(10, 30);
        s = s.trim();
        try {
            d = new Double(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public double getBscale() {
        return this.bscale;
    }

    public String getTelescop() {
        return this.Telescop;
    }

    public double getBzero() {
        return this.bzero;
    }

    public double getRestfreq() {
        return this.restfreq;
    }

    public double getCrval1() {
        return this.crval1;
    }

    public double getCrval2() {
        return this.crval2;
    }

    public double getCrval3() {
        return this.crval3;
    }

    public double getCdelt1() {
        return this.cdelt1;
    }

    public double getCrpix1() {
        return this.crpix1;
    }

    public double getVelolsr() {
        return this.velolsr;
    }

    public double getDeltav() {
        return this.deltav;
    }

    public String getHeaderInfo() {
        return new String(this.info);
    }

    public String getCtype1() {
        return this.ctype1;
    }

    public String getCunit1() {
        return this.cunit1;
    }
}

