/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import java.awt.Checkbox;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;

class FolderOpenerDialog
extends GenericDialog {
    ImagePlus imp;
    int fileCount;
    boolean eightBits;
    boolean rgb;
    String[] list;

    public FolderOpenerDialog(String title, ImagePlus imp, String[] list) {
        super(title);
        this.imp = imp;
        this.list = list;
        this.fileCount = list.length;
    }

    @Override
    protected void setup() {
        this.eightBits = ((Checkbox)this.checkbox.elementAt(0)).getState();
        this.rgb = ((Checkbox)this.checkbox.elementAt(1)).getState();
        this.setStackInfo();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Checkbox item = (Checkbox)e.getSource();
        Checkbox grayscaleCB = (Checkbox)this.checkbox.elementAt(0);
        Checkbox rgbCB = (Checkbox)this.checkbox.elementAt(1);
        if (item == grayscaleCB) {
            this.eightBits = item.getState();
            if (this.eightBits) {
                rgbCB.setState(false);
                this.rgb = false;
            }
        }
        if (item == rgbCB) {
            this.rgb = item.getState();
            if (this.rgb) {
                grayscaleCB.setState(false);
                this.eightBits = false;
            }
        }
        this.setStackInfo();
    }

    @Override
    public void textValueChanged(TextEvent e) {
        this.setStackInfo();
    }

    void setStackInfo() {
        int n2;
        TextField tf;
        String filter;
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int depth = this.imp.getStackSize();
        int bytesPerPixel = 1;
        int n = this.getNumber(this.numberField.elementAt(0));
        int start = this.getNumber(this.numberField.elementAt(1));
        int inc = this.getNumber(this.numberField.elementAt(2));
        double scale = this.getNumber(this.numberField.elementAt(3));
        if (scale < 5.0) {
            scale = 5.0;
        }
        if (scale > 100.0) {
            scale = 100.0;
        }
        if (n < 1) {
            n = this.fileCount;
        }
        if (start < 1 || start > this.fileCount) {
            start = 1;
        }
        if (start + n - 1 > this.fileCount) {
            n = this.fileCount - start + 1;
        }
        if (inc < 1) {
            inc = 1;
        }
        if (!(filter = (tf = (TextField)this.stringField.elementAt(0)).getText()).equals("") && !filter.equals("*")) {
            n2 = 0;
            for (int i = 0; i < this.list.length; ++i) {
                if (this.list[i].indexOf(filter) < 0) continue;
                ++n2;
            }
            if (n2 < n) {
                n = n2;
            }
        }
        switch (this.imp.getType()) {
            case 1: {
                bytesPerPixel = 2;
                break;
            }
            case 2: 
            case 4: {
                bytesPerPixel = 4;
            }
        }
        if (this.eightBits) {
            bytesPerPixel = 1;
        }
        if (this.rgb) {
            bytesPerPixel = 4;
        }
        width = (int)((double)width * scale / 100.0);
        height = (int)((double)height * scale / 100.0);
        n2 = (this.fileCount - start + 1) * depth / inc;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n) {
            n2 = n;
        }
        double size = (double)width * (double)height * (double)n2 * (double)bytesPerPixel / 1048576.0;
        ((Label)this.theLabel).setText(width + " x " + height + " x " + n2 + " (" + IJ.d2s(size, 1) + "MB)");
    }

    public int getNumber(Object field) {
        Double d;
        TextField tf = (TextField)field;
        String theText = tf.getText();
        try {
            d = new Double(theText);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return (int)d.doubleValue();
        }
        return 0;
    }
}

