/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.PlotWindow;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.FitsDecoder;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RadioSpectrum_Reader
implements PlugIn {
    public static int SCALETYPE;
    private final int pixel = 0;
    private final int velocity = 1;
    private final int frequency = 2;
    private final int wavelength = 3;
    private static double xGaussCenter;
    private static double yGaussCenter;
    private static double widthGauss;
    private static double area;
    private static double l;
    private static double b;
    private static String xLabel;
    private static String yLabel;
    private static Hashtable results;
    private static TextWindow res;
    private static int rdindex;
    private static ResourceBundle bun;
    public static boolean optique;
    private static boolean spectdata;
    public static double wave_ref;

    @Override
    public void run(String arg) {
        OpenDialog od = new OpenDialog(IJ.getBundle().getString("Open"), arg);
        String directory = od.getDirectory();
        String fileName = od.getFileName();
        if (fileName == null) {
            return;
        }
        IJ.showStatus("Opening: " + directory + fileName);
        InputStreamReader stream = null;
        if (directory.startsWith("http")) {
            IJ.log("Reading Spectrum over the Internet " + directory + " " + fileName);
            try {
                stream = new InputStreamReader(new URL(directory + fileName).openStream());
            }
            catch (IOException ex) {
                Logger.getLogger(RadioSpectrum_Reader.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                stream = new FileReader(directory + fileName);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(RadioSpectrum_Reader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (stream == null) {
            return;
        }
        spectdata = fileName.endsWith(".dat") || fileName.endsWith(".data") || fileName.endsWith(".csv");
        String freqUnit = "THz";
        String waveUnit = "nm";
        if (spectdata) {
            optique = true;
            ArrayList<Float> xarray = new ArrayList<Float>();
            ArrayList<Float> yarray = new ArrayList<Float>();
            int cpt = 0;
            boolean xx = false;
            try {
                BufferedReader bf = new BufferedReader(stream);
                String line = bf.readLine();
                while (line != null && (line = bf.readLine()) != null) {
                    String[] sp = line.split(" ");
                    xx = false;
                    for (int i = 0; i < sp.length; ++i) {
                        String s = sp[i];
                        if (s.length() <= 0) continue;
                        if (!xx) {
                            xarray.add(Float.valueOf(Float.parseFloat(sp[i])));
                            xx = true;
                            continue;
                        }
                        yarray.add(Float.valueOf(Float.parseFloat(sp[i])));
                    }
                    ++cpt;
                }
                float[] xtemp = new float[cpt];
                float[] ytemp = new float[cpt];
                for (int i = 0; i < cpt; ++i) {
                    xtemp[i] = ((Float)xarray.get(i)).floatValue();
                    ytemp[i] = ((Float)yarray.get(i)).floatValue();
                }
                int length = cpt;
                float[] xValues = new float[length];
                block51: for (int i = 0; i < length; ++i) {
                    float tmp_wave = xtemp[i] / 10.0f;
                    float tmp_freq = (float)(3.0E8 / ((double)tmp_wave * 1.0E-9));
                    float tmp_freq0 = (float)(3.0E17 / wave_ref);
                    switch (SCALETYPE) {
                        case 0: {
                            xValues[i] = i;
                            continue block51;
                        }
                        case 1: {
                            xValues[i] = (float)(3.0E8 * ((double)(tmp_freq0 / tmp_freq) - 1.0) * 0.001);
                            continue block51;
                        }
                        case 2: {
                            xValues[i] = (float)((double)tmp_freq * 1.0E-12);
                            continue block51;
                        }
                        case 3: {
                            xValues[i] = tmp_wave;
                            continue block51;
                        }
                        default: {
                            xValues[i] = i;
                        }
                    }
                }
                float[] yValues = new float[length];
                System.arraycopy(ytemp, 0, yValues, 0, length);
                switch (SCALETYPE) {
                    case 1: {
                        xLabel = bun.getString("VelocityRS") + " (" + bun.getString("unitsVelocityRS") + ")";
                        break;
                    }
                    case 2: {
                        xLabel = bun.getString("FrequencyRS") + " (" + freqUnit + ")";
                        break;
                    }
                    case 3: {
                        xLabel = bun.getString("WavelengthRS") + " (" + waveUnit + ")";
                        break;
                    }
                    default: {
                        xLabel = bun.getString("ChannelRS");
                    }
                }
                ImagePlus impdata = new ImagePlus();
                FloatProcessor ipdata = new FloatProcessor(cpt, 150);
                impdata.setProcessor("data", ipdata);
                FileInfo fi = new FileInfo();
                fi.fileName = fileName;
                fi.directory = directory;
                impdata.setFileInfo(fi);
                yLabel = bun.getString("IntensityRS");
                PlotWindow.RadioSpectra = true;
                PlotWindow.Base_Line_subtracted = false;
                PlotWindow.Base_Line = false;
                PlotWindow.ZERO_LINE = false;
                PlotWindow pw = new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + "  " + fileName, xLabel, yLabel, xValues, yValues, impdata);
                pw.draw();
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(RadioSpectrum_Reader.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(RadioSpectrum_Reader.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            FitsDecoder fd = new FitsDecoder(directory, fileName);
            FileInfo fi = null;
            try {
                fi = fd.getInfo();
            }
            catch (IOException e) {
                // empty catch block
            }
            System.out.print(fi.width + " " + fi.height + " " + fi.nImages);
            if (fi != null && fi.width > 0 && fi.height > 0 && fi.offset > 0 && fi.nImages == 1) {
                double deltav;
                int length;
                System.out.print(fi.width + " " + fi.height + " " + fi.nImages);
                fi.fileType = 2;
                FileOpener fo = new FileOpener(fi);
                ImagePlus imp = fo.open(false);
                ImageProcessor ip = imp.getProcessor();
                ip.flipVertical();
                Calibration cal = imp.getCalibration();
                if (fi.height == 150) {
                    optique = true;
                }
                double bzero = fd.getBzero();
                double bscale = fd.getBscale();
                imp.setProperty("Info", fd.getHeaderInfo());
                imp.setFileInfo(fi);
                short[] shortpixels = null;
                float[] floatpixels = null;
                System.out.print(1);
                if (fi.fileType == 1 || fi.fileType == 2) {
                    shortpixels = (short[])ip.getPixels();
                    length = shortpixels.length;
                } else {
                    floatpixels = (float[])ip.getPixels();
                    length = floatpixels.length;
                }
                xLabel = IJ.getPluginBundle().getString("ChannelRS");
                yLabel = bun.getString("IntensityRS");
                l = fd.getCrval2();
                b = fd.getCrval3();
                float[] xValues = new float[length];
                IJ.showProgress(0.0);
                double restfreq = fd.getRestfreq();
                if (!optique) {
                    int i;
                    int i2;
                    if (restfreq == 0.0) {
                        restfreq = fd.getCrval1();
                    }
                    if (fd.getDeltav() == 0.0 & SCALETYPE == 1) {
                        deltav = -3.0E8 * fd.getCdelt1() / restfreq;
                        System.out.println(deltav);
                    } else {
                        deltav = fd.getDeltav();
                    }
                    if (fd.getTelescop().startsWith("LAB-")) {
                        block52: for (i2 = 0; i2 < length; ++i2) {
                            switch (SCALETYPE) {
                                case 0: {
                                    xValues[i2] = i2;
                                    continue block52;
                                }
                                case 1: {
                                    xValues[i2] = (float)((double)((float)(fd.getCrval1() + fd.getCdelt1() * (double)i2 - fd.getCrpix1())) * 0.001);
                                    continue block52;
                                }
                                case 2: {
                                    xValues[i2] = (float)(restfreq * (1.0 - (double)((float)(fd.getCrval1() + fd.getCdelt1() * ((double)i2 - fd.getCrpix1()))) / 3.0E8) * 1.0E-6);
                                    continue block52;
                                }
                                case 3: {
                                    xValues[i2] = (float)(3.0E10 / restfreq / (1.0 - (fd.getCrval1() + fd.getCdelt1() * ((double)i2 - fd.getCrpix1())) / 3.0E8));
                                    continue block52;
                                }
                                default: {
                                    xValues[i2] = i2;
                                }
                            }
                        }
                    } else {
                        block53: for (i2 = 0; i2 < length; ++i2) {
                            switch (SCALETYPE) {
                                case 0: {
                                    xValues[i2] = i2;
                                    continue block53;
                                }
                                case 1: {
                                    if (fd.getVelolsr() > 100.0) {
                                        xValues[length - 1 - i2] = (float)((double)((float)(((double)i2 - fd.getCrpix1()) * deltav - fd.getVelolsr())) * 0.001 * 1.0 + (double)((float)(3.0E8 * (1.0 - fd.getCrval1() / restfreq))) * 0.001);
                                    }
                                    if (!(fd.getVelolsr() <= 100.0)) continue block53;
                                    xValues[length - 1 - i2] = (float)((double)((float)(((double)i2 - fd.getCrpix1()) * deltav * 0.001 - fd.getVelolsr()) * 1.0f) + (double)((float)(3.0E8 * (1.0 - fd.getCrval1() / restfreq))) * 0.001);
                                    continue block53;
                                }
                                case 2: {
                                    if (fd.getVelolsr() > 100.0) {
                                        xValues[i2] = (float)((double)((float)((fd.getCrval1() + fd.getCdelt1() * ((double)i2 - fd.getCrpix1())) * 1.0E-6)) + fd.getVelolsr() * restfreq / 3.0E8 * 1.0E-6);
                                    }
                                    if (!(fd.getVelolsr() <= 100.0)) continue block53;
                                    xValues[i2] = (float)((double)((float)((fd.getCrval1() + fd.getCdelt1() * ((double)i2 - fd.getCrpix1())) * 1.0E-6)) + fd.getVelolsr() * 1000.0 * restfreq / 3.0E8 * 1.0E-6);
                                    continue block53;
                                }
                                case 3: {
                                    if (fd.getVelolsr() > 100.0) {
                                        xValues[i2] = (float)(3.0E10 / (fd.getCrval1() + fd.getCdelt1() * (fd.getCrpix1() - (double)i2) + fd.getVelolsr() * restfreq / 3.0E8));
                                    }
                                    if (!(fd.getVelolsr() <= 100.0)) continue block53;
                                    xValues[i2] = (float)(3.0E10 / (fd.getCrval1() + fd.getCdelt1() * (fd.getCrpix1() - (double)i2) + fd.getVelolsr() * 1000.0 * restfreq / 3.0E8));
                                    continue block53;
                                }
                                default: {
                                    xValues[i2] = i2;
                                }
                            }
                        }
                    }
                    float[] yValues = new float[length];
                    double[] coeff = cal.getCoefficients();
                    if (coeff == null) {
                        coeff = new double[]{0.0, 1.0};
                    }
                    bzero = bscale * coeff[0] + bzero;
                    bscale = coeff[1] * bscale;
                    if (fi.fileType == 1 || fi.fileType == 2) {
                        for (i = 0; i < length; ++i) {
                            if (fd.getTelescop().startsWith("LAB-")) {
                                if (SCALETYPE == 3 || SCALETYPE == 1) {
                                    yValues[length - 1 - i] = (float)(bscale * (double)shortpixels[i] + bzero);
                                    continue;
                                }
                                yValues[i] = (float)(bscale * (double)shortpixels[i] + bzero);
                                continue;
                            }
                            if (SCALETYPE == 3 || SCALETYPE == 1) {
                                yValues[length - 1 - i] = (float)(bscale * (double)shortpixels[i] + bzero);
                                continue;
                            }
                            yValues[i] = (float)(bscale * (double)shortpixels[i] + bzero);
                        }
                    } else {
                        for (i = 0; i < length; ++i) {
                            yValues[i] = (float)(bscale * (double)floatpixels[i] + bzero);
                        }
                    }
                    freqUnit = "MHz";
                    waveUnit = "cm";
                    switch (SCALETYPE) {
                        case 1: {
                            xLabel = bun.getString("VelocityRS") + " (" + bun.getString("unitsVelocityRS") + ")";
                            break;
                        }
                        case 2: {
                            xLabel = bun.getString("FrequencyRS") + " (" + freqUnit + ")";
                            break;
                        }
                        case 3: {
                            xLabel = bun.getString("WavelengthRS") + " (" + waveUnit + ")";
                            break;
                        }
                        default: {
                            xLabel = bun.getString("ChannelRS");
                        }
                    }
                    PlotWindow.RadioSpectra = true;
                    PlotWindow.Base_Line_subtracted = false;
                    PlotWindow.Base_Line = false;
                    PlotWindow.ZERO_LINE = false;
                    PlotWindow pw = new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + "  " + fileName, xLabel, yLabel, xValues, yValues, imp);
                    pw.draw();
                }
                if (optique) {
                    int i;
                    length = fi.width;
                    xValues = new float[length];
                    if (restfreq == 0.0) {
                        restfreq = 3.0E8 / (fd.getCrval1() * 1.0E-10);
                    }
                    deltav = fd.getDeltav() == 0.0 & SCALETYPE == 1 ? -fd.getCdelt1() / restfreq : fd.getDeltav();
                    block56: for (int i3 = 0; i3 < length; ++i3) {
                        float tmp_wave = (float)(fd.getCrval1() + fd.getCdelt1() * (double)i3) * 0.1f;
                        float tmp_freq = (float)(3.0E8 / ((double)tmp_wave * 1.0E-9));
                        float tmp_freq0 = (float)(3.0E17 / wave_ref);
                        switch (SCALETYPE) {
                            case 0: {
                                xValues[i3] = i3;
                                continue block56;
                            }
                            case 1: {
                                xValues[i3] = (float)(3.0E8 * ((double)(tmp_freq0 / tmp_freq) - 1.0) * 0.001);
                                continue block56;
                            }
                            case 2: {
                                xValues[i3] = (float)((double)tmp_freq * 1.0E-12);
                                continue block56;
                            }
                            case 3: {
                                xValues[i3] = tmp_wave;
                                continue block56;
                            }
                            default: {
                                xValues[i3] = i3;
                            }
                        }
                    }
                    float[] yValues = new float[length];
                    double[] coeff = cal.getCoefficients();
                    if (coeff == null) {
                        coeff = new double[]{0.0, 1.0};
                    }
                    bscale = 2 * fi.width;
                    bzero = bscale * coeff[0] + bzero;
                    bscale = coeff[1] * bscale;
                    bzero = 32768.0;
                    bscale = 1.0;
                    if (fi.fileType == 1 || fi.fileType == 2) {
                        for (i = 0; i < length; ++i) {
                            yValues[i] = (float)(bzero + bscale * (double)shortpixels[i]);
                        }
                    } else {
                        for (i = 0; i < length; ++i) {
                            yValues[i] = (float)(bzero + bscale * (double)floatpixels[i]);
                        }
                    }
                    switch (SCALETYPE) {
                        case 1: {
                            xLabel = bun.getString("VelocityRS") + " (" + bun.getString("unitsVelocityRS") + ")";
                            break;
                        }
                        case 2: {
                            xLabel = bun.getString("FrequencyRS") + " (" + freqUnit + ")";
                            break;
                        }
                        case 3: {
                            xLabel = bun.getString("WavelengthRS") + " (" + waveUnit + ")";
                            break;
                        }
                        default: {
                            xLabel = bun.getString("ChannelRS");
                        }
                    }
                    PlotWindow.RadioSpectra = true;
                    PlotWindow.Base_Line_subtracted = false;
                    PlotWindow.Base_Line = false;
                    PlotWindow.ZERO_LINE = false;
                    PlotWindow pw = new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + "  " + fileName, xLabel, yLabel, xValues, yValues, imp);
                    pw.draw();
                }
            } else {
                IJ.log("Error FITS decoder ");
                IJ.error(bun.getString("error0"));
            }
            IJ.showStatus("");
        }
    }

    public static int gaussianFitSpectralLine(float[] xvals, float[] yvals, double[] a) {
        int ma;
        int DIM = 3;
        int dof = xvals.length;
        double amplitude = a[0];
        double center = a[1];
        double width = a[2];
        double[] chisq = new double[1];
        double[] ochisq = new double[1];
        double[] aa = Tools.getMinMax(yvals);
        double yvalsMax = aa[1];
        if (amplitude == 0.0) {
            amplitude = yvalsMax;
        }
        if (center == 0.0) {
            for (int i = 0; i < xvals.length; ++i) {
                if ((double)yvals[i] != yvalsMax) continue;
                center = xvals[i];
            }
        }
        if (width == 0.0) {
            width = 10.0;
        }
        if (dof <= (ma = DIM)) {
            IJ.error(bun.getString("error1"));
            return 0;
        }
        double[][] covar = new double[ma][ma];
        double[][] alpha = new double[ma][ma];
        double[] sig = new double[xvals.length];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = 1.0;
        }
        a[0] = amplitude;
        a[1] = center;
        a[2] = width;
        int[] ia = new int[3];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = 1;
        }
        double[] alamda = new double[]{-1.0};
        int err = Tools.mrqmin(Tools.toDouble(xvals), Tools.toDouble(yvals), sig, dof, a, ia, ma, covar, alpha, chisq, ochisq, alamda);
        int iter = 0;
        int itst = 0;
        while (itst < 5 && err != 0) {
            ++iter;
            ochisq[0] = chisq[0];
            err = Tools.mrqmin(Tools.toDouble(xvals), Tools.toDouble(yvals), sig, dof, a, ia, ma, covar, alpha, chisq, ochisq, alamda);
            if (chisq[0] > ochisq[0]) {
                itst = 0;
                continue;
            }
            if (!(Math.abs(ochisq[0] - chisq[0]) < 0.001)) continue;
            ++itst;
        }
        alamda[0] = 0.0;
        if (err != 0) {
            err = Tools.mrqmin(Tools.toDouble(xvals), Tools.toDouble(yvals), sig, dof, a, ia, ma, covar, alpha, chisq, ochisq, alamda);
        }
        amplitude = a[0];
        center = a[1];
        width = a[2];
        return err;
    }

    public static void activate() {
        if (res == null) {
            StringBuffer sb;
            results = new Hashtable();
            if (results.size() > 0) {
                Enumeration keys = results.keys();
                sb = new StringBuffer();
                int i = 1;
                int m = 0;
                while (keys.hasMoreElements()) {
                    ++i;
                    int n = Integer.parseInt((String)keys.nextElement());
                    if (n <= m) continue;
                    m = n;
                }
                for (int j = 1; j <= m; ++j) {
                    IRad res = (IRad)results.get(String.valueOf(j));
                    if (res == null) continue;
                    sb.append(j + "\t" + res.toString() + "\n");
                }
            } else {
                sb = null;
            }
            res = new TextWindow(bun.getString("GaussFitResults"), bun.getString("measurements") + "\t" + bun.getString("File") + "\tl\tb\t" + xLabel + "\t" + yLabel + "\t" + bun.getString("Width") + "\t" + bun.getString("Area"), sb == null ? null : new String(sb), 536, 200);
            res.setLocation(5, 475);
        }
        if (!res.isShowing()) {
            rdindex = 1;
            res.getTextPanel().setColumnHeadings(bun.getString("measurements") + "\t" + bun.getString("File") + "\tl\tb\t" + xLabel + "\t" + yLabel + "\t" + bun.getString("Width") + "\t" + bun.getString("Area"));
            res.setVisible(true);
        }
        WindowManager.activateWindow(bun.getString("GaussFitResults"));
    }

    public static void clear() {
        if (results == null) {
            return;
        }
        results.clear();
        rdindex = 1;
        if (res != null) {
            res.getTextPanel().selectAll();
            res.getTextPanel().clearSelection();
        }
    }

    public static void clear(String s) {
        StringTokenizer st1 = new StringTokenizer(s, "\n");
        while (st1.hasMoreTokens()) {
            String s1 = st1.nextToken();
            StringTokenizer st = new StringTokenizer(s1, "\t");
            try {
                int index = Integer.parseInt(st.nextToken());
                String img = st.nextToken();
                results.remove(String.valueOf(index));
            }
            catch (Exception e) {}
        }
    }

    public void close() {
        if (res != null) {
            res.close();
            res = null;
        }
    }

    public static void addResult(ImagePlus imp, double[] a) {
        RadioSpectrum_Reader.activate();
        FileInfo fi = imp.getOriginalFileInfo();
        String t = fi.fileName;
        area = 1.064467 * a[0] * a[2];
        widthGauss = a[2];
        xGaussCenter = a[1];
        yGaussCenter = a[0];
        res.append(new String(rdindex + "\t" + t + "\t" + IJ.d2s(l) + "\t" + IJ.d2s(b) + "\t" + IJ.d2s(xGaussCenter) + "\t" + IJ.d2s(yGaussCenter) + "\t" + IJ.d2s(widthGauss) + "\t" + IJ.d2s(area)));
        res.getTextPanel().resetSelection();
        results.put(String.valueOf(rdindex), new IRad(t, xGaussCenter, yGaussCenter, widthGauss, area, l, b));
        ++rdindex;
    }

    private void readSpectData() {
    }

    static {
        rdindex = 1;
        bun = IJ.getPluginBundle();
        wave_ref = 589.0;
    }

    static class IRad {
        String title;
        double xx;
        double yy;
        double ww;
        double aa;
        double ll;
        double bb;

        public IRad(String i, double xx, double yy, double ww, double aa, double ll, double bb) {
            this.title = new String(i);
            this.xx = xx;
            this.yy = yy;
            this.ww = ww;
            this.aa = aa;
            this.ll = ll;
            this.bb = bb;
        }

        public String toString() {
            return new String(this.title + "\t" + IJ.d2s(this.ll) + "\t" + IJ.d2s(this.bb) + "\t" + IJ.d2s(this.xx) + "\t" + IJ.d2s(this.yy) + "\t" + IJ.d2s(this.ww) + "\t" + IJ.d2s(this.aa));
        }
    }
}

