/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Measurements;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.FHT;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class FFTCustomFilter
implements PlugInFilter,
Measurements {
    private ImagePlus imp;
    private static int filterIndex = 1;
    private int slice;
    private int stackSize;
    private boolean done;
    private ImageProcessor filter;
    private static boolean processStack;
    private boolean padded;
    private int originalWidth;
    private int originalHeight;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (imp == null) {
            IJ.noImage();
            return 4096;
        }
        this.stackSize = imp.getStackSize();
        if (imp.getProperty("FHT") != null) {
            IJ.error("FFT Custom Filter", "Ordinary (non-FFT) image required");
            return 4096;
        }
        return processStack ? 63 : 31;
    }

    @Override
    public void run(ImageProcessor ip) {
        ++this.slice;
        if (this.done) {
            return;
        }
        FHT fht = this.newFHT(ip);
        if (this.slice == 1) {
            this.filter = this.getFilter(fht.getWidth());
            if (this.filter == null) {
                this.done = true;
                return;
            }
        }
        fht.transform();
        this.customFilter(fht);
        this.doInverseTransform(fht, ip);
        if (this.slice == 1) {
            ip.resetMinAndMax();
        }
        if (this.slice == this.stackSize) {
            this.imp.updateAndDraw();
        }
        IJ.showProgress(1.0);
    }

    void doInverseTransform(FHT fht, ImageProcessor ip) {
        this.showStatus("Inverse transform");
        fht.inverseTransform();
        if (fht.quadrantSwapNeeded) {
            fht.swapQuadrants();
        }
        fht.resetMinAndMax();
        ImageProcessor ip2 = fht;
        if (fht.originalWidth > 0) {
            fht.setRoi(0, 0, fht.originalWidth, fht.originalHeight);
            ip2 = fht.crop();
        }
        int bitDepth = fht.originalBitDepth > 0 ? fht.originalBitDepth : this.imp.getBitDepth();
        switch (bitDepth) {
            case 8: {
                ip2 = ip2.convertToByte(true);
                break;
            }
            case 16: {
                ip2 = ip2.convertToShort(true);
                break;
            }
            case 24: {
                this.showStatus("Setting brightness");
                fht.rgb.setBrightness((FloatProcessor)ip2);
                ip2 = fht.rgb;
                fht.rgb = null;
                break;
            }
        }
        ip.insert(ip2, 0, 0);
    }

    FHT newFHT(ImageProcessor ip) {
        FHT fht;
        if (ip instanceof ColorProcessor) {
            this.showStatus("Extracting brightness");
            FloatProcessor ip2 = ((ColorProcessor)ip).getBrightness();
            fht = new FHT(this.pad(ip2));
            fht.rgb = (ColorProcessor)ip.duplicate();
        } else {
            fht = new FHT(this.pad(ip));
        }
        if (this.padded) {
            fht.originalWidth = this.originalWidth;
            fht.originalHeight = this.originalHeight;
        }
        fht.originalBitDepth = this.imp.getBitDepth();
        return fht;
    }

    ImageProcessor pad(ImageProcessor ip) {
        int i;
        this.originalWidth = ip.getWidth();
        this.originalHeight = ip.getHeight();
        int maxN = Math.max(this.originalWidth, this.originalHeight);
        for (i = 2; i < maxN; i *= 2) {
        }
        if (i == maxN && this.originalWidth == this.originalHeight) {
            this.padded = false;
            return ip;
        }
        maxN = i;
        this.showStatus("Padding to " + maxN + "x" + maxN);
        ImageStatistics stats = ImageStatistics.getStatistics(ip, 2, null);
        ImageProcessor ip2 = ip.createProcessor(maxN, maxN);
        ip2.setValue(stats.mean);
        ip2.fill();
        ip2.insert(ip, 0, 0);
        this.padded = true;
        Undo.reset();
        return ip2;
    }

    void showStatus(String msg) {
        if (this.stackSize > 1) {
            IJ.showStatus("FFT: " + this.slice + "/" + this.stackSize);
        } else {
            IJ.showStatus(msg);
        }
    }

    void customFilter(FHT fht) {
        int size = fht.getWidth();
        this.showStatus("Filtering");
        fht.swapQuadrants(this.filter);
        float[] fhtPixels = (float[])fht.getPixels();
        byte[] filterPixels = (byte[])this.filter.getPixels();
        for (int i = 0; i < fhtPixels.length; ++i) {
            fhtPixels[i] = (float)((double)(fhtPixels[i] * (float)(filterPixels[i] & 0xFF)) / 255.0);
        }
        fht.swapQuadrants(this.filter);
    }

    ImageProcessor getFilter(int size) {
        ImagePlus filterImp;
        int[] wList = WindowManager.getIDList();
        if (wList == null || wList.length < 2) {
            IJ.error("FFT", "A filter (as an open image) is required.");
            return null;
        }
        String[] titles = new String[wList.length];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
        }
        if (filterIndex < 0 || filterIndex >= titles.length) {
            filterIndex = 1;
        }
        GenericDialog gd = new GenericDialog("FFT Filter");
        gd.addChoice("Filter:", titles, titles[filterIndex]);
        if (this.stackSize > 1) {
            gd.addCheckbox("Process Entire Stack", processStack);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        filterIndex = gd.getNextChoiceIndex();
        if (this.stackSize > 1) {
            processStack = gd.getNextBoolean();
        }
        if ((filterImp = WindowManager.getImage(wList[filterIndex])) == this.imp) {
            IJ.error("FFT", "The filter cannot be the same as the image being filtered.");
            return null;
        }
        if (filterImp.getStackSize() > 1) {
            IJ.error("FFT", "The filter cannot be a stack.");
            return null;
        }
        ImageProcessor filter = filterImp.getProcessor();
        if (filter.getWidth() > size || filter.getHeight() > size) {
            IJ.error("FFT", "Filter cannot be larger than " + size + "x" + size);
            this.done = true;
            return null;
        }
        filter = filter.convertToByte(true);
        filter = this.padFilter(filter, size);
        return filter;
    }

    ImageProcessor padFilter(ImageProcessor ip, int maxN) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        if (width == maxN && height == maxN) {
            return ip;
        }
        this.showStatus("Padding filter to " + maxN + "x" + maxN);
        ImageStatistics stats = ImageStatistics.getStatistics(ip, 2, null);
        ImageProcessor ip2 = ip.createProcessor(maxN, maxN);
        ip2.setValue(stats.mean);
        ip2.fill();
        ip2.insert(ip, (maxN - width) / 2, (maxN - height) / 2);
        return ip2;
    }
}

