/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Rectangle;

public class Info
implements PlugInFilter {
    private ImagePlus imp;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    @Override
    public void run(ImageProcessor ip) {
        String info = this.getImageInfo(this.imp, ip);
        if (info.indexOf("----") > 0) {
            this.showInfo(info, 450, 500);
        } else {
            this.showInfo(info, 300, 300);
        }
    }

    public String getImageInfo(ImagePlus imp, ImageProcessor ip) {
        ImageStack stack;
        String label;
        String infoProperty = null;
        if (imp.getStackSize() > 1 && (label = (stack = imp.getStack()).getSliceLabel(imp.getCurrentSlice())) != null && label.indexOf(10) > 0) {
            infoProperty = label;
        }
        String info = this.getInfo(imp, ip);
        if (infoProperty == null) {
            infoProperty = (String)imp.getProperty("Info");
        }
        if (infoProperty != null) {
            return infoProperty + "\n------------------------\n" + info;
        }
        return info;
    }

    String getInfo(ImagePlus imp, ImageProcessor ip) {
        Roi roi;
        double mag;
        int digits;
        String s = new String("\n");
        s = s + "Title: " + imp.getTitle() + "\n";
        Calibration cal = imp.getCalibration();
        int nSlices = imp.getStackSize();
        int n = digits = imp.getBitDepth() == 32 ? 4 : 0;
        if (cal.scaled()) {
            String unit = cal.getUnit();
            String units = cal.getUnits();
            s = s + "Width:  " + IJ.d2s((double)imp.getWidth() * cal.pixelWidth, 2) + " " + units + " (" + imp.getWidth() + ")\n";
            s = s + "Height:  " + IJ.d2s((double)imp.getHeight() * cal.pixelHeight, 2) + " " + units + " (" + imp.getHeight() + ")\n";
            if (nSlices > 1) {
                s = s + "Depth:  " + IJ.d2s((double)nSlices * cal.pixelDepth, 2) + " " + units + " (" + nSlices + ")\n";
            }
            if (nSlices > 1) {
                s = s + "Voxel size: " + IJ.d2s(cal.pixelWidth, 2) + "x" + IJ.d2s(cal.pixelHeight, 2) + "x" + IJ.d2s(cal.pixelDepth, 2) + "\n";
            }
            double xResolution = 1.0 / cal.pixelWidth;
            double yResolution = 1.0 / cal.pixelHeight;
            int places = Tools.getDecimalPlaces(xResolution, yResolution);
            if (xResolution == yResolution) {
                s = s + "Resolution:  " + IJ.d2s(xResolution, places) + " pixels per " + unit + "\n";
            } else {
                s = s + "X Resolution:  " + IJ.d2s(xResolution, places) + " pixels per " + unit + "\n";
                s = s + "Y Resolution:  " + IJ.d2s(yResolution, places) + " pixels per " + unit + "\n";
            }
        } else {
            s = s + "Width:  " + imp.getWidth() + " pixels\n";
            s = s + "Height:  " + imp.getHeight() + " pixels\n";
            if (nSlices > 1) {
                s = s + "Depth:  " + nSlices + " pixels\n";
            }
        }
        String zOrigin = nSlices > 1 || cal.zOrigin != 0.0 ? "," + this.d2s(cal.zOrigin) : "";
        s = s + "Coordinate origin:  " + this.d2s(cal.xOrigin) + "," + this.d2s(cal.yOrigin) + zOrigin + "\n";
        int type = imp.getType();
        switch (type) {
            case 0: {
                s = s + "Bits per pixel: 8 ";
                String lut = "LUT";
                lut = imp.getProcessor().isColorLut() ? "color " + lut : "grayscale " + lut;
                if (imp.isInvertedLut()) {
                    lut = "inverting " + lut;
                }
                s = s + "(" + lut + ")\n";
                break;
            }
            case 1: 
            case 2: {
                if (type == 1) {
                    String sign = cal.isSigned16Bit() ? "signed" : "unsigned";
                    s = s + "Bits per pixel: 16 (" + sign + ")\n";
                } else {
                    s = s + "Bits per pixel: 32 (float)\n";
                }
                s = s + "Display range: ";
                double min = ip.getMin();
                double max = ip.getMax();
                if (cal.calibrated()) {
                    min = cal.getCValue((int)min);
                    max = cal.getCValue((int)max);
                }
                s = s + IJ.d2s(min, digits) + " - " + IJ.d2s(max, digits) + "\n";
                break;
            }
            case 3: {
                s = s + "Bits per pixel: 8 (color LUT)\n";
                break;
            }
            case 4: {
                s = s + "Bits per pixel: 32 (RGB)\n";
            }
        }
        double interval = cal.frameInterval;
        double fps = cal.fps;
        if (nSlices > 1) {
            ImageStack stack = imp.getStack();
            int slice = imp.getCurrentSlice();
            String number = slice + "/" + nSlices;
            String label = stack.getShortSliceLabel(slice);
            label = label != null && label.length() > 0 ? " (" + label + ")" : "";
            if (interval > 0.0 || fps != 0.0) {
                s = s + "Frame: " + number + label + "\n";
                if (fps != 0.0) {
                    String sRate = Math.abs(fps - (double)Math.round(fps)) < 1.0E-5 ? IJ.d2s(fps, 0) : IJ.d2s(fps, 5);
                    s = s + "Frame rate: " + sRate + " fps\n";
                }
                if (interval != 0.0) {
                    s = s + "Frame interval: " + ((double)((int)interval) == interval ? IJ.d2s(interval, 0) : IJ.d2s(interval, 5)) + " " + cal.getTimeUnit() + "\n";
                }
            } else {
                s = s + "Slice: " + number + label + "\n";
            }
        }
        if (ip.getMinThreshold() == -808080.0) {
            s = s + "No Threshold\n";
        } else {
            double lower = ip.getMinThreshold();
            double upper = ip.getMaxThreshold();
            int dp = digits;
            if (cal.calibrated()) {
                lower = cal.getCValue((int)lower);
                upper = cal.getCValue((int)upper);
                dp = cal.isSigned16Bit() ? 0 : 4;
            }
            s = s + "Threshold: " + IJ.d2s(lower, dp) + "-" + IJ.d2s(upper, dp) + "\n";
        }
        ImageCanvas ic = imp.getCanvas();
        double d = mag = ic != null ? ic.getMagnification() : 1.0;
        if (mag != 1.0) {
            s = s + "Magnification: " + mag + "\n";
        }
        if (cal.calibrated()) {
            s = s + " \n";
            int curveFit = cal.getFunction();
            s = s + "Calibration Function: ";
            s = curveFit == 21 ? s + "Uncalibrated OD\n" : (curveFit == 22 ? s + "Custom lookup table\n" : s + CurveFitter.fList[curveFit] + "\n");
            double[] c = cal.getCoefficients();
            if (c != null) {
                s = s + "  a: " + IJ.d2s(c[0], 6) + "\n";
                s = s + "  b: " + IJ.d2s(c[1], 6) + "\n";
                if (c.length >= 3) {
                    s = s + "  c: " + IJ.d2s(c[2], 6) + "\n";
                }
                if (c.length >= 4) {
                    s = s + "  c: " + IJ.d2s(c[3], 6) + "\n";
                }
                if (c.length >= 5) {
                    s = s + "  c: " + IJ.d2s(c[4], 6) + "\n";
                }
            }
            s = s + "  Unit: \"" + cal.getValueUnit() + "\"\n";
        } else {
            s = s + "Uncalibrated\n";
        }
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi != null) {
            if (fi.directory != null && fi.fileName != null) {
                s = s + "Path: " + fi.directory + fi.fileName + "\n";
            }
            if (fi.url != null && !fi.url.equals("")) {
                s = s + "URL: " + fi.url + "\n";
            }
        }
        if ((roi = imp.getRoi()) == null) {
            if (cal.calibrated()) {
                s = s + " \n";
            }
            s = s + "No Selection\n";
        } else {
            String name;
            s = s + " \n";
            s = s + roi.getTypeAsString() + " Selection";
            String points = null;
            if (roi instanceof PointRoi) {
                int npoints = ((PolygonRoi)roi).getNCoordinates();
                String suffix = npoints > 1 ? "s)" : ")";
                points = " (" + npoints + " point" + suffix;
            }
            if ((name = roi.getName()) != null) {
                s = s + " (\"" + name + "\")";
                if (points != null) {
                    s = s + "\n " + points;
                }
            } else if (points != null) {
                s = s + points;
            }
            s = s + "\n";
            Rectangle r = roi.getBounds();
            if (roi instanceof Line) {
                Line line = (Line)roi;
                s = s + "  X1: " + IJ.d2s(line.x1d * cal.pixelWidth) + "\n";
                s = s + "  Y1: " + IJ.d2s(this.yy(line.y1d, imp) * cal.pixelHeight) + "\n";
                s = s + "  X2: " + IJ.d2s(line.x2d * cal.pixelWidth) + "\n";
                s = s + "  Y2: " + IJ.d2s(this.yy(line.y2d, imp) * cal.pixelHeight) + "\n";
            } else if (cal.scaled()) {
                s = s + "  X: " + IJ.d2s((double)r.x * cal.pixelWidth) + " (" + r.x + ")\n";
                s = s + "  Y: " + IJ.d2s((double)this.yy(r.y, imp) * cal.pixelHeight) + " (" + r.y + ")\n";
                s = s + "  Width: " + IJ.d2s((double)r.width * cal.pixelWidth) + " (" + r.width + ")\n";
                s = s + "  Height: " + IJ.d2s((double)r.height * cal.pixelHeight) + " (" + r.height + ")\n";
            } else {
                s = s + "  X: " + r.x + "\n";
                s = s + "  Y: " + this.yy(r.y, imp) + "\n";
                s = s + "  Width: " + r.width + "\n";
                s = s + "  Height: " + r.height + "\n";
            }
        }
        return s;
    }

    String d2s(double n) {
        return n == (double)((int)n) ? Integer.toString((int)n) : IJ.d2s(n);
    }

    int yy(int y, ImagePlus imp) {
        return Analyzer.updateY(y, imp.getHeight());
    }

    double yy(double y, ImagePlus imp) {
        return Analyzer.updateY(y, imp.getHeight());
    }

    void showInfo(String info, int width, int height) {
        new TextWindow(IJ.getPluginBundle().getString("Infofor") + this.imp.getTitle(), info, width, height);
    }
}

