/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.PlotWindow;
import ij.gui.ProfilePlot;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Dimension;

public class Profiler
implements PlugInFilter {
    ImagePlus imp;
    static boolean verticalProfile;
    static boolean horizontalProfile;

    @Override
    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("set")) {
            this.doOptions();
            return 4096;
        }
        this.imp = imp;
        return 1439;
    }

    @Override
    public void run(ImageProcessor ip) {
        boolean averageHorizontally = verticalProfile || IJ.altKeyDown();
        new ProfilePlot(this.imp, averageHorizontally).createWindow();
    }

    public void doOptions() {
        boolean fixedScale;
        double ymin = ProfilePlot.getFixedMin();
        double ymax = ProfilePlot.getFixedMax();
        boolean wasFixedScale = fixedScale = ymin != 0.0 || ymax != 0.0;
        GenericDialog gd = new GenericDialog(IJ.getPluginBundle().getString("ProOptTitle"), IJ.getInstance());
        gd.addNumericField(IJ.getPluginBundle().getString("Width") + " (" + IJ.getPluginBundle().getString("Pixels") + "):", PlotWindow.plotWidth, 0);
        gd.addNumericField(IJ.getPluginBundle().getString("Height") + " (" + IJ.getPluginBundle().getString("Pixels") + "):", PlotWindow.plotHeight, 0);
        gd.addNumericField(IJ.getPluginBundle().getString("Min") + " Y:", ymin, 2);
        gd.addNumericField(IJ.getPluginBundle().getString("Max") + " Y:", ymax, 2);
        gd.addCheckbox(IJ.getPluginBundle().getString("ProOptScale"), fixedScale);
        gd.addCheckbox(IJ.getPluginBundle().getString("ProOptSave"), !PlotWindow.saveXValues);
        gd.addCheckbox(IJ.getPluginBundle().getString("ProOptAuto"), PlotWindow.autoClose);
        gd.addCheckbox(IJ.getPluginBundle().getString("ProOptVert"), verticalProfile);
        gd.addCheckbox(IJ.getPluginBundle().getString("ProOptHoriz"), horizontalProfile);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        Dimension screen = IJ.getScreenSize();
        int w = (int)gd.getNextNumber();
        int h = (int)gd.getNextNumber();
        if (w < 300) {
            w = 300;
        }
        if (w > screen.width - 140) {
            w = screen.width - 140;
        }
        if (h < 100) {
            h = 100;
        }
        if (h > screen.height - 300) {
            h = screen.height - 300;
        }
        PlotWindow.plotWidth = w;
        PlotWindow.plotHeight = h;
        ymin = gd.getNextNumber();
        ymax = gd.getNextNumber();
        fixedScale = gd.getNextBoolean();
        PlotWindow.saveXValues = !gd.getNextBoolean();
        PlotWindow.autoClose = gd.getNextBoolean();
        verticalProfile = gd.getNextBoolean();
        horizontalProfile = gd.getNextBoolean();
        if (!(fixedScale || wasFixedScale || ymin == 0.0 && ymax == 0.0)) {
            fixedScale = true;
        }
        if (!fixedScale) {
            ymin = 0.0;
            ymax = 0.0;
        } else if (ymin > ymax) {
            double tmp = ymin;
            ymin = ymax;
            ymax = tmp;
        }
        ProfilePlot.setMinAndMax(ymin, ymax);
        IJ.register(Profiler.class);
    }
}

