/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;

public class UnsharpMask
implements ExtendedPlugInFilter,
DialogListener {
    private static double sigma = 1.0;
    private static double weight = 0.6;
    private final int flags = 16834655;
    private GaussianBlur gb;

    @Override
    public int setup(String arg, ImagePlus imp) {
        return 16834655;
    }

    @Override
    public void run(ImageProcessor ip) {
        this.sharpenFloat((FloatProcessor)ip, sigma, (float)weight);
    }

    public void sharpenFloat(FloatProcessor fp, double sigma, float weight) {
        if (this.gb == null) {
            this.gb = new GaussianBlur();
        }
        this.gb.blurGaussian(fp, sigma, sigma, 0.01);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        float[] pixels = (float[])fp.getPixels();
        float[] snapshotPixels = (float[])fp.getSnapshotPixels();
        int width = fp.getWidth();
        Rectangle roi = fp.getRoi();
        for (int y = roi.y; y < roi.y + roi.height; ++y) {
            int x = roi.x;
            int p = width * y + x;
            while (x < roi.x + roi.width) {
                pixels[p] = (snapshotPixels[p] - weight * pixels[p]) / (1.0f - weight);
                ++x;
                ++p;
            }
        }
    }

    @Override
    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        String options = Macro.getOptions();
        boolean oldMacro = false;
        if (options != null && options.indexOf("gaussian=") >= 0) {
            oldMacro = true;
            Macro.setOptions(options.replaceAll("gaussian=", "radius="));
        }
        GenericDialog gd = new GenericDialog(command);
        sigma = Math.abs(sigma);
        if (weight < 0.0) {
            weight = 0.0;
        }
        if (weight > 0.99) {
            weight = 0.99;
        }
        gd.addNumericField("Radius (Sigma)", sigma, 1, 6, "pixels");
        gd.addNumericField("Mask Weight (0.1-0.9)", weight, 2);
        gd.addPreviewCheckbox(pfr);
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        if (oldMacro) {
            sigma /= 2.5;
        }
        IJ.register(this.getClass());
        return IJ.setupDialog(imp, 16834655);
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        sigma = gd.getNextNumber();
        weight = gd.getNextNumber();
        return !(sigma < 0.0 || weight < 0.0 || weight > 0.99) && !gd.invalidNumber();
    }

    @Override
    public void setNPasses(int nPasses) {
        if (this.gb == null) {
            this.gb = new GaussianBlur();
        }
        this.gb.setNPasses(nPasses);
    }
}

