/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ColorChooser;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.MessageDialog;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.RoiDecoder;
import ij.io.RoiEncoder;
import ij.io.SaveDialog;
import ij.macro.Interpreter;
import ij.macro.MacroRunner;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Filler;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.StringSorter;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class RoiManager
extends PlugInFrame
implements ActionListener,
ItemListener,
MouseListener,
MouseWheelListener {
    static final int BUTTONS = 10;
    static final int DRAW = 0;
    static final int FILL = 1;
    static final int LABEL = 2;
    static final int MENU = 0;
    static final int COMMAND = 1;
    static final int MULTI = 2;
    static int rows = 15;
    static boolean allowMultipleSelections = true;
    Panel panel;
    static Frame instance;
    List list;
    Hashtable rois = new Hashtable();
    Roi roiCopy;
    boolean canceled;
    boolean macro;
    boolean ignoreInterrupts;
    PopupMenu pm;
    Button moreButton;
    Button colorButton;
    static boolean measureAll;
    static boolean onePerSlice;
    ResourceBundle bundle = IJ.gettToolBundle();

    public RoiManager() {
        super("ROI Manager");
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        this.list = new List(rows, allowMultipleSelections);
        this.showWindow();
    }

    public RoiManager(boolean hideWindow) {
        super("ROI Manager");
        this.list = new List(rows, allowMultipleSelections);
    }

    void showWindow() {
        ImageJ ij = IJ.getInstance();
        this.addKeyListener(ij);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        WindowManager.addWindow(this);
        this.setLayout(new FlowLayout(1, 5, 5));
        this.list.add("012345678901234");
        this.list.addItemListener(this);
        this.list.addKeyListener(ij);
        this.list.addMouseListener(this);
        this.list.addMouseWheelListener(this);
        if (IJ.isLinux()) {
            this.list.setBackground(Color.white);
        }
        this.add(this.list);
        this.panel = new Panel();
        int nButtons = 10;
        this.panel.setLayout(new GridLayout(nButtons, 1, 5, 0));
        this.addButton("RM_Add");
        this.addButton("RM_Update");
        this.addButton("RM_Delete");
        this.addButton("RM_Rename");
        this.addButton("RM_Open");
        this.addButton("RM_Save");
        this.addButton("RM_Measure");
        this.addButton("RM_Deselect");
        this.addButton("RM_Show_All");
        this.add(this.panel);
        this.addPopupMenu();
        this.pack();
        this.list.remove(0);
        GUI.center(this);
        this.show();
    }

    void addButton(String label) {
        Button b = new Button(this.bundle.getString(label));
        b.addActionListener(this);
        b.addKeyListener(IJ.getInstance());
        b.addMouseListener(this);
        b.setActionCommand(label);
        if (label.equals("More >>")) {
            this.moreButton = b;
        }
        this.panel.add(b);
    }

    void addPopupMenu() {
        this.pm = new PopupMenu();
        this.addPopupItem("RM_Draw");
        this.addPopupItem("RM_Fill");
        this.addPopupItem("RM_Label");
        this.pm.addSeparator();
        this.addPopupItem("RM_Combine");
        this.addPopupItem("RM_Split");
        this.addPopupItem("RM_Add_Particles");
        this.addPopupItem("RM_Multi_Measure");
        this.addPopupItem("Sort");
        this.addPopupItem("Specify...");
        this.addPopupItem("RM_Remove_Slice_Info");
        this.addPopupItem("RM_Help");
        this.addPopupItem("RM_Options...");
        this.add(this.pm);
    }

    void addPopupItem(String s) {
        MenuItem mi = new MenuItem(s);
        mi.setActionCommand(s);
        mi.addActionListener(this);
        this.pm.add(mi);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int modifiers = e.getModifiers();
        boolean altKeyDown = (modifiers & 8) != 0 || IJ.altKeyDown();
        boolean shiftKeyDown = (modifiers & 1) != 0 || IJ.shiftKeyDown();
        IJ.setKeyUp(18);
        IJ.setKeyUp(16);
        String label = e.getActionCommand();
        if (label == null) {
            return;
        }
        String command = label;
        if (command.equals("RM_Add")) {
            this.add(shiftKeyDown, altKeyDown);
        } else if (command.equals("RM_Update")) {
            this.update();
        } else if (command.equals("RM_Delete")) {
            this.delete(false);
        } else if (command.equals("RM_Rename")) {
            this.rename(null);
        } else if (command.equals("RM_Open")) {
            this.open(null);
        } else if (command.equals("RM_Save")) {
            this.save();
        } else if (command.equals("RM_Measure")) {
            this.measure(0);
        } else if (command.equals("RM_Show_All")) {
            this.showAll();
        } else if (command.equals("RM_Draw")) {
            this.drawOrFill(0);
        } else if (command.equals("RM_Fill")) {
            this.drawOrFill(1);
        } else if (command.equals("RM_Label")) {
            this.drawOrFill(2);
        } else if (command.equals("RM_Deselect")) {
            this.select(-1);
        } else if (command.equals("RM_More >>")) {
            Point ploc = this.panel.getLocation();
            Point bloc = this.moreButton.getLocation();
            this.pm.show(this, ploc.x, bloc.y);
        } else if (command.equals("RM_Select_All")) {
            this.selectAll();
        } else if (command.equals("RM_Combine")) {
            this.combine();
        } else if (command.equals("RM_Split")) {
            this.split();
        } else if (command.equals("RM_Add_Particles")) {
            this.addParticles();
        } else if (command.equals("RM_Multi_Measure")) {
            this.multiMeasure();
        } else if (command.equals("RM_Sort")) {
            this.sort();
        } else if (command.equals("RM_Specify...")) {
            this.specify();
        } else if (command.equals("RM_Remove_Slice_Info")) {
            this.removeSliceInfo();
        } else if (command.equals("RM_Help")) {
            this.help();
        } else if (command.equals("RM_Options...")) {
            this.options();
        } else if (command.equals("RM_Set_Color...")) {
            this.setShowAllColor();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && !this.ignoreInterrupts) {
            int index = 0;
            try {
                index = Integer.parseInt(e.getItem().toString());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (index < 0) {
                index = 0;
            }
            if (!IJ.shiftKeyDown() && !IJ.isMacintosh()) {
                int[] indexes = this.list.getSelectedIndexes();
                for (int i = 0; i < indexes.length; ++i) {
                    if (indexes[i] == index) continue;
                    this.list.deselect(indexes[i]);
                }
            }
            if (WindowManager.getCurrentImage() != null) {
                this.restore(index, true);
                if (Recorder.record) {
                    Recorder.record("roiManager", "Select", index);
                }
            }
        }
    }

    void add(boolean shiftKeyDown, boolean altKeyDown) {
        if (shiftKeyDown) {
            this.addAndDraw(altKeyDown);
        } else if (altKeyDown) {
            this.add(true);
        } else {
            this.add(false);
        }
    }

    boolean add(boolean promptForName) {
        String name;
        String label;
        Roi roi2;
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.error("The active image does not have a selection.");
            return false;
        }
        int n = this.list.getItemCount();
        if (n > 0 && (roi2 = (Roi)this.rois.get(label = this.list.getItem(n - 1))) != null) {
            int slice2 = this.getSliceNumber(label);
            if (roi.equals(roi2) && (slice2 == -1 || slice2 == imp.getCurrentSlice())) {
                return false;
            }
        }
        if (this.isStandardName(name = roi.getName())) {
            name = null;
        }
        String label2 = name != null ? name : this.getLabel(imp, roi, -1);
        label2 = promptForName ? this.promptForName(label2) : this.getUniqueName(label2);
        if (label2 == null) {
            return false;
        }
        this.list.add(label2);
        roi.setName(label2);
        this.roiCopy = (Roi)roi.clone();
        Calibration cal = imp.getCalibration();
        if (cal.xOrigin != 0.0 || cal.yOrigin != 0.0) {
            Rectangle r = this.roiCopy.getBounds();
            this.roiCopy.setLocation(r.x - (int)cal.xOrigin, r.y - (int)cal.yOrigin);
        }
        this.rois.put(label2, this.roiCopy);
        this.updateShowAll();
        if (Recorder.record) {
            Recorder.record("roiManager", "Add");
        }
        return true;
    }

    public void add(ImagePlus imp, Roi roi, int n) {
        if (roi == null) {
            return;
        }
        String label = this.getLabel(imp, roi, n);
        if (label == null) {
            return;
        }
        this.list.add(label);
        roi.setName(label);
        this.roiCopy = (Roi)roi.clone();
        Calibration cal = imp.getCalibration();
        if (cal.xOrigin != 0.0 || cal.yOrigin != 0.0) {
            Rectangle r = this.roiCopy.getBounds();
            this.roiCopy.setLocation(r.x - (int)cal.xOrigin, r.y - (int)cal.yOrigin);
        }
        this.rois.put(label, this.roiCopy);
    }

    boolean isStandardName(String name) {
        if (name == null) {
            return false;
        }
        boolean isStandard = false;
        int len = name.length();
        if (len >= 14 && name.charAt(4) == '-' && name.charAt(9) == '-') {
            isStandard = true;
        } else if (len >= 9 && name.charAt(4) == '-') {
            isStandard = true;
        }
        return isStandard;
    }

    String getLabel(ImagePlus imp, Roi roi, int n) {
        String ys;
        Rectangle r = roi.getBounds();
        int xc = r.x + r.width / 2;
        int yc = r.y + r.height / 2;
        if (n >= 0) {
            xc = yc;
            yc = n;
        }
        if (xc < 0) {
            xc = 0;
        }
        if (yc < 0) {
            yc = 0;
        }
        int digits = 4;
        String xs = "" + xc;
        if (xs.length() > digits) {
            digits = xs.length();
        }
        if ((ys = "" + yc).length() > digits) {
            digits = ys.length();
        }
        xs = "000000" + xc;
        ys = "000000" + yc;
        String label = ys.substring(ys.length() - digits) + "-" + xs.substring(xs.length() - digits);
        if (imp.getStackSize() > 1) {
            String zs = "000000" + imp.getCurrentSlice();
            label = zs.substring(zs.length() - digits) + "-" + label;
        }
        return label;
    }

    void addAndDraw(boolean altKeyDown) {
        if (altKeyDown ? !this.add(true) : !this.add(false)) {
            return;
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        Undo.setup(4, imp);
        IJ.run("Draw");
        Undo.setup(5, imp);
        if (Recorder.record) {
            Recorder.record("roiManager", "Add & Draw");
        }
    }

    boolean delete(boolean replacing) {
        int count = this.list.getItemCount();
        if (count == 0) {
            return this.error("The list is empty.");
        }
        int[] index = this.list.getSelectedIndexes();
        if (index.length == 0 || replacing && count > 1) {
            String msg = "Delete all items on the list?";
            if (replacing) {
                msg = "Replace items on the list?";
            }
            this.canceled = false;
            if (!IJ.macroRunning() && !this.macro) {
                YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, "ROI Manager", msg);
                if (d.cancelPressed()) {
                    this.canceled = true;
                    return false;
                }
                if (!d.yesPressed()) {
                    return false;
                }
            }
            index = this.getAllIndexes();
        }
        for (int i = count - 1; i >= 0; --i) {
            boolean delete = false;
            for (int j = 0; j < index.length; ++j) {
                if (index[j] != i) continue;
                delete = true;
            }
            if (!delete) continue;
            this.rois.remove(this.list.getItem(i));
            this.list.remove(i);
        }
        this.updateShowAll();
        if (Recorder.record) {
            Recorder.record("roiManager", "Delete");
        }
        return true;
    }

    boolean update() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        ImageCanvas ic = imp.getCanvas();
        boolean showingAll = ic != null && ic.getShowAllROIs();
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.error("The active image does not have a selection.");
            return false;
        }
        int index = this.list.getSelectedIndex();
        if (index < 0 && !showingAll) {
            return this.error("Exactly one item in the list must be selected.");
        }
        if (index >= 0) {
            String name = this.list.getItem(index);
            this.rois.remove(name);
            this.rois.put(name, roi);
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Update");
        }
        if (showingAll) {
            imp.draw();
        }
        return true;
    }

    boolean rename(String name2) {
        int index = this.list.getSelectedIndex();
        if (index < 0) {
            return this.error("Exactly one item in the list must be selected.");
        }
        String name = this.list.getItem(index);
        if (name2 == null) {
            name2 = this.promptForName(name);
        }
        if (name2 == null) {
            return false;
        }
        Roi roi = (Roi)this.rois.get(name);
        this.rois.remove(name);
        roi.setName(name2);
        this.rois.put(name2, roi);
        this.list.replaceItem(name2, index);
        this.list.select(index);
        if (Recorder.record) {
            Recorder.record("roiManager", "Rename", name2);
        }
        return true;
    }

    String promptForName(String name) {
        GenericDialog gd = new GenericDialog("ROI Manager");
        gd.addStringField("Rename As:", name, 20);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        String name2 = gd.getNextString();
        name2 = this.getUniqueName(name2);
        return name2;
    }

    boolean restore(int index, boolean setSlice) {
        int slice;
        String label = this.list.getItem(index);
        Roi roi = (Roi)this.rois.get(label);
        ImagePlus imp = this.getImage();
        if (imp == null || roi == null) {
            return false;
        }
        if (setSlice && (slice = this.getSliceNumber(label)) >= 1 && slice <= imp.getStackSize()) {
            imp.setSlice(slice);
        }
        Roi roi2 = (Roi)roi.clone();
        Calibration cal = imp.getCalibration();
        Rectangle r = roi2.getBounds();
        if (cal.xOrigin != 0.0 || cal.yOrigin != 0.0) {
            roi2.setLocation(r.x + (int)cal.xOrigin, r.y + (int)cal.yOrigin);
        }
        int width = imp.getWidth();
        int height = imp.getHeight();
        if (r.x >= width || r.y >= height || r.x + r.width <= 0 || r.y + r.height <= 0) {
            roi2.setLocation((width - r.width) / 2, (height - r.height) / 2);
        }
        imp.setRoi(roi2);
        return true;
    }

    int getSliceNumber(String label) {
        int slice = -1;
        if (label.length() > 4 && label.charAt(4) == '-' && label.length() >= 14) {
            slice = (int)Tools.parseDouble(label.substring(0, 4), -1.0);
        }
        return slice;
    }

    void open(String path) {
        Roi roi;
        Macro.setOptions(null);
        String name = null;
        if (path == null || path.equals("")) {
            OpenDialog od = new OpenDialog("Open Selection(s)...", "");
            String directory = od.getDirectory();
            name = od.getFileName();
            if (name == null) {
                return;
            }
            path = directory + name;
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Open", path);
        }
        if (path.endsWith(".zip")) {
            this.openZip(path);
            return;
        }
        Opener o = new Opener();
        if (name == null) {
            name = o.getName(path);
        }
        if ((roi = o.openRoi(path)) != null) {
            if (name.endsWith(".roi")) {
                name = name.substring(0, name.length() - 4);
            }
            name = this.getUniqueName(name);
            this.list.add(name);
            this.rois.put(name, roi);
        }
        this.updateShowAll();
    }

    void openZip(String path) {
        ZipInputStream in = null;
        int nRois = 0;
        try {
            in = new ZipInputStream(new FileInputStream(path));
            byte[] buf = new byte[1024];
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (name.endsWith(".roi")) {
                    int len;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.close();
                    byte[] bytes = out.toByteArray();
                    RoiDecoder rd = new RoiDecoder(bytes, name);
                    Roi roi = rd.getRoi();
                    if (roi != null) {
                        name = name.substring(0, name.length() - 4);
                        name = this.getUniqueName(name);
                        this.list.add(name);
                        this.rois.put(name, roi);
                        ++nRois;
                    }
                }
                entry = in.getNextEntry();
            }
            in.close();
        }
        catch (IOException e) {
            this.error(e.toString());
        }
        if (nRois == 0) {
            this.error("This ZIP archive does not appear to contain \".roi\" files");
        }
        this.updateShowAll();
    }

    String getUniqueName(String name) {
        String name2 = name;
        int n = 1;
        Roi roi2 = (Roi)this.rois.get(name2);
        while (roi2 != null) {
            roi2 = (Roi)this.rois.get(name2);
            if (roi2 != null) {
                int lastDash = name2.lastIndexOf("-");
                if (lastDash != -1 && name2.length() - lastDash < 5) {
                    name2 = name2.substring(0, lastDash);
                }
                name2 = name2 + "-" + n;
                ++n;
            }
            roi2 = (Roi)this.rois.get(name2);
        }
        return name2;
    }

    boolean save() {
        if (this.list.getItemCount() == 0) {
            return this.error("The selection list is empty.");
        }
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if (indexes.length > 1) {
            return this.saveMultiple(indexes, null);
        }
        String name = this.list.getItem(indexes[0]);
        Macro.setOptions(null);
        SaveDialog sd = new SaveDialog("Save Selection...", name, ".roi");
        String name2 = sd.getFileName();
        if (name2 == null) {
            return false;
        }
        String dir = sd.getDirectory();
        Roi roi = (Roi)this.rois.get(name);
        this.rois.remove(name);
        if (!name2.endsWith(".roi")) {
            name2 = name2 + ".roi";
        }
        String newName = name2.substring(0, name2.length() - 4);
        this.rois.put(newName, roi);
        roi.setName(newName);
        this.list.replaceItem(newName, indexes[0]);
        RoiEncoder re = new RoiEncoder(dir + name2);
        try {
            re.write(roi);
        }
        catch (IOException e) {
            IJ.error("ROI Manager", e.getMessage());
        }
        return true;
    }

    boolean saveMultiple(int[] indexes, String path) {
        Macro.setOptions(null);
        if (path == null) {
            SaveDialog sd = new SaveDialog("Save ROIs...", "RoiSet", ".zip");
            String name = sd.getFileName();
            if (name == null) {
                return false;
            }
            if (!name.endsWith(".zip") && !name.endsWith(".ZIP")) {
                name = name + ".zip";
            }
            String dir = sd.getDirectory();
            path = dir + name;
        }
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(path));
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(zos));
            RoiEncoder re = new RoiEncoder(out);
            for (int i = 0; i < indexes.length; ++i) {
                String label = this.list.getItem(indexes[i]);
                Roi roi = (Roi)this.rois.get(label);
                if (!label.endsWith(".roi")) {
                    label = label + ".roi";
                }
                zos.putNextEntry(new ZipEntry(label));
                re.write(roi);
                out.flush();
            }
            out.close();
        }
        catch (IOException e) {
            this.error("" + e);
            return false;
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Save", path);
        }
        return true;
    }

    boolean measure(int mode) {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if (indexes.length == 0) {
            return false;
        }
        int nLines = 0;
        boolean allSliceOne = true;
        for (int i = 0; i < indexes.length; ++i) {
            Roi roi;
            String label = this.list.getItem(indexes[i]);
            if (this.getSliceNumber(label) > 1) {
                allSliceOne = false;
            }
            if (!(roi = (Roi)this.rois.get(label)).isLine()) continue;
            ++nLines;
        }
        if (nLines > 0 && nLines != indexes.length) {
            this.error("All items must be areas or all must be lines.");
            return false;
        }
        int nSlices = 1;
        if (mode == 2) {
            nSlices = imp.getStackSize();
        }
        int measurements = Analyzer.getMeasurements();
        if (imp.getStackSize() > 1) {
            Analyzer.setMeasurements(measurements | 0x100000);
        }
        int currentSlice = imp.getCurrentSlice();
        for (int slice = 1; slice <= nSlices; ++slice) {
            if (nSlices > 1) {
                imp.setSlice(slice);
            }
            for (int i = 0; i < indexes.length && this.restore(indexes[i], nSlices == 1 && !allSliceOne); ++i) {
                IJ.run("Measure");
            }
        }
        imp.setSlice(currentSlice);
        Analyzer.setMeasurements(measurements);
        if (indexes.length > 1) {
            IJ.run("Select None");
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Measure");
        }
        return true;
    }

    boolean multiMeasure() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if (indexes.length == 0) {
            return false;
        }
        int measurements = Analyzer.getMeasurements();
        int nSlices = imp.getStackSize();
        GenericDialog gd = new GenericDialog("Multi Measure");
        if (nSlices > 1) {
            gd.addCheckbox("Measure All " + nSlices + " Slices", measureAll);
        }
        gd.addCheckbox("One Row Per Slice", onePerSlice);
        int columns = this.getColumnCount(imp, measurements) * indexes.length;
        String str = nSlices == 1 ? "this option" : "both options";
        gd.setInsets(10, 25, 0);
        gd.addMessage("Enabling " + str + " will result\n" + "in a table with " + columns + " columns.");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        if (nSlices > 1) {
            measureAll = gd.getNextBoolean();
        }
        onePerSlice = gd.getNextBoolean();
        if (!measureAll) {
            nSlices = 1;
        }
        int currentSlice = imp.getCurrentSlice();
        if (!onePerSlice) {
            return this.measure(2);
        }
        Analyzer aSys = new Analyzer();
        ResultsTable rtSys = Analyzer.getResultsTable();
        ResultsTable rtMulti = new ResultsTable();
        Analyzer aMulti = new Analyzer(imp, measurements, rtMulti);
        for (int slice = 1; slice <= nSlices; ++slice) {
            int sliceUse = slice;
            if (nSlices == 1) {
                sliceUse = currentSlice;
            }
            imp.setSlice(sliceUse);
            rtMulti.incrementCounter();
            int roiIndex = 0;
            for (int i = 0; i < indexes.length && this.restore(indexes[i], false); ++i) {
                ++roiIndex;
                Roi roi = imp.getRoi();
                ImageStatistics stats = imp.getStatistics(measurements);
                aSys.saveResults(stats, roi);
                for (int j = 0; j <= rtSys.getLastColumn(); ++j) {
                    float[] col = rtSys.getColumn(j);
                    String head = rtSys.getColumnHeading(j);
                    if (head == null || col == null || head.equals("Slice")) continue;
                    rtMulti.addValue(head + roiIndex, (double)rtSys.getValue(j, rtSys.getCounter() - 1));
                }
            }
            aMulti.displayResults();
            aMulti.updateHeadings();
        }
        imp.setSlice(currentSlice);
        if (indexes.length > 1) {
            IJ.run("Select None");
        }
        return true;
    }

    int getColumnCount(ImagePlus imp, int measurements) {
        ImageStatistics stats = imp.getStatistics(measurements);
        ResultsTable rt = new ResultsTable();
        Analyzer analyzer = new Analyzer(imp, measurements, rt);
        analyzer.saveResults(stats, null);
        int count = 0;
        for (int i = 0; i <= rt.getLastColumn(); ++i) {
            float[] col = rt.getColumn(i);
            String head = rt.getColumnHeading(i);
            if (head == null || col == null) continue;
            ++count;
        }
        return count;
    }

    boolean drawOrFill(int mode) {
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        imp.killRoi();
        ImageProcessor ip = imp.getProcessor();
        ip.setColor(Toolbar.getForegroundColor());
        ip.snapshot();
        Undo.setup(1, imp);
        Filler filler = mode == 2 ? new Filler() : null;
        int slice = imp.getCurrentSlice();
        block10: for (int i = 0; i < indexes.length; ++i) {
            int slice2;
            String name = this.list.getItem(i);
            Roi roi = (Roi)this.rois.get(name);
            int type = roi.getType();
            if (roi == null) continue;
            if (mode == 1 && (type == 6 || type == 7 || type == 8)) {
                mode = 0;
            }
            if ((slice2 = this.getSliceNumber(name)) >= 1 && slice2 <= imp.getStackSize()) {
                imp.setSlice(slice2);
                ip = imp.getProcessor();
                ip.setColor(Toolbar.getForegroundColor());
                if (slice2 != slice) {
                    Undo.reset();
                }
            }
            switch (mode) {
                case 0: {
                    roi.drawPixels(ip);
                    continue block10;
                }
                case 1: {
                    ip.fillPolygon(roi.getPolygon());
                    continue block10;
                }
                case 2: {
                    roi.drawPixels(ip);
                    filler.drawLabel(imp, ip, i + 1, roi.getBounds());
                }
            }
        }
        ImageCanvas ic = imp.getCanvas();
        if (ic != null) {
            ic.setShowAllROIs(false);
        }
        imp.updateAndDraw();
        String str = null;
        switch (mode) {
            case 0: {
                str = "Draw";
                break;
            }
            case 1: {
                str = "Fill";
                break;
            }
            case 2: {
                str = "Label";
                imp.updateAndDraw();
            }
        }
        if (Recorder.record) {
            Recorder.record("roiManager", str);
        }
        return true;
    }

    void combine() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length == 1) {
            this.error("More than one item must be selected, or none");
            return;
        }
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        ShapeRoi s1 = null;
        ShapeRoi s2 = null;
        for (int i = 0; i < indexes.length; ++i) {
            Roi roi = (Roi)this.rois.get(this.list.getItem(indexes[i]));
            if (roi.isLine() || roi.getType() == 10) continue;
            Calibration cal = imp.getCalibration();
            if (cal.xOrigin != 0.0 || cal.yOrigin != 0.0) {
                roi = (Roi)roi.clone();
                Rectangle r = roi.getBounds();
                roi.setLocation(r.x + (int)cal.xOrigin, r.y + (int)cal.yOrigin);
            }
            if (s1 == null) {
                s1 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
                if (s1 != null) continue;
                return;
            }
            s2 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
            if (s2 == null || !roi.isArea()) continue;
            s1.or(s2);
        }
        if (s1 != null) {
            imp.setRoi(s1);
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Combine");
        }
    }

    void addParticles() {
        String err = IJ.runMacroFile("ij.jar:AddParticles", null);
        if (err != null && err.length() > 0) {
            this.error(err);
        }
    }

    void sort() {
        int n = this.rois.size();
        if (n == 0) {
            return;
        }
        String[] labels = new String[n];
        int index = 0;
        Enumeration en = this.rois.keys();
        while (en.hasMoreElements()) {
            labels[index++] = (String)en.nextElement();
        }
        this.list.removeAll();
        StringSorter.sort(labels);
        for (int i = 0; i < labels.length; ++i) {
            this.list.add(labels[i]);
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Sort");
        }
    }

    void specify() {
        try {
            IJ.run("Specify...");
        }
        catch (Exception e) {
            return;
        }
        this.runCommand("add");
    }

    void removeSliceInfo() {
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        for (int i = 0; i < indexes.length; ++i) {
            int index = indexes[i];
            String name = this.list.getItem(index);
            int n = this.getSliceNumber(name);
            if (n == -1) continue;
            String name2 = name.substring(5, name.length());
            name2 = this.getUniqueName(name2);
            Roi roi = (Roi)this.rois.get(name);
            this.rois.remove(name);
            roi.setName(name2);
            this.rois.put(name2, roi);
            this.list.replaceItem(name2, index);
        }
    }

    void help() {
        String macro = "run('URL...', 'url=http://rsb.info.nih.gov/ij/docs/menus/analyze.html#manager');";
        new MacroRunner(macro);
    }

    void options() {
        Color c = ImageCanvas.getShowAllColor();
        GenericDialog gd = new GenericDialog("\"Show All\" Options");
        gd.addPanel(this.makeButtonPanel(gd), 10, new Insets(5, 0, 0, 0));
        gd.addCheckbox("Associate ROIs with Slices", Prefs.showAllSliceOnly);
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (c != ImageCanvas.getShowAllColor()) {
                ImageCanvas.setShowAllColor(c);
            }
            return;
        }
        Prefs.showAllSliceOnly = gd.getNextBoolean();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.draw();
        }
    }

    Panel makeButtonPanel(GenericDialog gd) {
        Panel panel = new Panel();
        this.colorButton = new Button("Set Color...");
        this.colorButton.addActionListener(this);
        panel.add(this.colorButton);
        return panel;
    }

    void setShowAllColor() {
        ColorChooser cc = new ColorChooser("\"Show All\" Color", ImageCanvas.getShowAllColor(), false);
        ImageCanvas.setShowAllColor(cc.getColor());
    }

    void split() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        Roi roi = imp.getRoi();
        if (roi == null || roi.getType() != 9) {
            this.error("Image with composite selection required");
            return;
        }
        boolean record = Recorder.record;
        Recorder.record = false;
        Roi[] rois = ((ShapeRoi)roi).getRois();
        for (int i = 0; i < rois.length; ++i) {
            imp.setRoi(rois[i]);
            this.add(false);
        }
        Recorder.record = record;
        if (Recorder.record) {
            Recorder.record("roiManager", "Split");
        }
    }

    void showAll() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            this.error(IJ.getBundle().getString("NoImgErr"));
            return;
        }
        ImageCanvas ic = imp.getCanvas();
        if (ic == null) {
            return;
        }
        boolean showingROIs = ic.getShowAllROIs();
        ic.setShowAllROIs(!showingROIs);
        if (Recorder.record) {
            Recorder.recordString("setOption(\"Show All\"," + (showingROIs ? "false" : "true") + ");\n");
        }
        imp.draw();
    }

    void updateShowAll() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        ImageCanvas ic = imp.getCanvas();
        if (ic != null && ic.getShowAllROIs()) {
            imp.draw();
        }
    }

    int[] getAllIndexes() {
        int count = this.list.getItemCount();
        int[] indexes = new int[count];
        for (int i = 0; i < count; ++i) {
            indexes[i] = i;
        }
        return indexes;
    }

    ImagePlus getImage() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            this.error(IJ.getBundle().getString("NoImgErr"));
            return null;
        }
        return imp;
    }

    boolean error(String msg) {
        new MessageDialog((Frame)this, "ROI Manager", msg);
        Macro.abort();
        return false;
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            instance = null;
        }
        this.ignoreInterrupts = false;
    }

    public static RoiManager getInstance() {
        return (RoiManager)instance;
    }

    public Hashtable getROIs() {
        return this.rois;
    }

    public List getList() {
        return this.list;
    }

    public int getCount() {
        return this.list.getItemCount();
    }

    public Roi[] getRoisAsArray() {
        int n = this.list.getItemCount();
        Roi[] array = new Roi[n];
        for (int i = 0; i < n; ++i) {
            String label = this.list.getItem(i);
            array[i] = (Roi)this.rois.get(label);
        }
        return array;
    }

    public static String getName(String index) {
        int i = (int)Tools.parseDouble(index, -1.0);
        RoiManager instance = RoiManager.getInstance();
        if (instance != null && i >= 0 && i < instance.list.getItemCount()) {
            return instance.list.getItem(i);
        }
        return "null";
    }

    public boolean runCommand(String cmd) {
        cmd = cmd.toLowerCase();
        this.macro = true;
        boolean ok = true;
        if (cmd.equals("add")) {
            this.add(IJ.shiftKeyDown(), IJ.altKeyDown());
        } else if (cmd.equals("add & draw")) {
            this.addAndDraw(false);
        } else if (cmd.equals("update")) {
            this.update();
        } else if (cmd.equals("delete")) {
            this.delete(false);
        } else if (cmd.equals("measure")) {
            this.measure(1);
        } else if (cmd.equals("draw")) {
            this.drawOrFill(0);
        } else if (cmd.equals("fill")) {
            this.drawOrFill(1);
        } else if (cmd.equals("label")) {
            this.drawOrFill(2);
        } else if (cmd.equals("combine")) {
            this.combine();
        } else if (cmd.equals("split")) {
            this.split();
        } else if (cmd.equals("sort")) {
            this.sort();
        } else if (cmd.equals("deselect") || cmd.indexOf("all") != -1) {
            if (IJ.isMacOSX()) {
                this.ignoreInterrupts = true;
            }
            this.select(-1);
        } else if (cmd.equals("reset")) {
            this.list.removeAll();
            this.rois.clear();
        } else {
            ok = false;
        }
        this.macro = false;
        return ok;
    }

    public boolean runCommand(String cmd, String name) {
        cmd = cmd.toLowerCase();
        this.macro = true;
        if (cmd.equals("open")) {
            this.open(name);
            this.macro = false;
            return true;
        }
        if (cmd.equals("save")) {
            if (!name.endsWith(".zip") && !name.equals("")) {
                return this.error("Name must end with '.zip'");
            }
            if (this.list.getItemCount() == 0) {
                return this.error("The selection list is empty.");
            }
            int[] indexes = this.getAllIndexes();
            boolean ok = false;
            ok = name.equals("") ? this.saveMultiple(indexes, null) : this.saveMultiple(indexes, name);
            this.macro = false;
            return ok;
        }
        if (cmd.equals("rename")) {
            this.rename(name);
            this.macro = false;
            return true;
        }
        return false;
    }

    public void select(int index) {
        int n = this.list.getItemCount();
        if (index < 0) {
            for (int i = 0; i < n; ++i) {
                if (!this.list.isSelected(i)) continue;
                this.list.deselect(i);
            }
            return;
        }
        boolean mm = this.list.isMultipleMode();
        if (mm) {
            this.list.setMultipleMode(false);
        }
        if (index < n) {
            this.list.select(index);
            this.restore(index, true);
            if (!Interpreter.isBatchMode()) {
                IJ.wait(10);
            }
        }
        if (mm) {
            this.list.setMultipleMode(true);
        }
    }

    public void select(int index, boolean shiftKeyDown, boolean altKeyDown) {
        ImagePlus imp;
        if (!shiftKeyDown && !altKeyDown) {
            this.select(index);
        }
        if ((imp = IJ.getImage()) == null) {
            return;
        }
        Roi previousRoi = imp.getRoi();
        if (previousRoi == null) {
            this.select(index);
            return;
        }
        Roi.previousRoi = (Roi)previousRoi.clone();
        String label = this.list.getItem(index);
        Roi roi = (Roi)this.rois.get(label);
        if (roi != null) {
            roi.setImage(imp);
            roi.update(shiftKeyDown, altKeyDown);
        }
    }

    void selectAll() {
        int i;
        boolean allSelected = true;
        int count = this.list.getItemCount();
        for (i = 0; i < count; ++i) {
            if (this.list.isIndexSelected(i)) continue;
            allSelected = false;
        }
        if (allSelected) {
            this.select(-1);
        } else {
            for (i = 0; i < count; ++i) {
                if (this.list.isSelected(i)) continue;
                this.list.select(i);
            }
        }
    }

    @Override
    public void close() {
        super.close();
        instance = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger() || e.isMetaDown()) {
            this.pm.show(e.getComponent(), x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        RoiManager roiManager = this;
        synchronized (roiManager) {
            int index = this.list.getSelectedIndex();
            int rot = event.getWheelRotation();
            if (rot < -1) {
                rot = -1;
            }
            if (rot > 1) {
                rot = 1;
            }
            if ((index += rot) < 0) {
                index = 0;
            }
            if (index >= this.list.getItemCount()) {
                index = this.list.getItemCount();
            }
            this.select(index);
            if (IJ.isWindows()) {
                this.list.requestFocusInWindow();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    static {
        measureAll = true;
        onePerSlice = true;
    }
}

