/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.jRenderer3D;

import ij.ImagePlus;
import ij.plugin.jRenderer3D.Line3D;
import ij.plugin.jRenderer3D.Point3D;
import ij.plugin.jRenderer3D.PointsPlot;
import ij.plugin.jRenderer3D.SurfacePlot;
import ij.plugin.jRenderer3D.Text3D;
import ij.plugin.jRenderer3D.Transform;
import ij.plugin.jRenderer3D.Volume;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.util.ArrayList;

public class JRenderer3D {
    private MemoryImageSource source = null;
    private BufferedImage bufferedImage = null;
    private Graphics2D g2D = null;
    private int[] bufferPixels = null;
    private double[] zbufferPixels = null;
    private int bufferWidth = 512;
    private int bufferHeight = 512;
    private Color backgroundColor = Color.gray;
    private Transform transform = null;
    private double tr_rotationX = 1.34;
    private double tr_rotationY = 0.0;
    private double tr_rotationZ = 1.0;
    private double tr_perspective = 0.0;
    private double tr_maxDistance = 256.0;
    private int zOrientation = -1;
    private double scale = 1.0;
    private double zAspectRatio = 1.0;
    private double xCenter = 0.0;
    private double yCenter = 0.0;
    private double zCenter = 0.0;
    private ArrayList lines3D = null;
    private ArrayList cubeLines3D = null;
    private ArrayList text3D = null;
    private PointsPlot pointsPlot = null;
    public static final int POINT_SPHERE = 2;
    public static final int POINT_CIRCLE = 1;
    public static final int POINT_DOT = 0;
    private static final int SURFACEGRID_DEFAULTWIDTH = 256;
    private static final int SURFACEGRID_DEFAULTHEIGHT = 256;
    public static final int SURFACEPLOT_DOTSNOLIGHT = 10;
    public static final int SURFACEPLOT_DOTS = 11;
    public static final int SURFACEPLOT_LINES = 12;
    public static final int SURFACEPLOT_MESH = 13;
    public static final int SURFACEPLOT_FILLED = 14;
    public static final int SURFACEPLOT_ISOLINES = 15;
    private SurfacePlot surfacePlot = null;
    private int surfacePlot_gridWidth = 256;
    private int surfacePlot_gridHeight = 256;
    private ImagePlus surfacePlot_imagePlusData = null;
    private ImagePlus surfacePlot_imagePlusTexture = null;
    private int surfacePlot_plotMode = 12;
    private int surfacePlot_lutNr = 50;
    private double surfacePlot_light = 0.0;
    public static final int VOLUME_DOTS = 20;
    public static final int VOLUME_SLICE_NEAREST_NEIGHBOR = 21;
    public static final int VOLUME_SLICE_TRILINEAR = 22;
    public static final int VOLUME_PROJECTION_TRILINEAR_FRONT = 25;
    private Volume volume = null;
    private int volume_drawMode = 20;
    private int volume_threshold = 0;
    private int volume_cutDist = 0;
    private int volume_lutNr = 50;
    private int volume_dotsDeltaX = 1;
    private int volume_dotsDeltaY = 1;
    private int volume_dotsDeltaZ = 1;
    private int surfacePlot_min = 0;
    private int surfacePlot_max = 255;
    private Image image;
    private boolean axes = true;
    private boolean lines = true;
    private boolean text = true;
    public static final int LUT_ORIGINAL = 50;
    public static final int LUT_GRAY = 51;
    public static final int LUT_SPECTRUM = 52;
    public static final int LUT_FIRE = 53;
    public static final int LUT_THERMAL = 54;
    public static final int LUT_ORANGE = 55;
    public static final int LUT_BLUE = 56;
    public static final int LUT_BLACK = 57;
    public static final int LUT_GRADIENT = 58;
    public static final int LUT_GRADIENT2 = 59;

    public JRenderer3D() {
    }

    public JRenderer3D(double xCenter, double yCenter, double zCenter) {
        this.xCenter = xCenter;
        this.yCenter = yCenter;
        this.zCenter = zCenter;
    }

    private void initBuffer() {
        this.bufferPixels = new int[this.bufferWidth * this.bufferHeight];
        this.zbufferPixels = new double[this.bufferWidth * this.bufferHeight];
        if (this.transform != null) {
            this.tr_rotationX = this.transform.getRotationX();
            this.tr_rotationY = this.transform.getRotationY();
            this.tr_rotationZ = this.transform.getRotationZ();
            this.scale = this.transform.getScale();
            this.zAspectRatio = this.transform.getZAspectRatio();
            this.tr_perspective = this.transform.getPerspective();
            this.tr_maxDistance = this.transform.getMaxDistance();
        }
        this.transform = new Transform(this.bufferWidth, this.bufferHeight);
        this.transform.setZOrientation(this.zOrientation);
        this.transform.setRotationXYZ(this.tr_rotationX, this.tr_rotationY, this.tr_rotationZ);
        this.transform.setScale(this.scale);
        this.transform.setZAspectRatio(this.zAspectRatio);
        this.transform.setPerspective(this.tr_perspective);
        this.transform.setMaxDistance(this.tr_maxDistance);
        this.source = new MemoryImageSource(this.bufferWidth, this.bufferHeight, this.bufferPixels, 0, this.bufferWidth);
        if (this.surfacePlot != null) {
            this.surfacePlot.setBuffers(this.bufferPixels, this.zbufferPixels, this.bufferWidth, this.bufferHeight);
            this.surfacePlot.setTransform(this.transform);
        }
        if (this.volume != null) {
            this.volume.setBuffers(this.bufferPixels, this.zbufferPixels, this.bufferWidth, this.bufferHeight);
            this.volume.setTransform(this.transform);
        }
    }

    private void lines() {
        Point3D p0 = new Point3D();
        Point3D p1 = new Point3D();
        for (int i = 0; i < this.lines3D.size(); ++i) {
            if (this.lines3D.get(i) == null || !(this.lines3D.get(i) instanceof Line3D)) continue;
            Line3D line = (Line3D)this.lines3D.get(i);
            int color = line.color;
            this.setPoints(line, p0, p1);
            this.transform.transform(p0);
            double x0 = this.transform.X;
            double y0 = this.transform.Y;
            double z0 = this.transform.Z + 2.0;
            this.transform.transform(p1);
            double x1 = this.transform.X;
            double y1 = this.transform.Y;
            double z1 = this.transform.Z + 2.0;
            if (line.isPair) {
                Line3D line2 = (Line3D)this.lines3D.get(++i);
                int color2 = line2.color;
                this.setPoints(line2, p0, p1);
                this.transform.transform(p0);
                double x0_2 = this.transform.X;
                double y0_2 = this.transform.Y;
                double z0_2 = this.transform.Z + 2.0;
                this.transform.transform(p1);
                double x1_2 = this.transform.X;
                double y1_2 = this.transform.Y;
                double z1_2 = this.transform.Z + 2.0;
                if (z0_2 + z1_2 > z0 + z1) {
                    x0 = x0_2;
                    y0 = y0_2;
                    z0 = z0_2;
                    x1 = x1_2;
                    y1 = y1_2;
                    z1 = z1_2;
                    color = color2;
                }
            }
            double dx1 = x1 - x0;
            double dy1 = y1 - y0;
            double dz1 = z1 - z0;
            int numSteps = (int)Math.max(Math.abs(dx1), Math.abs(dy1));
            double step = numSteps > 0 ? 1.0 / (double)numSteps : 1.0;
            for (int s = 0; s < numSteps; ++s) {
                double f = (double)s * step;
                int x = (int)(x0 + f * dx1);
                int y = (int)(y0 + f * dy1);
                if (x < 0 || y < 0 || x >= this.bufferWidth || y >= this.bufferHeight) continue;
                int pos = y * this.bufferWidth + x;
                double z = z0 + f * dz1;
                int v_ = (int)(z * 20.0 + 128.0);
                v_ = Math.min(Math.max(0, v_), 255);
                v_ = 0xFF000000 | v_ << 8;
                if (!(z <= this.zbufferPixels[pos])) continue;
                this.zbufferPixels[pos] = z;
                this.bufferPixels[pos] = color;
            }
        }
    }

    private void cubeLines() {
        Point3D p0 = new Point3D();
        Point3D p1 = new Point3D();
        for (int i = 0; i < this.cubeLines3D.size(); ++i) {
            if (this.cubeLines3D.get(i) == null || !(this.cubeLines3D.get(i) instanceof Line3D)) continue;
            Line3D line = (Line3D)this.cubeLines3D.get(i);
            int color = line.color;
            this.setPoints(line, p0, p1);
            this.transform.transform(p0);
            double x0 = this.transform.X;
            double y0 = this.transform.Y;
            double z0 = this.transform.Z;
            this.transform.transform(p1);
            double x1 = this.transform.X;
            double y1 = this.transform.Y;
            double z1 = this.transform.Z;
            double dx1 = x1 - x0;
            double dy1 = y1 - y0;
            double dz1 = z1 - z0;
            int numSteps = (int)Math.max(Math.abs(dx1), Math.abs(dy1));
            double step = numSteps > 0 ? 1.0 / (double)numSteps : 1.0;
            for (int s = 0; s < numSteps; ++s) {
                int pos;
                double z;
                double f = (double)s * step;
                int x = (int)(x0 + f * dx1);
                int y = (int)(y0 + f * dy1);
                if (x < 0 || y < 0 || x >= this.bufferWidth || y >= this.bufferHeight || !((z = z0 + f * dz1) <= this.zbufferPixels[pos = y * this.bufferWidth + x])) continue;
                this.zbufferPixels[pos] = z;
                this.bufferPixels[pos] = color;
            }
        }
    }

    private void setPoints(Line3D l0, Point3D p0, Point3D p1) {
        p0.x = l0.x1;
        p0.y = l0.y1;
        p0.z = l0.z1;
        p1.x = l0.x2;
        p1.y = l0.y2;
        p1.z = l0.z2;
    }

    private void finishAndDrawText() {
        int strWidth;
        Font font;
        double z4;
        double y4;
        double x4;
        double z3;
        double y3;
        double z2;
        double y2;
        double x2;
        double z;
        double y;
        double x;
        Text3D ti;
        int i;
        double scale;
        this.image = Toolkit.getDefaultToolkit().createImage(this.source);
        if (this.bufferedImage == null || this.bufferedImage.getHeight() != this.bufferHeight || this.bufferedImage.getWidth() != this.bufferWidth) {
            this.bufferedImage = new BufferedImage(this.bufferWidth, this.bufferHeight, 2);
            this.g2D = this.bufferedImage.createGraphics();
        }
        this.g2D.setColor(this.backgroundColor);
        this.g2D.fillRect(0, 0, this.bufferWidth, this.bufferHeight);
        if (this.text && this.text3D != null) {
            scale = this.transform.getScale();
            for (i = 0; i < this.text3D.size(); ++i) {
                Text3D ti2;
                if (this.text3D.get(i) == null || !(this.text3D.get(i) instanceof Text3D)) continue;
                ti = (Text3D)this.text3D.get(i);
                this.transform.transform(ti);
                x = this.transform.X;
                y = this.transform.Y;
                z = this.transform.Z;
                x2 = 0.0;
                y2 = 0.0;
                z2 = 0.0;
                if (ti.number == 2) {
                    ti2 = (Text3D)this.text3D.get(++i);
                    this.transform.transform(ti2);
                    x2 = this.transform.X;
                    y2 = this.transform.Y;
                    z2 = this.transform.Z;
                    if (z2 < z) {
                        x = x2;
                        y = y2;
                        z = z2;
                    }
                }
                if (ti.number == 4) {
                    ti2 = (Text3D)this.text3D.get(++i);
                    this.transform.transform(ti2);
                    x2 = this.transform.X;
                    y2 = this.transform.Y;
                    z2 = this.transform.Z;
                    ti = (Text3D)this.text3D.get(++i);
                    this.transform.transform(ti);
                    double x3 = this.transform.X;
                    y3 = this.transform.Y;
                    z3 = this.transform.Z;
                    ti = (Text3D)this.text3D.get(++i);
                    this.transform.transform(ti);
                    x4 = this.transform.X;
                    y4 = this.transform.Y;
                    z4 = this.transform.Z;
                    if (x2 < x) {
                        x = x2;
                        y = y2;
                        z = z3;
                    }
                    if (x3 < x) {
                        x = x3;
                        y = y3;
                        z = z3;
                    }
                    if (x4 < x) {
                        x = x4;
                        y = y4;
                        z = z4;
                    }
                }
                if (!(z >= 0.0)) continue;
                this.g2D.setColor(ti.color);
                int strHeight = (int)(scale * ti.size);
                font = new Font("Sans", 1, strHeight);
                this.g2D.setFont(font);
                FontMetrics metrics = this.g2D.getFontMetrics();
                strWidth = metrics.stringWidth(ti.text);
                this.g2D.drawString(ti.text, (int)x - strWidth / 2, (int)y + strHeight / 2);
            }
        }
        this.g2D.drawImage(this.image, 0, 0, null);
        if (this.text && this.text3D != null) {
            scale = this.transform.getScale();
            for (i = 0; i < this.text3D.size(); ++i) {
                if (this.text3D.get(i) == null || !(this.text3D.get(i) instanceof Text3D)) continue;
                ti = (Text3D)this.text3D.get(i);
                this.transform.transform(ti);
                x = this.transform.X;
                y = this.transform.Y;
                z = this.transform.Z;
                x2 = 0.0;
                y2 = 0.0;
                z2 = 0.0;
                if (ti.number == 2) {
                    Text3D ti2 = (Text3D)this.text3D.get(++i);
                    this.transform.transform(ti2);
                    x2 = this.transform.X;
                    y2 = this.transform.Y;
                    z2 = this.transform.Z;
                    if (z2 < z) {
                        x = x2;
                        y = y2;
                        z = z2;
                    }
                }
                if (ti.number == 4) {
                    Text3D ti2 = (Text3D)this.text3D.get(++i);
                    this.transform.transform(ti2);
                    x2 = this.transform.X;
                    y2 = this.transform.Y;
                    z2 = this.transform.Z;
                    ti = (Text3D)this.text3D.get(++i);
                    this.transform.transform(ti);
                    double x3 = this.transform.X;
                    y3 = this.transform.Y;
                    z3 = this.transform.Z;
                    ti = (Text3D)this.text3D.get(++i);
                    this.transform.transform(ti);
                    x4 = this.transform.X;
                    y4 = this.transform.Y;
                    z4 = this.transform.Z;
                    if (x2 < x) {
                        x = x2;
                        y = y2;
                        z = z3;
                    }
                    if (x3 < x) {
                        x = x3;
                        y = y3;
                        z = z3;
                    }
                    if (x4 < x) {
                        x = x4;
                        y = y4;
                        z = z4;
                    }
                }
                if (!(z < 0.0)) continue;
                this.g2D.setColor(ti.color);
                int strHeight = (int)(scale * ti.size);
                font = new Font("Sans", 1, strHeight);
                this.g2D.setFont(font);
                FontMetrics metrics = this.g2D.getFontMetrics();
                strWidth = metrics.stringWidth(ti.text);
                this.g2D.drawString(ti.text, (int)x - strWidth / 2, (int)y + strHeight / 2);
            }
        }
        font = new Font("Sans", 0, 13);
        this.g2D.setFont(font);
        this.g2D.setColor(new Color(80, 45, 164));
        this.g2D.drawString("ImageJ3D", this.bufferWidth - 66, this.bufferHeight - 6);
        this.g2D.setColor(new Color(255, 255, 255));
        this.g2D.drawString("ImageJ3D", this.bufferWidth - 68, this.bufferHeight - 8);
    }

    private void clearBuffers() {
        for (int i = this.bufferPixels.length - 1; i >= 0; --i) {
            this.bufferPixels[i] = 0;
            this.zbufferPixels[i] = 1000000.0;
        }
    }

    private Line3D setLinePoints(Line3D lineItem, double[] p1, double[] p2, int color) {
        lineItem.x1 = p1[0];
        lineItem.y1 = p1[1];
        lineItem.z1 = p1[2];
        lineItem.x2 = p2[0];
        lineItem.y2 = p2[1];
        lineItem.z2 = p2[2];
        lineItem.color = color;
        return lineItem;
    }

    private void addCubeLinesList(Line3D[] lines3D) {
        if (this.cubeLines3D == null) {
            this.cubeLines3D = new ArrayList();
        }
        for (int i = 0; i < lines3D.length; ++i) {
            this.cubeLines3D.add(lines3D[i]);
        }
    }

    private void clearCubeLines3D() {
        if (this.cubeLines3D != null) {
            this.cubeLines3D.clear();
        }
    }

    public void doRendering() {
        this.clearBuffers();
        if (this.volume != null) {
            this.transform.setOffsets(this.xCenter, this.yCenter, this.zCenter);
            this.volume.draw();
            this.transform.setOffsets(0.0, 0.0, 0.0);
        }
        if (this.surfacePlot != null) {
            this.surfacePlot.draw();
        }
        if (this.pointsPlot != null) {
            this.pointsPlot.draw();
        }
        if (this.lines && this.lines3D != null) {
            this.lines();
        }
        if (this.axes && this.cubeLines3D != null) {
            this.cubeLines();
        }
        this.finishAndDrawText();
    }

    public void addPoints3D(Point3D[] points3D) {
        if (this.pointsPlot == null) {
            this.pointsPlot = new PointsPlot();
            this.pointsPlot.setBuffers(this.bufferPixels, this.zbufferPixels, this.bufferWidth, this.bufferHeight);
            this.pointsPlot.setTransform(this.transform);
        }
        for (int i = 0; i < points3D.length; ++i) {
            if (points3D[i] == null) continue;
            points3D[i].x -= this.xCenter;
            points3D[i].y -= this.yCenter;
            points3D[i].z -= this.zCenter;
            this.pointsPlot.addPoint3D(points3D[i]);
        }
    }

    public void addPoint3D(Point3D point3D) {
        if (this.pointsPlot == null) {
            this.pointsPlot = new PointsPlot();
            this.pointsPlot.setBuffers(this.bufferPixels, this.zbufferPixels, this.bufferWidth, this.bufferHeight);
            this.pointsPlot.setTransform(this.transform);
        }
        point3D.x -= this.xCenter;
        point3D.y -= this.yCenter;
        point3D.z -= this.zCenter;
        this.pointsPlot.addPoint3D(point3D);
    }

    public void addPoint3D(int x, int y, int z, int size, Color color, int drawMode) {
        if (this.pointsPlot == null) {
            this.pointsPlot = new PointsPlot();
            this.pointsPlot.setBuffers(this.bufferPixels, this.zbufferPixels, this.bufferWidth, this.bufferHeight);
            this.pointsPlot.setTransform(this.transform);
        }
        Point3D point = new Point3D((double)x - this.xCenter, (double)y - this.yCenter, (double)z - this.zCenter, (double)size, color, drawMode);
        this.pointsPlot.addPoint3D(point);
    }

    public void addPoint3D(int x, int y, int z, int size, int rgb, int drawMode) {
        if (this.pointsPlot == null) {
            this.pointsPlot = new PointsPlot();
            this.pointsPlot.setBuffers(this.bufferPixels, this.zbufferPixels, this.bufferWidth, this.bufferHeight);
            this.pointsPlot.setTransform(this.transform);
        }
        Point3D point = new Point3D((double)x - this.xCenter, (double)y - this.yCenter, (double)z - this.zCenter, (double)size, rgb, drawMode);
        this.pointsPlot.addPoint3D(point);
    }

    public void setSurfacePlot(ImagePlus imp) {
        this.surfacePlot_imagePlusData = imp;
        this.surfacePlot = new SurfacePlot();
        this.surfacePlot.setSurfacePlotCenter(this.xCenter, this.yCenter, this.zCenter);
        this.surfacePlot.setSurfaceGridSize(this.surfacePlot_gridWidth, this.surfacePlot_gridHeight);
        this.surfacePlot.setSurfacePlotImage(this.surfacePlot_imagePlusData);
        if (this.surfacePlot_imagePlusTexture != null) {
            this.surfacePlot.setSurfacePlotTextureImage(this.surfacePlot_imagePlusTexture);
        }
        this.surfacePlot.resample();
        this.surfacePlot.setSurfacePlotMode(this.surfacePlot_plotMode);
        this.surfacePlot.setSurfacePlotLut(this.surfacePlot_lutNr);
        this.surfacePlot.setSurfacePLotSetLight(this.surfacePlot_light);
        this.surfacePlot.setBuffers(this.bufferPixels, this.zbufferPixels, this.bufferWidth, this.bufferHeight);
        this.surfacePlot.setTransform(this.transform);
    }

    public void setSurfacePlotTexture(ImagePlus impTexture) {
        this.surfacePlot_imagePlusTexture = impTexture;
        if (this.surfacePlot != null) {
            this.surfacePlot.setSurfacePlotTextureImage(impTexture);
            this.surfacePlot.resample();
        }
    }

    public void setSurfacePlotWithTexture(ImagePlus imp, ImagePlus impTexture) {
        this.setSurfacePlot(imp, impTexture);
    }

    private void setSurfacePlot(ImagePlus imp, ImagePlus impTexture) {
        this.surfacePlot_imagePlusData = imp;
        this.surfacePlot_imagePlusTexture = impTexture;
        this.surfacePlot = new SurfacePlot();
        this.surfacePlot.setSurfacePlotCenter(this.xCenter, this.yCenter, this.zCenter);
        this.surfacePlot.setSurfaceGridSize(this.surfacePlot_gridWidth, this.surfacePlot_gridHeight);
        if (this.surfacePlot_imagePlusData != null) {
            this.surfacePlot.setSurfacePlotImage(imp);
        }
        if (this.surfacePlot_imagePlusTexture != null) {
            this.surfacePlot.setSurfacePlotTextureImage(this.surfacePlot_imagePlusTexture);
        }
        this.surfacePlot.setSurfacePlotMode(this.surfacePlot_plotMode);
        this.surfacePlot.setSurfacePlotLut(this.surfacePlot_lutNr);
        this.surfacePlot.setSurfacePLotSetLight(this.surfacePlot_light);
        this.surfacePlot.setMinMax(this.surfacePlot_min, this.surfacePlot_max);
        this.surfacePlot.setBuffers(this.bufferPixels, this.zbufferPixels, this.bufferWidth, this.bufferHeight);
        this.surfacePlot.setTransform(this.transform);
    }

    public void setSurfacePlotMode(int surfacePlot_plotMode) {
        this.surfacePlot_plotMode = surfacePlot_plotMode;
        if (this.surfacePlot != null) {
            this.surfacePlot.setSurfacePlotMode(surfacePlot_plotMode);
        }
    }

    public void setVolumeDrawMode(int volume_drawMode) {
        this.volume_drawMode = volume_drawMode;
        if (this.volume != null) {
            this.volume.setVolumeDrawMode(volume_drawMode);
        }
    }

    public void setVolumeLut(int volume_lutNr) {
        this.volume_lutNr = volume_lutNr;
        if (this.volume != null) {
            this.volume.setVolumeLut(volume_lutNr);
        }
    }

    public void setVolumeDotsSubsampling(int volume_dotsDeltaX, int volume_dotsDeltaY, int volume_dotsDeltaZ) {
        this.volume_dotsDeltaX = volume_dotsDeltaX;
        this.volume_dotsDeltaY = volume_dotsDeltaY;
        this.volume_dotsDeltaZ = volume_dotsDeltaZ;
        if (this.volume != null) {
            this.volume.setVolumeDotsSubsampling(volume_dotsDeltaX, volume_dotsDeltaY, volume_dotsDeltaZ);
        }
    }

    public void setVolumeCutDistance(int volume_cutDist) {
        this.volume_cutDist = volume_cutDist * this.transform.getZOrientation();
        if (this.volume != null) {
            this.volume.setVolumeCutDist(this.volume_cutDist);
        }
    }

    public void setSurfacePlotGridSize(int width, int height) {
        this.surfacePlot_gridWidth = width;
        this.surfacePlot_gridHeight = height;
        if (this.surfacePlot != null) {
            this.surfacePlot.setSurfaceGridSize(this.surfacePlot_gridWidth, this.surfacePlot_gridHeight);
            this.surfacePlot.resample();
        }
    }

    public void setTransformZOrientation(int zOrientation) {
        this.transform.setZOrientation(zOrientation);
    }

    public void setTransformScale(double scale) {
        this.transform.setScale(scale);
    }

    public void setTransformRotationX(double ax) {
        this.transform.setRotationX(Math.toRadians(ax));
    }

    public void setTransformRotationY(double ay) {
        this.transform.setRotationY(Math.toRadians(ay));
    }

    public void setTransformRotationZ(double az) {
        this.transform.setRotationZ(Math.toRadians(az));
    }

    public void setTransformRotationXZ(double ax, double az) {
        this.transform.setRotationXZ(Math.toRadians(ax), Math.toRadians(az));
    }

    public void setTransformRotationXYZ(double ax, double ay, double az) {
        this.transform.setRotationXYZ(Math.toRadians(ax), Math.toRadians(ay), Math.toRadians(az));
    }

    public void changeTransformRotationXZ(double changeX, double changeZ) {
        this.transform.changeRotationXZ(Math.toRadians(changeX), Math.toRadians(changeZ));
    }

    public void changeTransformRotationXYZ(double changeX, double changeY, double changeZ) {
        this.transform.changeRotationXYZ(Math.toRadians(changeX), Math.toRadians(changeY), Math.toRadians(changeZ));
    }

    public void setBackgroundColor(int rgb) {
        this.backgroundColor = new Color(rgb, true);
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void addLines3D(Line3D[] lines3D) {
        if (this.lines3D == null) {
            this.lines3D = new ArrayList();
        }
        for (int i = 0; i < lines3D.length; ++i) {
            if (lines3D[i] == null) continue;
            lines3D[i].x1 -= this.xCenter;
            lines3D[i].y1 -= this.yCenter;
            lines3D[i].z1 -= this.zCenter;
            lines3D[i].x2 -= this.xCenter;
            lines3D[i].y2 -= this.yCenter;
            lines3D[i].z2 -= this.zCenter;
            this.lines3D.add(lines3D[i]);
        }
    }

    public void addLine3D(Line3D line3D) {
        if (this.lines3D == null) {
            this.lines3D = new ArrayList();
        }
        line3D.x1 -= this.xCenter;
        line3D.y1 -= this.yCenter;
        line3D.z1 -= this.zCenter;
        line3D.x2 -= this.xCenter;
        line3D.y2 -= this.yCenter;
        line3D.z2 -= this.zCenter;
        this.lines3D.add(line3D);
    }

    public void addLine3D(int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, Color color) {
        Line3D line3D = new Line3D(xStart, yStart, zStart, xEnd, yEnd, zEnd, color);
        line3D.x1 -= this.xCenter;
        line3D.y1 -= this.yCenter;
        line3D.z1 -= this.zCenter;
        line3D.x2 -= this.xCenter;
        line3D.y2 -= this.yCenter;
        line3D.z2 -= this.zCenter;
        if (this.lines3D == null) {
            this.lines3D = new ArrayList();
        }
        this.lines3D.add(line3D);
    }

    public void clearLines() {
        if (this.lines3D != null) {
            this.lines3D.clear();
        }
    }

    public void addText3D(Text3D[] text3D) {
        if (this.text3D == null) {
            this.text3D = new ArrayList();
        }
        for (int i = 0; i < text3D.length; ++i) {
            if (text3D[i] == null) continue;
            text3D[i].x -= this.xCenter;
            text3D[i].y -= this.yCenter;
            text3D[i].z -= this.zCenter;
            this.text3D.add(text3D[i]);
        }
    }

    public void addText3D(String text, int x, int y, int z, Color color, int size) {
        if (this.text3D == null) {
            this.text3D = new ArrayList();
        }
        Text3D t3D = new Text3D(text, (double)x - this.xCenter, (double)y - this.yCenter, (double)z - this.zCenter, color, size);
        this.text3D.add(t3D);
    }

    public void addText3D(String text, int x, int y, int z, int rgb, int size) {
        if (this.text3D == null) {
            this.text3D = new ArrayList();
        }
        Text3D t3D = new Text3D(text, (double)x - this.xCenter, (double)y - this.yCenter, (double)z - this.zCenter, new Color(rgb), size);
        this.text3D.add(t3D);
    }

    public void addText3D(Text3D text3D) {
        if (this.text3D == null) {
            this.text3D = new ArrayList();
        }
        text3D.x -= this.xCenter;
        text3D.y -= this.yCenter;
        text3D.z -= this.zCenter;
        this.text3D.add(text3D);
    }

    public void addTextPair3D(Text3D text1_3D, Text3D text2_3D) {
        if (this.text3D == null) {
            this.text3D = new ArrayList();
        }
        text1_3D.x -= this.xCenter;
        text1_3D.y -= this.yCenter;
        text1_3D.z -= this.zCenter;
        text2_3D.x -= this.xCenter;
        text2_3D.y -= this.yCenter;
        text2_3D.z -= this.zCenter;
        this.text3D.add(text1_3D);
        this.text3D.add(text2_3D);
    }

    public void clearText() {
        if (this.text3D != null) {
            this.text3D.clear();
        }
    }

    public void setBufferSize(int width, int height) {
        this.bufferWidth = width;
        this.bufferHeight = height;
        this.initBuffer();
    }

    public void add3DCube(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, Color color) {
        int colorInt = color.getRGB();
        this.add3DCube(xMin, yMin, zMin, xMax, yMax, zMax, colorInt);
    }

    public void add3DCube(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, int rgb) {
        double[][] cube = new double[][]{{(double)xMin - this.xCenter, (double)yMin - this.yCenter, (double)zMin - this.zCenter}, {(double)xMax - this.xCenter, (double)yMin - this.yCenter, (double)zMin - this.zCenter}, {(double)xMin - this.xCenter, (double)yMin - this.yCenter, (double)zMax - this.zCenter}, {(double)xMax - this.xCenter, (double)yMin - this.yCenter, (double)zMax - this.zCenter}, {(double)xMin - this.xCenter, (double)yMax - this.yCenter, (double)zMin - this.zCenter}, {(double)xMax - this.xCenter, (double)yMax - this.yCenter, (double)zMin - this.zCenter}, {(double)xMin - this.xCenter, (double)yMax - this.yCenter, (double)zMax - this.zCenter}, {(double)xMax - this.xCenter, (double)yMax - this.yCenter, (double)zMax - this.zCenter}};
        Line3D[] lines3D = new Line3D[]{this.setLinePoints(new Line3D(), cube[0], cube[1], rgb), this.setLinePoints(new Line3D(), cube[0], cube[2], rgb), this.setLinePoints(new Line3D(), cube[0], cube[4], rgb), this.setLinePoints(new Line3D(), cube[2], cube[6], rgb), this.setLinePoints(new Line3D(), cube[4], cube[6], rgb), this.setLinePoints(new Line3D(), cube[6], cube[7], rgb), this.setLinePoints(new Line3D(), cube[3], cube[7], rgb), this.setLinePoints(new Line3D(), cube[2], cube[3], rgb), this.setLinePoints(new Line3D(), cube[1], cube[3], rgb), this.setLinePoints(new Line3D(), cube[1], cube[5], rgb), this.setLinePoints(new Line3D(), cube[4], cube[5], rgb), this.setLinePoints(new Line3D(), cube[5], cube[7], rgb)};
        this.addCubeLinesList(lines3D);
    }

    public void clearCubes() {
        this.clearCubeLines3D();
    }

    public void setVolume(ImagePlus imagePlus) {
        this.volume = new Volume(imagePlus);
        this.zAspectRatio = this.volume.getZaspectRatio();
        this.transform.setZAspectRatio(this.zAspectRatio);
        this.volume.setBuffers(this.bufferPixels, this.zbufferPixels, this.bufferWidth, this.bufferHeight);
        this.volume.setVolumeLut(this.volume_lutNr);
        this.volume.setVolumeDrawMode(this.volume_drawMode);
        this.volume.setVolumeThreshold(this.volume_threshold);
        this.volume.setVolumeCutDist(this.volume_cutDist);
        this.volume.setVolumeDotsSubsampling(this.volume_dotsDeltaX, this.volume_dotsDeltaY, this.volume_dotsDeltaZ);
        this.volume.setTransform(this.transform);
    }

    public void setSurfacePlotLut(int surfacePlot_lutNr) {
        this.surfacePlot_lutNr = surfacePlot_lutNr;
        if (this.surfacePlot != null) {
            this.surfacePlot.setSurfacePlotLut(surfacePlot_lutNr);
        }
    }

    public void setSurfacePlotLight(double surfacePlot_light) {
        this.surfacePlot_light = surfacePlot_light;
        if (this.surfacePlot != null) {
            this.surfacePlot.setSurfacePLotSetLight(surfacePlot_light);
        }
    }

    public void setSurfacePlotMinMax(int surfacePlot_min, int surfacePlot_max) {
        this.surfacePlot_min = surfacePlot_min;
        this.surfacePlot_max = surfacePlot_max;
        if (this.surfacePlot != null) {
            this.surfacePlot.setMinMax(surfacePlot_min, surfacePlot_max);
            this.surfacePlot.applyMinMax();
        }
    }

    public void setSurfaceSmoothingFactor(double smoothRadius) {
        this.surfacePlot.applySmoothingFilter(smoothRadius);
    }

    public void setVolumeThreshold(int threshold) {
        this.volume_threshold = threshold;
        if (this.volume != null) {
            this.volume.setVolumeThreshold(threshold);
        }
    }

    public void setTransformZAspectRatio(double zAspectRatio) {
        this.zAspectRatio = zAspectRatio;
        this.transform.setZAspectRatio(zAspectRatio);
    }

    public int getWidth() {
        return this.bufferWidth;
    }

    public int getHeight() {
        return this.bufferHeight;
    }

    public Image getImage() {
        return this.bufferedImage;
    }

    public double getTransformZAspectRatio() {
        return this.transform.getZAspectRatio();
    }

    public void removeLastPoint3D() {
        if (this.pointsPlot != null) {
            this.pointsPlot.removeLastPoint();
        }
    }

    public void removeLastLine3D() {
        int size;
        if (this.lines3D != null && (size = this.lines3D.size()) > 0) {
            this.lines3D.remove(size - 1);
        }
    }

    public int getNumPoints3D() {
        return this.pointsPlot.getSize();
    }

    public void setTransformPerspective(double perspective) {
        this.transform.setPerspective(perspective);
    }

    public void setTransformMaxDistance(double maxDistance) {
        this.transform.setMaxDistance(maxDistance);
    }

    public void setAxes(boolean axes) {
        this.axes = axes;
    }

    public void setLines(boolean lines) {
        this.lines = lines;
    }

    public void setText(boolean text) {
        this.text = text;
    }

    public void setInverse(boolean b) {
        if (this.surfacePlot != null) {
            this.surfacePlot.setInverse(b);
        }
    }

    public double getTransformScale() {
        if (this.transform != null) {
            return this.transform.getScale();
        }
        return 1.0;
    }
}

