/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.OvalRoi;
import ij.gui.PhotometerParams;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.process.FloatProcessor;
import ij.process.IPhot;
import ij.process.ImageStatistics;
import ij.process.PhotometerSave;
import ij.text.TextWindow;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class Photometer
implements MouseListener,
WindowListener {
    public static final short STAR_RAD = 1;
    public static final short SKY_RAD = 2;
    public static final short SKY_VAL = 4;
    public static final short SKY_STAR = 8;
    public static final short COORD = 16;
    private short exec = 0;
    private int x = -1;
    private int y = -1;
    private int slic = -1;
    private ImageStatistics stat;
    private ImageStatistics istat;
    private OvalRoi out;
    private OvalRoi in;
    private float skyval;
    private static TextWindow res = null;
    private static Photometer instance = null;
    private static int phindex = 1;
    private ImagePlus imp;
    private static IPhot iphot;
    private static PhotometerSave PS;

    public Photometer() {
        res = new TextWindow(IJ.getBundle().getString("Photometer"), IJ.getBundle().getString("PhotometerLabels"), null, 600, 200, false);
        res.setPhotometry(true);
        PS = PhotometerSave.getInstance() == null ? new PhotometerSave() : PhotometerSave.getInstance();
        IJ.register(Photometer.class);
        instance = this;
        if (Photometer.PS.results.size() > 0) {
            StringBuffer sb;
            if (Photometer.PS.results.size() > 0) {
                Enumeration keys = Photometer.PS.results.keys();
                sb = new StringBuffer();
                int i = 1;
                int m = 0;
                while (keys.hasMoreElements()) {
                    ++i;
                    int n = Integer.parseInt((String)keys.nextElement());
                    if (n <= m) continue;
                    m = n;
                }
                for (int j = 1; j <= m; ++j) {
                    IPhot res = (IPhot)Photometer.PS.results.get(String.valueOf(j));
                    if (res == null) continue;
                    sb.append(j + "\t" + res.toString() + "\n");
                }
            } else {
                sb = null;
            }
            if (res == null) {
                res = new TextWindow(IJ.getBundle().getString("Photometer"), IJ.getBundle().getString("PhotometerLabels"), null, 600, 200, false);
                res.setPhotometry(true);
            }
            res.append(new String(sb));
        }
        this.activate();
    }

    public static Photometer getInstance() {
        return instance;
    }

    public static void activate() {
        WindowManager.activateWindow(IJ.getBundle().getString("Photometer"));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (instance != null) {
            int ii;
            short op = 0;
            PhotometerParams pp = PhotometerParams.getInstance();
            if (pp != null) {
                op = pp.getStatus();
            }
            int tool = Toolbar.getToolId();
            if ((e.getModifiers() & 0x10) == 0 || tool == 6 || tool == 7) {
                return;
            }
            this.stat = null;
            this.istat = null;
            this.x = e.getX();
            this.y = e.getY();
            try {
                ImageCanvas canvas = (ImageCanvas)e.getSource();
                this.x = canvas.offScreenX(this.x);
                this.y = canvas.offScreenY(this.y);
                this.imp = canvas.getImage();
                if (this.imp.getType() != 0 && this.imp.getType() != 1 && this.imp.getType() != 2) {
                    IJ.error(IJ.getBundle().getString("TypeReqErr") + IJ.getBundle().getString("Grayscale"));
                    return;
                }
            }
            catch (Exception ex) {
                return;
            }
            if (this.imp.getStackSize() > 1) {
                this.slic = this.imp.getCurrentSlice();
            }
            Calibration cal = this.imp.getCalibration();
            int anul_rad = 8;
            int rad = 2;
            int imwidth = this.imp.getProcessor().getWidth();
            int imheight = this.imp.getProcessor().getHeight();
            if ((op & 0x10) == 0) {
                double pixM = 0.0;
                double pixL = 0.0;
                int valnul = 0;
                for (int ii2 = this.x - anul_rad; ii2 <= this.x + anul_rad; ++ii2) {
                    for (int jj = this.y - anul_rad; jj <= this.y + anul_rad; ++jj) {
                        pixL = 0.0;
                        valnul = 0;
                        for (int i = ii2 - rad; i <= ii2 + rad; ++i) {
                            for (int j = jj - rad; j <= jj + rad; ++j) {
                                if (i >= 0 && i < imwidth && j >= 0 && j < imheight) {
                                    pixL += cal.getCValue(this.imp.getPixel(i, j)[0]);
                                    continue;
                                }
                                ++valnul;
                            }
                        }
                        if (!((pixL /= (double)((2 * rad + 1) * (2 * rad + 1) - valnul)) > pixM)) continue;
                        pixM = pixL;
                        this.x = ii2;
                        this.y = jj;
                    }
                }
            } else {
                try {
                    int[] t = PhotometerParams.getInstance().getCoord();
                    this.x = t[0];
                    this.y = t[1];
                }
                catch (NumberFormatException exc) {
                    IJ.error("CoordFmt");
                    return;
                }
            }
            anul_rad = 50;
            float[] tab = new float[2 * anul_rad * 2 * anul_rad];
            int[] raduis = new int[4];
            if (this.imp.getType() != 2) {
                for (ii = 0; ii < 2 * anul_rad; ++ii) {
                    for (int jj = 0; jj < 2 * anul_rad; ++jj) {
                        int x1 = this.x - anul_rad + ii;
                        int y1 = this.y - anul_rad + jj;
                        tab[ii * 2 * anul_rad + jj] = x1 >= 0 && y1 >= 0 && x1 < imwidth && y1 < imheight ? (float)this.imp.getPixel(x1, y1)[0] : Float.MIN_VALUE;
                    }
                }
            } else {
                FloatProcessor ip = (FloatProcessor)this.imp.getProcessor();
                for (int ii3 = 0; ii3 < 2 * anul_rad; ++ii3) {
                    for (int jj = 0; jj < 2 * anul_rad; ++jj) {
                        int x1 = this.x - anul_rad + ii3;
                        int y1 = this.y - anul_rad + jj;
                        tab[ii3 * 2 * anul_rad + jj] = x1 >= 0 && y1 >= 0 && x1 < imwidth && y1 < imheight ? Float.intBitsToFloat(ip.getPixel(x1, y1)) : Float.MIN_VALUE;
                    }
                }
            }
            Arrays.sort(tab);
            ii = 0;
            while (tab[ii] <= Float.MIN_VALUE) {
                ++ii;
            }
            int medval = (2 * anul_rad * 2 * anul_rad - 1 - ii) / 2;
            float median = tab[medval];
            int maxind = medval;
            int[] itab = new int[5];
            if (this.imp.getType() != 2) {
                int iy2;
                int iy1;
                int ix2;
                int ix1;
                this.skyval = (float)cal.getCValue(tab[maxind]);
                double cval = 0.0;
                int valnul = 0;
                for (int i = this.x - rad; i <= this.x + rad; ++i) {
                    for (int j = this.y - rad; j <= this.y + rad; ++j) {
                        if (i >= 0 && i < imwidth && j >= 0 && j < imheight) {
                            cval += Double.valueOf(cal.getCValue(this.imp.getPixel(i, j)[0])).doubleValue();
                            continue;
                        }
                        ++valnul;
                    }
                }
                cval = (cval / (double)((2 * rad + 1) * (2 * rad + 1) - valnul) - (double)this.skyval) / 2.0;
                double sval = cval + (double)this.skyval;
                for (ix1 = this.x; ix1 < imwidth && (double)((float)cal.getCValue(this.imp.getPixel(ix1, this.y)[0])) > sval; ++ix1) {
                }
                raduis[0] = ix1 - this.x;
                for (ix2 = this.x; ix2 >= 0 && (double)((float)cal.getCValue(this.imp.getPixel(ix2, this.y)[0])) > sval; --ix2) {
                }
                raduis[1] = this.x - ix2;
                for (iy1 = this.y; iy1 < imheight && (double)((float)cal.getCValue(this.imp.getPixel(this.x, iy1)[0])) > sval; ++iy1) {
                }
                raduis[2] = iy1 - this.y;
                for (iy2 = this.y; iy2 >= 0 && (double)((float)cal.getCValue(this.imp.getPixel(this.x, iy2)[0])) > sval; --iy2) {
                }
                raduis[3] = this.y - iy2;
                Arrays.sort(raduis);
                if (raduis[3] <= 0) {
                    raduis[3] = 4;
                }
                if (raduis[3] >= 10) {
                    raduis[3] = 8;
                }
            } else {
                int iy2;
                int iy1;
                int ix2;
                int ix1;
                FloatProcessor ip = (FloatProcessor)this.imp.getProcessor();
                this.skyval = tab[maxind];
                double cval = 0.0;
                int valnul = 0;
                for (int i = this.x - rad; i <= this.x + rad; ++i) {
                    for (int j = this.y - rad; j <= this.y + rad; ++j) {
                        if (i >= 0 && i < imwidth && j >= 0 && j < imheight) {
                            cval += (double)Float.intBitsToFloat(ip.getPixel(i, j));
                            continue;
                        }
                        ++valnul;
                    }
                }
                cval = (cval / (double)((2 * rad + 1) * (2 * rad + 1) - valnul) - (double)this.skyval) / 2.0;
                double sval = cval + (double)this.skyval;
                for (ix1 = this.x; ix1 < imwidth && (double)Float.intBitsToFloat(ip.getPixel(ix1, this.y)) > sval; ++ix1) {
                }
                raduis[0] = ix1 - this.x;
                for (ix2 = this.x; ix2 >= 0 && (double)Float.intBitsToFloat(ip.getPixel(ix2, this.y)) > sval; --ix2) {
                }
                raduis[1] = this.x - ix2;
                for (iy1 = this.y; iy1 < imheight && (double)Float.intBitsToFloat(ip.getPixel(this.x, iy1)) > sval; ++iy1) {
                }
                raduis[2] = iy1 - this.y;
                for (iy2 = this.y; iy2 >= 0 && (double)Float.intBitsToFloat(ip.getPixel(this.x, iy2)) > sval; --iy2) {
                }
                raduis[3] = this.y - iy2;
                Arrays.sort(raduis);
                if (raduis[3] <= 0) {
                    raduis[3] = 4;
                }
                if (raduis[3] >= 10) {
                    raduis[3] = 8;
                }
            }
            int StarRaduis = 0;
            int SkyRadius = 0;
            if ((op & 1) == 0) {
                StarRaduis = raduis[3] * 4 + 2;
            } else {
                try {
                    StarRaduis = (int)PhotometerParams.getInstance().getVal((short)1);
                }
                catch (NumberFormatException nfe) {
                    IJ.error("StarRadFmt");
                    StarRaduis = raduis[3] * 4 + 2;
                }
            }
            if ((op & 2) == 0) {
                SkyRadius = (op & 8) == 0 ? (int)(1.5 * (double)StarRaduis) : (int)(1.5 * (double)StarRaduis);
            } else {
                try {
                    SkyRadius = (int)PhotometerParams.getInstance().getVal((short)2);
                }
                catch (NumberFormatException nfe) {
                    IJ.error("SkyRadFmt");
                    SkyRadius = (int)(1.5 * (double)StarRaduis);
                }
            }
            this.out = new OvalRoi(this.x - SkyRadius, this.y - SkyRadius, 2 * SkyRadius, 2 * SkyRadius);
            this.in = new OvalRoi(this.x - StarRaduis, this.y - StarRaduis, 2 * StarRaduis, 2 * StarRaduis);
            this.imp.setRoi(this.out);
            this.stat = this.imp.getStatistics();
            this.imp.setRoi(this.in);
            this.istat = this.imp.getStatistics();
            if ((op & 4) == 0) {
                this.stat.mean = (this.stat.mean * (double)this.stat.pixelCount - this.istat.mean * (double)this.istat.pixelCount) / (double)(this.stat.pixelCount - this.istat.pixelCount);
            } else {
                try {
                    this.stat.mean = PhotometerParams.getInstance().getVal((short)4);
                }
                catch (NumberFormatException nfe) {
                    IJ.error("SkyValFmt");
                    this.stat.mean = (this.stat.mean * (double)this.stat.pixelCount - this.istat.mean * (double)this.istat.pixelCount) / (double)(this.stat.pixelCount - this.istat.pixelCount);
                }
            }
            this.istat.mean = (this.istat.mean - this.stat.mean) * (double)this.istat.pixelCount;
            if (PhotometerParams.getInstance() != null) {
                PhotometerParams.getInstance().setX(this.x);
                PhotometerParams.getInstance().setY(this.y);
                PhotometerParams.getInstance().setstatf(StarRaduis);
                PhotometerParams.getInstance().setradtf(SkyRadius);
                PhotometerParams.getInstance().setvaltf((int)this.stat.mean);
                PhotometerParams.getInstance().setIMP(this.imp);
            }
        }
    }

    public void computePhotometry(ImagePlus imp, int x, int y) {
        String t;
        int ii;
        short op = 0;
        PhotometerParams pp = PhotometerParams.getInstance();
        if (pp != null) {
            op = pp.getStatus();
        }
        if (imp.getStackSize() > 1) {
            this.slic = imp.getCurrentSlice();
        }
        Calibration cal = imp.getCalibration();
        int anul_rad = 8;
        int rad = 2;
        int imwidth = imp.getProcessor().getWidth();
        int imheight = imp.getProcessor().getHeight();
        if ((op & 0x10) == 0) {
            double pixM = 0.0;
            double pixL = 0.0;
            int valnul = 0;
            for (int ii2 = x - anul_rad; ii2 <= x + anul_rad; ++ii2) {
                for (int jj = y - anul_rad; jj <= y + anul_rad; ++jj) {
                    pixL = 0.0;
                    valnul = 0;
                    for (int i = ii2 - rad; i <= ii2 + rad; ++i) {
                        for (int j = jj - rad; j <= jj + rad; ++j) {
                            if (i >= 0 && i < imwidth && j >= 0 && j < imheight) {
                                pixL += cal.getCValue(imp.getPixel(i, j)[0]);
                                continue;
                            }
                            ++valnul;
                        }
                    }
                    if (!((pixL /= (double)((2 * rad + 1) * (2 * rad + 1) - valnul)) > pixM)) continue;
                    pixM = pixL;
                    x = ii2;
                    y = jj;
                }
            }
        } else {
            try {
                int[] t2 = PhotometerParams.getInstance().getCoord();
                x = t2[0];
                y = t2[1];
            }
            catch (NumberFormatException exc) {
                IJ.error("CoordFmt");
                return;
            }
        }
        anul_rad = 50;
        float[] tab = new float[2 * anul_rad * 2 * anul_rad];
        int[] raduis = new int[4];
        if (imp.getType() != 2) {
            for (ii = 0; ii < 2 * anul_rad; ++ii) {
                for (int jj = 0; jj < 2 * anul_rad; ++jj) {
                    int x1 = x - anul_rad + ii;
                    int y1 = y - anul_rad + jj;
                    tab[ii * 2 * anul_rad + jj] = x1 >= 0 && y1 >= 0 && x1 < imwidth && y1 < imheight ? (float)imp.getPixel(x1, y1)[0] : Float.MIN_VALUE;
                }
            }
        } else {
            FloatProcessor ip = (FloatProcessor)imp.getProcessor();
            for (int ii3 = 0; ii3 < 2 * anul_rad; ++ii3) {
                for (int jj = 0; jj < 2 * anul_rad; ++jj) {
                    int x1 = x - anul_rad + ii3;
                    int y1 = y - anul_rad + jj;
                    tab[ii3 * 2 * anul_rad + jj] = x1 >= 0 && y1 >= 0 && x1 < imwidth && y1 < imheight ? Float.intBitsToFloat(ip.getPixel(x1, y1)) : Float.MIN_VALUE;
                }
            }
        }
        Arrays.sort(tab);
        ii = 0;
        while (tab[ii] <= Float.MIN_VALUE) {
            ++ii;
        }
        int medval = (2 * anul_rad * 2 * anul_rad - 1 - ii) / 2;
        float median = tab[medval];
        int maxind = medval;
        int[] itab = new int[5];
        if (imp.getType() != 2) {
            int iy2;
            int iy1;
            int ix2;
            int ix1;
            this.skyval = (float)cal.getCValue(tab[maxind]);
            double cval = 0.0;
            int valnul = 0;
            for (int i = x - rad; i <= x + rad; ++i) {
                for (int j = y - rad; j <= y + rad; ++j) {
                    if (i >= 0 && i < imwidth && j >= 0 && j < imheight) {
                        cval += Double.valueOf(cal.getCValue(imp.getPixel(i, j)[0])).doubleValue();
                        continue;
                    }
                    ++valnul;
                }
            }
            cval = (cval / (double)((2 * rad + 1) * (2 * rad + 1) - valnul) - (double)this.skyval) / 2.0;
            double sval = cval + (double)this.skyval;
            for (ix1 = x; ix1 < imwidth && (double)((float)cal.getCValue(imp.getPixel(ix1, y)[0])) > sval; ++ix1) {
            }
            raduis[0] = ix1 - x;
            for (ix2 = x; ix2 >= 0 && (double)((float)cal.getCValue(imp.getPixel(ix2, y)[0])) > sval; --ix2) {
            }
            raduis[1] = x - ix2;
            for (iy1 = y; iy1 < imheight && (double)((float)cal.getCValue(imp.getPixel(x, iy1)[0])) > sval; ++iy1) {
            }
            raduis[2] = iy1 - y;
            for (iy2 = y; iy2 >= 0 && (double)((float)cal.getCValue(imp.getPixel(x, iy2)[0])) > sval; --iy2) {
            }
            raduis[3] = y - iy2;
            Arrays.sort(raduis);
            if (raduis[3] <= 0) {
                raduis[3] = 4;
            }
            if (raduis[3] >= 10) {
                raduis[3] = 8;
            }
        } else {
            int iy2;
            int iy1;
            int ix2;
            int ix1;
            FloatProcessor ip = (FloatProcessor)imp.getProcessor();
            this.skyval = tab[maxind];
            double cval = 0.0;
            int valnul = 0;
            for (int i = x - rad; i <= x + rad; ++i) {
                for (int j = y - rad; j <= y + rad; ++j) {
                    if (i >= 0 && i < imwidth && j >= 0 && j < imheight) {
                        cval += (double)Float.intBitsToFloat(ip.getPixel(i, j));
                        continue;
                    }
                    ++valnul;
                }
            }
            cval = (cval / (double)((2 * rad + 1) * (2 * rad + 1) - valnul) - (double)this.skyval) / 2.0;
            double sval = cval + (double)this.skyval;
            for (ix1 = x; ix1 < imwidth && (double)Float.intBitsToFloat(ip.getPixel(ix1, y)) > sval; ++ix1) {
            }
            raduis[0] = ix1 - x;
            for (ix2 = x; ix2 >= 0 && (double)Float.intBitsToFloat(ip.getPixel(ix2, y)) > sval; --ix2) {
            }
            raduis[1] = x - ix2;
            for (iy1 = y; iy1 < imheight && (double)Float.intBitsToFloat(ip.getPixel(x, iy1)) > sval; ++iy1) {
            }
            raduis[2] = iy1 - y;
            for (iy2 = y; iy2 >= 0 && (double)Float.intBitsToFloat(ip.getPixel(x, iy2)) > sval; --iy2) {
            }
            raduis[3] = y - iy2;
            Arrays.sort(raduis);
            if (raduis[3] <= 0) {
                raduis[3] = 4;
            }
            if (raduis[3] >= 10) {
                raduis[3] = 8;
            }
        }
        int StarRaduis = 0;
        int SkyRadius = 0;
        if ((op & 1) == 0) {
            StarRaduis = raduis[3] * 4 + 2;
        } else {
            try {
                StarRaduis = (int)PhotometerParams.getInstance().getVal((short)1);
            }
            catch (NumberFormatException nfe) {
                IJ.error("StarRadFmt");
                StarRaduis = raduis[3] * 4 + 2;
            }
        }
        if ((op & 2) == 0) {
            SkyRadius = (op & 8) == 0 ? (int)(1.5 * (double)StarRaduis) : (int)(1.5 * (double)StarRaduis);
        } else {
            try {
                SkyRadius = (int)PhotometerParams.getInstance().getVal((short)2);
            }
            catch (NumberFormatException nfe) {
                IJ.error("SkyRadFmt");
                SkyRadius = (int)(1.5 * (double)StarRaduis);
            }
        }
        this.out = new OvalRoi(x - SkyRadius, y - SkyRadius, 2 * SkyRadius, 2 * SkyRadius);
        this.in = new OvalRoi(x - StarRaduis, y - StarRaduis, 2 * StarRaduis, 2 * StarRaduis);
        imp.setRoi(this.out);
        this.stat = imp.getStatistics();
        imp.setRoi(this.in);
        this.istat = imp.getStatistics();
        if ((op & 4) == 0) {
            this.stat.mean = (this.stat.mean * (double)this.stat.pixelCount - this.istat.mean * (double)this.istat.pixelCount) / (double)(this.stat.pixelCount - this.istat.pixelCount);
        } else {
            try {
                this.stat.mean = PhotometerParams.getInstance().getVal((short)4);
            }
            catch (NumberFormatException nfe) {
                IJ.error("SkyValFmt");
                this.stat.mean = (this.stat.mean * (double)this.stat.pixelCount - this.istat.mean * (double)this.istat.pixelCount) / (double)(this.stat.pixelCount - this.istat.pixelCount);
            }
        }
        this.istat.mean = (this.istat.mean - this.stat.mean) * (double)this.istat.pixelCount;
        if (PhotometerParams.getInstance() != null) {
            PhotometerParams.getInstance().setX(x);
            PhotometerParams.getInstance().setY(y);
            PhotometerParams.getInstance().setstatf(StarRaduis);
            PhotometerParams.getInstance().setradtf(SkyRadius);
            PhotometerParams.getInstance().setvaltf((int)this.stat.mean);
            PhotometerParams.getInstance().setIMP(imp);
        }
        try {
            t = IJ.getImage().getTitle();
        }
        catch (Exception ex) {
            return;
        }
        try {
            String message = "";
            if (this.stat.mean < 0.0) {
                Double sqrt_stat_mean = Math.sqrt(-this.stat.mean);
            } else {
                Double sqrt_stat_mean = Math.sqrt(this.stat.mean);
            }
            if (this.istat.mean <= Math.sqrt(this.stat.mean)) {
                message = IJ.getBundle().getString("PhotometerWarningMesure");
            }
            Photometer.PS.s2 = "\t" + t + "\t" + x + "\t" + y + "\t" + (int)this.istat.mean + "\t" + this.in.width() / 2 + "\t" + (int)this.stat.mean + "\t" + this.out.width() / 2 + "\t" + message;
            if (Photometer.PS.s1.compareTo(Photometer.PS.s2) != 0) {
                res.append(new String(phindex + Photometer.PS.s2));
                res.getTextPanel().resetSelection();
                Photometer.PS.results.put(String.valueOf(phindex), new IPhot(t, x, y, this.in, (int)this.istat.mean, (int)this.stat.mean, this));
                Photometer.PS.s1 = Photometer.PS.s2;
                ++phindex;
            }
        }
        catch (Exception exp) {
            return;
        }
    }

    public int[] getCoord() {
        int[] t = new int[]{this.x, this.y};
        return t;
    }

    public ImagePlus getIMP() {
        return this.imp;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        String t;
        int tool = Toolbar.getToolId();
        if (tool == 6 || tool == 7) {
            return;
        }
        try {
            t = ((ImageCanvas)e.getSource()).getImage().getTitle();
        }
        catch (Exception ex) {
            return;
        }
        if (this.stat == null || this.istat == null) {
            return;
        }
        try {
            String message = "";
            if (this.stat.mean < 0.0) {
                Double sqrt_stat_mean = Math.sqrt(-this.stat.mean);
            } else {
                Double sqrt_stat_mean = Math.sqrt(this.stat.mean);
            }
            if (this.istat.mean <= Math.sqrt(this.stat.mean)) {
                message = IJ.getBundle().getString("PhotometerWarningMesure");
            }
            Photometer.PS.s2 = "\t" + t + "\t" + this.x + "\t" + this.y + "\t" + (int)this.istat.mean + "\t" + this.in.width() / 2 + "\t" + (int)this.stat.mean + "\t" + this.out.width() / 2 + "\t" + message;
            if (Photometer.PS.s1.compareTo(Photometer.PS.s2) != 0) {
                res.append(new String(phindex + Photometer.PS.s2));
                res.getTextPanel().resetSelection();
                Photometer.PS.results.put(String.valueOf(phindex), new IPhot(t, this.x, this.y, this.in, (int)this.istat.mean, (int)this.stat.mean, this));
                Photometer.PS.s1 = Photometer.PS.s2;
                ++phindex;
            }
        }
        catch (Exception exp) {
            return;
        }
    }

    public void set(String s) {
        StringTokenizer st = new StringTokenizer(s, "\t");
        int index = Integer.parseInt(st.nextToken());
        IPhot resu = (IPhot)Photometer.PS.results.get(String.valueOf(index));
        WindowManager.setCurrentWindow(resu.win);
        resu.win.getImagePlus().setRoi(resu.r);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static void clear() {
        if (Photometer.PS.results == null) {
            return;
        }
        Photometer.PS.results.clear();
        phindex = 1;
        if (res != null) {
            res.getTextPanel().selectAll();
            res.getTextPanel().clearSelection();
        }
        Enumeration en = WindowManager.getImageWindows().elements();
        while (en.hasMoreElements()) {
            ((ImageWindow)en.nextElement()).getImagePlus().killRoi();
        }
        Photometer.PS.s1 = "";
    }

    public static void clear(String s) {
        StringTokenizer st1 = new StringTokenizer(s, "\n");
        while (st1.hasMoreTokens()) {
            String s1 = st1.nextToken();
            StringTokenizer st = new StringTokenizer(s1, "\t");
            try {
                int index = Integer.parseInt(st.nextToken());
                String img = st.nextToken();
                WindowManager.activateWindow(img);
                WindowManager.getCurrentWindow().getImagePlus().killRoi();
                Photometer.PS.results.remove(String.valueOf(index));
            }
            catch (Exception e) {}
        }
    }

    public void close() {
    }

    public void setOp(short op) {
        this.exec = op;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public static void resetPh() {
        res = null;
        instance = null;
    }
}

