/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.PlotWindow;
import ij.process.FloatProcessor;
import java.util.ResourceBundle;

public abstract class Spectrum {
    double[] XdataRaw;
    double[] YdataRaw;
    double[] XdataDisplay;
    double[] YdataDisplay;
    int CRPIX1;
    float CRVAL1;
    int CDELT1;
    String CTYPE1;
    String CUNIT1;
    boolean optique;
    public static final int DISPLAY_VELOCITY = 1;
    public static final int DISPLAY_FREQ = 2;
    public static final int DISPLAY_WAVELENGTH = 3;
    public static final int DISPLAY_DEFAULT = 0;
    int display = 0;
    static final double SPEED_C = 2.99792458E8;
    static final double WAVE_REF = 21.10611405413;
    static final double FREQ_REF = 1420.40575177;
    private static ResourceBundle bun = IJ.getPluginBundle();
    String freqUnit = "THz";
    String waveUnit = "nm";

    public Spectrum(double[] XdataRaw, double[] YdataRaw) {
        this.XdataRaw = XdataRaw;
        this.YdataRaw = YdataRaw;
    }

    public int getDisplay() {
        return this.display;
    }

    public void setDisplay(int display) {
        this.display = display;
    }

    public boolean isOptique() {
        return this.optique;
    }

    public void setOptique(boolean optique) {
        this.optique = optique;
    }

    public void computeDisplay() {
        int nb = this.XdataRaw.length;
        double[] Xtemp = new double[nb];
        double[] Ytemp = new double[nb];
        for (int i = 0; i < nb; ++i) {
            Xtemp[i] = (float)((i - this.CRPIX1) * this.CDELT1) + this.CRVAL1;
            Ytemp[i] = this.YdataRaw[i];
        }
    }

    public PlotWindow plot() {
        String xLabel;
        this.computeDisplay();
        switch (this.display) {
            case 1: {
                xLabel = bun.getString("VelocityRS") + " (" + bun.getString("unitsVelocityRS") + ")";
                break;
            }
            case 2: {
                xLabel = bun.getString("FrequencyRS") + " (" + this.freqUnit + ")";
                break;
            }
            case 3: {
                xLabel = bun.getString("WavelengthRS") + " (" + this.waveUnit + ")";
                break;
            }
            default: {
                xLabel = bun.getString("ChannelRS");
            }
        }
        ImagePlus impdata = new ImagePlus();
        FloatProcessor ipdata = new FloatProcessor(this.XdataDisplay.length, 150);
        impdata.setProcessor("data", ipdata);
        String yLabel = bun.getString("IntensityRS");
        PlotWindow.RadioSpectra = true;
        PlotWindow.Base_Line_subtracted = false;
        PlotWindow.Base_Line = false;
        PlotWindow.ZERO_LINE = false;
        PlotWindow pw = new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + "  " + "test-spectrum", xLabel, yLabel, this.XdataDisplay, this.YdataDisplay, impdata);
        return pw;
    }
}

