/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.plugin.FitsDecoder;
import ij.process.Spectrum;

public class SpectrumOptical
extends Spectrum {
    FitsDecoder fd;
    double Wave_ref = 589.0;

    public SpectrumOptical(double[] XdataRaw, double[] YdataRaw) {
        super(XdataRaw, YdataRaw);
        this.setOptique(true);
    }

    @Override
    public void computeDisplay() {
        int length = this.XdataRaw.length;
        this.XdataDisplay = new double[length];
        this.YdataDisplay = new double[length];
        block6: for (int i = 0; i < length; ++i) {
            float tmp_wave = (float)(this.fd.getCrval1() + this.fd.getCdelt1() * (double)i) * 0.1f;
            float tmp_freq = (float)(3.0E8 / ((double)tmp_wave * 1.0E-9));
            float tmp_freq0 = (float)(3.0E17 / this.Wave_ref);
            switch (this.display) {
                case 0: {
                    this.XdataDisplay[i] = i;
                    continue block6;
                }
                case 1: {
                    this.XdataDisplay[i] = (float)(3.0E8 * ((double)(tmp_freq0 / tmp_freq) - 1.0) * 0.001);
                    continue block6;
                }
                case 2: {
                    this.XdataDisplay[i] = (float)((double)tmp_freq * 1.0E-12);
                    continue block6;
                }
                case 3: {
                    this.XdataDisplay[i] = tmp_wave;
                    continue block6;
                }
                default: {
                    this.XdataDisplay[i] = i;
                }
            }
        }
        float bzero = 32768.0f;
        float bscale = 1.0f;
        for (int i = 0; i < length; ++i) {
            this.YdataDisplay[i] = (double)bzero + (double)bscale * this.YdataRaw[i];
        }
    }

    public void setFd(FitsDecoder fd) {
        this.fd = fd;
    }

    public double getWave_ref() {
        return this.Wave_ref;
    }

    public void setWave_ref(double Wave_ref) {
        this.Wave_ref = Wave_ref;
    }
}

