/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.plugin.FitsDecoder;
import ij.process.Spectrum;

public class SpectrumRadio
extends Spectrum {
    FitsDecoder fd = null;
    double Wave_ref = 589.0;

    public SpectrumRadio(double[] XdataRaw, double[] YdataRaw) {
        super(XdataRaw, YdataRaw);
        this.setOptique(false);
    }

    public void setFd(FitsDecoder fd) {
        this.fd = fd;
    }

    @Override
    public void computeDisplay() {
        double deltav;
        double restfreq = this.fd.getRestfreq();
        int length = this.XdataRaw.length;
        if (restfreq == 0.0) {
            restfreq = this.fd.getCrval1();
        }
        if (this.fd.getDeltav() == 0.0 & this.display == 1) {
            deltav = -3.0E8 * this.fd.getCdelt1() / restfreq;
            System.out.println(deltav);
        } else {
            deltav = this.fd.getDeltav();
        }
        block6: for (int i = 0; i < length; ++i) {
            switch (this.display) {
                case 0: {
                    this.XdataDisplay[i] = i;
                    continue block6;
                }
                case 1: {
                    this.XdataDisplay[i] = (float)(((double)(i + 1 - length / 2) * deltav + this.fd.getVelolsr()) * 0.001) * -1.0f;
                    continue block6;
                }
                case 2: {
                    this.XdataDisplay[i] = (float)((restfreq + this.fd.getCdelt1() * ((double)i - this.fd.getCrpix1())) * 1.0E-6);
                    continue block6;
                }
                case 3: {
                    this.XdataDisplay[i] = (float)(3.0E10 / (restfreq + this.fd.getCdelt1() * (this.fd.getCrpix1() - (double)i)));
                    continue block6;
                }
                default: {
                    this.XdataDisplay[i] = i;
                }
            }
        }
        this.YdataDisplay = new double[length];
        double bzero = this.fd.getBzero();
        double bscale = this.fd.getBscale();
        for (int i = 0; i < length; ++i) {
            if (this.display == 0) {
                this.YdataDisplay[i] = (float)(bscale * this.YdataRaw[i] + bzero);
                continue;
            }
            this.YdataDisplay[length - 1 - i] = (float)(bscale * this.YdataRaw[i] + bzero);
        }
    }

    private void computeDisplaySpecData() {
        int length = this.XdataRaw.length;
        double[] xtemp = this.XdataRaw;
        double[] ytemp = this.YdataRaw;
        this.XdataDisplay = new double[length];
        this.YdataDisplay = new double[length];
        block6: for (int i = 0; i < length; ++i) {
            double tmp_wave = xtemp[i] / 10.0;
            double tmp_freq = (float)(3.0E8 / ((double)((float)tmp_wave) * 1.0E-9));
            double tmp_freq0 = (float)(3.0E17 / this.Wave_ref);
            switch (this.display) {
                case 0: {
                    this.XdataDisplay[i] = xtemp[i];
                    continue block6;
                }
                case 1: {
                    this.XdataDisplay[i] = (float)(3.0E8 * (tmp_freq0 / tmp_freq - 1.0) * 0.001);
                    continue block6;
                }
                case 2: {
                    this.XdataDisplay[i] = (float)(tmp_freq * 1.0E-12);
                    continue block6;
                }
                case 3: {
                    this.XdataDisplay[i] = (float)tmp_wave;
                    continue block6;
                }
                default: {
                    this.XdataDisplay[i] = i;
                }
            }
        }
        System.arraycopy(ytemp, 0, this.YdataDisplay, 0, length);
    }
}

