/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import nom.tam.fits.Data;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.HeaderOrder;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.Cursor;
import nom.tam.util.HashedList;
import nom.tam.util.RandomAccess;

public class Header
implements FitsElement {
    private HashedList cards = new HashedList();
    private Cursor iter = this.cards.iterator(0);
    private long fileOffset = -1L;
    private int oldSize;
    private ArrayDataInput input;

    public Header() {
    }

    public Header(ArrayDataInput is) throws TruncatedFileException, IOException {
        this.read(is);
    }

    public Header(String[] newCards) {
        for (int i = 0; i < newCards.length; ++i) {
            HeaderCard card = new HeaderCard(newCards[i]);
            if (card.getValue() == null) {
                this.cards.add(card);
                continue;
            }
            this.cards.add(card.getKey(), card);
        }
    }

    public Header(Data o) throws FitsException {
        o.fillHeader(this);
    }

    public Data makeData() throws FitsException {
        return FitsFactory.dataFactory(this);
    }

    public void updateLine(String key, HeaderCard card) throws HeaderCardException {
        this.removeCard(key);
        this.iter.add(key, card);
    }

    public void updateLines(Header newHdr) throws HeaderCardException {
        Cursor j = newHdr.iterator();
        while (j.hasNext()) {
            HeaderCard nextHCard = (HeaderCard)j.next();
            if (nextHCard.getKey().startsWith("COMMENT")) {
                this.insertComment(nextHCard.getComment());
                continue;
            }
            this.updateLine(nextHCard.getKey(), nextHCard);
        }
    }

    public int getNumberOfCards() {
        return this.cards.size();
    }

    public Cursor iterator() {
        return this.cards.iterator(0);
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    int trueDataSize() {
        if (!this.isValidHeader()) {
            return 0;
        }
        int naxis = this.getIntValue("NAXIS", 0);
        int bitpix = this.getIntValue("BITPIX");
        int[] axes = new int[naxis];
        for (int axis = 1; axis <= naxis; ++axis) {
            axes[axis - 1] = this.getIntValue("NAXIS" + axis, 0);
        }
        boolean isGroup = this.getBooleanValue("GROUPS", false);
        int pcount = this.getIntValue("PCOUNT", 0);
        int gcount = this.getIntValue("GCOUNT", 1);
        int startAxis = 0;
        if (isGroup && naxis > 1 && axes[0] == 0) {
            startAxis = 1;
        }
        int size = 1;
        for (int i = startAxis; i < naxis; ++i) {
            size *= axes[i];
        }
        size += pcount;
        size *= gcount;
        return size *= Math.abs(this.getIntValue("BITPIX", 0)) / 8;
    }

    public long getDataSize() {
        return FitsUtil.addPadding(this.trueDataSize());
    }

    @Override
    public long getSize() {
        return this.headerSize();
    }

    int headerSize() {
        if (!this.isValidHeader()) {
            return 0;
        }
        return FitsUtil.addPadding(this.cards.size() * 80);
    }

    boolean isValidHeader() {
        if (this.getNumberOfCards() < 4) {
            return false;
        }
        this.iter = this.iterator();
        String key = ((HeaderCard)this.iter.next()).getKey();
        if (!key.equals("SIMPLE") && !key.equals("XTENSION")) {
            return false;
        }
        key = ((HeaderCard)this.iter.next()).getKey();
        if (!key.equals("BITPIX")) {
            return false;
        }
        key = ((HeaderCard)this.iter.next()).getKey();
        if (!key.equals("NAXIS")) {
            return false;
        }
        while (this.iter.hasNext()) {
            key = ((HeaderCard)this.iter.next()).getKey();
        }
        return key.equals("END");
    }

    public HeaderCard findCard(String key) {
        HeaderCard card = (HeaderCard)this.cards.get(key);
        if (card != null) {
            this.iter.setKey(key);
        }
        return card;
    }

    public int getIntValue(String key, int dft) {
        return (int)this.getLongValue(key, dft);
    }

    public int getIntValue(String key) {
        return (int)this.getLongValue(key);
    }

    public long getLongValue(String key) {
        return this.getLongValue(key, 0L);
    }

    public long getLongValue(String key, long dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        try {
            String v = fcard.getValue();
            if (v != null) {
                return Long.parseLong(v);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return dft;
    }

    public float getFloatValue(String key, float dft) {
        return (float)this.getDoubleValue(key, dft);
    }

    public float getFloatValue(String key) {
        return (float)this.getDoubleValue(key);
    }

    public double getDoubleValue(String key) {
        return this.getDoubleValue(key, 0.0);
    }

    public double getDoubleValue(String key, double dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        try {
            String v = fcard.getValue();
            if (v != null) {
                return new Double(v);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return dft;
    }

    public boolean getBooleanValue(String key) {
        return this.getBooleanValue(key, false);
    }

    public boolean getBooleanValue(String key, boolean dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        String val = fcard.getValue();
        if (val == null) {
            return dft;
        }
        if (val.equals("T")) {
            return true;
        }
        if (val.equals("F")) {
            return false;
        }
        return dft;
    }

    public String getStringValue(String key) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null || !fcard.isStringValue()) {
            return null;
        }
        return fcard.getValue();
    }

    public void addLine(HeaderCard fcard) {
        if (fcard != null) {
            if (fcard.isKeyValuePair()) {
                this.iter.add(fcard.getKey(), fcard);
            } else {
                this.iter.add(fcard);
            }
        }
    }

    public void addLine(String card) throws HeaderCardException {
        this.addLine(new HeaderCard(card));
    }

    public static Header readHeader(ArrayDataInput dis) throws TruncatedFileException, IOException {
        Header myHeader = new Header();
        try {
            myHeader.read(dis);
        }
        catch (EOFException e) {
            return null;
        }
        return myHeader;
    }

    @Override
    public void read(ArrayDataInput dis) throws TruncatedFileException, IOException {
        String cbuf;
        this.fileOffset = dis instanceof RandomAccess ? FitsUtil.findOffset(dis) : -1L;
        byte[] buffer = new byte[80];
        boolean firstCard = true;
        int count = 0;
        do {
            String key;
            int need;
            try {
                int len;
                for (need = 80; need > 0; need -= len) {
                    len = dis.read(buffer, 80 - need, need);
                    ++count;
                    if (len != 0) continue;
                    throw new TruncatedFileException();
                }
            }
            catch (EOFException e) {
                if (firstCard && need == 80) {
                    throw e;
                }
                throw new TruncatedFileException(e.getMessage());
            }
            cbuf = new String(buffer);
            HeaderCard fcard = new HeaderCard(cbuf);
            if (firstCard) {
                key = fcard.getKey();
                if (key == null || !key.equals("SIMPLE") && !key.equals("XTENSION")) {
                    throw new IOException("Not FITS format at " + this.fileOffset + ":" + cbuf);
                }
                firstCard = false;
            }
            if ((key = fcard.getKey()) != null && this.cards.containsKey(key)) {
                System.err.println("Warning: multiple occurrences of key:" + key);
            }
            this.addLine(fcard);
        } while (!cbuf.substring(0, 8).equals("END     "));
        if (this.fileOffset >= 0L) {
            this.oldSize = this.cards.size();
            this.input = dis;
        }
        try {
            dis.skipBytes(FitsUtil.padding(count * 80));
        }
        catch (IOException e) {
            throw new TruncatedFileException(e.getMessage());
        }
    }

    public String findKey(String key) {
        HeaderCard card = this.findCard(key);
        if (card == null) {
            return null;
        }
        return card.toString();
    }

    boolean replaceKey(String oldKey, String newKey) throws HeaderCardException {
        HeaderCard oldCard = this.findCard(oldKey);
        if (oldCard == null) {
            return false;
        }
        if (!this.cards.replaceKey(oldKey, newKey)) {
            throw new HeaderCardException("Duplicate key in replace");
        }
        oldCard.setKey(newKey);
        return true;
    }

    @Override
    public void write(ArrayDataOutput dos) throws FitsException {
        this.fileOffset = FitsUtil.findOffset(dos);
        this.cards.sort(new HeaderOrder());
        this.checkBeginning();
        this.checkEnd();
        if (this.cards.size() <= 0) {
            return;
        }
        HashedList.HashedListIterator iter = this.cards.iterator(0);
        try {
            while (iter.hasNext()) {
                HeaderCard card = (HeaderCard)iter.next();
                byte[] b = card.toString().getBytes();
                dos.write(b);
            }
            byte[] padding = new byte[FitsUtil.padding(this.getNumberOfCards() * 80)];
            for (int i = 0; i < padding.length; ++i) {
                padding[i] = 32;
            }
            dos.write(padding);
        }
        catch (IOException e) {
            throw new FitsException("IO Error writing header: " + e);
        }
        try {
            dos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void rewrite() throws FitsException, IOException {
        ArrayDataOutput dos = (ArrayDataOutput)((Object)this.input);
        if (!this.rewriteable()) {
            throw new FitsException("Invalid attempt to rewrite Header.");
        }
        FitsUtil.reposition(dos, this.fileOffset);
        this.write(dos);
        dos.flush();
    }

    @Override
    public boolean rewriteable() {
        return this.fileOffset >= 0L && this.input instanceof ArrayDataOutput && (this.cards.size() + 35) / 36 == (this.oldSize + 35) / 36;
    }

    public void addValue(String key, boolean val, String comment) throws HeaderCardException {
        this.removeCard(key);
        this.iter.add(key, new HeaderCard(key, val, comment));
    }

    public void addValue(String key, double val, String comment) throws HeaderCardException {
        this.removeCard(key);
        this.iter.add(key, new HeaderCard(key, val, comment));
    }

    public void addValue(String key, String val, String comment) throws HeaderCardException {
        this.removeCard(key);
        this.iter.add(key, new HeaderCard(key, val, comment));
    }

    public void addValue(String key, long val, String comment) throws HeaderCardException {
        this.removeCard(key);
        this.iter.add(key, new HeaderCard(key, val, comment));
    }

    public void removeCard(String key) throws HeaderCardException {
        if (this.cards.containsKey(key)) {
            this.iter.setKey(key);
            if (this.iter.hasNext()) {
                this.iter.next();
                this.iter.remove();
            }
        }
    }

    public void insertCommentStyle(String header, String value) {
        try {
            this.iter.add(new HeaderCard(header, null, value));
        }
        catch (HeaderCardException e) {
            System.err.println("Impossible Exception for comment style:" + header + ":" + value);
        }
    }

    public void insertComment(String value) throws HeaderCardException {
        this.insertCommentStyle("COMMENT", value);
    }

    public void insertHistory(String value) throws HeaderCardException {
        this.insertCommentStyle("HISTORY", value);
    }

    public void deleteKey(String key) {
        this.iter.setKey(key);
        if (this.iter.hasNext()) {
            this.iter.next();
            this.iter.remove();
        }
    }

    public final boolean containsKey(String key) {
        return this.cards.containsKey(key);
    }

    void nullImage() {
        this.iter = this.iterator();
        try {
            this.addValue("SIMPLE", true, "Null Image Header");
            this.addValue("BITPIX", 8L, (String)null);
            this.addValue("NAXIS", 0L, (String)null);
            this.addValue("EXTEND", true, "Extensions are permitted");
        }
        catch (HeaderCardException headerCardException) {
            // empty catch block
        }
    }

    public void setSimple(boolean val) {
        this.deleteKey("SIMPLE");
        this.deleteKey("XTENSION");
        if (this.findCard("NAXIS") != null) {
            int nax = this.getIntValue("NAXIS");
            this.iter = this.iterator();
            if (this.findCard("NAXIS" + nax) != null) {
                HeaderCard hc = (HeaderCard)this.iter.next();
                try {
                    this.removeCard("EXTEND");
                    this.iter.add("EXTEND", new HeaderCard("EXTEND", true, "Extensions are permitted"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.iter = this.iterator();
        try {
            this.iter.add("SIMPLE", new HeaderCard("SIMPLE", val, "Java FITS: " + new Date()));
        }
        catch (HeaderCardException e) {
            System.err.println("Impossible exception at setSimple " + e);
        }
    }

    public void setXtension(String val) {
        this.deleteKey("SIMPLE");
        this.deleteKey("XTENSION");
        this.deleteKey("EXTEND");
        this.iter = this.iterator();
        try {
            this.iter.add("XTENSION", new HeaderCard("XTENSION", val, "Java FITS: " + new Date()));
        }
        catch (HeaderCardException e) {
            System.err.println("Impossible exception at setXtension " + e);
        }
    }

    public void setBitpix(int val) {
        this.iter = this.iterator();
        this.iter.next();
        try {
            this.iter.add("BITPIX", new HeaderCard("BITPIX", val, null));
        }
        catch (HeaderCardException e) {
            System.err.println("Impossible exception at setBitpix " + e);
        }
    }

    public void setNaxes(int val) {
        this.iter.setKey("BITPIX");
        if (this.iter.hasNext()) {
            this.iter.next();
        }
        try {
            this.iter.add("NAXIS", new HeaderCard("NAXIS", val, "Dimensionality"));
        }
        catch (HeaderCardException e) {
            System.err.println("Impossible exception at setNaxes " + e);
        }
    }

    public void setNaxis(int axis, int dim) {
        if (axis <= 0) {
            return;
        }
        if (axis == 1) {
            this.iter.setKey("NAXIS");
        } else if (axis > 1) {
            this.iter.setKey("NAXIS" + (axis - 1));
        }
        if (this.iter.hasNext()) {
            this.iter.next();
        }
        try {
            this.iter.add("NAXIS" + axis, new HeaderCard("NAXIS" + axis, dim, null));
        }
        catch (HeaderCardException e) {
            System.err.println("Impossible exception at setNaxis " + e);
        }
    }

    void checkBeginning() throws FitsException {
        this.iter = this.iterator();
        if (!this.iter.hasNext()) {
            throw new FitsException("Empty Header");
        }
        HeaderCard card = (HeaderCard)this.iter.next();
        String key = card.getKey();
        if (!key.equals("SIMPLE") && !key.equals("XTENSION")) {
            throw new FitsException("No SIMPLE or XTENSION at beginning of Header");
        }
        boolean isTable = false;
        boolean isExtension = false;
        if (key.equals("XTENSION")) {
            String value = card.getValue();
            if (value == null) {
                throw new FitsException("Empty XTENSION keyword");
            }
            isExtension = true;
            if (value.equals("BINTABLE") || value.equals("A3DTABLE") || value.equals("TABLE")) {
                isTable = true;
            }
        }
        this.cardCheck("BITPIX");
        this.cardCheck("NAXIS");
        int nax = this.getIntValue("NAXIS");
        this.iter.next();
        for (int i = 1; i <= nax; ++i) {
            this.cardCheck("NAXIS" + i);
        }
        if (isExtension) {
            this.cardCheck("PCOUNT");
            this.cardCheck("GCOUNT");
            if (isTable) {
                this.cardCheck("TFIELDS");
            }
        }
    }

    private void cardCheck(String key) throws FitsException {
        if (!this.iter.hasNext()) {
            throw new FitsException("Header terminates before " + key);
        }
        HeaderCard card = (HeaderCard)this.iter.next();
        if (!card.getKey().equals(key)) {
            throw new FitsException("Key " + key + " not found where expected." + "Found " + card.getKey());
        }
    }

    void checkEnd() {
        this.iter = this.iterator();
        while (this.iter.hasNext()) {
            HeaderCard card = (HeaderCard)this.iter.next();
            if (card.isKeyValuePair() || !card.getKey().equals("END")) continue;
            this.iter.remove();
        }
        try {
            this.iter.add(new HeaderCard("END", null, null));
        }
        catch (HeaderCardException headerCardException) {
            // empty catch block
        }
    }

    public void dumpHeader(PrintStream ps) {
        this.iter = this.iterator();
        while (this.iter.hasNext()) {
            ps.println(this.iter.next());
        }
    }

    public String dumpAllHeader() {
        this.iter = this.iterator();
        String s = "";
        while (this.iter.hasNext()) {
            s = s + this.iter.next() + "\n";
        }
        return s;
    }

    public int size() {
        return this.cards.size();
    }

    public String getCard(int n) {
        if (n >= 0 && n < this.cards.size()) {
            this.iter = this.cards.iterator(n);
            HeaderCard c = (HeaderCard)this.iter.next();
            return c.toString();
        }
        return null;
    }

    public String getKey(int n) {
        String card = this.getCard(n);
        if (card == null) {
            return null;
        }
        String key = card.substring(0, 8);
        if (key.charAt(0) == ' ') {
            return "";
        }
        if (key.indexOf(32) >= 1) {
            key = key.substring(0, key.indexOf(32));
        }
        return key;
    }

    public void pointToData(Data o) throws FitsException {
        o.fillHeader(this);
    }

    Cursor positionAfterIndex(String prefix, int col) {
        String colnum = "" + col;
        this.iter.setKey(prefix + colnum);
        if (this.iter.hasNext()) {
            String key;
            while (this.iter.hasNext() && (key = ((HeaderCard)this.iter.next()).getKey().trim()) != null && key.length() > colnum.length() && key.substring(key.length() - colnum.length()).equals(colnum)) {
            }
            if (this.iter.hasNext()) {
                this.iter.prev();
            }
        }
        return this.iter;
    }

    public HeaderCard nextCard() {
        if (this.iter == null) {
            return null;
        }
        if (this.iter.hasNext()) {
            return (HeaderCard)this.iter.next();
        }
        return null;
    }
}

