/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.IOException;
import java.lang.reflect.Array;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.DataTable;
import nom.tam.util.TableException;

public class ColumnTable
implements DataTable {
    private Object[] arrays;
    private int[] sizes;
    private int nrow;
    private int chunk;
    private int rowSize;
    private char[] types;
    private Class[] bases;
    private byte[][] bytePointers;
    private short[][] shortPointers;
    private int[][] intPointers;
    private long[][] longPointers;
    private float[][] floatPointers;
    private double[][] doublePointers;
    private char[][] charPointers;
    private boolean[][] booleanPointers;

    public ColumnTable(Object[] arrays, int[] sizes) throws TableException {
        this.setup(arrays, sizes);
    }

    protected void setup(Object[] arrays, int[] sizes) throws TableException {
        this.checkArrayConsistency(arrays, sizes);
        this.getNumberOfRows();
        this.initializePointers();
    }

    @Override
    public int getNRows() {
        return this.nrow;
    }

    @Override
    public int getNCols() {
        return this.arrays.length;
    }

    @Override
    public Object getColumn(int col) {
        return this.arrays[col];
    }

    @Override
    public void setColumn(int col, Object newColumn) throws TableException {
        boolean reset = newColumn.getClass() != this.arrays[col].getClass() || Array.getLength(newColumn) != Array.getLength(this.arrays[col]);
        this.arrays[col] = newColumn;
        if (reset) {
            this.setup(this.arrays, this.sizes);
        } else {
            this.initializePointers();
        }
    }

    public void addColumn(Object newColumn, int size) throws TableException {
        String classname = newColumn.getClass().getName();
        this.nrow = this.checkColumnConsistency(newColumn, classname, this.nrow, size);
        this.rowSize += this.nrow * ArrayFuncs.getBaseLength(newColumn);
        this.getNumberOfRows();
        int ncol = this.arrays.length;
        Object[] newArrays = new Object[ncol + 1];
        int[] newSizes = new int[ncol + 1];
        Class[] newBases = new Class[ncol + 1];
        char[] newTypes = new char[ncol + 1];
        System.arraycopy(this.arrays, 0, newArrays, 0, ncol);
        System.arraycopy(this.sizes, 0, newSizes, 0, ncol);
        System.arraycopy(this.bases, 0, newBases, 0, ncol);
        System.arraycopy(this.types, 0, newTypes, 0, ncol);
        this.arrays = newArrays;
        this.sizes = newSizes;
        this.bases = newBases;
        this.types = newTypes;
        this.arrays[ncol] = newColumn;
        this.sizes[ncol] = size;
        this.bases[ncol] = ArrayFuncs.getBaseClass(newColumn);
        this.types[ncol] = classname.charAt(1);
        this.addPointer(newColumn);
    }

    public void addRow(Object[] row) throws TableException {
        if (this.arrays.length == 0) {
            for (int i = 0; i < row.length; ++i) {
                this.addColumn(row[i], Array.getLength(row[i]));
            }
        } else {
            if (row.length != this.arrays.length) {
                throw new TableException("Row length mismatch");
            }
            for (int i = 0; i < row.length; ++i) {
                if (row[i].getClass() != this.arrays[i].getClass() || Array.getLength(row[i]) != this.sizes[i]) {
                    throw new TableException("Row column mismatch at column:" + i);
                }
                Object xarray = ArrayFuncs.newInstance(this.bases[i], (this.nrow + 1) * this.sizes[i]);
                System.arraycopy(this.arrays[i], 0, xarray, 0, this.nrow * this.sizes[i]);
                System.arraycopy(row[i], 0, xarray, this.nrow * this.sizes[i], this.sizes[i]);
                this.arrays[i] = xarray;
            }
            this.initializePointers();
            ++this.nrow;
        }
    }

    @Override
    public Object getElement(int row, int col) {
        Object x = ArrayFuncs.newInstance(this.bases[col], this.sizes[col]);
        System.arraycopy(this.arrays[col], this.sizes[col] * row, x, 0, this.sizes[col]);
        return x;
    }

    @Override
    public void setElement(int row, int col, Object x) throws TableException {
        String classname = x.getClass().getName();
        if (!classname.equals("[" + this.types[col])) {
            throw new TableException("setElement: Incompatible element type");
        }
        if (Array.getLength(x) != this.sizes[col]) {
            throw new TableException("setElement: Incompatible element size");
        }
        System.arraycopy(x, 0, this.arrays[col], this.sizes[col] * row, this.sizes[col]);
    }

    @Override
    public Object getRow(int row) {
        Object[] x = new Object[this.arrays.length];
        for (int col = 0; col < this.arrays.length; ++col) {
            x[col] = this.getElement(row, col);
        }
        return x;
    }

    @Override
    public void setRow(int row, Object x) throws TableException {
        if (!(x instanceof Object[])) {
            throw new TableException("setRow: Incompatible row");
        }
        for (int col = 0; col < this.arrays.length; ++col) {
            this.setElement(row, col, ((Object[])x)[col]);
        }
    }

    protected void checkArrayConsistency(Object[] arrays, int[] sizes) throws TableException {
        if (arrays.length != sizes.length) {
            throw new TableException("readArraysAsColumns: Incompatible arrays and sizes.");
        }
        int ratio = 0;
        int rowSize = 0;
        this.types = new char[arrays.length];
        this.bases = new Class[arrays.length];
        boolean nullTable = true;
        for (int i = 0; i < arrays.length; ++i) {
            String classname = arrays[i].getClass().getName();
            ratio = this.checkColumnConsistency(arrays[i], classname, ratio, sizes[i]);
            rowSize += sizes[i] * ArrayFuncs.getBaseLength(arrays[i]);
            this.types[i] = classname.charAt(1);
            this.bases[i] = ArrayFuncs.getBaseClass(arrays[i]);
        }
        this.nrow = ratio;
        this.rowSize = rowSize;
        this.arrays = arrays;
        this.sizes = sizes;
    }

    private int checkColumnConsistency(Object data, String classname, int ratio, int size) throws TableException {
        if (classname.charAt(0) != '[' || classname.length() != 2) {
            throw new TableException("Non-primitive array for column");
        }
        int thisSize = Array.getLength(data);
        if (thisSize == 0 && size != 0 && ratio != 0 || thisSize != 0 && size == 0) {
            throw new TableException("Size mismatch in column: " + thisSize + " != " + size);
        }
        if (size != 0 && thisSize % size != 0) {
            throw new TableException("Row size does not divide array for column");
        }
        int thisRatio = 0;
        if (size > 0) {
            thisRatio = thisSize / size;
            if (ratio != 0 && thisRatio != ratio) {
                throw new TableException("Different number of rows in different columns");
            }
        }
        if (thisRatio > 0) {
            return thisRatio;
        }
        return ratio;
    }

    protected void getNumberOfRows() {
        int bufSize = 65536;
        this.chunk = this.rowSize == 0 ? 0 : (this.rowSize > bufSize ? 1 : (bufSize / this.rowSize >= this.nrow ? this.nrow : bufSize / this.rowSize + 1));
    }

    protected void initializePointers() {
        int col;
        int nbyte = 0;
        int nshort = 0;
        int nint = 0;
        int nlong = 0;
        int nfloat = 0;
        int ndouble = 0;
        int nchar = 0;
        int nboolean = 0;
        block20: for (col = 0; col < this.arrays.length; ++col) {
            switch (this.types[col]) {
                case 'B': {
                    ++nbyte;
                    continue block20;
                }
                case 'S': {
                    ++nshort;
                    continue block20;
                }
                case 'I': {
                    ++nint;
                    continue block20;
                }
                case 'J': {
                    ++nlong;
                    continue block20;
                }
                case 'F': {
                    ++nfloat;
                    continue block20;
                }
                case 'D': {
                    ++ndouble;
                    continue block20;
                }
                case 'C': {
                    ++nchar;
                    continue block20;
                }
                case 'Z': {
                    ++nboolean;
                }
            }
        }
        this.bytePointers = new byte[nbyte][];
        this.shortPointers = new short[nshort][];
        this.intPointers = new int[nint][];
        this.longPointers = new long[nlong][];
        this.floatPointers = new float[nfloat][];
        this.doublePointers = new double[ndouble][];
        this.charPointers = new char[nchar][];
        this.booleanPointers = new boolean[nboolean][];
        nbyte = 0;
        nshort = 0;
        nint = 0;
        nlong = 0;
        nfloat = 0;
        ndouble = 0;
        nchar = 0;
        nboolean = 0;
        block21: for (col = 0; col < this.arrays.length; ++col) {
            switch (this.types[col]) {
                case 'B': {
                    this.bytePointers[nbyte] = (byte[])this.arrays[col];
                    ++nbyte;
                    continue block21;
                }
                case 'S': {
                    this.shortPointers[nshort] = (short[])this.arrays[col];
                    ++nshort;
                    continue block21;
                }
                case 'I': {
                    this.intPointers[nint] = (int[])this.arrays[col];
                    ++nint;
                    continue block21;
                }
                case 'J': {
                    this.longPointers[nlong] = (long[])this.arrays[col];
                    ++nlong;
                    continue block21;
                }
                case 'F': {
                    this.floatPointers[nfloat] = (float[])this.arrays[col];
                    ++nfloat;
                    continue block21;
                }
                case 'D': {
                    this.doublePointers[ndouble] = (double[])this.arrays[col];
                    ++ndouble;
                    continue block21;
                }
                case 'C': {
                    this.charPointers[nchar] = (char[])this.arrays[col];
                    ++nchar;
                    continue block21;
                }
                case 'Z': {
                    this.booleanPointers[nboolean] = (boolean[])this.arrays[col];
                    ++nboolean;
                }
            }
        }
    }

    protected void addPointer(Object data) throws TableException {
        String classname = data.getClass().getName();
        char type = classname.charAt(1);
        switch (type) {
            case 'B': {
                byte[][] xb = new byte[this.bytePointers.length + 1][];
                System.arraycopy(this.bytePointers, 0, xb, 0, this.bytePointers.length);
                xb[this.bytePointers.length] = (byte[])data;
                this.bytePointers = xb;
                break;
            }
            case 'Z': {
                boolean[][] xb = new boolean[this.booleanPointers.length + 1][];
                System.arraycopy(this.booleanPointers, 0, xb, 0, this.booleanPointers.length);
                xb[this.booleanPointers.length] = (boolean[])data;
                this.booleanPointers = xb;
                break;
            }
            case 'S': {
                short[][] xb = new short[this.shortPointers.length + 1][];
                System.arraycopy(this.shortPointers, 0, xb, 0, this.shortPointers.length);
                xb[this.shortPointers.length] = (short[])data;
                this.shortPointers = xb;
                break;
            }
            case 'C': {
                char[][] xb = new char[this.charPointers.length + 1][];
                System.arraycopy(this.charPointers, 0, xb, 0, this.charPointers.length);
                xb[this.charPointers.length] = (char[])data;
                this.charPointers = xb;
                break;
            }
            case 'I': {
                int[][] xb = new int[this.intPointers.length + 1][];
                System.arraycopy(this.intPointers, 0, xb, 0, this.intPointers.length);
                xb[this.intPointers.length] = (int[])data;
                this.intPointers = xb;
                break;
            }
            case 'J': {
                long[][] xb = new long[this.longPointers.length + 1][];
                System.arraycopy(this.longPointers, 0, xb, 0, this.longPointers.length);
                xb[this.longPointers.length] = (long[])data;
                this.longPointers = xb;
                break;
            }
            case 'F': {
                float[][] xb = new float[this.floatPointers.length + 1][];
                System.arraycopy(this.floatPointers, 0, xb, 0, this.floatPointers.length);
                xb[this.floatPointers.length] = (float[])data;
                this.floatPointers = xb;
                break;
            }
            case 'D': {
                double[][] xb = new double[this.doublePointers.length + 1][];
                System.arraycopy(this.doublePointers, 0, xb, 0, this.doublePointers.length);
                xb[this.doublePointers.length] = (double[])data;
                this.doublePointers = xb;
                break;
            }
            default: {
                throw new TableException("Invalid type for added column:" + classname);
            }
        }
    }

    public int read(ArrayDataInput is) throws IOException {
        boolean currRow = false;
        for (int row = 0; row < this.nrow; ++row) {
            int ibyte = 0;
            int ishort = 0;
            int iint = 0;
            int ilong = 0;
            int ichar = 0;
            int ifloat = 0;
            int idouble = 0;
            int iboolean = 0;
            block11: for (int col = 0; col < this.arrays.length; ++col) {
                int arrOffset = this.sizes[col] * row;
                int size = this.sizes[col];
                switch (this.types[col]) {
                    case 'I': {
                        int[] ia = this.intPointers[iint];
                        ++iint;
                        is.read(ia, arrOffset, size);
                        continue block11;
                    }
                    case 'S': {
                        short[] s = this.shortPointers[ishort];
                        ++ishort;
                        is.read(s, arrOffset, size);
                        continue block11;
                    }
                    case 'B': {
                        byte[] b = this.bytePointers[ibyte];
                        ++ibyte;
                        is.read(b, arrOffset, size);
                        continue block11;
                    }
                    case 'F': {
                        float[] f = this.floatPointers[ifloat];
                        ++ifloat;
                        is.read(f, arrOffset, size);
                        continue block11;
                    }
                    case 'D': {
                        double[] d = this.doublePointers[idouble];
                        ++idouble;
                        is.read(d, arrOffset, size);
                        continue block11;
                    }
                    case 'C': {
                        char[] c = this.charPointers[ichar];
                        ++ichar;
                        is.read(c, arrOffset, size);
                        continue block11;
                    }
                    case 'J': {
                        long[] l = this.longPointers[ilong];
                        ++ilong;
                        is.read(l, arrOffset, size);
                        continue block11;
                    }
                    case 'Z': {
                        boolean[] bool = this.booleanPointers[iboolean];
                        ++iboolean;
                        is.read(bool, arrOffset, size);
                    }
                }
            }
        }
        return this.rowSize * this.nrow;
    }

    public int write(ArrayDataOutput os) throws IOException {
        if (this.rowSize == 0) {
            return 0;
        }
        for (int row = 0; row < this.nrow; ++row) {
            int ibyte = 0;
            int ishort = 0;
            int iint = 0;
            int ilong = 0;
            int ichar = 0;
            int ifloat = 0;
            int idouble = 0;
            int iboolean = 0;
            block11: for (int col = 0; col < this.arrays.length; ++col) {
                int arrOffset = this.sizes[col] * row;
                int size = this.sizes[col];
                switch (this.types[col]) {
                    case 'I': {
                        int[] ia = this.intPointers[iint];
                        ++iint;
                        os.write(ia, arrOffset, size);
                        continue block11;
                    }
                    case 'S': {
                        short[] s = this.shortPointers[ishort];
                        ++ishort;
                        os.write(s, arrOffset, size);
                        continue block11;
                    }
                    case 'B': {
                        byte[] b = this.bytePointers[ibyte];
                        ++ibyte;
                        os.write(b, arrOffset, size);
                        continue block11;
                    }
                    case 'F': {
                        float[] f = this.floatPointers[ifloat];
                        ++ifloat;
                        os.write(f, arrOffset, size);
                        continue block11;
                    }
                    case 'D': {
                        double[] d = this.doublePointers[idouble];
                        ++idouble;
                        os.write(d, arrOffset, size);
                        continue block11;
                    }
                    case 'C': {
                        char[] c = this.charPointers[ichar];
                        ++ichar;
                        os.write(c, arrOffset, size);
                        continue block11;
                    }
                    case 'J': {
                        long[] l = this.longPointers[ilong];
                        ++ilong;
                        os.write(l, arrOffset, size);
                        continue block11;
                    }
                    case 'Z': {
                        boolean[] bool = this.booleanPointers[iboolean];
                        ++iboolean;
                        os.write(bool, arrOffset, size);
                    }
                }
            }
        }
        return this.rowSize * this.nrow;
    }

    public Class[] getBases() {
        return this.bases;
    }

    public char[] getTypes() {
        return this.types;
    }

    public Object[] getColumns() {
        return this.arrays;
    }

    public int[] getSizes() {
        return this.sizes;
    }

    public void deleteRow(int row) throws TableException {
        this.deleteRows(row, 1);
    }

    public void deleteRows(int row, int length) throws TableException {
        if (row < 0 || length < 0 || row + length > this.nrow) {
            throw new TableException("Invalid request to delete rows start: " + row + " length:" + length + " for table with " + this.nrow + " rows.");
        }
        if (length == 0) {
            return;
        }
        for (int col = 0; col < this.arrays.length; ++col) {
            int sz = this.sizes[col];
            int newSize = sz * (this.nrow - length);
            Object newArr = ArrayFuncs.newInstance(this.bases[col], newSize);
            System.arraycopy(this.arrays[col], 0, newArr, 0, row * sz);
            System.arraycopy(this.arrays[col], (row + length) * sz, newArr, row * sz, (this.nrow - row - length) * sz);
            this.arrays[col] = newArr;
        }
        this.nrow -= length;
        this.initializePointers();
    }

    public int deleteColumns(int start, int len) throws TableException {
        int ncol = this.arrays.length;
        if (start < 0 || len < 0 || start + len > ncol) {
            throw new TableException("Invalid request to delete columns start: " + start + " length:" + len + " for table with " + ncol + " columns.");
        }
        if (len == 0) {
            return this.rowSize;
        }
        for (int i = start; i < start + len; ++i) {
            this.rowSize -= this.sizes[i] * ArrayFuncs.getBaseLength(this.arrays[i]);
        }
        int ocol = ncol;
        Object[] newArrays = new Object[ncol -= len];
        int[] newSizes = new int[ncol];
        Class[] newBases = new Class[ncol];
        char[] newTypes = new char[ncol];
        System.arraycopy(this.arrays, 0, newArrays, 0, start);
        System.arraycopy(this.sizes, 0, newSizes, 0, start);
        System.arraycopy(this.bases, 0, newBases, 0, start);
        System.arraycopy(this.types, 0, newTypes, 0, start);
        int rem = ocol - (start + len);
        System.arraycopy(this.arrays, start + len, newArrays, start, rem);
        System.arraycopy(this.sizes, start + len, newSizes, start, rem);
        System.arraycopy(this.bases, start + len, newBases, start, rem);
        System.arraycopy(this.types, start + len, newTypes, start, rem);
        this.arrays = newArrays;
        this.sizes = newSizes;
        this.bases = newBases;
        this.types = newTypes;
        this.initializePointers();
        return this.rowSize;
    }
}

