/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry;

import java.util.ArrayList;
import skyview.Component;
import skyview.geometry.Rotater;
import skyview.geometry.Scaler;
import skyview.geometry.TransformationException;
import skyview.geometry.Transformer;

public class Converter
extends Transformer
implements Component {
    private ArrayList<Transformer> components = new ArrayList();
    private Transformer[] compArr;
    private double[][] datArr;
    private double[] d2 = new double[2];
    private double[] d3 = new double[3];
    private boolean checked = false;
    private static boolean doDebug = false;

    @Override
    public String getName() {
        return "Converter";
    }

    @Override
    public String getDescription() {
        return "A compound set of transformations";
    }

    public void debug(boolean flag) {
        doDebug = flag;
    }

    @Override
    public int getInputDimension() {
        if (this.components.size() > 0) {
            return this.components.get(0).getInputDimension();
        }
        return 0;
    }

    @Override
    public int getOutputDimension() {
        if (this.components.size() > 0) {
            return this.components.get(this.components.size() - 1).getOutputDimension();
        }
        return 0;
    }

    public void add(Transformer trans) throws TransformationException {
        if (trans == null) {
            return;
        }
        if (this.components.size() > 0 && trans.getInputDimension() != this.getOutputDimension()) {
            throw new TransformationException("Incompatible adjacent components: " + this.components.get(this.components.size() - 1).getName() + " -> " + trans.getName());
        }
        if (trans instanceof Converter) {
            Converter c = (Converter)trans;
            this.components.addAll(c.components);
        } else {
            this.components.add(trans);
        }
        this.checked = false;
    }

    @Override
    public void transform(double[] in, double[] out) {
        if (!this.checked) {
            this.check();
        }
        if (this.compArr.length == 0) {
            if (in != out) {
                System.arraycopy(in, 0, out, 0, in.length);
            }
            return;
        }
        double[] from = in;
        for (int i = 0; i < this.compArr.length; ++i) {
            Transformer t = this.compArr[i];
            if (doDebug) {
                System.err.printf("Converter: %d %s: ", i, t);
                for (double x : from) {
                    System.err.print(x + " ");
                }
                System.err.print(" -> ");
            }
            double[] to = i == this.compArr.length - 1 ? out : this.datArr[i];
            t.transform(from, to);
            from = to;
            if (!doDebug) continue;
            for (double x : from) {
                System.err.print(x + " ");
            }
            System.err.println();
        }
    }

    @Override
    public void transform(double[][] in, double[][] out) {
        if (!this.checked) {
            this.check();
        }
        if (this.components.size() == 0 && in != out && in.length > 0) {
            int len = in[0].length;
            for (int i = 0; i < in.length; ++i) {
                System.arraycopy(in[i], 0, out[i], 0, len);
            }
        }
        double[][] from = in;
        double[][] d2a = null;
        double[][] d3a = null;
        for (int i = 0; i < this.components.size(); ++i) {
            double[][] to;
            Transformer t = this.components.get(i);
            if (i == this.components.size() - 1) {
                to = out;
            } else if (t.getOutputDimension() == 2) {
                if (d2a == null) {
                    d2a = new double[2][in[0].length];
                }
                to = d2a;
            } else {
                if (d3a == null) {
                    d3a = new double[3][in[0].length];
                }
                to = d3a;
            }
            t.transform(from, to);
            from = to;
        }
    }

    private void check() {
        block0: while (this.components.size() > 0) {
            if (doDebug) {
                System.err.println("Converter: deleter: " + this.components.size());
            }
            Transformer last = this.components.get(0);
            for (int i = 1; i < this.components.size(); ++i) {
                Transformer comb;
                Transformer curr;
                if (doDebug) {
                    System.err.println("Check: compLoop" + i);
                }
                if (last.isInverse(curr = this.components.get(i))) {
                    this.components.remove(i);
                    this.components.remove(i - 1);
                    if (!doDebug) continue block0;
                    System.err.println("inverse");
                    continue block0;
                }
                if (last instanceof Rotater && curr instanceof Rotater) {
                    comb = ((Rotater)last).add((Rotater)curr);
                    this.components.remove(i);
                    this.components.remove(i - 1);
                    this.components.add(i - 1, comb);
                    if (!doDebug) continue block0;
                    System.err.println("rotation");
                    continue block0;
                }
                if (last instanceof Scaler && curr instanceof Scaler) {
                    comb = ((Scaler)last).add((Scaler)curr);
                    this.components.remove(i);
                    this.components.remove(i - 1);
                    this.components.add(i - 1, comb);
                    if (!doDebug) continue block0;
                    System.err.println("scalers");
                    continue block0;
                }
                last = curr;
                if (!doDebug) continue;
                System.err.println("Check: endcomploop");
            }
        }
        this.compArr = this.components.toArray(new Transformer[0]);
        this.datArr = new double[this.compArr.length][];
        for (int i = 0; i < this.datArr.length; ++i) {
            this.datArr[i] = this.compArr[i].getOutputDimension() == 2 ? this.d2 : this.d3;
        }
        this.checked = true;
        if (doDebug) {
            System.err.println("Check: exit");
        }
    }

    @Override
    public Converter inverse() {
        Converter x = new Converter();
        for (int i = this.components.size() - 1; i >= 0; --i) {
            try {
                x.add(this.components.get(i).inverse());
                continue;
            }
            catch (TransformationException e) {
                return null;
            }
        }
        return x;
    }

    @Override
    public boolean isInverse(Transformer t) {
        this.check();
        if (t == null && this.components.size() == 0) {
            return true;
        }
        if (!(t instanceof Converter)) {
            if (this.components.size() != 1) {
                return false;
            }
            return this.components.get(0).isInverse(t);
        }
        Converter c = (Converter)t;
        c.check();
        if (c.components.size() != this.components.size()) {
            return false;
        }
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            if (this.components.get(n - i).isInverse(c.components.get(i))) continue;
            return false;
        }
        return true;
    }
}

