/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry;

import skyview.Component;
import skyview.geometry.TransformationException;

public abstract class Transformer
implements Component {
    private double[] t2 = new double[2];
    private double[] t3 = new double[3];

    protected abstract int getOutputDimension();

    protected abstract int getInputDimension();

    public double[] transform(double[] in) {
        int odim = this.getOutputDimension();
        if (odim == 0) {
            return in;
        }
        double[] out = new double[odim];
        this.transform(in, out);
        return out;
    }

    public abstract Transformer inverse() throws TransformationException;

    public abstract void transform(double[] var1, double[] var2);

    public abstract boolean isInverse(Transformer var1);

    public void transform(double[][] in, double[][] out) {
        int idim = this.getInputDimension();
        int odim = this.getOutputDimension();
        if (idim == 0 && odim == 0) {
            for (int i = 0; i < in.length; ++i) {
                System.arraycopy(in[i], 0, out[i], 0, in[i].length);
            }
            return;
        }
        double[] xin = idim == 2 ? this.t2 : this.t3;
        double[] xout = odim == 2 ? this.t2 : this.t3;
        for (int i = 0; i < in[0].length; ++i) {
            int j;
            for (j = 0; j < idim; ++j) {
                xin[j] = in[j][i];
            }
            this.transform(xin, xout);
            for (j = 0; j < odim; ++j) {
                out[j][i] = xout[j];
            }
        }
    }
}

