/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry;

public final class Util {
    private Util() {
    }

    public static double[] unit(double ra, double dec) {
        return new double[]{Math.cos(ra) * Math.cos(dec), Math.sin(ra) * Math.cos(dec), Math.sin(dec)};
    }

    public static double[] unit(double[] coord) {
        return new double[]{Math.cos(coord[0]) * Math.cos(coord[1]), Math.sin(coord[0]) * Math.cos(coord[1]), Math.sin(coord[1])};
    }

    public static void unit(double[] coord, double[] unitV) {
        unitV[0] = Math.cos(coord[0]) * Math.cos(coord[1]);
        unitV[1] = Math.sin(coord[0]) * Math.cos(coord[1]);
        unitV[2] = Math.sin(coord[1]);
    }

    public static double[] coord(double[] unit) {
        double[] coord = new double[2];
        Util.coord(unit, coord);
        return coord;
    }

    public static void coord(double[] unit, double[] coord) {
        coord[0] = Math.atan2(unit[1], unit[0]);
        if (coord[0] < 0.0) {
            coord[0] = coord[0] + Math.PI * 2;
        }
        coord[1] = Math.asin(unit[2]);
    }

    public static double sphdist(double lon1, double lat1, double lon2, double lat2) {
        double dlon = lon2 - lon1;
        double dlat = lat2 - lat1;
        double sindlat2 = Math.sin(dlat / 2.0);
        double sindlon2 = Math.sin(dlon / 2.0);
        double a = sindlat2 * sindlat2 + Math.cos(lat1) * Math.cos(lat2) * sindlon2 * sindlon2;
        if (a < 0.0) {
            a = 0.0;
        } else if (a > 1.0) {
            a = 1.0;
        }
        double dist = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return dist;
    }

    public static double sphdistDeg(double lon1, double lat1, double lon2, double lat2) {
        return Math.toDegrees(Util.sphdist(Math.toRadians(lon1), Math.toRadians(lat1), Math.toRadians(lon2), Math.toRadians(lat2)));
    }
}

