/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.distorter;

import skyview.geometry.Distorter;
import skyview.geometry.Transformer;

public class NeatDistorter
extends Distorter {
    private double x0;
    private double y0;
    private double scale;

    @Override
    public String getName() {
        return "NeatDistorter";
    }

    @Override
    public String getDescription() {
        return "Invert a radial cubic distortion (find x from y where y=x+d x^3)";
    }

    @Override
    public Distorter inverse() {
        return new NeatInvDistorter();
    }

    @Override
    public boolean isInverse(Transformer test) {
        try {
            return test.inverse().inverse() == this;
        }
        catch (Exception e) {
            throw new Error("Unexpected exception in NeatDistorter.isInverse:" + e);
        }
    }

    public NeatDistorter(double x0, double y0, double scale) {
        this.x0 = x0;
        this.y0 = y0;
        this.scale = scale;
    }

    @Override
    public void transform(double[] in, double[] out) {
        double x = in[0];
        double dx = x - this.x0;
        double y = in[1];
        double dy = y - this.y0;
        double r = Math.sqrt(dx * dx + dy * dy);
        if (r > 0.0) {
            double athird = 0.3333333333333333;
            double t = 9.0 * Math.sqrt(this.scale) * r + Math.sqrt(12.0 + 81.0 * this.scale * r * r);
            double rp = (-Math.pow(2.0 / (3.0 * t), athird) + Math.pow(t / 18.0, athird)) / Math.sqrt(this.scale);
        }
        out[0] = dx + this.x0;
        out[1] = dy + this.y0;
    }

    public class NeatInvDistorter
    extends Distorter {
        @Override
        public String getName() {
            return "NeatInvDistorter";
        }

        public String getDescrition() {
            return "Perform radial distortion y = x + d x^3";
        }

        @Override
        public boolean isInverse(Transformer test) {
            return test == NeatDistorter.this;
        }

        @Override
        public Distorter inverse() {
            return NeatDistorter.this;
        }

        @Override
        public void transform(double[] in, double[] out) {
            double dy;
            double x = in[0];
            double y = in[1];
            double dx = x - NeatDistorter.this.x0;
            double r = Math.sqrt(dx * dx + (dy = y - NeatDistorter.this.y0) * dy);
            if (r > 0.0) {
                double rp = r + NeatDistorter.this.scale * r * r * r;
                dx = dx * rp / r;
                dy = dy * rp / r;
            }
            out[0] = dx + NeatDistorter.this.x0;
            out[1] = dy + NeatDistorter.this.y0;
        }
    }
}

