/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public class ArcProjecter
extends Projecter {
    @Override
    public String getName() {
        return "ArcProjecter";
    }

    @Override
    public String getDescription() {
        return "Zenithal Equidistant (ARC) projecter";
    }

    @Override
    public Deprojecter inverse() {
        return new ArcDeprojecter();
    }

    @Override
    public boolean isInverse(Transformer t) {
        return t.getName().equals("ArcDeprojecter");
    }

    @Override
    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2])) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            double denom = sphere[0] * sphere[0] + sphere[1] * sphere[1];
            if (denom == 0.0) {
                plane[0] = 0.0;
                plane[1] = 0.0;
            } else {
                double ratio = (1.5707963267948966 - Math.asin(sphere[2])) / Math.sqrt(denom);
                plane[0] = ratio * sphere[0];
                plane[1] = ratio * sphere[1];
            }
        }
    }

    public class ArcDeprojecter
    extends Deprojecter {
        @Override
        public String getName() {
            return "ArcDeprojecter";
        }

        @Override
        public String getDescription() {
            return "Zenithal equal area (ARC) deprojecter";
        }

        @Override
        public Projecter inverse() {
            return ArcProjecter.this;
        }

        @Override
        public boolean isInverse(Transformer t) {
            return t.getName().equals("ArcProjecter");
        }

        @Override
        public final void transform(double[] plane, double[] sphere) {
            double r = Math.sqrt(plane[0] * plane[0] + plane[1] * plane[1]);
            if (Double.isNaN(plane[0])) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                sphere[2] = Math.cos(r);
                double pr_sinde = sphere[2];
                double pr_sq_cosde = 1.0 - pr_sinde * pr_sinde;
                double ratio = 0.0;
                if (r > 0.0) {
                    ratio = Math.sqrt(pr_sq_cosde) / r;
                }
                sphere[0] = ratio * plane[0];
                sphere[1] = ratio * plane[1];
            }
        }
    }
}

