/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public class ZeaProjecter
extends Projecter {
    @Override
    public String getName() {
        return "ZeaProjecter";
    }

    @Override
    public String getDescription() {
        return "Zenithal Equal Area projecter";
    }

    @Override
    public Deprojecter inverse() {
        return new ZeaDeprojecter();
    }

    @Override
    public boolean isInverse(Transformer t) {
        return t.getName().equals("ZeaDeprojecter");
    }

    @Override
    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2])) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            double denom;
            double num = 2.0 * (1.0 - sphere[2]);
            if (num < 0.0) {
                num = 0.0;
            }
            if ((denom = sphere[0] * sphere[0] + sphere[1] * sphere[1]) == 0.0) {
                plane[0] = 0.0;
                plane[1] = 0.0;
            } else {
                double ratio = Math.sqrt(num) / Math.sqrt(sphere[0] * sphere[0] + sphere[1] * sphere[1]);
                plane[0] = ratio * sphere[0];
                plane[1] = ratio * sphere[1];
            }
        }
    }

    public class ZeaDeprojecter
    extends Deprojecter {
        @Override
        public String getName() {
            return "ZeaDeprojecter";
        }

        @Override
        public String getDescription() {
            return "Zenithal equal area deprojecter";
        }

        @Override
        public Projecter inverse() {
            return ZeaProjecter.this;
        }

        @Override
        public boolean isInverse(Transformer t) {
            return t.getName().equals("ZeaProjecter");
        }

        @Override
        public final void transform(double[] plane, double[] sphere) {
            double r = Math.sqrt(plane[0] * plane[0] + plane[1] * plane[1]);
            if (r > 2.0 || Double.isNaN(plane[0])) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                sphere[2] = 1.0 - r * r / 2.0;
                double ratio = 1.0 - sphere[2] * sphere[2];
                ratio = ratio > 0.0 ? Math.sqrt(ratio) / r : 0.0;
                sphere[0] = ratio * plane[0];
                sphere[1] = ratio * plane[1];
            }
        }
    }
}

