/*
 * Decompiled with CFR 0.152.
 */
package ageco.titan;

import ageco.misc.AgecPipedInputStream;
import ageco.misc.Pause;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Date;

public class TitanToBin
extends Thread {
    public boolean dataOrTime = true;
    private boolean osiris = false;
    private boolean stopWhenEmpty = false;
    public RandomAccessFile Previous;
    public RandomAccessFile Current;
    public RandomAccessFile Next;
    public StringBuffer PreviousName;
    public StringBuffer CurrentName;
    public StringBuffer NextName;
    public boolean DirectionToRight;
    public boolean DataValides;
    public boolean NewTime;
    public short NumberOfPoints;
    public short[] ANumberOfPoints = new short[32];
    public boolean[] Trigger;
    public boolean[][] ATrigger = new boolean[32][2000];
    public boolean TimeOutReached;
    public int FrameTime;
    public short FrameMilli;
    public int FrameRxTime;
    public short FrameRxMilli;
    public int Titan2IntGpsSeconds = 0;
    public long Titan2IntGpsUSeconds = 0L;
    public int Titan2ExtGpsSeconds = 0;
    public int CorrectedTime;
    public short CorrectedMilli;
    public long CorrectedUsec;
    public boolean TimeOut;
    public byte SamplingFrequency;
    public byte[] ASamplingFrequency = new byte[32];
    public short StepMilli;
    public short[] AStepMilli = new short[32];
    public int MilliCorrection;
    public int[][] Data;
    public int[][] AData = new int[32][2000];
    public long[][] Stack;
    public long[][] AStack = new long[32][2000];
    public int Stack_size;
    public byte[][] Infos;
    public short NewInfos;
    public boolean FileChanged;
    public byte LastSynchro;
    public byte[] Buffer;
    public byte Channel;
    public boolean Desync;
    public float TpgAdc;
    public float GpsLatitude;
    public float GpsLongitude;
    public float Gpsheight;
    public boolean SynchroFailed;
    public int vMax;
    double[] sigma;
    double[] sigma2;
    double cptrSigma;
    double[] Asigma = new double[32];
    double[] Asigma2 = new double[32];
    double[] AcptrSigma = new double[32];
    boolean test = false;
    double[] noise = new double[3];
    double[] Anoise = new double[32];
    double[] LastNoise = new double[3];
    double[] ALastNoise = new double[32];
    public byte NumberOfChannels = (byte)3;
    public float FloatSamplingPeriod;
    public float FloatSamplingFrequency;
    public float[] AFloatSamplingPeriod = new float[32];
    public float[] AFloatSamplingFrequency = new float[32];
    public boolean InfosVuesUneFois;
    public long TempsMilliDebut;
    public long TempsMilliFin;
    public String latitude = "??";
    public String longitude = "??";
    public String height = "??";
    public String nbSat = "??";
    long Premier;
    long Dernier;
    long BonPremier;
    long BonDernier;
    int BufferHaut;
    int BufferBas;
    public boolean NoMoreDataInFile;
    byte[] SuperTrame;
    long TailleCurrent;
    public AgecPipedInputStream pipe_in;
    public boolean abort = false;
    public boolean freeRun = true;
    public byte[] bufferTitan;
    public int indexBufferTitan = 0;

    public TitanToBin(AgecPipedInputStream agecPipedInputStream, boolean bl) {
        this.osiris = true;
        this.constructeur(agecPipedInputStream);
        this.stopWhenEmpty = bl;
    }

    public TitanToBin(AgecPipedInputStream agecPipedInputStream, boolean bl, boolean bl2) {
        this.osiris = bl2;
        this.constructeur(agecPipedInputStream);
        this.stopWhenEmpty = bl;
    }

    public TitanToBin(AgecPipedInputStream agecPipedInputStream) {
        this.osiris = true;
        this.constructeur(agecPipedInputStream);
        this.stopWhenEmpty = this.stopWhenEmpty;
    }

    public TitanToBin(boolean bl, AgecPipedInputStream agecPipedInputStream) {
        this.osiris = bl;
        this.constructeur(agecPipedInputStream);
        this.stopWhenEmpty = this.stopWhenEmpty;
    }

    void constructeur(AgecPipedInputStream agecPipedInputStream) {
        int n;
        this.bufferTitan = this.osiris ? new byte[800000] : new byte[100000];
        this.sigma = new double[3];
        this.sigma2 = new double[3];
        this.LastNoise[0] = -1.0;
        this.LastNoise[1] = -1.0;
        this.LastNoise[2] = -1.0;
        for (n = 0; n < 32; ++n) {
            this.ALastNoise[n] = -1.0;
        }
        this.resetNoise();
        this.abort = false;
        this.pipe_in = agecPipedInputStream;
        this.SynchroFailed = true;
        this.InfosVuesUneFois = false;
        this.DirectionToRight = true;
        this.BufferHaut = 0;
        this.BufferBas = 0;
        this.DataValides = false;
        this.NewTime = false;
        this.NumberOfPoints = 0;
        for (n = 0; n < 32; ++n) {
            this.ANumberOfPoints[n] = 0;
            this.ASamplingFrequency[n] = 0;
            this.AStepMilli[n] = 0;
        }
        this.Trigger = new boolean[2100];
        for (n = 0; n < 2100; ++n) {
            this.Trigger[n] = false;
        }
        for (int i = 0; i < 32; ++i) {
            for (n = 0; n < 2000; ++n) {
                this.ATrigger[i][n] = false;
            }
        }
        this.TimeOutReached = false;
        this.FrameTime = 0;
        this.FrameMilli = 0;
        this.FrameRxTime = 0;
        this.FrameRxMilli = 0;
        this.TimeOut = false;
        this.SamplingFrequency = 0;
        this.StepMilli = 0;
        this.MilliCorrection = 0;
        if (this.osiris) {
            this.Data = new int[3][2100];
            this.Stack = new long[3][2100];
        } else {
            this.Data = new int[3][200];
            this.Stack = new long[3][200];
        }
        this.FileChanged = false;
        this.LastSynchro = (byte)-96;
        this.Infos = new byte[48][12];
        this.Infos[16][0] = 0;
        this.Channel = 0;
        this.PreviousName = new StringBuffer(100);
        this.CurrentName = new StringBuffer(100);
        this.NextName = new StringBuffer(100);
        this.Desync = true;
        this.NoMoreDataInFile = false;
        this.SuperTrame = this.osiris ? new byte[800000] : new byte[12000];
        this.TpgAdc = -1.0f;
        this.CorrectedTime = -1;
        this.CorrectedMilli = (short)-1;
        this.NewInfos = (short)-1;
        this.Premier = 0L;
        this.Dernier = 0L;
        this.BonPremier = 0L;
        this.BonDernier = 0L;
    }

    public void run() {
        this.test = true;
        while (!this.abort) {
            byte[] byArray = new byte[1000];
            if (this.freeRun) {
                this.GetData();
            } else {
                this.GetData();
                if (this.NewInfos == 1) {
                    while (!this.abort && this.NewInfos == 1) {
                        Pause.pause(100L);
                    }
                    this.indexBufferTitan = 0;
                }
            }
            try {
                TitanToBin.sleep(2L);
            }
            catch (Exception exception) {}
        }
    }

    public void ToLeft() {
        if (this.DirectionToRight) {
            this.NoMoreDataInFile = false;
            for (int i = this.BufferBas; i <= this.BufferHaut; ++i) {
                this.SuperTrame[i + 6000 - 1 - this.BufferHaut] = this.SuperTrame[i];
            }
        }
        this.DirectionToRight = false;
    }

    public void ToRight() {
        if (!this.DirectionToRight) {
            this.NoMoreDataInFile = false;
            for (int i = this.BufferBas; i <= this.BufferHaut; ++i) {
                this.SuperTrame[i - this.BufferBas] = this.SuperTrame[i];
            }
        }
        this.DirectionToRight = true;
    }

    public void SetChannel(byte by) {
        if (this.Channel != by) {
            this.resetNoise();
            this.LastNoise[0] = -1.0;
            this.LastNoise[1] = -1.0;
            this.LastNoise[2] = -1.0;
        }
        this.Channel = by;
    }

    public byte GetChannel() {
        return this.Channel;
    }

    public boolean SetCurrentFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            this.CurrentName.setLength(0);
            this.CurrentName.append(string);
            try {
                this.Current = new RandomAccessFile(string, "r");
                this.TailleCurrent = this.Current.length();
                if (this.DirectionToRight) {
                    this.Premier = 0L;
                    this.Dernier = 0L;
                    this.BonPremier = 0L;
                    this.BonDernier = 0L;
                } else {
                    this.Current.seek(this.TailleCurrent - 1L);
                    this.Premier = this.TailleCurrent - 1L;
                    this.Dernier = this.TailleCurrent - 1L;
                    this.BonPremier = this.Premier;
                    this.BonDernier = this.Dernier;
                }
                this.NoMoreDataInFile = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return file.exists();
    }

    public String GetCurrentFile() {
        return this.CurrentName.toString();
    }

    public boolean SetPreviousFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            this.PreviousName.setLength(0);
            this.PreviousName.append(string);
        }
        return file.exists();
    }

    public String GetPreviousFile() {
        return this.PreviousName.toString();
    }

    public boolean SetNextFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            this.NextName.setLength(0);
            this.NextName.append(string);
        }
        return file.exists();
    }

    public String GetNextFile() {
        return this.NextName.toString();
    }

    public boolean NoMoreData() {
        return this.NoMoreDataInFile;
    }

    public void InitStack() {
        for (int i = 0; i < this.Stack[0].length; ++i) {
            this.Stack[0][i] = 0L;
            this.Stack[1][i] = 0L;
            this.Stack[2][i] = 0L;
        }
        this.Stack_size = 0;
    }

    public boolean GetData() {
        byte[] byArray = new byte[12];
        this.SynchroFailed = false;
        this.DataValides = false;
        this.NumberOfPoints = 0;
        for (int i = 0; i < 32; ++i) {
            this.ANumberOfPoints[i] = 0;
        }
        try {
            if (this.DirectionToRight) {
                this.Premier = this.Dernier;
                this.BufferBas = 0;
                this.BufferHaut = 0;
                while (!(this.DataValides || this.NoMoreDataInFile || this.abort)) {
                    this.Dernier += 12L;
                    this.CurrentRead(12);
                    if ((this.SuperTrame[this.BufferHaut - 1] & 0xF0) != 160 && (this.SuperTrame[this.BufferHaut - 1] & 0xF0) != 80) {
                        System.out.println(">>RESYNC<<? " + this.BufferHaut + " " + this.SuperTrame[this.BufferHaut - 1]);
                        this.Resync();
                        continue;
                    }
                    if (this.SuperTrame[this.BufferHaut - 1] != -94 && this.SuperTrame[this.BufferHaut - 1] != 82 || (this.SuperTrame[this.BufferHaut - 4] & 0x10) != 0) continue;
                    this.DataValides = true;
                }
            }
            if (!this.DataValides) {
                this.Dernier = this.BonDernier;
                this.Premier = this.BonPremier;
            }
            if (this.DataValides) {
                this.BonPremier = this.Premier;
                this.BonDernier = this.Dernier;
                if (this.dataOrTime) {
                    this.Decommuter();
                    this.computeNoise();
                } else {
                    this.GetTime();
                }
            }
            return this.SynchroFailed;
        }
        catch (Exception exception) {
            return true;
        }
    }

    void Resync() {
        System.out.println("entree dans resync");
        byte[] byArray = new byte[1];
        this.SynchroFailed = true;
        if (this.DirectionToRight) {
            this.BufferHaut = 0;
            this.SuperTrame[0] = 0;
            while (!this.NoMoreDataInFile && !this.abort && (this.BufferHaut == 0 || this.SuperTrame[this.BufferHaut - 1] != -94 && this.SuperTrame[this.BufferHaut - 1] != 82 || (this.SuperTrame[this.BufferHaut - 4] & 0x10) != 0)) {
                this.CurrentRead(1);
                ++this.Dernier;
            }
            this.Premier = this.Dernier;
            this.BufferBas = 0;
            this.BufferHaut = 0;
        }
        System.out.println("sortie de resync");
    }

    byte CurrentRead(long l) {
        byte[] byArray = new byte[1];
        if (l < 0L || l >= this.TailleCurrent) {
            return 0;
        }
        try {
            this.Current.seek(l);
            this.Current.read(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray[0];
    }

    byte[] CurrentRead(int n) {
        block11: {
            byte[] byArray = new byte[n];
            try {
                try {
                    while (!this.abort && this.pipe_in.available() < n) {
                        TitanToBin.sleep(100L);
                        if (this.pipe_in.available() >= n || !this.stopWhenEmpty) continue;
                        this.abort = true;
                        this.NoMoreDataInFile = true;
                    }
                }
                catch (Exception exception) {
                    System.out.println("ex 1");
                }
                if (this.abort || this.pipe_in.available() < n) break block11;
                try {
                    this.pipe_in.read(this.SuperTrame, this.BufferHaut, n);
                }
                catch (Exception exception) {
                    System.out.println("ex 2 " + exception.getMessage() + " " + this.pipe_in + " " + this.SuperTrame + " " + this.BufferHaut + " " + n);
                }
                if (!this.freeRun) {
                    for (int i = 0; i < n; ++i) {
                        try {
                            this.bufferTitan[this.indexBufferTitan++] = this.SuperTrame[this.BufferHaut + i];
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                this.BufferHaut += n;
            }
            catch (Exception exception) {
                System.out.println("catches ttbin " + exception.getMessage() + " " + this.pipe_in + " " + this.SuperTrame + " " + this.BufferHaut + " " + this.bufferTitan + " " + this);
            }
        }
        return this.SuperTrame;
    }

    private void Decommuter() {
        int[] nArray = new int[32];
        int[] nArray2 = new int[32];
        int[] nArray3 = new int[32];
        Date date = new Date();
        byte by = 100;
        try {
            long l;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            this.NewTime = true;
            --this.BufferHaut;
            this.FrameTime = this.SuperTrame[this.BufferHaut - 11] & 0xFF;
            this.FrameTime <<= 8;
            this.FrameTime += this.SuperTrame[this.BufferHaut - 10] & 0xFF;
            this.FrameTime <<= 8;
            this.FrameTime += this.SuperTrame[this.BufferHaut - 9] & 0xFF;
            this.FrameTime <<= 8;
            this.FrameTime += this.SuperTrame[this.BufferHaut - 8] & 0xFF;
            this.FrameMilli = (short)(((this.SuperTrame[this.BufferHaut - 2] & 3) << 8) + (this.SuperTrame[this.BufferHaut - 1] & 0xFF));
            this.TimeOut = (this.SuperTrame[this.BufferHaut - 3] & 0x80) != 0;
            byte by2 = (byte)(this.SuperTrame[this.BufferHaut - 3] & 0x40);
            float f = by2 != 0 ? 20.0f : 31.25f;
            if (f == 20.0f) {
                this.FrameMilli = (short)(this.FrameMilli * 1000);
                this.FrameMilli = (short)(this.FrameMilli / 640);
            }
            this.FrameRxTime = this.SuperTrame[this.BufferHaut - 7] & 0xFF;
            this.FrameRxTime <<= 8;
            this.FrameRxTime += this.SuperTrame[this.BufferHaut - 6] & 0xFF;
            this.FrameRxTime <<= 8;
            this.FrameRxTime += this.SuperTrame[this.BufferHaut - 5] & 0xFF;
            this.FrameRxTime <<= 8;
            this.FrameRxTime += this.SuperTrame[this.BufferHaut - 4] & 0xFF;
            this.FrameRxMilli = (short)(((this.SuperTrame[this.BufferHaut - 3] & 0xF) << 8) + (this.SuperTrame[this.BufferHaut - 2] & 0xFF));
            this.FrameRxMilli = (short)(this.FrameRxMilli >> 2);
            this.FrameRxMilli = (short)(this.FrameRxMilli & 0x3FF);
            if (f == 20.0f) {
                l = this.FrameRxMilli;
                l *= 1000L;
                this.FrameRxMilli = (short)(l /= 640L);
            }
            int n7 = this.BufferBas - 1;
            while (n7 != this.BufferHaut) {
                int n8;
                byte by3;
                byte by4;
                int n9;
                int n10;
                int n11;
                if ((this.SuperTrame[n7 += 12] & 7) == 0 || (this.SuperTrame[n7] & 7) == 1) {
                    if ((this.SuperTrame[n7 - 2] & 0xF0) >> 4 <= 5) {
                        by = (byte)(((this.SuperTrame[n7 - 2] & 0xF0) >> 4) * 3);
                        this.ASamplingFrequency[by] = (byte)(this.SuperTrame[n7 - 2] & 0xF);
                        this.ASamplingFrequency[by + 1] = (byte)(this.SuperTrame[n7 - 2] & 0xF);
                        this.ASamplingFrequency[by + 2] = (byte)(this.SuperTrame[n7 - 2] & 0xF);
                        byte by5 = by;
                        this.ASamplingFrequency[by5] = (byte)(this.ASamplingFrequency[by5] << 4);
                        byte by6 = by;
                        this.ASamplingFrequency[by6] = (byte)(this.ASamplingFrequency[by6] >> 4);
                        int n12 = by + 1;
                        this.ASamplingFrequency[n12] = (byte)(this.ASamplingFrequency[n12] << 4);
                        int n13 = by + 1;
                        this.ASamplingFrequency[n13] = (byte)(this.ASamplingFrequency[n13] >> 4);
                        int n14 = by + 2;
                        this.ASamplingFrequency[n14] = (byte)(this.ASamplingFrequency[n14] << 4);
                        int n15 = by + 2;
                        this.ASamplingFrequency[n15] = (byte)(this.ASamplingFrequency[n15] >> 4);
                        this.AFloatSamplingFrequency[by] = f * (float)Math.pow(2.0, this.ASamplingFrequency[by]);
                        this.AFloatSamplingPeriod[by] = 1.0f / this.AFloatSamplingFrequency[by];
                        this.AFloatSamplingFrequency[by + 1] = f * (float)Math.pow(2.0, this.ASamplingFrequency[by + 1]);
                        this.AFloatSamplingPeriod[by + 1] = 1.0f / this.AFloatSamplingFrequency[by + 1];
                        this.AFloatSamplingFrequency[by + 2] = f * (float)Math.pow(2.0, this.ASamplingFrequency[by + 2]);
                        this.AFloatSamplingPeriod[by + 2] = 1.0f / this.AFloatSamplingFrequency[by + 2];
                        if (this.ANumberOfPoints[by + 0] == 0) {
                            this.AData[by][0] = this.SuperTrame[n7 - 11];
                            this.AData[by][0] = (this.AData[by][0] << 8) + (this.SuperTrame[n7 - 10] & 0xFF);
                            this.AData[by][0] = (this.AData[by][0] << 8) + (this.SuperTrame[n7 - 9] & 0xFF);
                            if ((this.SuperTrame[n7 - 1] & 0x10) == 0) {
                                this.NumberOfChannels = (byte)3;
                                this.AData[by + 1][0] = this.SuperTrame[n7 - 8];
                                this.AData[by + 1][0] = (this.AData[by + 1][0] << 8) + (this.SuperTrame[n7 - 7] & 0xFF);
                                this.AData[by + 1][0] = (this.AData[by + 1][0] << 8) + (this.SuperTrame[n7 - 6] & 0xFF);
                                this.AData[by + 2][0] = this.SuperTrame[n7 - 5];
                                this.AData[by + 2][0] = (this.AData[by + 2][0] << 8) + (this.SuperTrame[n7 - 4] & 0xFF);
                                this.AData[by + 2][0] = (this.AData[by + 2][0] << 8) + (this.SuperTrame[n7 - 3] & 0xFF);
                                nArray[by + 0] = this.AData[by + 0][0];
                                nArray2[by + 1] = this.AData[by + 1][0];
                                nArray3[by + 2] = this.AData[by + 2][0];
                            } else {
                                this.NumberOfChannels = 1;
                                nArray[by + 0] = this.AData[by + 0][0];
                                this.AData[by + 1][0] = 0;
                                this.AData[by + 2][0] = 0;
                            }
                            long[] lArray = this.Stack[0];
                            lArray[0] = lArray[0] + (long)this.Data[0][0];
                            long[] lArray2 = this.Stack[1];
                            lArray2[0] = lArray2[0] + (long)this.Data[1][0];
                            long[] lArray3 = this.Stack[2];
                            lArray3[0] = lArray3[0] + (long)this.Data[2][0];
                            if ((this.SuperTrame[n7] & 2) != 0) {
                                this.ATrigger[by + 0][this.ANumberOfPoints[by + 0]] = true;
                                this.ATrigger[by + 1][this.ANumberOfPoints[by + 1]] = true;
                                this.ATrigger[by + 2][this.ANumberOfPoints[by + 2]] = true;
                            } else {
                                this.ATrigger[by + 0][this.ANumberOfPoints[by + 0]] = false;
                                this.ATrigger[by + 1][this.ANumberOfPoints[by + 1]] = false;
                                this.ATrigger[by + 2][this.ANumberOfPoints[by + 2]] = false;
                            }
                            this.addAPoint(by);
                            this.addAPoint((byte)(by + 1));
                            this.addAPoint((byte)(by + 2));
                        } else {
                            if ((this.SuperTrame[n7] & 2) != 0) {
                                this.ATrigger[by + 0][this.ANumberOfPoints[by]] = true;
                                this.ATrigger[by + 1][this.ANumberOfPoints[by + 1]] = true;
                                this.ATrigger[by + 2][this.ANumberOfPoints[by + 2]] = true;
                            } else {
                                this.ATrigger[by + 0][this.ANumberOfPoints[by]] = false;
                                this.ATrigger[by + 1][this.ANumberOfPoints[by + 1]] = false;
                                this.ATrigger[by + 2][this.ANumberOfPoints[by + 2]] = false;
                            }
                            if ((this.SuperTrame[n7 - 1] & 0x10) == 0) {
                                n11 = this.SuperTrame[n7 - 11];
                                n11 = (n11 << 8) + (this.SuperTrame[n7 - 10] & 0xFF);
                                n11 = (n11 << 8) + (this.SuperTrame[n7 - 9] & 0xFF);
                                n10 = this.SuperTrame[n7 - 8];
                                n10 = (n10 << 8) + (this.SuperTrame[n7 - 7] & 0xFF);
                                n10 = (n10 << 8) + (this.SuperTrame[n7 - 6] & 0xFF);
                                n9 = this.SuperTrame[n7 - 5];
                                n9 = (n9 << 8) + (this.SuperTrame[n7 - 4] & 0xFF);
                                n9 = (n9 << 8) + (this.SuperTrame[n7 - 3] & 0xFF);
                                by4 = (byte)(this.SuperTrame[n7 - 1] & 0xF);
                                switch (by4) {
                                    case 1: {
                                        n = 0xFFFFFF;
                                        n2 = 1;
                                        n3 = 8;
                                        break;
                                    }
                                    case 2: {
                                        n = 4095;
                                        n2 = 12;
                                        n3 = 20;
                                        break;
                                    }
                                    case 3: {
                                        n = 255;
                                        n2 = 8;
                                        n3 = 24;
                                        break;
                                    }
                                    case 4: {
                                        n = 63;
                                        n2 = 6;
                                        n3 = 26;
                                        break;
                                    }
                                    case 6: {
                                        n = 15;
                                        n2 = 4;
                                        n3 = 28;
                                        break;
                                    }
                                    case 8: {
                                        n = 7;
                                        n2 = 3;
                                        n3 = 29;
                                    }
                                }
                                for (by3 = 0; by3 < by4; by3 = (byte)(by3 + 1)) {
                                    n4 = n11 & n;
                                    n11 >>= n2;
                                    n4 <<= n3;
                                    int n16 = by + 0;
                                    nArray[n16] = nArray[n16] + (n4 >>= n3);
                                    this.AData[by + 0][this.ANumberOfPoints[by + 0]] = nArray[by + 0];
                                    n5 = n10 & n;
                                    n10 >>= n2;
                                    n5 <<= n3;
                                    int n17 = by + 1;
                                    nArray2[n17] = nArray2[n17] + (n5 >>= n3);
                                    this.AData[by + 1][this.ANumberOfPoints[by + 1]] = nArray2[by + 1];
                                    n6 = n9 & n;
                                    n9 >>= n2;
                                    n6 <<= n3;
                                    int n18 = by + 2;
                                    nArray3[n18] = nArray3[n18] + (n6 >>= n3);
                                    this.AData[by + 2][this.ANumberOfPoints[by + 2]] = nArray3[by + 2];
                                    this.addAPoint(by);
                                    this.addAPoint((byte)(by + 1));
                                    this.addAPoint((byte)(by + 2));
                                }
                            } else {
                                n11 = this.SuperTrame[n7 - 11];
                                n11 = (n11 << 8) + (this.SuperTrame[n7 - 10] & 0xFF);
                                n11 = (n11 << 8) + (this.SuperTrame[n7 - 9] & 0xFF);
                                n10 = this.SuperTrame[n7 - 8];
                                n10 = (n10 << 8) + (this.SuperTrame[n7 - 7] & 0xFF);
                                n10 = (n10 << 8) + (this.SuperTrame[n7 - 6] & 0xFF);
                                n9 = this.SuperTrame[n7 - 5];
                                n9 = (n9 << 8) + (this.SuperTrame[n7 - 4] & 0xFF);
                                n9 = (n9 << 8) + (this.SuperTrame[n7 - 3] & 0xFF);
                                by4 = (byte)(this.SuperTrame[n7 - 1] & 0xF);
                                switch (by4) {
                                    case 1: {
                                        n = 0xFFFFFF;
                                        n2 = 1;
                                        n3 = 8;
                                        break;
                                    }
                                    case 2: {
                                        n = 4095;
                                        n2 = 12;
                                        n3 = 20;
                                        break;
                                    }
                                    case 3: {
                                        n = 255;
                                        n2 = 8;
                                        n3 = 24;
                                        break;
                                    }
                                    case 4: {
                                        n = 63;
                                        n2 = 6;
                                        n3 = 26;
                                        break;
                                    }
                                    case 6: {
                                        n = 15;
                                        n2 = 4;
                                        n3 = 28;
                                        break;
                                    }
                                    case 8: {
                                        n = 7;
                                        n2 = 3;
                                        n3 = 29;
                                    }
                                }
                                if (by4 == 0) {
                                    int n19 = by + 0;
                                    nArray[n19] = nArray[n19] + n11;
                                    this.AData[by + 0][this.ANumberOfPoints[by + 0]] = nArray[by + 0];
                                    this.AData[by + 1][this.ANumberOfPoints[by + 1]] = 0;
                                    this.AData[by + 2][this.ANumberOfPoints[by + 2]] = 0;
                                    this.addAPoint(by);
                                    this.addAPoint((byte)(by + 1));
                                    this.addAPoint((byte)(by + 2));
                                } else {
                                    for (by3 = 0; by3 < by4; by3 = (byte)(by3 + 1)) {
                                        n4 = n11 & n;
                                        n11 >>= n2;
                                        n4 <<= n3;
                                        int n20 = by + 0;
                                        nArray[n20] = nArray[n20] + (n4 >>= n3);
                                        this.AData[by + 0][this.ANumberOfPoints[by + 0]] = nArray[by + 0];
                                        this.AData[by + 1][this.ANumberOfPoints[by + 1]] = 0;
                                        this.AData[by + 2][this.ANumberOfPoints[by + 2]] = 0;
                                        this.addAPoint(by);
                                        this.addAPoint((byte)(by + 1));
                                        this.addAPoint((byte)(by + 2));
                                    }
                                    for (by3 = 0; by3 < by4; by3 = (byte)(by3 + 1)) {
                                        n5 = n10 & n;
                                        n10 >>= n2;
                                        n5 <<= n3;
                                        int n21 = by + 0;
                                        nArray[n21] = nArray[n21] + (n5 >>= n3);
                                        this.AData[by + 0][this.ANumberOfPoints[by + 0]] = nArray[by + 0];
                                        this.AData[by + 1][this.ANumberOfPoints[by + 1]] = 0;
                                        this.AData[by + 2][this.ANumberOfPoints[by + 2]] = 0;
                                        this.addAPoint(by);
                                        this.addAPoint((byte)(by + 1));
                                        this.addAPoint((byte)(by + 2));
                                    }
                                    for (by3 = 0; by3 < by4; by3 = (byte)(by3 + 1)) {
                                        n6 = n9 & n;
                                        n9 >>= n2;
                                        n6 <<= n3;
                                        int n22 = by + 0;
                                        nArray[n22] = nArray[n22] + (n6 >>= n3);
                                        this.AData[by + 0][this.ANumberOfPoints[by + 0]] = nArray[by + 0];
                                        this.AData[by + 1][this.ANumberOfPoints[by + 1]] = 0;
                                        this.AData[by + 2][this.ANumberOfPoints[by + 2]] = 0;
                                        this.addAPoint(by);
                                        this.addAPoint((byte)(by + 1));
                                        this.addAPoint((byte)(by + 2));
                                    }
                                }
                            }
                        }
                    }
                    if ((this.SuperTrame[n7 - 2] & 0xF0) >> 4 != this.Channel) continue;
                    this.NumberOfPoints = this.ANumberOfPoints[this.Channel * 3];
                    for (int i = 0; i < this.NumberOfPoints; ++i) {
                        this.Data[0][i] = this.AData[3 * this.Channel][i];
                        this.Data[1][i] = this.AData[3 * this.Channel + 1][i];
                        this.Data[2][i] = this.AData[3 * this.Channel + 2][i];
                        this.SamplingFrequency = this.ASamplingFrequency[3 * this.Channel];
                        this.FloatSamplingFrequency = this.AFloatSamplingFrequency[3 * this.Channel];
                        this.FloatSamplingPeriod = this.AFloatSamplingPeriod[3 * this.Channel];
                        this.Trigger[this.NumberOfPoints - 1] = this.ATrigger[3 * this.Channel + 0][this.ANumberOfPoints[3 * this.Channel] - 1];
                        this.sigma[0] = this.Asigma[3 * this.Channel + 0];
                        this.sigma2[0] = this.Asigma2[3 * this.Channel + 0];
                        this.sigma[1] = this.Asigma[3 * this.Channel + 1];
                        this.sigma2[1] = this.Asigma2[3 * this.Channel + 1];
                        this.sigma[2] = this.Asigma[3 * this.Channel + 2];
                        this.sigma2[2] = this.Asigma2[3 * this.Channel + 2];
                        this.cptrSigma = this.AcptrSigma[3 * this.Channel];
                    }
                    continue;
                }
                if ((this.SuperTrame[n7] & 7) == 3) continue;
                if ((this.SuperTrame[n7] & 7) == 4) {
                    this.NewInfos = 1;
                    this.InfosVuesUneFois = true;
                    for (int n23 = 0; n23 < 12; n23 = (int)((byte)(n23 + 1))) {
                        this.Infos[this.SuperTrame[n7 - 1]][n23] = this.SuperTrame[n7 - 11 + n23];
                    }
                    if (this.SuperTrame[n7 - 1] != 20) continue;
                    if ((this.SuperTrame[n7 - 10] & 7) == 0 || (this.SuperTrame[n7 - 10] & 7) == 3) {
                        this.TpgAdc = 29.0f;
                        continue;
                    }
                    this.TpgAdc = 1.5f;
                    continue;
                }
                if ((this.SuperTrame[n7] & 7) == 6) {
                    double d;
                    if (this.SuperTrame[n7 - 2] == 0) {
                        int n24 = this.SuperTrame[n7 - 11] & 0xFF;
                        n24 <<= 8;
                        n24 += this.SuperTrame[n7 - 10] & 0xFF;
                        n24 <<= 8;
                        n24 += this.SuperTrame[n7 - 9] & 0xFF;
                        n24 <<= 8;
                        d = n24 += this.SuperTrame[n7 - 8] & 0xFF;
                        d /= 1.5707963267948966;
                        d *= 9.0E-7;
                        String string = "";
                        if (d < 0.0) {
                            string = string + "-";
                            d = -d;
                        }
                        string = string + Integer.toString((int)d);
                        d -= (double)((int)d);
                        string = string + " " + Integer.toString((int)(d *= 60.0));
                        d -= (double)((int)d);
                        this.latitude = string = string + " " + Integer.toString((int)(d *= 60.0));
                        n8 = this.SuperTrame[n7 - 7] & 0xFF;
                        n8 <<= 8;
                        n8 += this.SuperTrame[n7 - 6] & 0xFF;
                        n8 <<= 8;
                        n8 += this.SuperTrame[n7 - 5] & 0xFF;
                        n8 <<= 8;
                        double d2 = n8 += this.SuperTrame[n7 - 4] & 0xFF;
                        d2 /= 1.5707963267948966;
                        d2 *= 9.0E-7;
                        string = "";
                        if (d2 < 0.0) {
                            string = string + "-";
                            d2 = -d2;
                        }
                        string = string + Integer.toString((int)d2);
                        d2 -= (double)((int)d2);
                        string = string + " " + Integer.toString((int)(d2 *= 60.0));
                        d2 -= (double)((int)d2);
                        this.longitude = string = string + " " + Integer.toString((int)(d2 *= 60.0));
                    }
                    if (this.SuperTrame[n7 - 2] == 1) {
                        long l2 = this.SuperTrame[n7 - 11] & 0xFF;
                        l2 <<= 8;
                        l2 += (long)(this.SuperTrame[n7 - 10] & 0xFF);
                        l2 <<= 8;
                        l2 += (long)(this.SuperTrame[n7 - 9] & 0xFF);
                        l2 <<= 8;
                        d = l2 += (long)(this.SuperTrame[n7 - 8] & 0xFF);
                        l2 = (int)d;
                        d = (double)l2 / 100.0;
                        this.height = Double.toString(d);
                    }
                    if (this.SuperTrame[n7 - 2] != 2) continue;
                    byte by7 = this.SuperTrame[n7 - 11];
                    this.nbSat = Byte.toString(by7);
                    continue;
                }
                if ((this.SuperTrame[n7] & 7) == 7) {
                    by = (byte)(this.SuperTrame[n7 - 2] & 0x1F);
                    this.ASamplingFrequency[by] = (byte)(this.SuperTrame[n7 - 1] & 0xF8);
                    byte by8 = by;
                    this.ASamplingFrequency[by8] = (byte)(this.ASamplingFrequency[by8] >> 3);
                    int n25 = (this.ASamplingFrequency[by] & 0x18) >> 3;
                    n8 = this.ASamplingFrequency[by] & 7;
                    this.AFloatSamplingFrequency[by] = 16000.0f / (float)(Math.pow(2.0, n8) * Math.pow(5.0, n25));
                    this.AFloatSamplingPeriod[by] = 1.0f / this.AFloatSamplingFrequency[by];
                    if (this.ANumberOfPoints[by] == 0) {
                        this.AData[by][0] = this.SuperTrame[n7 - 11];
                        this.AData[by][0] = (this.AData[by][0] << 8) + (this.SuperTrame[n7 - 10] & 0xFF);
                        this.AData[by][0] = (this.AData[by][0] << 8) + (this.SuperTrame[n7 - 9] & 0xFF);
                        this.NumberOfChannels = 1;
                        nArray[by] = this.AData[by][0];
                        this.ATrigger[by][this.ANumberOfPoints[by]] = (this.SuperTrame[n7 - 2] & 0x40) != 0;
                        this.addAPoint(by);
                    } else {
                        this.ATrigger[by][this.ANumberOfPoints[by]] = (this.SuperTrame[n7 - 2] & 0x40) != 0;
                        n11 = this.SuperTrame[n7 - 11];
                        n11 = (n11 << 8) + (this.SuperTrame[n7 - 10] & 0xFF);
                        n11 = (n11 << 8) + (this.SuperTrame[n7 - 9] & 0xFF);
                        n10 = this.SuperTrame[n7 - 8];
                        n10 = (n10 << 8) + (this.SuperTrame[n7 - 7] & 0xFF);
                        n10 = (n10 << 8) + (this.SuperTrame[n7 - 6] & 0xFF);
                        n9 = this.SuperTrame[n7 - 5];
                        n9 = (n9 << 8) + (this.SuperTrame[n7 - 4] & 0xFF);
                        n9 = (n9 << 8) + (this.SuperTrame[n7 - 3] & 0xFF);
                        by4 = (byte)(this.SuperTrame[n7 - 1] & 7);
                        switch (by4) {
                            case 1: {
                                n = 0xFFFFFF;
                                n2 = 1;
                                n3 = 8;
                                break;
                            }
                            case 2: {
                                n = 4095;
                                n2 = 12;
                                n3 = 20;
                                break;
                            }
                            case 3: {
                                n = 255;
                                n2 = 8;
                                n3 = 24;
                                break;
                            }
                            case 4: {
                                n = 63;
                                n2 = 6;
                                n3 = 26;
                                break;
                            }
                            case 6: {
                                n = 15;
                                n2 = 4;
                                n3 = 28;
                                break;
                            }
                            case 8: {
                                n = 7;
                                n2 = 3;
                                n3 = 29;
                            }
                        }
                        if (by4 == 0) {
                            byte by9 = by;
                            nArray[by9] = nArray[by9] + n11;
                            this.AData[by][this.ANumberOfPoints[by]] = nArray[by];
                            this.addAPoint(by);
                        } else {
                            for (by3 = 0; by3 < by4; by3 = (byte)(by3 + 1)) {
                                n4 = n11 & n;
                                n11 >>= n2;
                                n4 <<= n3;
                                byte by10 = by;
                                nArray[by10] = nArray[by10] + (n4 >>= n3);
                                this.AData[by][this.ANumberOfPoints[by]] = nArray[by];
                                this.addAPoint(by);
                            }
                            for (by3 = 0; by3 < by4; by3 = (byte)(by3 + 1)) {
                                n5 = n10 & n;
                                n10 >>= n2;
                                n5 <<= n3;
                                byte by11 = by;
                                nArray[by11] = nArray[by11] + (n5 >>= n3);
                                this.AData[by][this.ANumberOfPoints[by]] = nArray[by];
                                this.addAPoint(by);
                            }
                            for (by3 = 0; by3 < by4; by3 = (byte)(by3 + 1)) {
                                n6 = n9 & n;
                                n9 >>= n2;
                                n6 <<= n3;
                                byte by12 = by;
                                nArray[by12] = nArray[by12] + (n6 >>= n3);
                                this.AData[by][this.ANumberOfPoints[by]] = nArray[by];
                                this.addAPoint(by);
                            }
                        }
                    }
                    if ((this.SuperTrame[n7 - 2] & 0x1F) != this.Channel) continue;
                    this.NumberOfPoints = this.ANumberOfPoints[this.Channel];
                    for (n25 = 0; n25 < this.NumberOfPoints; ++n25) {
                        this.Data[0][n25] = this.AData[by][n25];
                        this.Data[1][n25] = 0;
                        this.Data[2][n25] = 0;
                        this.SamplingFrequency = this.ASamplingFrequency[by];
                        this.FloatSamplingFrequency = this.AFloatSamplingFrequency[by];
                        this.FloatSamplingPeriod = this.AFloatSamplingPeriod[by];
                        this.Trigger[this.NumberOfPoints - 1] = this.ATrigger[by][this.ANumberOfPoints[by] - 1];
                        this.sigma[0] = this.Asigma[by];
                        this.sigma2[0] = this.Asigma2[by];
                        this.sigma[1] = this.Asigma[by + 1];
                        this.sigma2[1] = this.Asigma2[by + 1];
                        this.sigma[2] = this.Asigma[by + 2];
                        this.sigma2[2] = this.Asigma2[by + 2];
                        this.cptrSigma = this.AcptrSigma[by];
                    }
                    continue;
                }
                if ((this.SuperTrame[n7] & 7) != 5) continue;
                this.Titan2IntGpsSeconds = this.SuperTrame[n7 - 11] & 0xFF;
                this.Titan2IntGpsSeconds <<= 8;
                this.Titan2IntGpsSeconds += this.SuperTrame[n7 - 10] & 0xFF;
                this.Titan2IntGpsSeconds <<= 8;
                this.Titan2IntGpsSeconds += this.SuperTrame[n7 - 9] & 0xFF;
                this.Titan2IntGpsSeconds <<= 8;
                this.Titan2IntGpsSeconds += this.SuperTrame[n7 - 8] & 0xFF;
                this.Titan2ExtGpsSeconds = this.SuperTrame[n7 - 7] & 0xFF;
                this.Titan2ExtGpsSeconds <<= 8;
                this.Titan2ExtGpsSeconds += this.SuperTrame[n7 - 6] & 0xFF;
                this.Titan2ExtGpsSeconds <<= 8;
                this.Titan2ExtGpsSeconds += this.SuperTrame[n7 - 5] & 0xFF;
                this.Titan2ExtGpsSeconds <<= 8;
                this.Titan2ExtGpsSeconds += this.SuperTrame[n7 - 4] & 0xFF;
                this.Titan2IntGpsUSeconds = this.SuperTrame[n7 - 3] & 0xFF;
                this.Titan2IntGpsUSeconds <<= 8;
                this.Titan2IntGpsUSeconds += (long)(this.SuperTrame[n7 - 2] & 0xFF);
                this.Titan2IntGpsUSeconds <<= 8;
                this.Titan2IntGpsUSeconds += (long)(this.SuperTrame[n7 - 1] & 0xFF);
                this.Titan2IntGpsUSeconds <<= 8;
                this.Titan2IntGpsUSeconds += 0L;
            }
            if (this.Titan2IntGpsSeconds != 0) {
                l = (long)this.Titan2ExtGpsSeconds << 32;
                l -= this.Titan2IntGpsUSeconds;
                long l3 = (long)this.FrameTime << 32;
                l3 += 4294967L * (long)this.FrameMilli;
                this.CorrectedTime = (int)((l3 += (l -= (long)this.Titan2IntGpsSeconds << 32)) >> 32);
                this.CorrectedMilli = (short)(1000L * (l3 & 0xFFFFL) / 4294967L);
                this.CorrectedUsec = l3 & 0xFFFFL;
                this.TempsMilliFin = 1000L * (long)this.CorrectedTime + (long)this.CorrectedMilli;
                this.TempsMilliDebut = this.TempsMilliFin - 1000L;
            } else if (this.TpgAdc != -1.0f && this.FrameRxTime != 0) {
                date.setTime(1000L * (long)this.FrameRxTime);
                if (date.getSeconds() > 30) {
                    this.MilliCorrection = 1000 * (60 - date.getSeconds()) - this.FrameRxMilli;
                } else {
                    this.MilliCorrection = 1000 * date.getSeconds() + this.FrameRxMilli;
                    this.MilliCorrection *= -1;
                }
                this.CorrectedTime = this.FrameTime;
                this.CorrectedMilli = (short)((float)(this.FrameMilli + this.MilliCorrection) - this.TpgAdc * (float)this.StepMilli);
                if (this.CorrectedMilli >= 0) {
                    while (this.CorrectedMilli >= 1000) {
                        this.CorrectedMilli = (short)(this.CorrectedMilli - 1000);
                        ++this.CorrectedTime;
                    }
                } else {
                    while (this.CorrectedMilli < 0) {
                        this.CorrectedMilli = (short)(this.CorrectedMilli + 1000);
                        --this.CorrectedTime;
                    }
                }
                this.CorrectedUsec = (long)this.CorrectedMilli * 4294967L;
                this.TempsMilliFin = 1000L * (long)this.CorrectedTime + (long)this.CorrectedMilli;
                this.TempsMilliDebut = this.TempsMilliFin - (long)((float)(1000 * this.NumberOfPoints) * this.FloatSamplingPeriod);
            } else {
                this.CorrectedTime = -1;
                this.CorrectedMilli = (short)-1;
                this.TempsMilliFin = 1000L * (long)this.FrameTime + (long)this.FrameMilli;
                this.TempsMilliDebut = this.TempsMilliFin - (long)((float)(1000 * this.NumberOfPoints) * this.FloatSamplingPeriod);
            }
            ++this.Stack_size;
        }
        catch (Exception exception) {
            System.out.println("Exception decommuter! :" + exception.getMessage() + " >" + by + "<");
            this.DataValides = false;
        }
    }

    private void GetTime() {
        Date date = new Date();
        try {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            this.NewTime = true;
            --this.BufferHaut;
            this.FrameTime = this.SuperTrame[this.BufferHaut - 11] & 0xFF;
            this.FrameTime <<= 8;
            this.FrameTime += this.SuperTrame[this.BufferHaut - 10] & 0xFF;
            this.FrameTime <<= 8;
            this.FrameTime += this.SuperTrame[this.BufferHaut - 9] & 0xFF;
            this.FrameTime <<= 8;
            this.FrameTime += this.SuperTrame[this.BufferHaut - 8] & 0xFF;
            this.FrameMilli = (short)(((this.SuperTrame[this.BufferHaut - 2] & 3) << 8) + (this.SuperTrame[this.BufferHaut - 1] & 0xFF));
        }
        catch (Exception exception) {
            System.out.println("Exception Gettime:" + exception.getMessage());
            this.DataValides = false;
        }
    }

    public String getOwner() {
        return this.GetStationName().trim();
    }

    void resetNoise() {
        for (int i = 0; i < 3; ++i) {
            this.sigma[i] = 0.0;
            this.sigma2[i] = 0.0;
        }
        this.cptrSigma = 0.0;
    }

    synchronized void resetNoise(int n) {
        this.Asigma[n] = 0.0;
        this.Asigma2[n] = 0.0;
        this.AcptrSigma[n] = 0.0;
    }

    synchronized void computeNoise() {
        for (int i = 0; i < 32; ++i) {
            if (!(this.AcptrSigma[i] > 100.0)) continue;
            double d = Math.pow(this.Asigma[i] / this.AcptrSigma[i], 2.0);
            d = this.Asigma2[i] / this.AcptrSigma[i] - d;
            d *= 12.0;
            this.Anoise[i] = (d = Math.pow(d, 0.5)) > 0.0 ? (d = Math.log(d) / Math.log(2.0)) : 0.0;
            for (int j = 0; j < 3; ++j) {
                int n = (int)(10.0 * this.Anoise[i]);
                this.Anoise[i] = (double)n / 10.0;
            }
            this.ALastNoise[i] = this.Anoise[i];
            this.LastNoise[0] = this.ALastNoise[3 * this.Channel];
            this.LastNoise[1] = this.ALastNoise[3 * this.Channel + 1];
            this.LastNoise[2] = this.ALastNoise[3 * this.Channel + 2];
            this.resetNoise(i);
        }
    }

    public double[] getNoise() {
        return this.LastNoise;
    }

    public double getNoise(int n) {
        return this.ALastNoise[n];
    }

    void addAPoint(byte by) {
        byte by2 = by;
        this.Asigma[by2] = this.Asigma[by2] + (double)this.AData[by][this.ANumberOfPoints[by]];
        byte by3 = by;
        this.Asigma2[by3] = this.Asigma2[by3] + (double)this.AData[by][this.ANumberOfPoints[by]] * (double)this.AData[by][this.ANumberOfPoints[by]];
        byte by4 = by;
        this.AcptrSigma[by4] = this.AcptrSigma[by4] + 1.0;
        byte by5 = by;
        this.ANumberOfPoints[by5] = (short)(this.ANumberOfPoints[by5] + 1);
    }

    public void showNoise() {
        System.out.println(this.getNoiseString());
    }

    public String getNoiseString() {
        String string = "";
        double[] dArray = this.getNoise();
        for (int i = 0; i < 3; ++i) {
            string = dArray[i] >= 0.0 ? string + dArray[i] + "   " : string + "?   ";
        }
        return string;
    }

    public String GetStationName() {
        if (this.InfosVuesUneFois && this.Infos[16][0] != 0) {
            char[] cArray = new char[9];
            for (int i = 0; i < 9; ++i) {
                cArray[i] = this.Infos[16][i] != 0 ? (int)this.Infos[16][i] : 32;
            }
            return new String(cArray);
        }
        return "TitanNoName";
    }
}

