/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.container;

import edu.iris.Fissures.seed.container.BlocketteFactory;
import edu.iris.Fissures.seed.container.BlocketteVector;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.SeedObject;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.exception.SeedException;
import edu.iris.Fissures.seed.exception.SeedFormatException;
import edu.iris.Fissures.seed.exception.SeedInputException;
import edu.iris.Fissures.seed.util.Utility;
import java.util.StringTokenizer;
import java.util.Vector;

public class Blockette
extends SeedObject {
    private Vector fieldValue;
    private BlocketteVector childBlockette;
    private Waveform waveformData;
    private Vector lookupMap;
    private int lookupId;
    private int blocketteType;
    private float version;
    private static final float minSEEDVersion = 2.0f;
    private static final float maxSEEDVersion = 2.4f;
    private static final float defaultSEEDVersion = 2.3f;
    private int numBytes;
    private boolean incompleteFlag;

    Blockette(byte[] byArray, boolean bl, boolean bl2, float f) throws SeedException {
        this.initialize(byArray, bl, bl2, f);
    }

    Blockette(byte[] byArray, boolean bl, boolean bl2) throws SeedException {
        this.initialize(byArray, bl, bl2);
    }

    Blockette(String string, String string2, String string3, float f) throws SeedException {
        this.initialize(string, string2, string3, f);
    }

    Blockette(String string, String string2, String string3) throws SeedException {
        this.initialize(string, string2, string3);
    }

    Blockette(String string) throws SeedException {
        this.initialize(string);
    }

    Blockette(String string, float f) throws SeedException {
        this.initialize(string, f);
    }

    public void initialize(byte[] byArray, boolean bl, boolean bl2, float f) throws SeedException {
        this.instanceInit();
        this.setVersion(f);
        this.numBytes = this.setByteStream(byArray, bl, bl2);
        if (this.numBytes == 0) {
            this.incompleteFlag = true;
        }
    }

    public void initialize(byte[] byArray, boolean bl, boolean bl2) throws SeedException {
        this.instanceInit();
        this.numBytes = this.setByteStream(byArray, bl, bl2);
        if (this.numBytes == 0) {
            this.incompleteFlag = true;
        }
    }

    public void initialize(String string, String string2, String string3, float f) throws SeedException {
        this.instanceInit();
        this.setVersion(f);
        this.setTokenString(string, string2, string3);
    }

    public void initialize(String string, String string2, String string3) throws SeedException {
        this.instanceInit();
        this.setTokenString(string, string2, string3);
    }

    public void initialize(String string) throws SeedException {
        this.instanceInit();
        this.setTokenString(string, "|", "^");
    }

    public void initialize(String string, float f) throws SeedException {
        this.instanceInit();
        this.setVersion(f);
        this.setTokenString(string, "|", "^");
    }

    public int getType() {
        return this.blocketteType;
    }

    public float getVersion() throws SeedException {
        if (this.version < 2.0f || this.version > 2.4f) {
            throw new SeedException("Blockette version invalid");
        }
        return this.version;
    }

    public boolean isIncomplete() {
        return this.incompleteFlag;
    }

    public int getNumBytes() throws SeedException {
        return this.numBytes;
    }

    public String toString(int n, int n2) {
        try {
            Object object = this.getFieldVal(n, n2);
            if (object == null) {
                return new String("");
            }
            return BlocketteFactory.formatDecimal(this.getType(), n, object);
        }
        catch (SeedException seedException) {
            return new String("Exception encountered: " + seedException);
        }
    }

    public String toString(int n) {
        return this.toString(n, 0);
    }

    public String toString(String string, String string2) {
        try {
            StringBuffer stringBuffer = new StringBuffer("");
            int n = this.getNumFields();
            int n2 = 1;
            while (n2 <= n) {
                Object object;
                int n3;
                if (n2 > 1) {
                    stringBuffer.append(string);
                }
                if ((n3 = this.getFieldRepeat(n2)) > 0) {
                    object = this.getFieldVal(n3);
                    if (object == null) {
                        throw new SeedException("Number of repeat fields is null: field num = " + n3);
                    }
                    int n4 = Integer.parseInt(object.toString());
                    int n5 = 0;
                    for (int i = 0; i < n4; ++i) {
                        Vector vector = this.getFieldGrp(n2, i);
                        n5 = vector.size();
                        for (int j = 0; j < n5; ++j) {
                            String string3;
                            if (j > 0 || i > 0) {
                                stringBuffer.append(string);
                            }
                            if ((string3 = BlocketteFactory.formatDecimal(this.getType(), n2 + j, vector.get(j))).length() == 0) {
                                string3 = new String(string2);
                            }
                            stringBuffer.append(string3);
                        }
                    }
                    if (n5 == 0) {
                        stringBuffer.append(string2);
                        ++n2;
                        continue;
                    }
                    n2 += n5;
                    continue;
                }
                object = this.toString(n2, 0);
                if (((String)object).length() == 0) {
                    object = new String(string2);
                }
                stringBuffer.append((String)object);
                ++n2;
            }
            return stringBuffer.toString();
        }
        catch (SeedException seedException) {
            return new String("Exception encountered: " + seedException);
        }
    }

    public String toString() {
        String string = "|";
        String string2 = "^";
        return this.toString(string, string2);
    }

    public String getName() throws SeedException {
        return BlocketteFactory.getName(this.getType());
    }

    public String getCategory() throws SeedException {
        return BlocketteFactory.getCategory(this.getType());
    }

    public int getNumFields() throws SeedException {
        return BlocketteFactory.getNumFields(this.getType(), this.version);
    }

    public String getFieldName(int n) throws SeedException {
        return BlocketteFactory.getFieldName(this.getType(), n);
    }

    public String getFieldType(int n) throws SeedException {
        return BlocketteFactory.getFieldType(this.getType(), n);
    }

    public String getFieldLength(int n) throws SeedException {
        return BlocketteFactory.getFieldLength(this.getType(), n);
    }

    public String getFieldMask(int n) throws SeedException {
        return BlocketteFactory.getFieldMask(this.getType(), n);
    }

    public int getFieldRepeat(int n) throws SeedException {
        return BlocketteFactory.getFieldRepeat(this.getType(), n);
    }

    public String getDefinition() throws SeedException {
        return BlocketteFactory.getBlocketteDefinition(this.getType());
    }

    public Object getFieldVal(int n, int n2) throws SeedException {
        int n3 = this.fieldValue.size() - 1;
        if (n > n3) {
            throw new SeedException("field number out of bounds (max = " + n3 + ")");
        }
        Object object = this.fieldValue.get(n);
        if (object == null) {
            return null;
        }
        int n4 = this.getFieldRepeat(n);
        if (n4 > 0) {
            Vector vector = (Vector)object;
            object = n2 >= vector.size() ? null : vector.get(n2);
        }
        return object;
    }

    public Object getFieldVal(int n) throws SeedException {
        return this.getFieldVal(n, 0);
    }

    public Vector getFieldGrp(int n, int n2) throws SeedException {
        int n3 = this.getNumFields();
        if (n > n3) {
            throw new SeedException("fieldNum is larger than the number of blockette fields (" + n3 + ")");
        }
        int n4 = this.getFieldRepeat(n);
        if (n4 == 0) {
            throw new SeedException("This field is not part of a repeat group");
        }
        Object object = this.getFieldVal(n4);
        if (object == null) {
            throw new SeedException("Number of repeat fields is null: field num = " + n4);
        }
        int n5 = Integer.parseInt(object.toString());
        if (n2 > n5 - 1) {
            throw new SeedException("fieldIndex is larger than the index of the last repeating field (" + new Integer(n5 - 1) + ")");
        }
        Vector<Object> vector = new Vector<Object>();
        int n6 = 0;
        while (n + n6 <= n3 && this.getFieldRepeat(n + n6) != 0) {
            Object object2 = this.getFieldVal(n + n6, n2);
            vector.add(object2);
            ++n6;
        }
        return vector;
    }

    public String translate(int n) throws SeedException {
        return BlocketteFactory.getTranslation(this.getType(), n, this.getFieldVal(n));
    }

    public Blockette getChildBlockette(int n) {
        if (n + 1 > this.childBlockette.size()) {
            return null;
        }
        return (Blockette)this.childBlockette.get(n);
    }

    public int numberofChildBlockettes() {
        return this.childBlockette.size();
    }

    public Waveform getWaveform() {
        return this.waveformData;
    }

    public int getDictionaryLookup(int n) {
        if (n + 1 > this.lookupMap.size()) {
            return 0;
        }
        return Integer.parseInt(this.lookupMap.get(n).toString());
    }

    public int numberofDictionaryLookups() {
        return this.lookupMap.size() - 1;
    }

    public int getLookupId() {
        return this.lookupId;
    }

    public void setVersion(float f) throws SeedException {
        if (f < 2.0f || f > 2.4f) {
            throw new SeedException("Blockette version invalid");
        }
        this.version = f;
    }

    public void setFieldVal(int n, int n2, Object object) throws SeedException {
        if (n == 1) {
            throw new SeedInputException("Cannot alter field number " + n);
        }
        String string = object.toString();
        this.setFieldString(this.getType(), n, n2, string);
        this.update();
    }

    public void setFieldVal(int n, Object object) throws SeedException {
        this.setFieldVal(n, 0, object);
    }

    public void addFieldGrp(int n, Vector vector) throws SeedException {
        int n2 = this.getFieldRepeat(n);
        if (n2 == 0) {
            throw new SeedInputException("Blockette field " + n + " not listed as a repeating field");
        }
        int n3 = this.getNumFields();
        int n4 = n2;
        int n5 = n;
        while (n4 == n2 && ++n5 <= n3) {
            n4 = this.getFieldRepeat(n5);
        }
        int n6 = n5 - n;
        if (vector.size() != n6) {
            throw new SeedInputException("invalid Vector size " + vector.size() + " (need " + n6 + ")");
        }
        int n7 = 0;
        for (int i = 0; i < n6; ++i) {
            Vector vector2 = (Vector)this.fieldValue.get(n + i);
            n7 = vector2.size();
            String string = vector.get(i).toString();
            this.setFieldString(this.getType(), n + i, n7, string);
        }
        String string = Integer.toString(n7 + 1);
        this.setFieldString(this.getType(), n2, 0, string);
        this.update();
    }

    public int addChildBlockette(Blockette blockette) {
        this.childBlockette.add(blockette);
        return this.childBlockette.size() - 1;
    }

    public void removeChildBlockette(int n) {
        this.childBlockette.remove(n);
    }

    public void replaceChildBlockette(int n, Blockette blockette) {
        this.childBlockette.set(n, blockette);
    }

    public void attachWaveform(Waveform waveform) {
        this.waveformData = waveform;
    }

    public void removeWaveform() {
        this.waveformData = null;
    }

    public int addDictionaryLookup(int n) {
        if (this.lookupMap.size() == 0) {
            this.lookupMap.add(new Integer(0));
        }
        this.lookupMap.add(new Integer(n));
        return this.lookupMap.size() - 1;
    }

    public void setLookupId(int n) {
        this.lookupId = n;
    }

    public Btime getMTime() {
        return (Btime)this.fieldValue.get(0);
    }

    public static float getDefaultVersion() {
        return 2.3f;
    }

    private int setByteStream(byte[] byArray, boolean bl, boolean bl2) throws SeedException {
        int n = 0;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        String string = "";
        String string2 = "";
        int n9 = 0;
        while (n3 <= byArray.length && (n9 <= 0 || n3 < n9)) {
            if (++n == 1) {
                string = null;
                if (bl2) {
                    if (byArray.length < 2) {
                        this.incompleteFlag = true;
                        return byArray.length;
                    }
                    byte[] byArray2 = new byte[2];
                    System.arraycopy(byArray, 0, byArray2, 0, 2);
                    n8 = Utility.uBytesToInt(byArray2[0], byArray2[1], bl);
                    string = Integer.toString(n8);
                    n3 = 2;
                } else {
                    if (byArray.length < 3) {
                        this.incompleteFlag = true;
                        return byArray.length;
                    }
                    string = new String(byArray, 0, 3);
                    n3 = 3;
                }
                n7 = Integer.parseInt(string);
                float f = BlocketteFactory.getVersion(n7);
                if (f > this.version) {
                    throw new SeedInputException("blockette type " + n7 + " is a version " + f + " blockette");
                }
                n2 = BlocketteFactory.getNumFields(n7, this.version);
                this.fieldValue.setSize(n2 + 1);
            } else {
                int n10;
                Object object;
                int n11;
                int n12;
                if (n > n2) {
                    if (n4 < 2) break;
                    --n4;
                    n = n6;
                }
                if ((n12 = BlocketteFactory.getFieldRepeat(n7, n)) > 0) {
                    if (this.fieldValue.get(n) == null) {
                        this.fieldValue.set(n, new Vector(1, 1));
                    }
                    if (n4 == 0) {
                        n5 = n4 = Integer.parseInt(this.fieldValue.get(n12).toString());
                        n6 = n;
                        if (n5 == 0) {
                            continue;
                        }
                    }
                } else if (n4 > 0) {
                    if (--n4 > 0) {
                        n = n6;
                    } else {
                        n5 = 0;
                    }
                }
                if (n3 == byArray.length) {
                    this.incompleteFlag = true;
                    break;
                }
                string2 = BlocketteFactory.getFieldType(n7, n);
                String string3 = BlocketteFactory.getFieldLength(n7, n);
                if (string2.equals("L")) {
                    Vector<Integer> vector = new Vector<Integer>();
                    n11 = BlocketteFactory.getFieldRepeat(n7, n);
                    object = (Vector)this.fieldValue.get(n11);
                    int n13 = Integer.parseInt(((Vector)object).get(n5 - n4).toString());
                    for (n10 = 0; n10 < n13; ++n10) {
                        int n14 = Integer.parseInt(string3);
                        if (n14 > byArray.length - n3) {
                            this.incompleteFlag = true;
                            break;
                        }
                        String string4 = new String(byArray, n3, n14);
                        Integer n15 = new Integer(string4);
                        vector.add(n15);
                        n3 += n14;
                    }
                    string = vector.toString();
                } else if (string2.equals("V")) {
                    String string5;
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "-");
                    String string6 = stringTokenizer.nextToken();
                    string6 = stringTokenizer.nextToken();
                    int n16 = Integer.parseInt(string6);
                    if (n16 >= byArray.length - n3) {
                        n16 = byArray.length - n3 - 1;
                    }
                    if ((n10 = (string5 = new String(byArray, n3, n16 + 1)).indexOf("~")) == -1) {
                        this.incompleteFlag = true;
                        break;
                    }
                    string = string5.substring(0, n10);
                    n3 += n10 + 1;
                } else if (string2.equals("B")) {
                    String string7 = BlocketteFactory.getFieldMask(n7, n);
                    n11 = Integer.parseInt(string3);
                    if (n11 > byArray.length - n3) {
                        this.incompleteFlag = true;
                        break;
                    }
                    object = new byte[n11];
                    System.arraycopy(byArray, n3, object, 0, n11);
                    if (string7.equals("BTIME")) {
                        Btime btime = new Btime((byte[])object, bl);
                        string = btime.getStringTime();
                    } else if (string7.equals("FLOAT")) {
                        n8 = Utility.bytesToInt((byte)object[0], (byte)object[1], (byte)object[2], (byte)object[3], bl);
                        Float f = new Float(Float.intBitsToFloat(n8));
                        string = f.toString();
                    } else if (string7.equals("UBYTE") || string7.equals("BYTE")) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (n10 = 0; n10 < ((Object)object).length; ++n10) {
                            if (n10 > 0) {
                                stringBuffer.append(" ");
                            }
                            n8 = string7.equals("UBYTE") ? Utility.uBytesToInt((byte)object[n10]) : Utility.bytesToInt((byte)object[n10]);
                            stringBuffer.append(Integer.toString(n8));
                        }
                        string = stringBuffer.toString();
                    } else if (string7.equals("WORD") || string7.equals("UWORD")) {
                        n8 = string7.equals("UWORD") ? Utility.uBytesToInt((byte)object[0], (byte)object[1], bl) : Utility.bytesToInt((byte)object[0], (byte)object[1], bl);
                        string = Integer.toString(n8);
                    } else if (string7.equals("LONG") || string7.equals("ULONG")) {
                        if (string7.equals("ULONG")) {
                            long l = Utility.uBytesToLong((byte)object[0], (byte)object[1], (byte)object[2], (byte)object[3], bl);
                            string = Long.toString(l);
                        } else {
                            n8 = Utility.bytesToInt((byte)object[0], (byte)object[1], (byte)object[2], (byte)object[3], bl);
                            string = Integer.toString(n8);
                        }
                    } else {
                        throw new SeedInputException("unrecognized field mask: " + string7);
                    }
                    n3 += n11;
                } else {
                    int n17 = Integer.parseInt(string3);
                    if (n17 > byArray.length - n3) {
                        this.incompleteFlag = true;
                        break;
                    }
                    string = new String(byArray, n3, n17);
                    if (n == 2 && !bl2 && byArray.length >= 7) {
                        n9 = Integer.parseInt(string.trim());
                    }
                    n3 += n17;
                }
            }
            this.setFieldString(n7, n, n5 - n4, string);
        }
        if ((n < n2 || n4 > 1) && n3 < n9) {
            this.incompleteFlag = true;
        }
        this.update();
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    private void setFieldString(int var1_1, int var2_2, int var3_3, String var4_4) throws SeedException {
        var5_5 = BlocketteFactory.getFieldType(var1_1, var2_2);
        var6_6 = BlocketteFactory.getFieldMask(var1_1, var2_2);
        var7_7 = BlocketteFactory.getFieldLength(var1_1, var2_2);
        var8_8 = BlocketteFactory.getFieldRepeat(var1_1, var2_2);
        var9_9 = var8_8 > 0;
        v0 = var10_10 = var4_4.length() == 0;
        if (var10_10) {
            if (var9_9 && var3_3 == 0) {
                this.fieldValue.set(var2_2, new Vector<E>(1, 1));
            } else {
                this.fieldValue.set(var2_2, null);
            }
            return;
        }
        var11_11 = var4_4.trim();
        if (var11_11.length() > 0) {
            var4_4 = var11_11;
        }
        if (var6_6.charAt(0) == '\"') {
            try {
                if (var11_11.length() != 0) ** GOTO lbl82
                var4_4 = new String("0");
            }
            catch (NumberFormatException var12_12) {
                throw new SeedFormatException("Encountered NumberFormatException for blockette " + var1_1 + ", field " + var2_2 + ", value '" + var4_4 + "'");
            }
        } else if (var6_6.charAt(0) == '[') {
            var13_14 = false;
            var14_16 = 0;
            var15_19 = false;
            var16_25 = 0;
            var17_29 = 0;
            var18_32 = false;
            var19_33 = true;
            block10: for (var20_34 = 1; var20_34 < var6_6.length(); ++var20_34) {
                v1 = var6_6.charAt(var20_34);
                var12_13 = v1;
                if (v1 == ']') break;
                var19_33 = false;
                switch (var12_13) {
                    case 85: {
                        var13_14 = true;
                        continue block10;
                    }
                    case 76: {
                        var14_16 = 1;
                        continue block10;
                    }
                    case 78: {
                        var15_19 = true;
                        continue block10;
                    }
                    case 80: {
                        var16_25 = 1;
                        continue block10;
                    }
                    case 83: {
                        var17_29 = 1;
                        continue block10;
                    }
                    case 95: {
                        var18_32 = true;
                    }
                }
            }
            for (var20_34 = 0; !var19_33 && var20_34 < var4_4.length(); ++var20_34) {
                var21_35 = var4_4.charAt(var20_34);
                if (var13_14 && Character.isUpperCase(var21_35) || var14_16 != 0 && Character.isLowerCase(var21_35) || var15_19 && Character.isDigit(var21_35) || var16_25 != 0 && this.isPunctuation(var21_35) || var17_29 != 0 && var21_35 == ' ' || var18_32 && var21_35 == '_') continue;
                var22_36 = new StringBuffer();
                var22_36.append("character '" + var21_35 + "' is not acceptable for Blockette " + var1_1 + " field " + var2_2 + "\nExpected one of:\n");
                if (var13_14) {
                    var22_36.append("\tUpperCase\n");
                }
                if (var14_16 != 0) {
                    var22_36.append("\tLowerCase\n");
                }
                if (var15_19) {
                    var22_36.append("\tDigit\n");
                }
                if (var16_25 != 0) {
                    var22_36.append("\tPunctuation\n");
                }
                if (var17_29 != 0) {
                    var22_36.append("\tSpace\n");
                }
                if (var18_32) {
                    var22_36.append("\tUnderscore\n");
                }
                throw new SeedInputException(var22_36.toString());
            }
        }
lbl82:
        // 5 sources

        var12_13 = 0;
        var13_15 = null;
        if (var9_9) {
            var13_15 = (Vector)this.fieldValue.get(var2_2);
            if (var13_15.size() < var3_3 + 1) {
                var13_15.setSize(var3_3 + 1);
            }
            var12_13 = var3_3;
        } else {
            var13_15 = this.fieldValue;
            var12_13 = var2_2;
        }
        if (var5_5.equals("L")) {
            var14_16 = Integer.parseInt(var7_7);
            if (var4_4.charAt(0) != '[') {
                throw new SeedInputException("Incorrect format for List field type...need to enclose list in square brackets ([])");
            }
            var15_20 = new StringTokenizer(var4_4, "[], ");
            var16_26 = new Vector<Integer>();
            while (var15_20.hasMoreTokens()) {
                var16_26.add(new Integer(var15_20.nextToken()));
            }
            var13_15.set(var12_13, var16_26);
        } else if (var5_5.equals("A")) {
            var14_16 = Integer.parseInt(var7_7);
            if (var14_16 < var4_4.length()) {
                var4_4 = var15_21 = var4_4.substring(0, var14_16);
            }
            var13_15.set(var12_13, var4_4);
        } else if (var5_5.equals("D")) {
            if (var6_6.indexOf(46) > 0) {
                var13_15.set(var12_13, new Double(var4_4));
            } else {
                var13_15.set(var12_13, new Integer(var4_4));
            }
        } else if (var5_5.equals("F")) {
            var13_15.set(var12_13, new Double(var4_4));
        } else if (var5_5.equals("V")) {
            var14_17 = new StringTokenizer(var7_7, "-");
            var15_22 = var14_17.nextToken();
            var15_22 = var14_17.nextToken();
            var16_25 = Integer.parseInt(var15_22);
            if (var16_25 < var4_4.length()) {
                var4_4 = var17_30 = var4_4.substring(0, var16_25);
            }
            if (var6_6.equals("TIME")) {
                var17_31 = new Btime(var4_4);
                var13_15.set(var12_13, var17_31);
            } else {
                var13_15.set(var12_13, var4_4);
            }
        } else if (var5_5.equals("B")) {
            if (var6_6.equals("BTIME")) {
                var14_18 = new Btime(var4_4);
                var13_15.set(var12_13, var14_18);
            } else if (var6_6.equals("UBYTE")) {
                var15_23 = new StringTokenizer(var4_4, " ");
                for (var14_16 = Integer.parseInt(var7_7); var14_16 > 0 && var15_23.hasMoreTokens(); --var14_16) {
                    var16_27 = var15_23.nextToken();
                    var17_29 = Integer.parseInt(var16_27);
                    if (var17_29 >= 0 && var17_29 <= 255) continue;
                    throw new SeedInputException("input value " + var16_27 + " exceeds UBYTE value boundary");
                }
                if (var14_16 > 0) {
                    throw new SeedInputException("not enough UBYTEs in String entry (need " + var7_7 + ")");
                }
                var13_15.set(var12_13, var4_4);
            } else if (var6_6.equals("BYTE")) {
                var15_24 = new StringTokenizer(var4_4, " ");
                for (var14_16 = Integer.parseInt(var7_7); var14_16 > 0 && var15_24.hasMoreTokens(); --var14_16) {
                    var16_28 = var15_24.nextToken();
                    var17_29 = Integer.parseInt(var16_28);
                    if (var17_29 >= -128 && var17_29 <= 127) continue;
                    throw new SeedInputException("input value " + var16_28 + " exceeds BYTE value boundary");
                }
                if (var14_16 > 0) {
                    throw new SeedInputException("not enough BYTEs in String entry (need " + var7_7 + ")");
                }
                var13_15.set(var12_13, var4_4);
            } else if (var6_6.equals("UWORD")) {
                var14_16 = Integer.parseInt(var4_4);
                if (var14_16 < 0 || var14_16 > 65535) {
                    throw new SeedInputException("input value " + var4_4 + " exceeds UWORD value boundary");
                }
                var13_15.set(var12_13, new Integer(var14_16));
            } else if (var6_6.equals("WORD")) {
                var14_16 = Integer.parseInt(var4_4);
                if (var14_16 < -32768 || var14_16 > 32767) {
                    throw new SeedInputException("input value " + var4_4 + " exceeds WORD value boundary");
                }
                var13_15.set(var12_13, new Integer(var14_16));
            } else if (var6_6.equals("ULONG") || var6_6.equals("LONG")) {
                var13_15.set(var12_13, new Long(var4_4));
            } else if (var6_6.equals("FLOAT")) {
                var13_15.set(var12_13, new Float(var4_4));
            }
        } else {
            throw new SeedInputException("unknown blockette " + var1_1 + " field type: " + var5_5);
        }
    }

    private void setTokenString(String string, String string2, String string3) throws SeedException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n7;
            String string4 = stringTokenizer.nextToken();
            if (++n == 1) {
                n6 = Integer.parseInt(string4);
                float f = BlocketteFactory.getVersion(n6);
                if (f > this.version) {
                    throw new SeedInputException("blockette type " + n6 + " is a version " + f + " blockette");
                }
                n2 = BlocketteFactory.getNumFields(n6, this.version);
                this.fieldValue.setSize(n2 + 1);
            } else if (n > n2) {
                if (n3 < 2) {
                    throw new SeedInputException("input string has too many fields for blockette " + n6);
                }
                --n3;
                n = n5;
            }
            if (string4.equals(string3)) {
                string4 = new String("");
            }
            if ((n7 = BlocketteFactory.getFieldRepeat(n6, n)) > 0) {
                if (this.fieldValue.get(n) == null) {
                    this.fieldValue.set(n, new Vector(1, 1));
                }
                if (n3 == 0) {
                    n4 = n3 = Integer.parseInt(this.fieldValue.get(n7).toString());
                    n5 = n;
                }
            } else if (n3 > 0) {
                if (--n3 > 0) {
                    n = n5;
                } else {
                    n4 = 0;
                }
            }
            this.setFieldString(n6, n, n4 - n3, string4);
        }
        if (n < n2 || n3 > 1) {
            this.incompleteFlag = true;
        }
        this.update();
    }

    private boolean isPunctuation(char c) {
        return c > ' ' && c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z' && c < '\u007f';
    }

    private void update() throws SeedException {
        this.blocketteType = Integer.parseInt(this.fieldValue.get(1).toString());
        this.resetMTime();
    }

    private void resetMTime() throws SeedException {
        Btime btime = new Btime();
        this.fieldValue.set(0, btime);
    }

    private void instanceInit() {
        this.fieldValue = new Vector(8, 8);
        this.childBlockette = new BlocketteVector(1, 1);
        this.waveformData = null;
        this.lookupMap = new Vector(1, 1);
        this.lookupId = 0;
        this.blocketteType = 0;
        this.version = 2.4f;
        this.numBytes = 0;
        this.incompleteFlag = false;
    }
}

