/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.container;

import edu.iris.Fissures.seed.container.Blockette;

public class SeedEncodingResolver {
    private static final String[] encodingArray = new String[]{"0", "ASCIIText", "1", "16BitInt", "2", "24BitInt", "3", "32BitInt", "4", "Float", "5", "DoubleFloat", "10", "Steim1", "11", "Steim2", "12", "GMuxed24Bit", "13", "GMuxed16Bit3Exp", "14", "GMuxed16Bit4Exp", "15", "USNSN", "16", "CDSN", "17", "Graefenberg", "18", "IPG", "19", "Steim3", "30", "SRO", "31", "HGLP", "32", "DWWSSN", "33", "RSTN", "999", "UNKNOWN"};

    public static String resolve(Blockette blockette) {
        String string;
        block25: {
            string = "UNKNOWN";
            block0 : switch (Integer.parseInt(blockette.toString(5))) {
                case 0: {
                    String string2 = blockette.toString(7, 1);
                    if (string2 == null) break;
                    if (string2.equals("W2 D0-15 C2")) {
                        string = "16BitInt";
                        break;
                    }
                    if (string2.equals("W3 D0-23 C2") || string2.equals("W3 D24 C2")) {
                        string = "24BitInt";
                        break;
                    }
                    if (!string2.equals("W4 D0-31 C2")) break;
                    string = "32BitInt";
                    break;
                }
                case 1: {
                    switch (Integer.parseInt(blockette.toString(6))) {
                        case 4: {
                            String string3 = blockette.toString(7, 1);
                            if (string3 == null) break;
                            if (string3.equals("W2 D0-11 A-2048")) {
                                String string4 = blockette.toString(7, 2);
                                if (string4 == null) break;
                                if (string4.equals("D12-14")) {
                                    string = "GMuxed16Bit3Exp";
                                    break;
                                }
                                if (!string4.equals("D12-15")) break block0;
                                string = "GMuxed16Bit4Exp";
                                break;
                            }
                            if (string3.equals("W2 D0-11 C2")) {
                                string = "SRO";
                                break;
                            }
                            if (string3.equals("W2 D0-13 A-8191")) {
                                String string5 = blockette.toString(7, 3);
                                if (string5 == null) break;
                                if (string5.equals("P0:#0,1:#2,2:#4,3:#7")) {
                                    string = "CDSN";
                                    break;
                                }
                                if (!string5.equals("P0:1,1:4,2:16,3:128")) break block0;
                                string = "RSTN";
                                break;
                            }
                            if (string3.equals("W2 D4-15 C2")) {
                                string = "GRAEF";
                                break;
                            }
                            if (string3.equals("W3,0,2,1 D0-15:1:0:-16384")) {
                                string = "KNMI";
                                break;
                            }
                            if (string3.equals("W4 D0-22 S31") || string3.equals("W4, 1, 0, 3,2, D0-22 S31,0")) {
                                string = "Float";
                                break;
                            }
                            break block25;
                        }
                        case 5: {
                            string = "Float";
                        }
                    }
                    break;
                }
                case 50: {
                    switch (Integer.parseInt(blockette.toString(6))) {
                        case 6: {
                            string = "Steim1";
                            break;
                        }
                        case 14: {
                            string = "Steim2";
                            break;
                        }
                        case 19: {
                            string = "USNSN";
                        }
                    }
                    break;
                }
                case 80: {
                    string = "ASCIIText";
                    break;
                }
                default: {
                    string = "UNKNOWN";
                }
            }
        }
        return string;
    }

    public static String translate(String string) {
        if (string.length() == 0) {
            return new String("");
        }
        if (string.charAt(0) < 'A') {
            for (int i = 0; i < encodingArray.length; i += 2) {
                if (!string.equals(encodingArray[i])) continue;
                return encodingArray[i + 1];
            }
            return "UNKNOWN";
        }
        for (int i = 1; i < encodingArray.length; i += 2) {
            if (!string.equals(encodingArray[i])) continue;
            return encodingArray[i - 1];
        }
        return "999";
    }
}

