/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.container;

import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.BlockettePlaceholder;
import edu.iris.Fissures.seed.container.BlocketteVector;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.ObjectContainer;
import edu.iris.Fissures.seed.container.SeedBlocketteRankMap;
import edu.iris.Fissures.seed.container.SeedEncodingResolver;
import edu.iris.Fissures.seed.container.SeedObject;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.exception.ContainerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class SeedObjectContainer
implements ObjectContainer {
    private HashMap volume = null;
    private HashMap dictionary = null;
    private HashMap station = null;
    private HashMap timespan = null;
    private HashMap data = null;
    private Blockette locateRegister = null;
    private Blockette addRegister = null;
    private BlocketteVector rankLattice = null;
    private Iterator currentIterator = null;
    private RandomAccessFile diskStore = null;
    private LinkedList blocketteQueue = null;
    private int filterRank = 0;
    private int queueSize = 6;
    private HashMap encodingMap = null;
    private HashMap staChanMap = null;
    private HashMap parentChildMap = null;
    private HashMap dictionaryMatchMap = null;
    private int[] lastIdMap = new int[30];

    public SeedObjectContainer() {
        this.volume = new HashMap();
        this.dictionary = new HashMap();
        this.station = new HashMap();
        this.timespan = new HashMap();
        this.data = new HashMap();
        this.encodingMap = new HashMap();
        this.rankLattice = new BlocketteVector(8, 8);
        this.blocketteQueue = new LinkedList();
        this.staChanMap = new HashMap();
        this.parentChildMap = new HashMap();
        this.dictionaryMatchMap = new HashMap();
    }

    public SeedObjectContainer(String string) throws Exception {
        this();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.close();
        this.diskStore = new RandomAccessFile(string, "rw");
    }

    public void add(Object object) throws Exception {
        int n;
        int n2;
        try {
            this.addRegister = (Blockette)object;
        }
        catch (Exception exception) {
            String string = new String("Failure to cast added object as a Blockette");
            throw new ContainerException(string);
        }
        if (this.addRegister == null) {
            throw new ContainerException("add method was passed a null value");
        }
        int n3 = SeedBlocketteRankMap.getRank(this.addRegister);
        if (this.filterRank > 0) {
            if (n3 >= this.filterRank) {
                this.addRegister = null;
                return;
            }
            this.filterRank = 0;
        }
        this.rankLattice.setSize(n3 + 1);
        this.rankLattice.set(n3, this.addRegister);
        if (n3 > 0) {
            Object object2;
            Blockette blockette = this.rankLattice.getBlockette(n3 - 1);
            if (blockette == null) {
                throw new ContainerException("added child blockette does not have a parent blockette");
            }
            blockette.addChildBlockette(this.addRegister);
            this.parentChildMap.put(new Integer(this.addRegister.getLookupId()), new Integer(blockette.getLookupId()));
            n2 = this.addRegister.getType();
            if (n2 == 52) {
                object2 = new EncodeKey();
                ((EncodeKey)object2).location = this.addRegister.toString(3);
                ((EncodeKey)object2).channel = this.addRegister.toString(4);
                Btime btime = new Btime(this.addRegister.toString(22));
                if (blockette.getType() != 50) {
                    throw new ContainerException("Blockette 52 detected without Blockette 50 as parent. It was type: " + blockette.getType());
                }
                ((EncodeKey)object2).station = blockette.toString(3);
                ((EncodeKey)object2).network = blockette.toString(16);
                this.addStaChanLookup(null, ((EncodeKey)object2).channel, blockette.getLookupId(), 3);
                this.addStaChanLookup(((EncodeKey)object2).station, ((EncodeKey)object2).channel, blockette.getLookupId(), 3);
                Blockette blockette2 = this.getDictionaryBlockette(this.addRegister, 16);
                if (blockette2 != null) {
                    String string = SeedEncodingResolver.resolve(blockette2);
                    Vector vector = null;
                    vector = this.encodingMap.containsKey(((EncodeKey)object2).toString()) ? (Vector)this.encodingMap.get(((EncodeKey)object2).toString()) : new Vector(2, 2);
                    vector.add(btime);
                    vector.add(string);
                    this.encodingMap.put(((EncodeKey)object2).toString(), vector);
                }
            }
            if (n2 == 1000) {
                if (blockette.getType() != 999) {
                    throw new ContainerException("Blockette 1000 detected without Blockette 999 as parent");
                }
                object2 = blockette.getWaveform();
                if (object2 != null) {
                    ((Waveform)object2).setEncoding(SeedEncodingResolver.translate(this.addRegister.toString(3)));
                }
            }
        } else {
            SeedObject seedObject;
            int n4 = SeedBlocketteRankMap.getHeaderCode(this.addRegister);
            Integer n5 = new Integer(this.addRegister.getLookupId());
            this.parentChildMap.put(n5, new Integer(0));
            if (this.addRegister.getType() == 50) {
                this.addStaChanLookup(this.addRegister.toString(3), null, n5, 3);
            }
            if (this.addRegister.getType() == 72) {
                this.addStaChanLookup(this.addRegister.toString(3), null, n5, 4);
                this.addStaChanLookup(null, this.addRegister.toString(5), n5, 4);
                this.addStaChanLookup(this.addRegister.toString(3), this.addRegister.toString(5), n5, 4);
            }
            if (this.addRegister.getType() == 999) {
                this.addStaChanLookup(this.addRegister.toString(4), null, n5, 5);
                this.addStaChanLookup(null, this.addRegister.toString(6), n5, 5);
                this.addStaChanLookup(this.addRegister.toString(4), this.addRegister.toString(6), n5, 5);
            }
            SeedObject seedObject2 = this.addRegister;
            if (this.diskStore != null) {
                seedObject = new BlockettePlaceholder();
                ((BlockettePlaceholder)seedObject).blkType = this.addRegister.getType();
                ((BlockettePlaceholder)seedObject).lookupId = n5;
                ((BlockettePlaceholder)seedObject).isCached = true;
                seedObject2 = seedObject;
                Object object3 = this.lookup(n5);
                if (object3 != null && object3 instanceof BlockettePlaceholder && ((BlockettePlaceholder)object3).isCached) {
                    this.cacheFind(n5, true);
                }
                this.enqueue(this.addRegister);
            }
            switch (n4) {
                case 1: {
                    this.volume.put(n5, seedObject2);
                    break;
                }
                case 2: {
                    this.dictionary.put(n5, seedObject2);
                    break;
                }
                case 3: {
                    this.station.put(n5, seedObject2);
                    break;
                }
                case 4: {
                    this.timespan.put(n5, seedObject2);
                    break;
                }
                case 5: {
                    this.data.put(n5, seedObject2);
                    break;
                }
                default: {
                    throw new ContainerException("attempted to add unknown category number: " + n4);
                }
            }
            if (this.addRegister.getType() == 999 && (seedObject = this.addRegister.getWaveform()) != null && ((Waveform)seedObject).getEncoding().equals("UNKNOWN")) {
                ((Waveform)seedObject).setEncoding(this.getMetaEncoding(this.addRegister));
            }
        }
        n2 = n = SeedBlocketteRankMap.getHeaderCode(this.addRegister);
        if (n == 2) {
            n2 = this.addRegister.getType() - 20;
        }
        if (this.lastIdMap[n2] < this.addRegister.getLookupId()) {
            this.lastIdMap[n2] = this.addRegister.getLookupId();
        }
        if (SeedBlocketteRankMap.getHeaderCode(this.addRegister) == 2) {
            this.dictionaryMatchMap.put(this.addRegister.toString(), new Integer(this.addRegister.getLookupId()));
        }
        this.addRegister = null;
    }

    public Blockette getDictionaryBlockette(Blockette blockette, int n) throws Exception {
        return this.getDictionaryBlockette(blockette, n, 0);
    }

    public Blockette getDictionaryBlockette(Blockette blockette, int n, int n2) throws Exception {
        int n3;
        int n4;
        String string = blockette.toString(n, n2);
        if (string.length() == 0) {
            string = "0";
        }
        if ((n4 = blockette.getDictionaryLookup(n3 = Integer.parseInt(string))) > 0) {
            return (Blockette)this.get(n4);
        }
        return null;
    }

    public Object get(int n) throws ContainerException {
        if (this.locate(n)) {
            return this.locateRegister;
        }
        return null;
    }

    public Object remove(int n) throws ContainerException {
        Object object = this.improvedGet(n);
        if (object != null) {
            Integer n2 = new Integer(n);
            this.volume.remove(n2);
            this.dictionary.remove(n2);
            this.station.remove(n2);
            this.timespan.remove(n2);
            this.data.remove(n2);
            this.parentChildMap.remove(n2);
            Object v = this.dictionaryMatchMap.get(object.toString());
            if (v != null && ((Integer)v).equals(n2)) {
                this.dictionaryMatchMap.remove(object.toString());
            }
            if (this.isUsingSerialization()) {
                this.cacheFind(n, true);
            }
        }
        return object;
    }

    public boolean locate(int n) throws ContainerException {
        if (this.locateRegister != null && this.locateRegister.getLookupId() == n) {
            return true;
        }
        Object object = this.lookup(n);
        if (object != null && object instanceof BlockettePlaceholder) {
            BlockettePlaceholder blockettePlaceholder = (BlockettePlaceholder)object;
            if (blockettePlaceholder.isCached) {
                Blockette blockette = this.cacheFind(n);
                if (blockette == null) {
                    throw new ContainerException("unable to locate blockette " + n + " in cache queue");
                }
                this.locateRegister = blockette;
            } else {
                if (this.diskStore == null) {
                    throw new ContainerException("unable to access disk store for blockette proxy");
                }
                try {
                    this.diskStore.seek(blockettePlaceholder.offset);
                    byte[] byArray = new byte[blockettePlaceholder.length];
                    this.diskStore.readFully(byArray);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    this.locateRegister = (Blockette)objectInputStream.readObject();
                    byteArrayInputStream.close();
                    objectInputStream.close();
                }
                catch (Exception exception) {
                    throw new ContainerException("disk storage exception encountered: " + exception);
                }
                blockettePlaceholder.isCached = true;
                if (this.locateRegister.getLookupId() != n) {
                    throw new ContainerException("lookupId mismatch between proxy " + n + " and disk store " + this.locateRegister.getLookupId());
                }
                this.enqueue(this.locateRegister);
            }
        } else {
            this.locateRegister = (Blockette)object;
        }
        return this.locateRegister != null;
    }

    public int iterate(int n, int n2) {
        int n3;
        int n4;
        HashMap hashMap = null;
        Vector vector = new Vector(8, 8);
        if (n2 == -1) {
            n4 = 1;
            n3 = 5;
        } else {
            n4 = n2;
            n3 = n2;
        }
        for (int i = n4; i <= n3; ++i) {
            switch (i) {
                case 1: {
                    hashMap = this.volume;
                    break;
                }
                case 2: {
                    hashMap = this.dictionary;
                    break;
                }
                case 3: {
                    hashMap = this.station;
                    break;
                }
                case 4: {
                    hashMap = this.timespan;
                    break;
                }
                case 5: {
                    hashMap = this.data;
                    break;
                }
                default: {
                    this.currentIterator = null;
                    return 0;
                }
            }
            Set set = hashMap.entrySet();
            for (Map.Entry entry : set) {
                Integer n5 = (Integer)entry.getKey();
                boolean bl = false;
                if (n == -1) {
                    bl = i == n5 / 1000000 % 10;
                } else {
                    boolean bl2 = bl = n * 10 + n4 == n5 / 1000000;
                }
                if (!bl) continue;
                Object v = entry.getValue();
                vector.add(v);
            }
        }
        Collections.sort(vector);
        this.currentIterator = vector.iterator();
        return vector.size();
    }

    public int iterate(int n) {
        return this.iterate(-1, n);
    }

    public int iterate() {
        return this.iterate(-1, -1);
    }

    public int iterate(Vector vector, Vector vector2, int n) throws ContainerException {
        Serializable serializable;
        Serializable serializable2;
        int n2;
        if (vector == null && vector2 == null) {
            throw new ContainerException("attempted to map null station and channel");
        }
        if (n <= 0) {
            throw new ContainerException("category is zero or negative");
        }
        Vector vector3 = new Vector(4, 4);
        if (vector == null) {
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                serializable2 = new StringBuffer();
                ((StringBuffer)serializable2).append(n);
                ((StringBuffer)serializable2).append(".");
                ((StringBuffer)serializable2).append(vector2.get(n2).toString());
                serializable = (Vector)this.staChanMap.get(((StringBuffer)serializable2).toString());
                if (serializable == null) continue;
                vector3.addAll(serializable);
            }
        } else {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                if (vector2 != null) {
                    for (int i = 0; i < vector2.size(); ++i) {
                        serializable = new StringBuffer();
                        ((StringBuffer)serializable).append(n);
                        ((StringBuffer)serializable).append(".");
                        ((StringBuffer)serializable).append(vector.get(n2).toString());
                        ((StringBuffer)serializable).append(".");
                        ((StringBuffer)serializable).append(vector2.get(i).toString());
                        Vector vector4 = (Vector)this.staChanMap.get(((StringBuffer)serializable).toString());
                        if (vector4 == null) continue;
                        vector3.addAll(vector4);
                    }
                    continue;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(n);
                stringBuffer.append(".");
                stringBuffer.append(vector.get(n2).toString());
                serializable = (Vector)this.staChanMap.get(stringBuffer.toString());
                if (serializable == null) continue;
                vector3.addAll(serializable);
            }
        }
        if (vector3 == null) {
            return 0;
        }
        HashMap hashMap = null;
        switch (n) {
            case 1: {
                hashMap = this.volume;
                break;
            }
            case 2: {
                hashMap = this.dictionary;
                break;
            }
            case 3: {
                hashMap = this.station;
                break;
            }
            case 4: {
                hashMap = this.timespan;
                break;
            }
            case 5: {
                hashMap = this.data;
                break;
            }
            default: {
                this.currentIterator = null;
                return 0;
            }
        }
        serializable2 = new Vector(vector3.size());
        for (int i = 0; i < vector3.size(); ++i) {
            ((Vector)serializable2).add(hashMap.get(vector3.get(i)));
        }
        Collections.sort(serializable2);
        this.currentIterator = ((Vector)serializable2).iterator();
        return ((Vector)serializable2).size();
    }

    public Object getNext() throws ContainerException {
        if (this.currentIterator == null) {
            return null;
        }
        if (this.currentIterator.hasNext()) {
            Object object = this.currentIterator.next();
            if (object instanceof BlockettePlaceholder) {
                if (!this.locate(((BlockettePlaceholder)object).lookupId)) {
                    throw new ContainerException("Unable to locate() blockette for lookup ID " + ((BlockettePlaceholder)object).lookupId);
                }
                object = this.locateRegister;
            }
            return object;
        }
        return null;
    }

    public void setFiltered(Blockette blockette) throws Exception {
        int n = SeedBlocketteRankMap.getRank(blockette);
        if (++n < this.filterRank || this.filterRank == 0) {
            this.filterRank = n;
        }
    }

    public void setFiltered(int n) {
        this.filterRank = n;
    }

    public int getFiltered() {
        return this.filterRank;
    }

    public void setQueueSize(int n) {
        this.queueSize = n;
    }

    public void flushQueue() {
    }

    public String getMetaEncoding(Blockette blockette) throws Exception {
        if (blockette == null) {
            throw new ContainerException("attempted to resolve encoding for null dataBlk");
        }
        if (blockette.getType() != 999) {
            throw new ContainerException("can only resolve encoding for an FSDH blockette");
        }
        EncodeKey encodeKey = new EncodeKey();
        encodeKey.station = blockette.toString(4);
        encodeKey.location = blockette.toString(5);
        encodeKey.channel = blockette.toString(6);
        encodeKey.network = blockette.toString(7);
        Vector vector = (Vector)this.encodingMap.get(encodeKey.toString());
        String string = "UNKNOWN";
        if (vector != null) {
            Btime btime = (Btime)blockette.getFieldVal(8);
            long l = -1L;
            long l2 = 0L;
            for (int i = 0; i < vector.size(); i += 2) {
                l2 = btime.diffSeconds((Btime)vector.get(i));
                if ((l2 <= 0L || l2 >= l) && l != -1L) continue;
                l = l2;
                string = (String)vector.get(i + 1);
            }
        }
        return string;
    }

    public void addStaChanLookup(String string, String string2, int n, int n2) throws ContainerException {
        Vector<Integer> vector;
        if (string == null && string2 == null) {
            throw new ContainerException("attempted to map null station and channel");
        }
        if (n <= 0) {
            throw new ContainerException("lookupId is zero or negative: " + n);
        }
        if (n2 <= 0) {
            throw new ContainerException("category value is zero or negative: " + n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2);
        stringBuffer.append(".");
        if (string != null) {
            stringBuffer.append(string);
        }
        if (string != null && string2 != null) {
            stringBuffer.append(".");
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if ((vector = (Vector<Integer>)this.staChanMap.get(stringBuffer.toString())) == null) {
            vector = new Vector<Integer>(4, 4);
            this.staChanMap.put(stringBuffer.toString(), vector);
        }
        vector.add(new Integer(n));
    }

    public void setParent(int n) throws Exception {
        this.rankLattice.setSize(0);
        Integer n2 = null;
        Integer n3 = new Integer(n);
        Vector<Integer> vector = new Vector<Integer>(2, 2);
        while (n3 != null && n3 > 0) {
            n2 = new Integer(n3);
            vector.add(n2);
            n3 = (Integer)this.parentChildMap.get(n2);
        }
        Blockette blockette = (Blockette)this.get(n2);
        if (blockette == null || n3 == null) {
            throw new ContainerException("(setParent) unable to locate parent blockette " + n);
        }
        int n4 = vector.size();
        this.rankLattice.setSize(n4);
        Blockette blockette2 = blockette;
        for (int i = 0; i < n4; ++i) {
            if (i > 0) {
                int n5 = (Integer)vector.get(n4 - i - 1);
                int n6 = blockette.numberofChildBlockettes();
                boolean bl = false;
                for (int j = 0; !bl && j < n6; ++j) {
                    blockette2 = blockette.getChildBlockette(j);
                    if (blockette2.getLookupId() != n5) continue;
                    bl = true;
                }
                if (!bl && n6 > 0) {
                    throw new ContainerException("(setParent) unable to locate blockette " + n5);
                }
            }
            this.rankLattice.set(i, blockette2);
            blockette = blockette2;
        }
    }

    public boolean improvedLocate(int n) {
        if (this.locateRegister != null && this.locateRegister.getLookupId() == n) {
            return true;
        }
        try {
            this.setParent(n);
            if (this.rankLattice.size() == 0) {
                return false;
            }
            this.locateRegister = (Blockette)this.rankLattice.get(this.rankLattice.size() - 1);
            if (this.locateRegister == null) {
                throw new Exception("improvedLocate(): pulled back null object");
            }
            if (n != this.locateRegister.getLookupId()) {
                throw new Exception("improvedLocate(): looked for id=" + n + " and came back with id=" + this.locateRegister.getLookupId());
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.rankLattice.setSize(0);
            this.locateRegister = null;
            return false;
        }
    }

    public Object improvedGet(int n) {
        if (this.improvedLocate(n)) {
            return this.locateRegister;
        }
        return null;
    }

    public int getNewId(Blockette blockette) throws Exception {
        int n = SeedBlocketteRankMap.getHeaderCode(blockette);
        if (n == 2) {
            return this.lastIdMap[blockette.getType() - 20] + 1;
        }
        return this.lastIdMap[n] + 1;
    }

    public int findMatchingDictionary(String string) {
        Integer n = (Integer)this.dictionaryMatchMap.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public boolean isUsingSerialization() {
        return this.diskStore != null;
    }

    public void commitChange(Blockette blockette) throws ContainerException {
        if (!this.isUsingSerialization()) {
            return;
        }
        int n = 0;
        int n2 = blockette.getLookupId();
        try {
            n = SeedBlocketteRankMap.getRank(blockette);
        }
        catch (Exception exception) {
            throw new ContainerException("Cannot get rank of blockette type: " + n2);
        }
        if (n > 0) {
            return;
        }
        this.cacheFind(n2, true);
        this.enqueue(blockette);
        BlockettePlaceholder blockettePlaceholder = (BlockettePlaceholder)this.lookup(n2);
        if (blockettePlaceholder == null) {
            throw new ContainerException("null lookup return for lookupId " + n2);
        }
        blockettePlaceholder.onDisk = false;
        blockettePlaceholder.isCached = true;
    }

    public void commitChange(Object object) throws ContainerException {
        this.commitChange((Blockette)object);
    }

    private Blockette cacheFind(int n, boolean bl) throws ContainerException {
        if (this.blocketteQueue == null) {
            throw new ContainerException("cacheFind method encounters a null blocketteQueue");
        }
        ListIterator listIterator = this.blocketteQueue.listIterator();
        while (listIterator.hasNext()) {
            Blockette blockette = (Blockette)listIterator.next();
            if (blockette.getLookupId() != n) continue;
            listIterator.remove();
            if (bl) {
                BlockettePlaceholder blockettePlaceholder = (BlockettePlaceholder)this.lookup(n);
                if (blockettePlaceholder != null) {
                    blockettePlaceholder.isCached = false;
                }
            } else {
                this.enqueue(blockette);
            }
            return blockette;
        }
        return null;
    }

    private Blockette cacheFind(int n) throws ContainerException {
        return this.cacheFind(n, false);
    }

    private void enqueue(Blockette blockette) throws ContainerException {
        if (this.blocketteQueue == null) {
            throw new ContainerException("enqueue method encounters a null blocketteQueue");
        }
        this.blocketteQueue.addFirst(blockette);
        while (this.blocketteQueue.size() > this.queueSize) {
            this.dequeue();
        }
    }

    private Blockette dequeue() throws ContainerException {
        int n;
        BlockettePlaceholder blockettePlaceholder;
        if (this.blocketteQueue == null) {
            throw new ContainerException("dequeue method encounters a null blocketteQueue");
        }
        Blockette blockette = (Blockette)this.blocketteQueue.removeLast();
        if (this.rankLattice.size() > 0 && blockette == this.rankLattice.getBlockette(0)) {
            this.blocketteQueue.addFirst(blockette);
            blockette = (Blockette)this.blocketteQueue.removeLast();
        }
        if ((blockettePlaceholder = (BlockettePlaceholder)this.lookup(n = blockette.getLookupId())) == null) {
            throw new ContainerException("null lookup return for lookupId " + n);
        }
        if (!blockettePlaceholder.onDisk) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(blockette);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.diskStore.seek(this.diskStore.length());
                blockettePlaceholder.offset = this.diskStore.length();
                blockettePlaceholder.length = byArray.length;
                this.diskStore.write(byArray);
                objectOutputStream.flush();
                byteArrayOutputStream.flush();
                objectOutputStream.close();
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {
                throw new ContainerException("disk store exception encountered: " + exception);
            }
            blockettePlaceholder.onDisk = true;
        }
        blockettePlaceholder.isCached = false;
        return blockette;
    }

    private Object lookup(int n) {
        Integer n2 = new Integer(n);
        Object var3_3 = null;
        var3_3 = this.volume.get(n2);
        if (var3_3 == null) {
            var3_3 = this.dictionary.get(n2);
        }
        if (var3_3 == null) {
            var3_3 = this.station.get(n2);
        }
        if (var3_3 == null) {
            var3_3 = this.timespan.get(n2);
        }
        if (var3_3 == null) {
            var3_3 = this.data.get(n2);
        }
        return var3_3;
    }

    class EncodeKey {
        String station = null;
        String network = null;
        String channel = null;
        String location = null;

        EncodeKey() {
        }

        public String toString() {
            return "" + this.station + "." + this.network + "." + this.channel + "." + this.location;
        }
    }
}

