/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.director;

import edu.iris.Fissures.seed.exception.SeedException;
import edu.iris.Fissures.seed.exception.SeedInputException;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;

public class ReadBuffer {
    protected byte[] buffer;
    private int dataLength = 0;
    private int bufSize = 0;
    public static final int defaultBufSize = 32768;
    private boolean reachedEOF = false;

    public ReadBuffer(int n) {
        this.buffer = new byte[n];
        Arrays.fill(this.buffer, (byte)0);
        this.bufSize = n;
    }

    public ReadBuffer() {
        this(32768);
    }

    public int length() {
        return this.dataLength;
    }

    public int bufSize() {
        return this.bufSize;
    }

    public void fill(DataInputStream dataInputStream) throws SeedException, IOException {
        int n = this.bufSize - this.dataLength;
        if (n < 0) {
            throw new SeedInputException("bufSize less than dataLength");
        }
        if (!this.reachedEOF()) {
            int n2 = dataInputStream.available();
            if (n2 == 0) {
                this.reachedEOF = true;
                return;
            }
            if (n2 < n) {
                this.reachedEOF = true;
                n = n2;
            }
            dataInputStream.readFully(this.buffer, this.dataLength, n);
            this.dataLength += n;
            return;
        }
    }

    public void shift(int n) {
        System.arraycopy(this.buffer, n, this.buffer, 0, this.bufSize - n);
        Arrays.fill(this.buffer, this.bufSize - n, this.bufSize, (byte)0);
        this.dataLength -= n;
        if (this.dataLength < 0) {
            this.dataLength = 0;
        }
    }

    public boolean reachedEOF() {
        return this.reachedEOF;
    }
}

