/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.CriticalDepth;
import edu.sc.seis.TauP.DepthRange;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SplitLayerInfo;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import java.io.Serializable;
import java.util.Vector;

public abstract class SlownessModel
implements Serializable,
Cloneable {
    public transient boolean DEBUG = false;
    public transient boolean verbose = false;
    protected double radiusOfEarth = 6371.0;
    protected VelocityModel vMod;
    protected Vector criticalDepthVector = new Vector();
    protected Vector highSlownessLayerDepthsP = new Vector();
    protected Vector highSlownessLayerDepthsS = new Vector();
    protected Vector fluidLayerDepths = new Vector();
    protected static int vectorLength = 256;
    protected Vector PLayers = new Vector(vectorLength);
    protected Vector SLayers = new Vector(vectorLength);
    protected double minDeltaP = 0.1;
    protected double maxDeltaP = 11.0;
    protected double maxDepthInterval = 115.0;
    protected double maxRangeInterval = 200.0 / this.radiusOfEarth;
    protected double maxInterpError = 0.5;
    protected boolean allowInnerCoreS = true;
    protected double slownessTolerance = 1.0E-16;
    public static final boolean PWAVE = true;
    public static final boolean SWAVE = false;

    public void setRadiusOfEarth(double d) {
        this.radiusOfEarth = d;
    }

    public void setMinDeltaP(double d) {
        this.minDeltaP = d;
    }

    public void setMaxDeltaP(double d) {
        this.maxDeltaP = d;
    }

    public void setMaxDepthInterval(double d) {
        this.maxDepthInterval = d;
    }

    public void setMaxRangeInterval(double d) {
        this.maxRangeInterval = d * Math.PI / 180.0;
    }

    public void setMaxInterpError(double d) {
        this.maxInterpError = d;
    }

    public void setAllowInnerCoreS(boolean bl) {
        this.allowInnerCoreS = bl;
    }

    public void setSlownessTolerance(double d) {
        this.slownessTolerance = d;
    }

    public final double getRadiusOfEarth() {
        return this.radiusOfEarth;
    }

    public final double getMinDeltaP() {
        return this.minDeltaP;
    }

    public final double getMaxDeltaP() {
        return this.maxDeltaP;
    }

    public final double getMaxDepthInterval() {
        return this.maxDepthInterval;
    }

    public final double getMaxRangeInterval() {
        return 180.0 * this.maxRangeInterval / Math.PI;
    }

    public final double getMaxInterpError() {
        return this.maxInterpError;
    }

    public final boolean isAllowInnerCoreS() {
        return this.allowInnerCoreS;
    }

    public final double getSlownessTolerance() {
        return this.slownessTolerance;
    }

    public final int getNumCriticalDepths() {
        return this.criticalDepthVector.size();
    }

    public final CriticalDepth getCriticalDepth(int n) {
        return (CriticalDepth)this.criticalDepthVector.elementAt(n);
    }

    public final int getNumLayers(boolean bl) {
        if (bl) {
            return this.PLayers.size();
        }
        return this.SLayers.size();
    }

    public double getMinTurnRayParam(double d, boolean bl) throws NoSuchLayerException, SlownessModelException {
        double d2 = Double.MAX_VALUE;
        Vector vector = bl ? this.PLayers : this.SLayers;
        if (this.depthInHighSlowness(d, Double.MAX_VALUE, bl)) {
            for (int i = 0; i < vector.size(); ++i) {
                SlownessLayer slownessLayer = this.getSlownessLayer(i, bl);
                if (slownessLayer.botDepth == d) {
                    d2 = Math.min(d2, slownessLayer.botP);
                    return d2;
                }
                if (slownessLayer.botDepth > d) {
                    d2 = Math.min(d2, slownessLayer.evaluateAt_bullen(d, this.getRadiusOfEarth()));
                    return d2;
                }
                d2 = Math.min(d2, slownessLayer.botP);
            }
        } else {
            SlownessLayer slownessLayer = this.getSlownessLayer(this.layerNumberAbove(d, bl), bl);
            d2 = d == slownessLayer.botDepth ? slownessLayer.botP : slownessLayer.evaluateAt_bullen(d, this.getRadiusOfEarth());
        }
        return d2;
    }

    public double getMinRayParam(double d, boolean bl) throws NoSuchLayerException, SlownessModelException {
        double d2 = this.getMinTurnRayParam(d, bl);
        int n = this.layerNumberAbove(d, bl);
        int n2 = this.layerNumberBelow(d, bl);
        SlownessLayer slownessLayer = this.getSlownessLayer(n, bl);
        SlownessLayer slownessLayer2 = this.getSlownessLayer(n2, bl);
        if (slownessLayer.botDepth == d) {
            d2 = Math.min(Math.min(d2, slownessLayer.botP), slownessLayer2.topP);
        }
        return d2;
    }

    public DepthRange[] getHighSlowness(boolean bl) {
        Vector vector = bl ? this.highSlownessLayerDepthsP : this.highSlownessLayerDepthsS;
        DepthRange[] depthRangeArray = new DepthRange[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            depthRangeArray[i] = (DepthRange)((DepthRange)vector.elementAt(i)).clone();
        }
        return depthRangeArray;
    }

    public SlownessLayer getSlownessLayerClone(int n, boolean bl) {
        if (bl) {
            return (SlownessLayer)((SlownessLayer)this.PLayers.elementAt(n)).clone();
        }
        return (SlownessLayer)((SlownessLayer)this.SLayers.elementAt(n)).clone();
    }

    protected SlownessLayer getSlownessLayer(int n, boolean bl) {
        if (bl) {
            return (SlownessLayer)this.PLayers.elementAt(n);
        }
        return (SlownessLayer)this.SLayers.elementAt(n);
    }

    public abstract double toSlowness(double var1, double var3) throws SlownessModelException;

    public abstract double toVelocity(double var1, double var3) throws SlownessModelException;

    public abstract TimeDist layerTimeDist(double var1, int var3, boolean var4) throws SlownessModelException;

    public abstract SlownessLayer toSlownessLayer(VelocityLayer var1, boolean var2) throws SlownessModelException;

    public abstract double interpolate(double var1, double var3, double var5, double var7) throws SlownessModelException;

    public TimeDist approxDistance(int n, double d, boolean bl) throws NoSuchLayerException, SlownessModelException {
        if (n >= this.getNumLayers(bl)) {
            throw new SlownessModelException("Can't calculate a distance when slownessTurnLayer >= getNumLayers(" + bl + ")\n" + " slownessTurnLayer=" + n + " getNumLayers()=" + this.getNumLayers(bl));
        }
        if (d < 0.0) {
            throw new SlownessModelException("approxDistance: Ray parameter is negative!!!" + d + " slownessTurnLayer=" + n);
        }
        TimeDist timeDist = new TimeDist(d);
        for (int i = 0; i <= n; ++i) {
            timeDist.add(this.layerTimeDist(d, i, bl));
        }
        timeDist.dist *= 2.0;
        timeDist.time *= 2.0;
        return timeDist;
    }

    public boolean depthInHighSlowness(double d, double d2, boolean bl) {
        DepthRange depthRange = new DepthRange();
        return this.depthInHighSlowness(d, d2, depthRange, bl);
    }

    public boolean depthInHighSlowness(double d, double d2, DepthRange depthRange, boolean bl) {
        Vector vector = bl ? this.highSlownessLayerDepthsP : this.highSlownessLayerDepthsS;
        for (int i = 0; i < vector.size(); ++i) {
            DepthRange depthRange2 = (DepthRange)vector.elementAt(i);
            if (!(depthRange2.topDepth <= d) || !(d <= depthRange2.botDepth)) continue;
            depthRange.topDepth = depthRange2.topDepth;
            depthRange.botDepth = depthRange2.botDepth;
            depthRange.rayParam = depthRange2.rayParam;
            if (!(d2 > depthRange2.rayParam) && (d2 != depthRange2.rayParam || d != depthRange2.topDepth)) continue;
            return true;
        }
        return false;
    }

    public boolean depthInFluid(double d) {
        DepthRange depthRange = new DepthRange();
        return this.depthInFluid(d, depthRange);
    }

    public boolean depthInFluid(double d, DepthRange depthRange) {
        for (int i = 0; i < this.fluidLayerDepths.size(); ++i) {
            DepthRange depthRange2 = (DepthRange)this.fluidLayerDepths.elementAt(i);
            if (!(depthRange2.topDepth <= d) || !(d < depthRange2.botDepth)) continue;
            depthRange.topDepth = depthRange2.topDepth;
            depthRange.botDepth = depthRange2.botDepth;
            return true;
        }
        return false;
    }

    public SplitLayerInfo splitLayer(double d, boolean bl) throws SlownessModelException, NoSuchLayerException {
        int n;
        Vector vector;
        Vector vector2;
        if (bl) {
            vector2 = this.PLayers;
            vector = this.SLayers;
        } else {
            vector2 = this.SLayers;
            vector = this.PLayers;
        }
        boolean bl2 = !bl;
        boolean bl3 = false;
        int n2 = this.layerNumberAbove(d, bl);
        SlownessLayer slownessLayer = this.getSlownessLayer(n2, bl);
        if (slownessLayer.topDepth == d || slownessLayer.botDepth == d) {
            return new SplitLayerInfo(false, false, 0.0);
        }
        if (Math.abs(slownessLayer.topDepth - d) < 1.0E-6) {
            slownessLayer.topDepth = d;
            slownessLayer = this.getSlownessLayer(n2 - 1, bl);
            slownessLayer.botDepth = d;
            return new SplitLayerInfo(false, true, slownessLayer.botP);
        }
        if (Math.abs(d - slownessLayer.botDepth) < 1.0E-6) {
            slownessLayer.botDepth = d;
            slownessLayer = this.getSlownessLayer(n2 + 1, bl);
            slownessLayer.topDepth = d;
            return new SplitLayerInfo(false, true, slownessLayer.topP);
        }
        double d2 = slownessLayer.evaluateAt_bullen(d, this.radiusOfEarth);
        int n3 = -1;
        int n4 = -1;
        SlownessLayer slownessLayer2 = (SlownessLayer)slownessLayer.clone();
        slownessLayer2.botP = d2;
        slownessLayer2.botDepth = d;
        SlownessLayer slownessLayer3 = (SlownessLayer)slownessLayer.clone();
        slownessLayer3.topP = d2;
        slownessLayer3.topDepth = slownessLayer2.botDepth;
        vector2.removeElementAt(n2);
        vector2.insertElementAt(slownessLayer3, n2);
        vector2.insertElementAt(slownessLayer2, n2);
        for (n = 0; n < this.getNumCriticalDepths(); ++n) {
            CriticalDepth criticalDepth = this.getCriticalDepth(n);
            if (criticalDepth.getLayerNum(bl) <= n2) continue;
            criticalDepth.setLayerNum(criticalDepth.getLayerNum(bl) + 1, bl);
        }
        n4 = vector.indexOf(slownessLayer);
        if (n4 != -1) {
            vector.removeElementAt(n4);
            vector.insertElementAt(slownessLayer3, n4);
            vector.insertElementAt(slownessLayer2, n4);
        }
        for (n = 0; n < vector.size(); ++n) {
            slownessLayer = (SlownessLayer)vector.elementAt(n);
            if (!((slownessLayer.topP - d2) * (d2 - slownessLayer.botP) > 0.0)) continue;
            slownessLayer2 = (SlownessLayer)slownessLayer.clone();
            slownessLayer2.botP = d2;
            slownessLayer2.botDepth = slownessLayer.bullenDepthFor(d2, this.radiusOfEarth);
            slownessLayer3 = (SlownessLayer)slownessLayer.clone();
            slownessLayer3.topP = d2;
            slownessLayer3.topDepth = slownessLayer2.botDepth;
            vector.removeElementAt(n);
            vector.insertElementAt(slownessLayer3, n);
            vector.insertElementAt(slownessLayer2, n);
            for (int i = 0; i < this.getNumCriticalDepths(); ++i) {
                CriticalDepth criticalDepth = this.getCriticalDepth(i);
                if (criticalDepth.getLayerNum(bl2) <= n) continue;
                criticalDepth.setLayerNum(criticalDepth.getLayerNum(bl2) + 1, bl2);
            }
        }
        return new SplitLayerInfo(true, false, d2);
    }

    protected void findCriticalPoints() throws SlownessModelException {
        int n;
        double d = this.getRadiusOfEarth();
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        DepthRange depthRange = new DepthRange();
        DepthRange depthRange2 = new DepthRange();
        boolean bl = false;
        boolean bl2 = false;
        DepthRange depthRange3 = new DepthRange();
        boolean bl3 = false;
        boolean bl4 = false;
        this.highSlownessLayerDepthsP.removeAllElements();
        this.highSlownessLayerDepthsS.removeAllElements();
        this.criticalDepthVector.removeAllElements();
        this.fluidLayerDepths.removeAllElements();
        VelocityLayer velocityLayer = this.vMod.getVelocityLayerClone(0);
        velocityLayer.botDepth = velocityLayer.topDepth;
        velocityLayer.botPVelocity = velocityLayer.topPVelocity;
        velocityLayer.botSVelocity = velocityLayer.topSVelocity;
        velocityLayer.botDensity = velocityLayer.topDensity;
        velocityLayer.botQp = velocityLayer.topQp;
        velocityLayer.botQs = velocityLayer.topQs;
        SlownessLayer slownessLayer = this.toSlownessLayer(velocityLayer, false);
        SlownessLayer slownessLayer2 = this.toSlownessLayer(velocityLayer, true);
        this.criticalDepthVector.addElement(new CriticalDepth(0.0, 0, 0, 0));
        if (!bl3 && velocityLayer.topSVelocity == 0.0) {
            bl3 = true;
            depthRange3 = new DepthRange();
            depthRange3.topDepth = velocityLayer.topDepth;
            slownessLayer = slownessLayer2;
        }
        if (d3 > slownessLayer.topP) {
            d3 = slownessLayer.topP;
        }
        if (d2 > slownessLayer2.topP) {
            d2 = slownessLayer2.topP;
        }
        for (n = 0; n < this.vMod.getNumLayers(); ++n) {
            VelocityLayer velocityLayer2 = velocityLayer;
            SlownessLayer slownessLayer3 = slownessLayer;
            SlownessLayer slownessLayer4 = slownessLayer2;
            velocityLayer = this.vMod.getVelocityLayerClone(n);
            slownessLayer = this.toSlownessLayer(velocityLayer, false);
            slownessLayer2 = this.toSlownessLayer(velocityLayer, true);
            if (!bl3 && velocityLayer.topSVelocity == 0.0) {
                bl3 = true;
                depthRange3 = new DepthRange();
                depthRange3.topDepth = velocityLayer.topDepth;
            }
            if (bl3 && velocityLayer.topSVelocity != 0.0) {
                if (velocityLayer2.botDepth > this.vMod.getIocbDepth()) {
                    bl4 = true;
                }
                bl3 = false;
                depthRange3.botDepth = velocityLayer2.botDepth;
                this.fluidLayerDepths.addElement(depthRange3);
            }
            if (bl3 || bl4 && !this.allowInnerCoreS) {
                slownessLayer = slownessLayer2;
            }
            if (slownessLayer3.botP != slownessLayer.topP || slownessLayer4.botP != slownessLayer2.topP) {
                this.criticalDepthVector.addElement(new CriticalDepth(slownessLayer.topDepth, n, -1, -1));
                if (this.DEBUG) {
                    System.out.println("first order discontinuity, depth=" + slownessLayer.topDepth);
                    System.out.println(slownessLayer3 + "\n" + slownessLayer);
                    System.out.println(slownessLayer4 + "\n" + slownessLayer2);
                }
                if (bl2 && slownessLayer.topP < d3) {
                    if (this.DEBUG) {
                        System.out.println("top of current layer is the bottom of a high slowness zone.");
                    }
                    depthRange2.botDepth = slownessLayer.topDepth;
                    this.highSlownessLayerDepthsS.addElement(depthRange2);
                    bl2 = false;
                }
                if (bl && slownessLayer2.topP < d2) {
                    if (this.DEBUG) {
                        System.out.println("top of current layer is the bottom of a high slowness zone.");
                    }
                    depthRange.botDepth = slownessLayer.topDepth;
                    this.highSlownessLayerDepthsP.addElement(depthRange);
                    bl = false;
                }
                if (d2 > slownessLayer2.topP) {
                    d2 = slownessLayer2.topP;
                }
                if (d3 > slownessLayer.topP) {
                    d3 = slownessLayer.topP;
                }
                if (!bl2 && (slownessLayer3.botP < slownessLayer.topP || slownessLayer.topP < slownessLayer.botP)) {
                    if (this.DEBUG) {
                        System.out.println("Found S high slowness at first order discontinuity, layer = " + n);
                    }
                    bl2 = true;
                    depthRange2 = new DepthRange();
                    depthRange2.topDepth = slownessLayer.topDepth;
                    depthRange2.rayParam = d3;
                }
                if (!bl && (slownessLayer4.botP < slownessLayer2.topP || slownessLayer2.topP < slownessLayer2.botP)) {
                    if (this.DEBUG) {
                        System.out.println("Found P high slowness at first order discontinuity, layer = " + n);
                    }
                    bl = true;
                    depthRange = new DepthRange();
                    depthRange.topDepth = slownessLayer2.topDepth;
                    depthRange.rayParam = d2;
                }
            } else if ((slownessLayer3.topP - slownessLayer3.botP) * (slownessLayer3.botP - slownessLayer.botP) < 0.0 || (slownessLayer4.topP - slownessLayer4.botP) * (slownessLayer4.botP - slownessLayer2.botP) < 0.0) {
                this.criticalDepthVector.addElement(new CriticalDepth(slownessLayer.topDepth, n, -1, -1));
                if (this.DEBUG) {
                    System.out.println("local slowness extrema, depth=" + slownessLayer.topDepth);
                }
                if (!bl && slownessLayer2.topP < slownessLayer2.botP) {
                    if (this.DEBUG) {
                        System.out.println("start of a P high slowness zone, local slowness extrema, minPSoFar=" + d2);
                    }
                    bl = true;
                    depthRange = new DepthRange();
                    depthRange.topDepth = slownessLayer2.topDepth;
                    depthRange.rayParam = d2;
                }
                if (!bl2 && slownessLayer.topP < slownessLayer.botP) {
                    if (this.DEBUG) {
                        System.out.println("start of a S high slowness zone, local slowness extrema, minSSoFar=" + d3);
                    }
                    bl2 = true;
                    depthRange2 = new DepthRange();
                    depthRange2.topDepth = slownessLayer.topDepth;
                    depthRange2.rayParam = d3;
                }
            }
            if (bl && slownessLayer2.botP < d2) {
                if (this.DEBUG) {
                    System.out.println("layer contains the bottom of a P high slowness zone. minPSoFar=" + d2 + " " + slownessLayer2);
                }
                depthRange.botDepth = this.findDepth(d2, n, n, true);
                this.highSlownessLayerDepthsP.addElement(depthRange);
                bl = false;
            }
            if (bl2 && slownessLayer.botP < d3) {
                if (this.DEBUG) {
                    System.out.println("layer contains the bottom of a S high slowness zone. minSSoFar=" + d3 + " " + slownessLayer);
                }
                depthRange2.botDepth = this.findDepth(d3, n, n, false);
                this.highSlownessLayerDepthsS.addElement(depthRange2);
                bl2 = false;
            }
            if (d2 > slownessLayer2.botP) {
                d2 = slownessLayer2.botP;
            }
            if (d2 > slownessLayer2.topP) {
                d2 = slownessLayer2.topP;
            }
            if (d3 > slownessLayer.botP) {
                d3 = slownessLayer.botP;
            }
            if (d3 > slownessLayer.topP) {
                d3 = slownessLayer.topP;
            }
            if (this.DEBUG && bl2) {
                System.out.println("In S high slowness zone, layerNum = " + n + " minSSoFar=" + d3);
            }
            if (!this.DEBUG || !bl) continue;
            System.out.println("In P high slowness zone, layerNum = " + n + " minPSoFar=" + d2);
        }
        this.criticalDepthVector.addElement(new CriticalDepth(this.getRadiusOfEarth(), this.vMod.getNumLayers(), -1, -1));
        if (bl2) {
            depthRange2.botDepth = velocityLayer.botDepth;
            this.highSlownessLayerDepthsS.addElement(depthRange2);
        }
        if (bl) {
            depthRange.botDepth = velocityLayer.botDepth;
            this.highSlownessLayerDepthsP.addElement(depthRange);
        }
        if (bl3) {
            depthRange3.botDepth = velocityLayer.botDepth;
            this.fluidLayerDepths.addElement(depthRange3);
        }
        if (this.DEBUG && this.criticalDepthVector.size() != 0) {
            String string = "**** Critical Velocity Layers ************************\n";
            n = ((CriticalDepth)this.criticalDepthVector.elementAt((int)0)).velLayerNum - 1;
            for (int i = 1; i < this.criticalDepthVector.size(); ++i) {
                int n2 = n + 1;
                n = ((CriticalDepth)this.criticalDepthVector.elementAt((int)i)).velLayerNum - 1;
                string = string + " " + n2 + "," + n;
            }
            System.out.println(string);
        }
        if (this.DEBUG && this.highSlownessLayerDepthsP.size() != 0) {
            for (n = 0; n < this.highSlownessLayerDepthsP.size(); ++n) {
                System.out.println((DepthRange)this.highSlownessLayerDepthsP.elementAt(n));
            }
        }
        if (this.DEBUG && this.highSlownessLayerDepthsS.size() != 0) {
            for (n = 0; n < this.highSlownessLayerDepthsS.size(); ++n) {
                System.out.println((DepthRange)this.highSlownessLayerDepthsS.elementAt(n));
            }
        }
        if (!this.validate()) {
            throw new SlownessModelException("Validation Failed!");
        }
    }

    public double findDepth(double d, boolean bl) throws SlownessModelException {
        return this.findDepth(d, 0, this.vMod.getNumLayers() - 1, bl);
    }

    public double findDepth(double d, double d2, double d3, boolean bl) throws SlownessModelException {
        try {
            int n = this.vMod.layerNumberBelow(d2);
            if (this.vMod.getVelocityLayer((int)n).botDepth == d2) {
                ++n;
            }
            int n2 = this.vMod.layerNumberAbove(d3);
            return this.findDepth(d, n, n2, bl);
        }
        catch (NoSuchLayerException noSuchLayerException) {
            throw new SlownessModelException(noSuchLayerException.getMessage());
        }
    }

    public double findDepth(double d, int n, int n2, boolean bl) throws SlownessModelException {
        VelocityLayer velocityLayer = new VelocityLayer();
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        char c = bl ? (char)'P' : 'S';
        try {
            if (n > n2) {
                throw new SlownessModelException("findDepth: no layers to search!: topCriticalLayer = " + n + "botCriticalLayer = " + n2);
            }
            for (int i = n; i <= n2; ++i) {
                velocityLayer = this.vMod.getVelocityLayer(i);
                double d4 = velocityLayer.evaluateAtTop(c);
                double d5 = velocityLayer.evaluateAtBottom(c);
                d2 = this.toSlowness(d4, velocityLayer.topDepth);
                d3 = this.toSlowness(d5, velocityLayer.botDepth);
                if (Math.abs(d2 - d) < this.slownessTolerance) {
                    return velocityLayer.topDepth;
                }
                if (Math.abs(d - d3) < this.slownessTolerance) {
                    return velocityLayer.botDepth;
                }
                if ((d2 - d) * (d - d3) >= 0.0) {
                    double d6 = (d5 - d4) / (velocityLayer.botDepth - velocityLayer.topDepth);
                    double d7 = this.interpolate(d, d4, velocityLayer.topDepth, d6);
                    return d7;
                }
                if (i == n && Math.abs(d - d2) < this.slownessTolerance) {
                    return velocityLayer.topDepth;
                }
                if (i >= this.vMod.getNumLayers() - 1) continue;
                velocityLayer = this.vMod.getVelocityLayerClone(i + 1);
                d4 = velocityLayer.evaluateAtTop(c);
                if (!bl && this.depthInFluid(velocityLayer.topDepth)) {
                    d4 = velocityLayer.evaluateAtTop('P');
                }
                d2 = this.toSlowness(d4, velocityLayer.topDepth);
                if (!(d3 >= d) || !(d >= d2)) continue;
                return velocityLayer.topDepth;
            }
            if (Math.abs(d - d3) < this.slownessTolerance) {
                System.out.println(" p is just outside the bottommost layer. This probably shouldn't be allowed to happen!\n");
                return velocityLayer.botDepth;
            }
        }
        catch (NoSuchMatPropException noSuchMatPropException) {
            noSuchMatPropException.printStackTrace();
        }
        throw new SlownessModelException("slowness p=" + d + " is not contained within the specified layers." + "\np=" + d + " topCriticalLayer=" + n + " botCriticalLayer=" + n2 + " isPWave=" + bl + " topP=" + d2 + " botP=" + d3);
    }

    public void createSample(VelocityModel velocityModel) throws SlownessModelException, NoSuchMatPropException, NoSuchLayerException {
        double d = 0.0;
        DepthRange depthRange = new DepthRange();
        if (!velocityModel.validate()) {
            throw new SlownessModelException("Error in velocity model!");
        }
        if (velocityModel.getNumLayers() == 0) {
            throw new SlownessModelException("velModel.getNumLayers()==0");
        }
        if (this.DEBUG) {
            System.out.println("start createSample");
        }
        this.vMod = velocityModel;
        this.setRadiusOfEarth(velocityModel.getRadiusOfEarth());
        if (this.DEBUG) {
            System.out.println("findCriticalPoints");
        }
        this.findCriticalPoints();
        if (this.DEBUG) {
            System.out.println("coarseSample");
        }
        this.coarseSample();
        boolean bl = false;
        if (this.DEBUG) {
            bl = this.validate();
            System.out.println("rayParamCheck");
        }
        this.rayParamIncCheck();
        if (this.DEBUG) {
            bl &= this.validate();
            System.out.println("depthIncCheck");
        }
        this.depthIncCheck();
        if (this.DEBUG) {
            bl &= this.validate();
            System.out.println("distanceCheck");
        }
        this.distanceCheck();
        if (this.DEBUG) {
            bl &= this.validate();
            System.out.println("fixCriticalPoints");
        }
        this.fixCriticalPoints();
        if (this.DEBUG) {
            System.out.println("done createSample");
        }
    }

    protected void coarseSample() throws SlownessModelException, NoSuchLayerException {
        VelocityLayer velocityLayer = this.vMod.getVelocityLayerClone(0);
        VelocityLayer velocityLayer2 = new VelocityLayer();
        this.PLayers.removeAllElements();
        this.SLayers.removeAllElements();
        velocityLayer.botDepth = velocityLayer.topDepth;
        velocityLayer.botPVelocity = velocityLayer.topPVelocity;
        velocityLayer.botSVelocity = velocityLayer.topSVelocity;
        velocityLayer.botDensity = velocityLayer.topDensity;
        velocityLayer.botQp = velocityLayer.topQp;
        velocityLayer.botQs = velocityLayer.topQs;
        try {
            int n;
            SlownessLayer slownessLayer;
            int n2;
            DepthRange depthRange;
            int n3;
            for (n3 = 0; n3 < this.vMod.getNumLayers(); ++n3) {
                SlownessLayer slownessLayer2;
                SlownessLayer slownessLayer3;
                VelocityLayer velocityLayer3 = velocityLayer;
                velocityLayer = this.vMod.getVelocityLayer(n3);
                if (velocityLayer3.botPVelocity != velocityLayer.topPVelocity || velocityLayer3.botSVelocity != velocityLayer.topSVelocity && (this.allowInnerCoreS || velocityLayer.topDepth < this.vMod.getIocbDepth())) {
                    velocityLayer2.topDepth = velocityLayer3.botDepth;
                    velocityLayer2.botDepth = velocityLayer3.botDepth;
                    velocityLayer2.topPVelocity = velocityLayer3.evaluateAtBottom('P');
                    velocityLayer2.botPVelocity = velocityLayer.evaluateAtTop('P');
                    velocityLayer2.topSVelocity = velocityLayer3.botSVelocity == 0.0 ? velocityLayer3.evaluateAtBottom('P') : velocityLayer3.evaluateAtBottom('S');
                    velocityLayer2.botSVelocity = velocityLayer.topSVelocity == 0.0 ? velocityLayer.evaluateAtTop('P') : velocityLayer.evaluateAtTop('S');
                    slownessLayer3 = this.toSlownessLayer(velocityLayer2, true);
                    this.PLayers.addElement(slownessLayer3);
                    slownessLayer2 = velocityLayer3.botSVelocity == 0.0 && velocityLayer.topSVelocity == 0.0 || !this.allowInnerCoreS && velocityLayer2.topDepth >= this.vMod.getIocbDepth() ? slownessLayer3 : this.toSlownessLayer(velocityLayer2, false);
                    this.SLayers.addElement(slownessLayer2);
                }
                slownessLayer3 = this.toSlownessLayer(velocityLayer, true);
                this.PLayers.addElement(slownessLayer3);
                slownessLayer2 = this.depthInFluid(velocityLayer.topDepth) || !this.allowInnerCoreS && velocityLayer.topDepth >= this.vMod.getIocbDepth() ? slownessLayer3 : this.toSlownessLayer(velocityLayer, false);
                this.SLayers.addElement(slownessLayer2);
            }
            for (n3 = 0; n3 < this.highSlownessLayerDepthsS.size(); ++n3) {
                depthRange = (DepthRange)this.highSlownessLayerDepthsS.elementAt(n3);
                n2 = this.layerNumberAbove(depthRange.botDepth, false);
                slownessLayer = this.getSlownessLayer(n2, false);
                while (slownessLayer.topDepth == slownessLayer.botDepth && (slownessLayer.topP - depthRange.rayParam) * (depthRange.rayParam - slownessLayer.botP) < 0.0) {
                    slownessLayer = this.getSlownessLayer(++n2, false);
                }
                if (depthRange.rayParam == slownessLayer.botP) continue;
                this.addSlowness(depthRange.rayParam, false);
            }
            for (n3 = 0; n3 < this.highSlownessLayerDepthsP.size(); ++n3) {
                depthRange = (DepthRange)this.highSlownessLayerDepthsP.elementAt(n3);
                n2 = this.layerNumberAbove(depthRange.botDepth, true);
                slownessLayer = this.getSlownessLayer(n2, true);
                while (slownessLayer.topDepth == slownessLayer.botDepth && (slownessLayer.topP - depthRange.rayParam) * (depthRange.rayParam - slownessLayer.botP) < 0.0) {
                    slownessLayer = this.getSlownessLayer(++n2, true);
                }
                if (depthRange.rayParam == slownessLayer.botP) continue;
                this.addSlowness(depthRange.rayParam, true);
            }
            double d = -1.0;
            double d2 = -1.0;
            for (n = 0; n < this.PLayers.size(); ++n) {
                d2 = ((SlownessLayer)this.PLayers.elementAt((int)n)).topP;
                if (d2 != d) {
                    this.addSlowness(d2, false);
                }
                d = ((SlownessLayer)this.PLayers.elementAt((int)n)).botP;
                this.addSlowness(d, false);
            }
            d = -1.0;
            for (n = 0; n < this.SLayers.size(); ++n) {
                d2 = ((SlownessLayer)this.SLayers.elementAt((int)n)).topP;
                if (d2 != d) {
                    this.addSlowness(d2, true);
                }
                d = ((SlownessLayer)this.SLayers.elementAt((int)n)).botP;
                this.addSlowness(d, true);
            }
        }
        catch (NoSuchMatPropException noSuchMatPropException) {
            noSuchMatPropException.printStackTrace();
        }
    }

    protected void rayParamIncCheck() throws SlownessModelException, NoSuchLayerException {
        int n;
        double d;
        double d2;
        SlownessLayer slownessLayer;
        int n2;
        for (n2 = 0; n2 < this.SLayers.size(); ++n2) {
            slownessLayer = (SlownessLayer)this.SLayers.elementAt(n2);
            if (!(Math.abs(slownessLayer.topP - slownessLayer.botP) > this.maxDeltaP)) continue;
            d2 = Math.ceil(Math.abs(slownessLayer.topP - slownessLayer.botP) / this.maxDeltaP);
            d = (slownessLayer.topP - slownessLayer.botP) / d2;
            n = 1;
            while ((double)n < d2) {
                this.addSlowness(slownessLayer.topP + (double)n * d, true);
                this.addSlowness(slownessLayer.topP + (double)n * d, false);
                ++n;
            }
        }
        for (n2 = 0; n2 < this.PLayers.size(); ++n2) {
            slownessLayer = (SlownessLayer)this.PLayers.elementAt(n2);
            if (!(Math.abs(slownessLayer.topP - slownessLayer.botP) > this.maxDeltaP)) continue;
            d2 = Math.ceil(Math.abs(slownessLayer.topP - slownessLayer.botP) / this.maxDeltaP);
            d = (slownessLayer.topP - slownessLayer.botP) / d2;
            n = 1;
            while ((double)n < d2) {
                this.addSlowness(slownessLayer.topP + (double)n * d, true);
                this.addSlowness(slownessLayer.topP + (double)n * d, false);
                ++n;
            }
        }
    }

    protected void depthIncCheck() throws SlownessModelException, NoSuchLayerException {
        try {
            double d;
            int n;
            double d2;
            int n2;
            SlownessLayer slownessLayer;
            int n3;
            for (n3 = 0; n3 < this.SLayers.size(); ++n3) {
                slownessLayer = (SlownessLayer)this.SLayers.elementAt(n3);
                if (!(slownessLayer.botDepth - slownessLayer.topDepth > this.maxDepthInterval)) continue;
                n2 = (int)Math.ceil((slownessLayer.botDepth - slownessLayer.topDepth) / this.maxDepthInterval);
                d2 = (slownessLayer.botDepth - slownessLayer.topDepth) / (double)n2;
                for (n = 1; n < n2; ++n) {
                    double d3 = this.vMod.evaluateAbove(slownessLayer.topDepth + (double)n * d2, 'S');
                    if (d3 == 0.0 || !this.allowInnerCoreS && slownessLayer.topDepth + (double)n * d2 >= this.vMod.getIocbDepth()) {
                        d3 = this.vMod.evaluateAbove(slownessLayer.topDepth + (double)n * d2, 'P');
                    }
                    d = this.toSlowness(d3, slownessLayer.topDepth + (double)n * d2);
                    this.addSlowness(d, true);
                    this.addSlowness(d, false);
                }
            }
            for (n3 = 0; n3 < this.PLayers.size(); ++n3) {
                slownessLayer = (SlownessLayer)this.PLayers.elementAt(n3);
                if (!(slownessLayer.botDepth - slownessLayer.topDepth > this.maxDepthInterval)) continue;
                n2 = (int)Math.ceil((slownessLayer.botDepth - slownessLayer.topDepth) / this.maxDepthInterval);
                d2 = (slownessLayer.botDepth - slownessLayer.topDepth) / (double)n2;
                for (n = 1; n < n2; ++n) {
                    d = this.toSlowness(this.vMod.evaluateAbove(slownessLayer.topDepth + (double)n * d2, 'P'), slownessLayer.topDepth + (double)n * d2);
                    this.addSlowness(d, true);
                    this.addSlowness(d, false);
                }
            }
        }
        catch (NoSuchMatPropException noSuchMatPropException) {
            noSuchMatPropException.printStackTrace();
        }
    }

    protected void distanceCheck() throws SlownessModelException, NoSuchMatPropException, NoSuchLayerException {
        for (int i = 0; i < 2; ++i) {
            boolean bl = i != 0;
            boolean bl2 = !bl;
            TimeDist timeDist = null;
            TimeDist timeDist2 = null;
            TimeDist timeDist3 = null;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = 0;
            SlownessLayer slownessLayer = this.getSlownessLayer(0, bl);
            while (n < this.getNumLayers(bl)) {
                SlownessLayer slownessLayer2 = slownessLayer;
                slownessLayer = this.getSlownessLayer(n, bl);
                if (!this.depthInHighSlowness(slownessLayer.botDepth, slownessLayer.botP, bl) && !this.depthInHighSlowness(slownessLayer.topDepth, slownessLayer.topP, bl)) {
                    if (bl3) {
                        timeDist = bl4 ? timeDist2 : null;
                        timeDist2 = timeDist3;
                        bl4 = true;
                    } else {
                        timeDist2 = this.approxDistance(n - 1, slownessLayer.topP, bl);
                        bl4 = true;
                    }
                    timeDist3 = this.approxDistance(n, slownessLayer.botP, bl);
                    bl3 = true;
                    if (Math.abs(timeDist2.dist - timeDist3.dist) > this.maxRangeInterval && Math.abs(slownessLayer.topP - slownessLayer.botP) > 2.0 * this.minDeltaP) {
                        this.addSlowness((slownessLayer.topP + slownessLayer.botP) / 2.0, true);
                        this.addSlowness((slownessLayer.topP + slownessLayer.botP) / 2.0, false);
                        timeDist3 = timeDist2;
                        timeDist2 = timeDist;
                        continue;
                    }
                    if (timeDist != null && Math.abs(timeDist2.time - ((timeDist3.time - timeDist.time) * (timeDist2.dist - timeDist.dist) / (timeDist3.dist - timeDist.dist) + timeDist.time)) > this.maxInterpError) {
                        this.addSlowness((slownessLayer2.topP + slownessLayer2.botP) / 2.0, true);
                        this.addSlowness((slownessLayer2.topP + slownessLayer2.botP) / 2.0, false);
                        this.addSlowness((slownessLayer.topP + slownessLayer.botP) / 2.0, true);
                        this.addSlowness((slownessLayer.topP + slownessLayer.botP) / 2.0, false);
                        timeDist3 = timeDist;
                        bl4 = false;
                        slownessLayer = this.getSlownessLayer(--n - 1 >= 0 ? n - 1 : 0, bl);
                        continue;
                    }
                    if (!this.DEBUG || ++n % 100 != 0) continue;
                    System.out.print(" " + n);
                    continue;
                }
                timeDist = null;
                timeDist2 = null;
                timeDist3 = null;
                bl3 = false;
                bl4 = false;
                if (!this.DEBUG || ++n % 100 != 0) continue;
                System.out.print(" " + n);
            }
            if (!this.DEBUG) continue;
            System.out.println("\nNumber of " + (bl ? (char)'P' : 'S') + " slowness layers: " + n);
        }
    }

    protected void addSlowness(double d, boolean bl) throws SlownessModelException, NoSuchLayerException {
        Vector vector;
        Vector vector2;
        boolean bl2 = false;
        if (bl) {
            vector2 = this.PLayers;
            vector = this.SLayers;
        } else {
            vector2 = this.SLayers;
            vector = this.PLayers;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            double d2;
            double d3;
            SlownessLayer slownessLayer = (SlownessLayer)vector2.elementAt(i);
            try {
                if (slownessLayer.topDepth != slownessLayer.botDepth) {
                    d3 = this.vMod.evaluateBelow(slownessLayer.topDepth, bl ? (char)'P' : 'S');
                    d2 = this.vMod.evaluateAbove(slownessLayer.botDepth, bl ? (char)'P' : 'S');
                } else {
                    d3 = this.vMod.evaluateAbove(slownessLayer.botDepth, bl ? (char)'P' : 'S');
                    d2 = this.vMod.evaluateBelow(slownessLayer.topDepth, bl ? (char)'P' : 'S');
                }
            }
            catch (NoSuchMatPropException noSuchMatPropException) {
                throw new SlownessModelException("Caught NoSuchMatPropException: " + noSuchMatPropException.getMessage());
            }
            if (!bl) {
                if (!this.allowInnerCoreS && slownessLayer.botDepth > this.vMod.getIocbDepth()) break;
                if (d3 == 0.0) continue;
            }
            if (!((slownessLayer.topP - d) * (d - slownessLayer.botP) > 0.0)) continue;
            bl2 = true;
            SlownessLayer slownessLayer2 = (SlownessLayer)slownessLayer.clone();
            slownessLayer2.botP = d;
            if (slownessLayer.botDepth != slownessLayer.topDepth) {
                double d4 = (d2 - d3) / (slownessLayer.botDepth - slownessLayer.topDepth);
                slownessLayer2.botDepth = this.interpolate(d, d3, slownessLayer.topDepth, d4);
            }
            SlownessLayer slownessLayer3 = (SlownessLayer)slownessLayer.clone();
            slownessLayer3.topP = d;
            slownessLayer3.topDepth = slownessLayer2.botDepth;
            vector2.removeElementAt(i);
            vector2.insertElementAt(slownessLayer3, i);
            vector2.insertElementAt(slownessLayer2, i);
            int n = vector.indexOf(slownessLayer);
            if (n == -1) continue;
            vector.removeElementAt(n);
            vector.insertElementAt(slownessLayer3, n);
            vector.insertElementAt(slownessLayer2, n);
        }
    }

    protected void fixCriticalPoints() throws NoSuchLayerException {
        for (int i = 0; i < this.criticalDepthVector.size(); ++i) {
            CriticalDepth criticalDepth = (CriticalDepth)this.criticalDepthVector.elementAt(i);
            criticalDepth.PLayerNum = this.layerNumberBelow(criticalDepth.depth, true);
            SlownessLayer slownessLayer = this.getSlownessLayer(criticalDepth.PLayerNum, true);
            if (criticalDepth.PLayerNum == this.PLayers.size() - 1 && slownessLayer.botDepth == criticalDepth.depth) {
                ++criticalDepth.PLayerNum;
            }
            criticalDepth.SLayerNum = this.layerNumberBelow(criticalDepth.depth, false);
            slownessLayer = this.getSlownessLayer(criticalDepth.SLayerNum, false);
            if (criticalDepth.SLayerNum != this.SLayers.size() - 1 || slownessLayer.botDepth != criticalDepth.depth) continue;
            ++criticalDepth.SLayerNum;
        }
    }

    public int layerNumberAbove(double d, boolean bl) throws NoSuchLayerException {
        Vector vector = bl ? this.PLayers : this.SLayers;
        SlownessLayer slownessLayer = (SlownessLayer)vector.elementAt(0);
        if (slownessLayer.topDepth == d) {
            return 0;
        }
        if (d < slownessLayer.topDepth || ((SlownessLayer)vector.elementAt((int)(vector.size() - 1))).botDepth < d) {
            throw new NoSuchLayerException(d);
        }
        int n = 0;
        int n2 = vector.size() - 1;
        int n3 = 0;
        boolean bl2 = false;
        while (!bl2) {
            n3 = Math.round((float)(n + n2) / 2.0f);
            slownessLayer = this.getSlownessLayer(n3, bl);
            if (slownessLayer.topDepth >= d) {
                n2 = n3 - 1;
                continue;
            }
            if (slownessLayer.botDepth < d) {
                n = n3 + 1;
                continue;
            }
            bl2 = true;
        }
        return n3;
    }

    public int layerNumberBelow(double d, boolean bl) throws NoSuchLayerException {
        Vector vector = bl ? this.PLayers : this.SLayers;
        SlownessLayer slownessLayer = (SlownessLayer)vector.elementAt(0);
        if (slownessLayer.topDepth == d) {
            return 0;
        }
        slownessLayer = (SlownessLayer)vector.elementAt(vector.size() - 1);
        if (slownessLayer.botDepth == d) {
            return vector.size() - 1;
        }
        if (d < ((SlownessLayer)vector.elementAt((int)0)).topDepth || ((SlownessLayer)vector.elementAt((int)(vector.size() - 1))).botDepth < d) {
            throw new NoSuchLayerException(d);
        }
        int n = 0;
        int n2 = vector.size() - 1;
        int n3 = 0;
        boolean bl2 = false;
        while (!bl2) {
            n3 = Math.round((float)(n + n2) / 2.0f);
            slownessLayer = this.getSlownessLayer(n3, bl);
            if (slownessLayer.topDepth > d) {
                n2 = n3 - 1;
                continue;
            }
            if (slownessLayer.botDepth <= d) {
                n = n3 + 1;
                continue;
            }
            bl2 = true;
        }
        return n3;
    }

    public boolean validate() throws SlownessModelException {
        double d;
        int n;
        boolean bl = true;
        if (this.radiusOfEarth <= 0.0) {
            throw new SlownessModelException("Radius of earth is not positive. radiusOfEarth = " + this.radiusOfEarth);
        }
        if (this.maxDepthInterval <= 0.0) {
            throw new SlownessModelException("maxDepthInterval is not positive. maxDepthInterval = " + this.maxDepthInterval);
        }
        Vector vector = this.highSlownessLayerDepthsP;
        boolean bl2 = true;
        for (n = 0; n < 2; ++n) {
            vector = bl2 ? this.highSlownessLayerDepthsP : this.highSlownessLayerDepthsS;
            d = -1.7976931348623157E308;
            for (int i = 0; i < vector.size(); ++i) {
                DepthRange depthRange = (DepthRange)vector.elementAt(i);
                if (depthRange.topDepth >= depthRange.botDepth) {
                    throw new SlownessModelException("High slowness zone has zero or negative thickness. Num " + i + " isPWave=" + bl2 + " top depth " + depthRange.topDepth + " bottom depth " + depthRange.botDepth);
                }
                if (depthRange.topDepth <= d) {
                    throw new SlownessModelException("High slowness zone overlaps previous zone. Num " + i + " isPWave=" + bl2 + " top depth " + depthRange.topDepth + " bottom depth " + depthRange.botDepth);
                }
                d = depthRange.botDepth;
            }
            bl2 = false;
        }
        d = -1.7976931348623157E308;
        for (n = 0; n < this.fluidLayerDepths.size(); ++n) {
            DepthRange depthRange = (DepthRange)this.fluidLayerDepths.elementAt(n);
            if (depthRange.topDepth >= depthRange.botDepth) {
                throw new SlownessModelException("Fluid zone has zero or negative thickness. Num " + n + " top depth " + depthRange.topDepth + " bottom depth " + depthRange.botDepth);
            }
            if (depthRange.topDepth <= d) {
                throw new SlownessModelException("Fluid zone overlaps previous zone. Num " + n + " top depth " + depthRange.topDepth + " bottom depth " + depthRange.botDepth);
            }
            d = depthRange.botDepth;
        }
        bl2 = true;
        for (int i = 0; i < 2; ++i) {
            d = 0.0;
            double d2 = this.getNumLayers(bl2) > 0 ? this.getSlownessLayer((int)0, (boolean)bl2).topP : -1.0;
            for (int j = 0; j < this.getNumLayers(bl2); ++j) {
                SlownessLayer slownessLayer = this.getSlownessLayer(j, bl2);
                bl &= slownessLayer.validate();
                if (slownessLayer.topDepth > d) {
                    throw new SlownessModelException("Gap of " + (slownessLayer.topDepth - d) + " between slowness layers. Num " + j + " isPWave=" + bl2 + " top depth " + slownessLayer.topDepth + " bottom depth " + slownessLayer.botDepth);
                }
                if (slownessLayer.topDepth < d) {
                    throw new SlownessModelException("Slowness layer overlaps previous layer by " + (d - slownessLayer.topDepth) + ". Num " + j + " isPWave=" + bl2 + " top depth " + slownessLayer.topDepth + " bottom depth " + slownessLayer.botDepth);
                }
                if (slownessLayer.topP != d2) {
                    throw new SlownessModelException("Slowness layer gap/overlaps previous layer in slowness . Num " + j + " isPWave=" + bl2 + " prevBotP= " + d2 + " sLayer= " + slownessLayer);
                }
                if (Double.isNaN(slownessLayer.topDepth)) {
                    throw new SlownessModelException("Top depth is NaN, layerNum=" + j + " waveType=" + (bl2 ? (char)'P' : 'S'));
                }
                if (Double.isNaN(slownessLayer.botDepth)) {
                    throw new SlownessModelException("Top depth is NaN, layerNum=" + j + " waveType=" + (bl2 ? (char)'P' : 'S'));
                }
                d2 = slownessLayer.botP;
                d = slownessLayer.botDepth;
            }
            bl2 = false;
        }
        return bl;
    }

    public Object clone() {
        try {
            int n;
            SlownessModel slownessModel = (SlownessModel)super.clone();
            slownessModel.criticalDepthVector = new Vector(this.criticalDepthVector.size());
            for (n = 0; n < this.criticalDepthVector.size(); ++n) {
                slownessModel.criticalDepthVector.addElement(((CriticalDepth)this.criticalDepthVector.elementAt(n)).clone());
            }
            slownessModel.highSlownessLayerDepthsP = new Vector(this.highSlownessLayerDepthsP.size());
            for (n = 0; n < this.highSlownessLayerDepthsP.size(); ++n) {
                slownessModel.highSlownessLayerDepthsP.addElement(((DepthRange)this.highSlownessLayerDepthsP.elementAt(n)).clone());
            }
            slownessModel.highSlownessLayerDepthsS = new Vector(this.highSlownessLayerDepthsS.size());
            for (n = 0; n < this.highSlownessLayerDepthsS.size(); ++n) {
                slownessModel.highSlownessLayerDepthsS.addElement(((DepthRange)this.highSlownessLayerDepthsS.elementAt(n)).clone());
            }
            slownessModel.fluidLayerDepths = new Vector(this.fluidLayerDepths.size());
            for (n = 0; n < this.fluidLayerDepths.size(); ++n) {
                slownessModel.fluidLayerDepths.addElement(((DepthRange)this.fluidLayerDepths.elementAt(n)).clone());
            }
            slownessModel.PLayers = new Vector(this.getNumLayers(true));
            for (n = 0; n < this.getNumLayers(true); ++n) {
                slownessModel.PLayers.addElement(this.getSlownessLayerClone(n, true));
            }
            slownessModel.SLayers = new Vector(this.getNumLayers(false));
            for (n = 0; n < this.getNumLayers(false); ++n) {
                slownessModel.SLayers.addElement(this.getSlownessLayerClone(n, false));
            }
            return slownessModel;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Caught CloneNotSupportedException: " + cloneNotSupportedException.getMessage());
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        int n;
        String string = "";
        string = "radiusOfEarth=" + this.radiusOfEarth + "\n maxDeltaP=" + this.maxDeltaP + "\n minDeltaP=" + this.minDeltaP + "\n maxDepthInterval=" + this.maxDepthInterval + "\n maxRangeInterval=" + this.maxRangeInterval + "\n allowInnerCoreS=" + this.allowInnerCoreS + "\n slownessTolerance=" + this.slownessTolerance + "\n getNumLayers('P')=" + this.getNumLayers(true) + "\n getNumLayers('S')=" + this.getNumLayers(false) + "\n fluidLayerDepths.size()=" + this.fluidLayerDepths.size() + "\n highSlownessLayerDepthsP.size()=" + this.highSlownessLayerDepthsP.size() + "\n highSlownessLayerDepthsS.size()=" + this.highSlownessLayerDepthsS.size() + "\n criticalDepthVector.size()=" + this.criticalDepthVector.size() + "\n";
        if (this.criticalDepthVector.size() != 0) {
            string = string + "**** Critical Depth Layers ************************\n";
            int n2 = ((CriticalDepth)this.criticalDepthVector.elementAt((int)0)).velLayerNum - 1;
            for (n = 1; n < this.criticalDepthVector.size(); ++n) {
                int n3 = n2 + 1;
                n2 = ((CriticalDepth)this.criticalDepthVector.elementAt((int)n)).velLayerNum - 1;
                string = string + " " + n3 + "," + n2;
            }
        }
        string = string + "\n";
        if (this.fluidLayerDepths.size() != 0) {
            string = string + "\n**** Fluid Layer Depths ************************\n";
            for (n = 0; n < this.fluidLayerDepths.size(); ++n) {
                string = string + ((DepthRange)this.fluidLayerDepths.elementAt((int)n)).topDepth + "," + ((DepthRange)this.fluidLayerDepths.elementAt((int)n)).botDepth + " ";
            }
        }
        string = string + "\n";
        if (this.highSlownessLayerDepthsP.size() != 0) {
            string = string + "\n**** P High Slowness Layer Depths ****************\n";
            for (n = 0; n < this.highSlownessLayerDepthsP.size(); ++n) {
                string = string + ((DepthRange)this.highSlownessLayerDepthsP.elementAt((int)n)).topDepth + "," + ((DepthRange)this.highSlownessLayerDepthsP.elementAt((int)n)).botDepth + " ";
            }
        }
        string = string + "\n";
        if (this.highSlownessLayerDepthsS.size() != 0) {
            string = string + "\n**** S High Slowness Layer Depths ****************\n";
            for (n = 0; n < this.highSlownessLayerDepthsS.size(); ++n) {
                string = string + ((DepthRange)this.highSlownessLayerDepthsS.elementAt((int)n)).topDepth + "," + ((DepthRange)this.highSlownessLayerDepthsS.elementAt((int)n)).botDepth + " ";
            }
        }
        string = string + "\n";
        return string;
    }
}

