/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import net.alomax.awt.AJLButton;

public class PolygonButton
extends AJLButton {
    public static final Polygon[] LEFT_ARROW = new Polygon[1];
    public static final Polygon[] RIGHT_ARROW;
    public static final Polygon[] CIRCLE;
    protected Polygon[] polygon;
    protected Color polygonColor = this.getBackground().darker().darker();

    public PolygonButton(Polygon[] polygonArray, String string, ActionListener actionListener, KeyListener keyListener, boolean bl) {
        super(actionListener, keyListener, string, bl);
        this.polygon = polygonArray;
    }

    public PolygonButton(Polygon[] polygonArray, ActionListener actionListener, KeyListener keyListener, boolean bl) {
        this(polygonArray, "", actionListener, keyListener, bl);
    }

    public void setColors(Color color, Color color2, Color color3) {
        if (color3 != null) {
            this.polygonColor = color3;
        }
        super.setColors(color, color2);
    }

    public void setPolygon(Polygon[] polygonArray) {
        this.polygon = polygonArray;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        this.paintBackground(graphics, dimension);
        Rectangle rectangle = this.getDrawingRectangle();
        for (int i = 0; i < this.polygon.length; ++i) {
            int[] nArray = new int[this.polygon[i].npoints];
            int[] nArray2 = new int[this.polygon[i].npoints];
            for (int j = 0; j < this.polygon[i].npoints; ++j) {
                nArray[j] = rectangle.x + this.polygon[i].xpoints[j] * (rectangle.width - 0) / 1000;
                nArray2[j] = rectangle.y + (1000 - this.polygon[i].ypoints[j]) * (rectangle.height - 0) / 1000;
            }
            Polygon polygon = new Polygon(nArray, nArray2, nArray.length);
            if (this.isEnabled()) {
                graphics.setColor(this.polygonColor);
                graphics.fillPolygon(polygon);
                graphics.setColor(this.getForeground());
                graphics.drawPolygon(polygon);
                continue;
            }
            graphics.translate(1, 1);
            graphics.setColor(this.controlHighlight);
            graphics.drawPolygon(polygon);
            graphics.translate(-1, -1);
            graphics.setColor(this.controlShadow);
            graphics.drawPolygon(polygon);
        }
        this.paintLabel(graphics, dimension);
        this.paintBorder(graphics, dimension);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        super.processActionEvent(actionEvent);
    }

    static {
        int[] nArray = new int[]{300, 700, 700};
        int[] nArray2 = new int[]{500, 800, 200};
        PolygonButton.LEFT_ARROW[0] = new Polygon(nArray, nArray2, nArray.length);
        RIGHT_ARROW = new Polygon[1];
        nArray = new int[]{300, 300, 700};
        nArray2 = new int[]{200, 800, 500};
        PolygonButton.RIGHT_ARROW[0] = new Polygon(nArray, nArray2, nArray.length);
        CIRCLE = new Polygon[1];
        int n = 32;
        nArray2 = new int[n];
        int[] nArray3 = new int[n];
        double d = 0.0;
        double d2 = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            nArray2[i] = 499 + (int)(499.0 * Math.cos(d));
            nArray3[i] = 499 + (int)(499.0 * Math.sin(d));
            d += d2;
        }
        PolygonButton.CIRCLE[0] = new Polygon(nArray2, nArray3, nArray2.length);
    }
}

