/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.earthworm;

import java.util.Vector;
import net.alomax.earthworm.WSSiteChanNet;
import net.alomax.earthworm.WaveserverException;
import net.alomax.util.StringExt;

public class WSPacket {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_MENU = 0;
    public static final int TYPE_MENUPIN = 1;
    public static final int TYPE_MENUSCN = 2;
    public static final int TYPE_GETPIN = 3;
    public static final int TYPE_GETSCN = 4;
    public static final int TYPE_GETSCNRAW = 5;
    public int type = -1;
    public static final WSPacket WSTERMINATE = new WSPacket();
    public static final WSPacket WSNOPACKET = new WSPacket();
    public static final WSPacket WSERROR = new WSPacket();
    public byte[] reply = null;
    public String request_id = null;
    public WSSiteChanNet[] scnList = null;
    public String[] reply_fields = null;
    public byte[] reply_data = null;
    protected int WSPACKET_MIN_LENGTH = 10;

    protected WSPacket() {
    }

    public WSPacket(byte[] byArray, int n) throws WaveserverException {
        if (byArray == null || byArray.length < this.WSPACKET_MIN_LENGTH) {
            throw new WaveserverException("null, empty or incomplete Waveserver reply");
        }
        this.reply = byArray;
        this.type = n;
        int n2 = 0;
        try {
            int n3;
            int n4;
            int n5 = 0;
            while (byArray[n5++] != 10) {
                if (n5 != byArray.length) continue;
                throw new WaveserverException("failed to find \"\\n\" character parsing Waveserver reply: <" + byArray + ">");
            }
            String[] stringArray = null;
            if (n != 4) {
                stringArray = StringExt.parse(new String(byArray, 0, n5 - 1), " ");
                n2 = byArray.length;
            } else {
                int n6;
                stringArray = new String[9];
                for (n6 = 0; n6 < stringArray.length; ++n6) {
                    stringArray[n6] = new String();
                }
                n6 = 0;
                boolean bl = false;
                for (n4 = 0; n4 < byArray.length && n6 < stringArray.length; ++n4) {
                    if (byArray[n4] == 32) {
                        if (!bl) continue;
                        ++n6;
                        continue;
                    }
                    int n7 = n6;
                    stringArray[n7] = stringArray[n7] + (char)byArray[n4];
                    bl = true;
                }
                n2 = n4;
                System.out.println("TOKENS: ");
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    System.out.print(stringArray[n3] + " ");
                }
                System.out.println("");
            }
            this.request_id = stringArray[0];
            if (n == 0) {
                Vector<WSSiteChanNet> vector = new Vector<WSSiteChanNet>();
                n4 = 1;
                while (n4 < stringArray.length) {
                    String[] stringArray2 = new String[7];
                    for (n3 = 0; n3 < 7; ++n3) {
                        stringArray2[n3] = stringArray[n4++];
                    }
                    vector.add(WSSiteChanNet.createFromResponseToMENU(stringArray2));
                }
                this.scnList = new WSSiteChanNet[vector.size()];
                vector.copyInto(this.scnList);
            } else if (n == 2) {
                String[] stringArray3 = new String[stringArray.length - 1];
                for (n4 = 0; n4 < stringArray.length - 1; ++n4) {
                    stringArray3[n4] = stringArray[n4 + 1];
                }
                WSSiteChanNet wSSiteChanNet = WSSiteChanNet.createFromResponseToMENU(stringArray3);
                this.scnList = new WSSiteChanNet[1];
                this.scnList[0] = wSSiteChanNet;
            } else if (n == 4) {
                String[] stringArray4 = new String[stringArray.length - 1];
                for (n4 = 0; n4 < stringArray.length - 1; ++n4) {
                    stringArray4[n4] = stringArray[n4 + 1];
                }
                WSSiteChanNet wSSiteChanNet = WSSiteChanNet.createFromResponseToGETSCN(stringArray4);
                this.scnList = new WSSiteChanNet[1];
                this.scnList[0] = wSSiteChanNet;
                this.reply_data = new byte[byArray.length - n2];
                System.arraycopy(byArray, n2, this.reply_data, 0, this.reply_data.length);
            } else if (n == 5) {
                String[] stringArray5 = new String[stringArray.length - 1];
                for (n4 = 0; n4 < stringArray.length - 1; ++n4) {
                    stringArray5[n4] = stringArray[n4 + 1];
                }
                WSSiteChanNet wSSiteChanNet = WSSiteChanNet.createFromResponseToGETSCNRAW(stringArray5);
                this.scnList = new WSSiteChanNet[1];
                this.scnList[0] = wSSiteChanNet;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new WaveserverException("parsing Waveserver reply: <" + new String(byArray, 0, n2) + ">: " + exception);
        }
    }

    public String toString() {
        return new String(this.reply);
    }
}

