/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.freq;

import net.alomax.freq.FilterException;
import net.alomax.freq.FreqText;
import net.alomax.freq.FrequencyDomainProcess;
import net.alomax.math.Cmplx;
import net.alomax.math.TimeSeries;

public class GaussianFilter
implements FrequencyDomainProcess {
    public double centFreq;
    public double alpha;
    public String errorMessage;
    private static final double FREQ_MIN = Double.MIN_VALUE;
    private static final double FREQ_MAX = Double.MAX_VALUE;
    private static final double ALPHA_MIN = Double.MIN_VALUE;
    private static final double ALPHA_MAX = Double.MAX_VALUE;

    public GaussianFilter(String string, double d, double d2) {
        this.centFreq = d;
        this.alpha = d2;
        this.errorMessage = " ";
        FreqText.setLocale(string);
    }

    public void setCentFreq(double d) throws FilterException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new FilterException(FreqText.invalid_center_frequency);
        }
        this.centFreq = d;
    }

    public void setCentFreq(String string) throws FilterException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FilterException(FreqText.invalid_center_frequency);
        }
        this.setCentFreq(d);
    }

    public void setAlpha(double d) throws FilterException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new FilterException(FreqText.invalid_alpha_value);
        }
        this.alpha = d;
    }

    public void setAlpha(String string) throws FilterException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FilterException(FreqText.invalid_alpha_value);
        }
        this.setAlpha(d);
    }

    public void checkSettings() throws FilterException {
        String string = "";
        int n = 0;
        if (this.centFreq < Double.MIN_VALUE || this.centFreq > Double.MAX_VALUE) {
            string = string + ": " + FreqText.invalid_center_frequency;
            ++n;
        }
        if (this.alpha < Double.MIN_VALUE || this.alpha > Double.MAX_VALUE) {
            string = string + ": " + FreqText.invalid_alpha_value;
            ++n;
        }
        if (n > 0) {
            throw new FilterException(string + ".");
        }
    }

    public final Cmplx[] apply(double d, Cmplx[] cmplxArray) {
        double d2 = Math.PI * 2 * this.centFreq;
        double d3 = Math.PI * 2 / (((double)(cmplxArray.length - 1) + 1.0) * d);
        int n = cmplxArray.length;
        int n2 = cmplxArray.length / 2;
        Cmplx cmplx = new Cmplx(0.5, 0.0);
        for (int i = 0; i < n2; ++i) {
            double d4 = d3 * (double)(i + 1);
            double d5 = (d4 - d2) / d2;
            Cmplx cmplx2 = new Cmplx(Math.exp(-this.alpha * d5 * d5), 0.0);
            int n3 = i + 1;
            int n4 = n - 1 - i;
            if (i != n2 - 1) {
                cmplxArray[n3].mul(cmplx2);
                cmplxArray[n4].mul(cmplx2);
                continue;
            }
            cmplxArray[n3].mul(cmplx2.mul(cmplx));
        }
        cmplxArray[0] = new Cmplx(0.0, 0.0);
        return cmplxArray;
    }

    public float[] preProcess(double d, float[] fArray) {
        return fArray;
    }

    public float[] postProcess(double d, float[] fArray) {
        return fArray;
    }

    public boolean sampleChangedInPreProcess() {
        return false;
    }

    public boolean sampleChangedInPostProcess() {
        return false;
    }

    public void updateFields(TimeSeries timeSeries) {
    }
}

