/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.freq;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import net.alomax.freq.FreqText;
import net.alomax.freq.Response;
import net.alomax.freq.ResponseException;
import net.alomax.io.GeneralInputStream;
import net.alomax.math.Cmplx;
import net.alomax.math.TimeSeries;
import net.alomax.seis.BasicChannel;
import net.alomax.util.PhysicalUnits;
import net.alomax.util.TimeInstant;
import sdsu.io.ASCIIInputStream;

public class PoleZeroResponse
extends Response {
    protected static final boolean DEBUG = false;
    private static int n_static_init = 0;
    public static int LAPLACE = n_static_init++;
    public static int Z = n_static_init++;
    protected int transformType = LAPLACE;
    public double gain = 1.0;
    public Cmplx[] poles = new Cmplx[0];
    public Cmplx[] zeros = new Cmplx[0];
    private static final int KEY = 0;
    private static final int POLE = 1;
    private static final int ZERO = 2;

    public PoleZeroResponse() {
    }

    public PoleZeroResponse(PoleZeroResponse poleZeroResponse) {
        super(poleZeroResponse);
        this.transformType = poleZeroResponse.transformType;
        this.gain = poleZeroResponse.gain;
        this.poles = new Cmplx[poleZeroResponse.poles.length];
        System.arraycopy(poleZeroResponse.poles, 0, this.poles, 0, poleZeroResponse.poles.length);
        this.zeros = new Cmplx[poleZeroResponse.zeros.length];
        System.arraycopy(poleZeroResponse.zeros, 0, this.zeros, 0, poleZeroResponse.zeros.length);
    }

    public PoleZeroResponse(double d, Cmplx[] cmplxArray, Cmplx[] cmplxArray2, String string, String string2, int n) {
        int n2;
        this.gain = d;
        this.type = n;
        if (cmplxArray != null) {
            this.poles = new Cmplx[cmplxArray.length];
            for (n2 = 0; n2 < cmplxArray.length; ++n2) {
                this.poles[n2] = new Cmplx(cmplxArray[n2]);
            }
        }
        if (cmplxArray2 != null) {
            this.zeros = new Cmplx[cmplxArray2.length];
            for (n2 = 0; n2 < cmplxArray2.length; ++n2) {
                this.zeros[n2] = new Cmplx(cmplxArray2[n2]);
            }
        }
        if (string != null) {
            this.shortName = string;
        }
        if (string2 != null) {
            this.longName = string2;
        }
    }

    public PoleZeroResponse(double d, Cmplx[] cmplxArray, Cmplx[] cmplxArray2, String string, String string2, int n, String[] stringArray, String[] stringArray2, String string3, String string4) {
        this(d, cmplxArray, cmplxArray2, string, string2, n);
        this.setBeforeUnits(stringArray);
        this.setAfterUnits(stringArray2);
        this.setBeforeName(string3);
        this.setAfterName(string4);
    }

    public PoleZeroResponse(URL uRL, String string, TimeInstant timeInstant, BasicChannel basicChannel, TimeSeries timeSeries) throws ResponseException {
        String[] stringArray;
        String[] stringArray2;
        try {
            stringArray2 = null;
            stringArray2 = GeneralInputStream.openStream(uRL, string, true);
            stringArray = new ASCIIInputStream(new BufferedInputStream((InputStream)stringArray2));
            this.read((ASCIIInputStream)stringArray);
            stringArray.close();
        }
        catch (IOException iOException) {
            throw new ResponseException(iOException.getMessage());
        }
        if (string != null) {
            this.shortName = new String(string);
            this.longName = new String(string);
        }
        stringArray2 = new String[]{PhysicalUnits.getDefaultLengthUnits()};
        this.setBeforeUnits(stringArray2);
        stringArray = new String[]{"counts"};
        this.setAfterUnits(stringArray);
        this.setBeforeName(GROUND_DISP_NAME);
        if (basicChannel != null) {
            this.setAfterName(basicChannel.instName);
        }
        this.setType(Response.OTHER_CONVERSION);
        if (timeSeries != null) {
            this.dt = timeSeries.sampleInt;
        }
    }

    public int getIntegralOrDerivative() {
        return DERIVATIVE;
    }

    public double getGain() {
        return this.gain;
    }

    public void setTransformType(int n) {
        this.transformType = n;
    }

    public int getTransformType() {
        return this.transformType;
    }

    public PoleZeroResponse convertToZ() throws ResponseException {
        int n;
        if (this.transformType == Z) {
            throw new ResponseException(FreqText.response_already_z);
        }
        PoleZeroResponse poleZeroResponse = new PoleZeroResponse(this);
        for (n = 0; n < this.zeros.length; ++n) {
            poleZeroResponse.zeros[n] = Cmplx.exp(Cmplx.mul(this.zeros[n], this.dt));
        }
        for (n = 0; n < this.poles.length; ++n) {
            poleZeroResponse.poles[n] = Cmplx.exp(Cmplx.mul(this.poles[n], this.dt));
        }
        poleZeroResponse.transformType = Z;
        return poleZeroResponse;
    }

    protected void read(ASCIIInputStream aSCIIInputStream) throws ResponseException, IOException {
        String string;
        this.gain = 1.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        block5: while ((string = aSCIIInputStream.readLine()) != null) {
            int n4;
            int n5;
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens() || (string2 = stringTokenizer.nextToken()).startsWith("*") || string2.startsWith("#")) continue;
            if (string2.equalsIgnoreCase("CONSTANT")) {
                this.gain = Double.valueOf(stringTokenizer.nextToken());
                n = 0;
                continue;
            }
            if (string2.equalsIgnoreCase("ZEROS")) {
                n5 = Integer.valueOf(stringTokenizer.nextToken());
                if (n5 < 0) {
                    throw new ResponseException(FreqText.invalid_number_of_zeros + ": " + n5);
                }
                this.zeros = new Cmplx[n5];
                for (n4 = 0; n4 < this.zeros.length; ++n4) {
                    this.zeros[n4] = new Cmplx(0.0, 0.0);
                }
                if (n5 > 0) {
                    n = 2;
                    continue;
                }
                n = 0;
                continue;
            }
            if (string2.equalsIgnoreCase("POLES")) {
                n5 = Integer.valueOf(stringTokenizer.nextToken());
                if (n5 < 0) {
                    throw new ResponseException(FreqText.invalid_number_of_poles + ": " + n5);
                }
                this.poles = new Cmplx[n5];
                for (n4 = 0; n4 < this.poles.length; ++n4) {
                    this.poles[n4] = new Cmplx(0.0, 0.0);
                }
                if (n5 > 0) {
                    n = 1;
                    continue;
                }
                n = 0;
                continue;
            }
            switch (n) {
                case 0: {
                    throw new ResponseException(FreqText.invalid_keyword + ": " + string2);
                }
                case 2: {
                    if (n2 >= this.zeros.length) {
                        throw new ResponseException(FreqText.too_many_zeros_read);
                    }
                    this.zeros[n2] = new Cmplx(Double.valueOf(string2), Double.valueOf(stringTokenizer.nextToken()));
                    if (++n2 != this.zeros.length) continue block5;
                    n = 0;
                    continue block5;
                }
                case 1: {
                    if (n3 >= this.poles.length) {
                        throw new ResponseException(FreqText.too_many_poles_read);
                    }
                    this.poles[n3] = new Cmplx(Double.valueOf(string2), Double.valueOf(stringTokenizer.nextToken()));
                    if (++n3 != this.poles.length) continue block5;
                    n = 0;
                    continue block5;
                }
            }
        }
    }

    public final Cmplx[] response(int n, double d) {
        int n2 = n;
        Cmplx[] cmplxArray = new Cmplx[n2];
        double d2 = Math.PI * 2 / ((double)n * d);
        cmplxArray[0] = new Cmplx(0.0, 0.0);
        for (int i = 1; i <= n2 / 2; ++i) {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            int n3;
            int n4 = n2 - i;
            double d8 = d2 * (double)i;
            double d9 = 1.0;
            double d10 = 0.0;
            for (n3 = 0; n3 < this.zeros.length; ++n3) {
                d7 = -this.zeros[n3].r;
                d6 = d8 - this.zeros[n3].i;
                d5 = d9 * d7 - d10 * d6;
                d4 = d9 * d6 + d10 * d7;
                d9 = d5;
                d10 = d4;
            }
            double d11 = 1.0;
            double d12 = 0.0;
            for (n3 = 0; n3 < this.poles.length; ++n3) {
                d7 = -this.poles[n3].r;
                d6 = d8 - this.poles[n3].i;
                d5 = d11 * d7 - d12 * d6;
                d4 = d11 * d6 + d12 * d7;
                d11 = d5;
                d12 = d4;
            }
            if (i != n2 / 2) {
                d3 = this.gain / (d11 * d11 + d12 * d12);
                d5 = d3 * (d9 * d11 + d10 * d12);
                d4 = -d3 * (d10 * d11 - d9 * d12);
                cmplxArray[i] = new Cmplx(d5, d4);
                cmplxArray[n4] = new Cmplx(d5, -d4);
                continue;
            }
            d3 = 0.5 * this.gain / (d11 * d11 + d12 * d12);
            d5 = d3 * (d9 * d11 + d10 * d12);
            d4 = d3 * (d10 * d11 - d9 * d12);
            cmplxArray[i] = new Cmplx(d5, d4);
        }
        return cmplxArray;
    }

    public final Response div(Response response) throws ResponseException {
        int n;
        PoleZeroResponse poleZeroResponse = this;
        PoleZeroResponse poleZeroResponse2 = null;
        try {
            poleZeroResponse2 = (PoleZeroResponse)response;
        }
        catch (ClassCastException classCastException) {
            throw new ResponseException(FreqText.cannot_divide_argument_is_not_a_PoleZeroResponse);
        }
        PoleZeroResponse poleZeroResponse3 = new PoleZeroResponse();
        poleZeroResponse3.gain = poleZeroResponse.gain / poleZeroResponse2.gain;
        poleZeroResponse3.poles = new Cmplx[poleZeroResponse.poles.length + poleZeroResponse2.zeros.length];
        poleZeroResponse3.zeros = new Cmplx[poleZeroResponse.zeros.length + poleZeroResponse2.poles.length];
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < poleZeroResponse.poles.length; ++n) {
            poleZeroResponse3.poles[n3++] = new Cmplx(poleZeroResponse.poles[n]);
        }
        for (n = 0; n < poleZeroResponse.zeros.length; ++n) {
            poleZeroResponse3.zeros[n2++] = new Cmplx(poleZeroResponse.zeros[n]);
        }
        for (n = 0; n < poleZeroResponse2.poles.length; ++n) {
            poleZeroResponse3.zeros[n2++] = new Cmplx(poleZeroResponse2.poles[n]);
        }
        for (n = 0; n < poleZeroResponse2.zeros.length; ++n) {
            poleZeroResponse3.poles[n3++] = new Cmplx(poleZeroResponse2.zeros[n]);
        }
        return poleZeroResponse3;
    }

    public final Cmplx evaluateResponse(double d) {
        Cmplx cmplx = new Cmplx(0.0, d * 2.0 * Math.PI);
        Cmplx cmplx2 = new Cmplx(1.0, 0.0);
        for (int i = 0; i < this.zeros.length; ++i) {
            cmplx2 = cmplx2.mul(new Cmplx(Cmplx.sub(cmplx, this.zeros[i])));
        }
        Cmplx cmplx3 = new Cmplx(1.0, 0.0);
        for (int i = 0; i < this.poles.length; ++i) {
            cmplx3 = cmplx3.mul(new Cmplx(Cmplx.sub(cmplx, this.poles[i])));
        }
        Cmplx cmplx4 = Cmplx.mul(Cmplx.div(cmplx2, cmplx3), this.gain);
        return cmplx4;
    }

    public String toString() {
        int n;
        String string = "";
        string = string + "-----------\n";
        string = string + "SHORT_NAME " + this.shortName + "; ";
        string = string + "LONG_NAME " + this.longName + "; ";
        string = string + "TYPE " + this.type + "\n";
        string = string + "CONSTANT " + this.gain + "\n";
        string = string + "POLES " + this.poles.length + "\n";
        for (n = 0; n < this.poles.length; ++n) {
            string = string + "   " + this.poles[n].r + "  " + this.poles[n].i + "\n";
        }
        string = string + "ZEROS " + this.zeros.length + "\n";
        for (n = 0; n < this.zeros.length; ++n) {
            string = string + "   " + this.zeros[n].r + "  " + this.zeros[n].i + "\n";
        }
        string = string + "-----------\n";
        return string;
    }

    public static void main(String[] stringArray) {
        Cmplx[] cmplxArray;
        PoleZeroResponse poleZeroResponse = null;
        try {
            poleZeroResponse = new PoleZeroResponse(null, stringArray[0], null, null, null);
            System.out.println(poleZeroResponse);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
        try {
            cmplxArray = (Cmplx[])poleZeroResponse.div(poleZeroResponse);
            System.out.println(cmplxArray);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
        try {
            cmplxArray = poleZeroResponse.response(64, 0.1);
            for (int i = 0; i < cmplxArray.length; ++i) {
                System.out.println(cmplxArray[i]);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }
}

