/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.alomax.geog.EarthEllipsoid;
import net.alomax.geog.Position;
import net.alomax.graphics3d.Vect2D;
import net.alomax.graphics3d.Vect3D;
import sdsu.io.ASCIIInputStream;

public class GeogCoords {
    protected static final String ProgName = "GeogCoords: ";
    public static final double EARTH_RADIUS = 6371.0;
    public boolean splitLastAtCentralMeridan = false;
    public static final double PI_2 = Math.PI * 2;
    public static final double D2R = Math.PI / 180;
    public static final double R2D = 57.29577951308232;
    protected double EQ_RAD;
    protected double ECC;
    protected double ECC2;
    protected double ECC4;
    protected double ECC6;
    protected double M_PR_DEG;
    protected boolean NorthPole;
    protected double CentralMeridian;
    protected double Pole;
    protected double LambertConfConic_N;
    protected double LambertConfConic_F;
    protected double LambertConfConic_rho0;
    protected static final int N_ELLIPSOIDS = 13;
    protected static EarthEllipsoid[] ellipse = new EarthEllipsoid[13];
    public static final double DEG2KM = 111.11111111111111;
    public static final double KM2DEG = 0.009;
    public int transformType = -1;
    public boolean initialized = false;
    public static final int GLOBAL = 1;
    protected static final double RAD_PER_DEG = Math.PI / 180;
    protected String transformName = "UNDEF";
    protected double latOrig = 0.0;
    protected double longOrig = 0.0;
    protected double rotAngle = 0.0;
    protected double transCos = 0.0;
    protected double transSin = 0.0;
    protected String refEllipsoid;
    protected static final int SIMPLE = 2;
    protected double C111 = 111.11111111111111;
    protected boolean convergence = true;
    protected static final int LAMBERT = 3;
    protected double Lambert1stStdParall = -100.0;
    protected double Lambert2ndStdParall = -100.0;

    static double d_log(double d) {
        return d <= 0.0 ? -1.0E10 : Math.log(d);
    }

    static double d_sqrt(double d) {
        return d < 0.0 ? 0.0 : Math.sqrt(d);
    }

    public GeogCoords() {
        this.transformType = 1;
        this.initialized = true;
    }

    public GeogCoords(double d, double d2, double d3, boolean bl) {
        this.latOrig = d;
        this.longOrig = d2;
        this.rotAngle = d3;
        this.convergence = bl;
        this.transformName = bl ? "SIMPLE" : "EQUIRECTANGULAR";
        this.init();
    }

    public GeogCoords(double d, double d2, double d3) {
        this.latOrig = d;
        this.longOrig = d2;
        this.rotAngle = d3;
        this.convergence = true;
        this.transformName = "SIMPLE";
        this.init();
    }

    public GeogCoords(String string, double d, double d2, double d3, double d4, double d5) {
        this.transformName = this.transformName;
        this.latOrig = d;
        this.longOrig = d2;
        this.rotAngle = d5;
        this.refEllipsoid = string;
        this.Lambert1stStdParall = d3;
        this.Lambert2ndStdParall = d4;
        this.transformName = "LAMBERT";
        this.init();
    }

    public GeogCoords(ASCIIInputStream aSCIIInputStream) {
        try {
            this.transformName = aSCIIInputStream.readWord();
            String string = aSCIIInputStream.readWord();
            if (!this.transformName.equals("GLOBAL")) {
                if (this.transformName.equals("SDC") || this.transformName.equals("SIMPLE") || this.transformName.equals("EQUIRECTANGULAR")) {
                    this.latOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.longOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.rotAngle = aSCIIInputStream.readFloat();
                    this.convergence = !this.transformName.equals("EQUIRECTANGULAR");
                } else if (this.transformName.equals("LAMBERT")) {
                    this.refEllipsoid = aSCIIInputStream.readWord();
                    string = aSCIIInputStream.readWord();
                    this.latOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.longOrig = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.Lambert1stStdParall = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.Lambert2ndStdParall = aSCIIInputStream.readFloat();
                    string = aSCIIInputStream.readWord();
                    this.rotAngle = aSCIIInputStream.readFloat();
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("ERROR: reading geographic coordinates transform.");
        }
        this.init();
    }

    protected void init() {
        if (this.transformName.equals("GLOBAL")) {
            this.transformType = 1;
            this.initialized = true;
        } else if (this.transformName.equals("SDC") || this.transformName.equals("SIMPLE") || this.transformName.equals("EQUIRECTANGULAR")) {
            if (this.longOrig > 180.0) {
                this.longOrig -= 360.0;
            } else if (this.longOrig < -180.0) {
                this.longOrig += 360.0;
            }
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            this.transformType = 2;
            this.initialized = true;
        } else if (this.transformName.equals("LAMBERT")) {
            if (this.longOrig > 180.0) {
                this.longOrig -= 360.0;
            } else if (this.longOrig < -180.0) {
                this.longOrig += 360.0;
            }
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            int n = this.mapSetup(this.refEllipsoid);
            if (n < 0) {
                System.out.println("GeogCoords: ERROR: unrecognized reference ellipsoid: <" + this.refEllipsoid + ">");
            } else {
                this.vlamb(this.latOrig, this.longOrig, this.Lambert1stStdParall, this.Lambert2ndStdParall);
                this.transformType = 3;
                this.initialized = true;
            }
        } else {
            System.out.println("GeogCoords: ERROR: unrecognized geographic tranform type: <" + this.transformName + ">");
        }
    }

    public String getTransformName() {
        return this.transformName;
    }

    public double getRotationAngle() {
        return this.rotAngle;
    }

    public boolean isGlobal() {
        return this.transformType == 1;
    }

    protected int mapSetup(String string) {
        int n;
        for (n = 0; n < ellipse.length && !string.equals(GeogCoords.ellipse[n].name); ++n) {
        }
        if (n == 13) {
            return -1;
        }
        this.EQ_RAD = GeogCoords.ellipse[n].eq_radius;
        double d = GeogCoords.ellipse[n].flattening;
        this.ECC2 = 2.0 * d - d * d;
        this.ECC4 = this.ECC2 * this.ECC2;
        this.ECC6 = this.ECC2 * this.ECC4;
        this.ECC = GeogCoords.d_sqrt(this.ECC2);
        return n;
    }

    protected void vlamb(double d, double d2, double d3, double d4) {
        this.NorthPole = d > 0.0;
        this.Pole = this.NorthPole ? 90.0 : -90.0;
        double d5 = Math.tan(0.7853981633974483 - 0.5 * (d3 *= Math.PI / 180)) / Math.pow((1.0 - this.ECC * Math.sin(d3)) / (1.0 + this.ECC * Math.sin(d3)), 0.5 * this.ECC);
        double d6 = Math.cos(d3) / GeogCoords.d_sqrt(1.0 - this.ECC2 * Math.pow(Math.sin(d3), 2.0));
        double d7 = Math.tan(0.7853981633974483 - 0.5 * (d4 *= Math.PI / 180)) / Math.pow((1.0 - this.ECC * Math.sin(d4)) / (1.0 + this.ECC * Math.sin(d4)), 0.5 * this.ECC);
        double d8 = Math.cos(d4) / GeogCoords.d_sqrt(1.0 - this.ECC2 * Math.pow(Math.sin(d4), 2.0));
        double d9 = Math.tan(0.7853981633974483 - 0.5 * d * (Math.PI / 180)) / Math.pow((1.0 - this.ECC * Math.sin(d * (Math.PI / 180))) / (1.0 + this.ECC * Math.sin(d * (Math.PI / 180))), 0.5 * this.ECC);
        this.LambertConfConic_N = d3 != d4 ? (GeogCoords.d_log(d6) - GeogCoords.d_log(d8)) / (GeogCoords.d_log(d5) - GeogCoords.d_log(d7)) : Math.sin(d3);
        this.LambertConfConic_F = d6 / (this.LambertConfConic_N * Math.pow(d5, this.LambertConfConic_N));
        this.CentralMeridian = d2;
        this.LambertConfConic_rho0 = this.EQ_RAD * this.LambertConfConic_F * Math.pow(d9, this.LambertConfConic_N);
    }

    public Vect2D xy2geog(double d, double d2) {
        if (!this.initialized) {
            System.out.println("GeogCoords WARNING: geographic conversion used but not initialized.");
        }
        if (this.transformType == 1) {
            System.out.println("GeogCoords ERROR: Cannot convert x,y to GLOBAL geographic conversion.");
            return new Vect2D(0.0, 0.0);
        }
        if (this.transformType == 2) {
            double d3 = d * this.transCos + d2 * this.transSin;
            double d4 = d2 * this.transCos - d * this.transSin;
            double d5 = this.latOrig + d4 / this.C111;
            double d6 = 0.0;
            d6 = this.convergence ? this.longOrig + d3 / (this.C111 * Math.cos(Math.PI / 180 * d5)) : this.longOrig + d3 / this.C111;
            return new Vect2D(d5, d6);
        }
        if (this.transformType == 3) {
            return this.ilamb(d, d2);
        }
        return new Vect2D(0.0, 0.0);
    }

    public Vect2D geog2xy(double d, double d2) {
        if (!this.initialized) {
            System.out.println("GeogCoords WARNING: geographic conversion used but not initialized.");
        }
        if (this.transformType == 1) {
            double d3 = Math.sin(d * (Math.PI / 180));
            double d4 = Math.cos(d2 * (Math.PI / 180));
            double d5 = Math.sin(d2 * (Math.PI / 180));
            double d6 = 6371.0 * d4 * d3;
            double d7 = 6371.0 * d5 * d3;
            return new Vect2D(d6, d7);
        }
        if (this.transformType == 2) {
            double d8 = d2 - this.longOrig;
            this.splitLastAtCentralMeridan = false;
            if (d8 > 180.0) {
                d8 -= 360.0;
                this.splitLastAtCentralMeridan = true;
            }
            if (d8 < -180.0) {
                d8 += 360.0;
                this.splitLastAtCentralMeridan = true;
            }
            double d9 = 0.0;
            d9 = this.convergence ? Math.cos(Math.PI / 180 * d) * d8 * this.C111 : d8 * this.C111;
            double d10 = (d - this.latOrig) * this.C111;
            double d11 = d9 * this.transCos - d10 * this.transSin;
            double d12 = d10 * this.transCos + d9 * this.transSin;
            return new Vect2D(d11, d12);
        }
        if (this.transformType == 3) {
            return this.lamb(d, d2);
        }
        return new Vect2D(0.0, 0.0);
    }

    public Vect3D xyz2geog(Vect3D vect3D) {
        return this.xyz2geog(vect3D.x, vect3D.y, vect3D.z);
    }

    public Vect3D xyz2geog(double d, double d2, double d3) {
        if (!this.initialized) {
            System.out.println("GeogCoords WARNING: geographic conversion used but not initialized.");
        }
        if (this.transformType == 1) {
            double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
            double d5 = Math.asin(d3 / d4);
            double d6 = Math.atan2(d2, d);
            d5 /= Math.PI / 180;
            if ((d6 /= Math.PI / 180) > 180.0) {
                d6 -= 360.0;
            } else if (d6 < -180.0) {
                d6 += 360.0;
            }
            return new Vect3D(d5, d6, 6371.0 - d4);
        }
        return new Vect3D(this.xy2geog(d, d2), -d3);
    }

    public Vect3D geog2xyz(Vect3D vect3D) {
        return this.geog2xyz(vect3D.x, vect3D.y, vect3D.z);
    }

    public Vect3D geog2xyz(Position position) {
        return this.geog2xyz(position.latitude, position.longitude, position.depth - position.elevation / 1000.0);
    }

    public Vect3D geog2xyz(double d, double d2, double d3) {
        if (!this.initialized) {
            System.out.println("GeogCoords WARNING: geographic conversion used but not initialized.");
        }
        if (this.transformType == 1) {
            double d4 = Math.cos(d * (Math.PI / 180));
            double d5 = Math.sin(d * (Math.PI / 180));
            double d6 = Math.cos(d2 * (Math.PI / 180));
            double d7 = Math.sin(d2 * (Math.PI / 180));
            double d8 = (6371.0 - d3) * d6 * d4;
            double d9 = (6371.0 - d3) * d7 * d4;
            double d10 = (6371.0 - d3) * d5;
            return new Vect3D(d8, d9, d10);
        }
        return new Vect3D(this.geog2xy(d, d2), -d3);
    }

    public double geogAng2xyAng(double d) {
        if (!this.initialized) {
            System.out.println("GeogCoords WARNING: geographic conversion used but not initialized.");
        }
        if (this.transformType == 2 || this.transformType == 3) {
            double d2 = d + this.rotAngle;
            if (d2 > 360.0) {
                d2 -= 360.0;
            }
            if (d2 < 0.0) {
                d2 += 360.0;
            }
            return d2;
        }
        return d;
    }

    public Vect2D lamb(double d, double d2) {
        double d3 = d2;
        double d4 = d;
        this.splitLastAtCentralMeridan = false;
        while (d3 - this.CentralMeridian < -180.0) {
            d3 += 360.0;
            this.splitLastAtCentralMeridan = true;
        }
        while (d3 - this.CentralMeridian > 180.0) {
            d3 -= 360.0;
            this.splitLastAtCentralMeridan = true;
        }
        double d5 = Math.pow((1.0 - this.ECC * Math.sin(d4 *= Math.PI / 180)) / (1.0 + this.ECC * Math.sin(d4)), 0.5 * this.ECC);
        double d6 = Math.tan(0.7853981633974483 - 0.5 * d4);
        if (Math.abs(d6) < Double.MIN_VALUE) {
            d6 = 0.0;
        }
        double d7 = d6 == 0.0 ? 0.0 : Math.pow(d6 / d5, this.LambertConfConic_N);
        double d8 = this.EQ_RAD * this.LambertConfConic_F * d7;
        double d9 = this.LambertConfConic_N * (d3 - this.CentralMeridian) * (Math.PI / 180);
        double d10 = d8 * Math.sin(d9);
        double d11 = this.LambertConfConic_rho0 - d8 * Math.cos(d9);
        double d12 = d10 * this.transCos - d11 * this.transSin;
        double d13 = d11 * this.transCos + d10 * this.transSin;
        return new Vect2D(d12 / 1000.0, d13 / 1000.0);
    }

    public Vect2D ilamb(double d, double d2) {
        double d3 = (d *= 1000.0) * this.transCos + (d2 *= 1000.0) * this.transSin;
        double d4 = d2 * this.transCos - d * this.transSin;
        double d5 = Math.atan(d3 / (this.LambertConfConic_rho0 - d4));
        double d6 = d5 / this.LambertConfConic_N * 57.29577951308232 + this.CentralMeridian;
        double d7 = d3 * d3 + (this.LambertConfConic_rho0 - d4) * (this.LambertConfConic_rho0 - d4);
        double d8 = this.LambertConfConic_N < 0.0 ? -Math.sqrt(d7) : Math.sqrt(d7);
        double d9 = Math.pow(d8 / (this.EQ_RAD * this.LambertConfConic_F), 1.0 / this.LambertConfConic_N);
        double d10 = 1.5707963267948966 - 2.0 * Math.atan(d9);
        double d11 = 1.0;
        double d12 = 0.0;
        for (int i = 0; i < 100 && d11 > 1.0E-8; ++i) {
            d7 = (1.0 - this.ECC * Math.sin(d10)) / (1.0 + this.ECC * Math.sin(d10));
            d12 = 1.5707963267948966 - 2.0 * Math.atan(d9 * Math.pow(d7, 0.5 * this.ECC));
            d11 = Math.abs(Math.abs(d10) - Math.abs(d12));
            d10 = d12;
        }
        double d13 = d12 * 57.29577951308232;
        return new Vect2D(d13, d6);
    }

    public int writeBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.transformName);
        if (!this.transformName.equals("GLOBAL")) {
            if (this.transformName.equals("SIMPLE") || this.transformName.equals("EQUIRECTANGULAR")) {
                dataOutputStream.writeFloat((float)this.latOrig);
                dataOutputStream.writeFloat((float)this.longOrig);
                dataOutputStream.writeFloat((float)this.rotAngle);
            } else if (this.transformName.equals("LAMBERT")) {
                dataOutputStream.writeUTF(this.refEllipsoid);
                dataOutputStream.writeFloat((float)this.latOrig);
                dataOutputStream.writeFloat((float)this.longOrig);
                dataOutputStream.writeFloat((float)this.Lambert1stStdParall);
                dataOutputStream.writeFloat((float)this.Lambert2ndStdParall);
                dataOutputStream.writeFloat((float)this.rotAngle);
            }
        }
        return 0;
    }

    public int readBinary(DataInputStream dataInputStream) throws IOException {
        this.transformName = dataInputStream.readUTF();
        if (this.transformName.equals("GLOBAL")) {
            this.transformType = 1;
            this.initialized = true;
        } else if (this.transformName.equals("SIMPLE") || this.transformName.equals("EQUIRECTANGULAR")) {
            this.latOrig = dataInputStream.readFloat();
            this.longOrig = dataInputStream.readFloat();
            this.rotAngle = dataInputStream.readFloat();
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            this.convergence = !this.transformName.equals("EQUIRECTANGULAR");
            this.transformType = 2;
            this.initialized = true;
        } else if (this.transformName.equals("LAMBERT")) {
            this.refEllipsoid = dataInputStream.readUTF();
            this.latOrig = dataInputStream.readFloat();
            this.longOrig = dataInputStream.readFloat();
            this.Lambert1stStdParall = dataInputStream.readFloat();
            this.Lambert2ndStdParall = dataInputStream.readFloat();
            this.rotAngle = dataInputStream.readFloat();
            this.transCos = Math.cos(-Math.PI / 180 * this.rotAngle);
            this.transSin = Math.sin(-Math.PI / 180 * this.rotAngle);
            int n = this.mapSetup(this.refEllipsoid);
            if (n < 0) {
                System.out.println("GeogCoords: ERROR: unrecognized reference ellipsoid: <" + this.refEllipsoid + ">");
            } else {
                this.vlamb(this.latOrig, this.longOrig, this.Lambert1stStdParall, this.Lambert2ndStdParall);
                this.transformType = 3;
                this.initialized = true;
            }
        }
        return 0;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        if (this.transformType == 1) {
            stringBuffer.append("GLOBAL ").append(string);
        } else if (this.transformType == 2) {
            if (this.convergence) {
                stringBuffer.append("SIMPLE ");
            } else {
                stringBuffer.append("EQUIRECTANGULAR ");
            }
            stringBuffer.append("  latOrig ");
            stringBuffer.append(this.latOrig);
            stringBuffer.append("  longOrig ");
            stringBuffer.append(this.longOrig);
            stringBuffer.append("  rotAngle ");
            stringBuffer.append(this.rotAngle);
            stringBuffer.append(string);
        } else if (this.transformType == 3) {
            stringBuffer.append("LAMBERT ");
            stringBuffer.append("  refEllipsoid ");
            stringBuffer.append(this.refEllipsoid);
            stringBuffer.append("  latOrig ");
            stringBuffer.append(this.latOrig);
            stringBuffer.append("  longOrig ");
            stringBuffer.append(this.longOrig);
            stringBuffer.append("  Lambert1stStdParall ");
            stringBuffer.append(this.Lambert1stStdParall);
            stringBuffer.append("  Lambert2ndStdParall ");
            stringBuffer.append(this.Lambert2ndStdParall);
            stringBuffer.append("  rotAngle ");
            stringBuffer.append(this.rotAngle);
            stringBuffer.append(string);
        } else {
            stringBuffer.append("ERROR: unrecognized geographic tranform type: <" + this.transformName + ">");
        }
        return stringBuffer.toString();
    }

    static {
        GeogCoords.ellipse[0] = new EarthEllipsoid("WGS-84", 1984, 6378137.0, 6356752.1, 0.0033528469023047466);
        GeogCoords.ellipse[1] = new EarthEllipsoid("GRS-80", 1980, 6378137.0, 6356752.3, 0.0033528131778969143);
        GeogCoords.ellipse[2] = new EarthEllipsoid("WGS-72", 1972, 6378135.0, 6356750.5, 0.003352779454167505);
        GeogCoords.ellipse[3] = new EarthEllipsoid("Australian", 1965, 6378160.0, 6356774.7, 0.003352891869237217);
        GeogCoords.ellipse[4] = new EarthEllipsoid("Krasovsky", 1940, 6378245.0, 6356863.0, 0.003352329869259135);
        GeogCoords.ellipse[5] = new EarthEllipsoid("International", 1924, 6378388.0, 6356911.9, 0.003367003367003367);
        GeogCoords.ellipse[6] = new EarthEllipsoid("Hayford-1909", 1909, 6378388.0, 6356911.9, 0.003367003367003367);
        GeogCoords.ellipse[7] = new EarthEllipsoid("Clarke-1880", 1880, 6378249.1, 6356514.9, 0.0034076194370612693);
        GeogCoords.ellipse[8] = new EarthEllipsoid("Clarke-1866", 1866, 6378206.4, 6356583.8, 0.0033900603430741063);
        GeogCoords.ellipse[9] = new EarthEllipsoid("Airy", 1830, 6377563.4, 6356256.9, 0.0033409060537217695);
        GeogCoords.ellipse[10] = new EarthEllipsoid("Bessel", 1841, 6377397.2, 6356079.0, 0.003342804613070366);
        GeogCoords.ellipse[11] = new EarthEllipsoid("Hayford-1830", 1830, 6377276.3, 6356075.4, 0.003324468085106383);
        GeogCoords.ellipse[12] = new EarthEllipsoid("Sphere", 1980, 6371008.7714, 6371008.7714, 0.0);
    }
}

