/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.alomax.util.BinaryType;

public class BinaryInputStream
extends DataInputStream {
    public int binaryType;

    public BinaryInputStream(InputStream inputStream, String string) {
        super(inputStream);
        this.binaryType = BinaryType.stringToBinaryType(string);
    }

    public BinaryInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.binaryType = BinaryType.intToBinaryType(n);
    }

    public void setBinaryType(int n) {
        this.binaryType = BinaryType.intToBinaryType(n);
    }

    public final short readShortB() throws IOException {
        switch (this.binaryType) {
            case 1: {
                int n = this.readUnsignedByte();
                int n2 = this.readUnsignedByte();
                short s = (short)(n2 << 8 | n);
                return s;
            }
        }
        return this.readShort();
    }

    public final int readUnsignedShortB() throws IOException {
        switch (this.binaryType) {
            case 1: {
                int n = this.readUnsignedByte();
                int n2 = this.readUnsignedByte();
                int n3 = n2 << 8 | n;
                return n3;
            }
        }
        return this.readUnsignedShort();
    }

    public final int readIntB() throws IOException {
        switch (this.binaryType) {
            case 1: {
                int n = this.readUnsignedByte();
                int n2 = this.readUnsignedByte();
                int n3 = this.readUnsignedByte();
                int n4 = this.readUnsignedByte();
                int n5 = ((n4 << 8 | n3) << 8 | n2) << 8 | n;
                return n5;
            }
        }
        return this.readInt();
    }

    public final float readFloatB() throws IOException {
        switch (this.binaryType) {
            case 1: {
                int n = this.readUnsignedByte();
                int n2 = this.readUnsignedByte();
                int n3 = this.readUnsignedByte();
                int n4 = this.readUnsignedByte();
                int n5 = ((n4 << 8 | n3) << 8 | n2) << 8 | n;
                float f = Float.intBitsToFloat(n5);
                return f;
            }
        }
        return this.readFloat();
    }

    public final String readStringB(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        return new String(byArray).trim();
    }
}

