/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.math;

public final class Cmplx {
    public double r;
    public double i;
    private static final double PI = Math.PI;
    private static final double TWOPI = Math.PI * 2;
    public static double[] data = new double[0];

    public Cmplx() {
    }

    public Cmplx(Cmplx cmplx) {
        this.r = cmplx.r;
        this.i = cmplx.i;
    }

    public Cmplx(double d, double d2) {
        this.r = d;
        this.i = d2;
    }

    public static final Cmplx add(Cmplx cmplx, Cmplx cmplx2) {
        Cmplx cmplx3 = new Cmplx();
        cmplx3.r = cmplx.r + cmplx2.r;
        cmplx3.i = cmplx.i + cmplx2.i;
        return cmplx3;
    }

    public final Cmplx add(Cmplx cmplx) {
        this.r += cmplx.r;
        this.i += cmplx.i;
        return this;
    }

    public static final Cmplx sub(Cmplx cmplx, Cmplx cmplx2) {
        Cmplx cmplx3 = new Cmplx();
        cmplx3.r = cmplx.r - cmplx2.r;
        cmplx3.i = cmplx.i - cmplx2.i;
        return cmplx3;
    }

    public final Cmplx sub(Cmplx cmplx) {
        this.r -= cmplx.r;
        this.i -= cmplx.i;
        return this;
    }

    public static final Cmplx mul(Cmplx cmplx, Cmplx cmplx2) {
        Cmplx cmplx3 = new Cmplx();
        cmplx3.r = cmplx.r * cmplx2.r - cmplx.i * cmplx2.i;
        cmplx3.i = cmplx.i * cmplx2.r + cmplx.r * cmplx2.i;
        return cmplx3;
    }

    public final Cmplx mul(Cmplx cmplx) {
        double d = this.r;
        double d2 = this.i;
        this.r = d * cmplx.r - d2 * cmplx.i;
        this.i = d2 * cmplx.r + d * cmplx.i;
        return this;
    }

    public static final Cmplx mul(Cmplx cmplx, double d) {
        Cmplx cmplx2 = new Cmplx();
        cmplx2.r = cmplx.r * d;
        cmplx2.i = cmplx.i * d;
        return cmplx2;
    }

    public final Cmplx mul(double d) {
        this.r *= d;
        this.i *= d;
        return this;
    }

    public final Cmplx div(Cmplx cmplx) {
        double d = this.r;
        double d2 = this.i;
        if (Math.abs(cmplx.r) >= Math.abs(cmplx.i)) {
            double d3 = cmplx.i / cmplx.r;
            double d4 = cmplx.r + d3 * cmplx.i;
            this.r = (d + d3 * d2) / d4;
            this.i = (d2 - d3 * d) / d4;
        } else {
            double d5 = cmplx.r / cmplx.i;
            double d6 = cmplx.i + d5 * cmplx.r;
            this.r = (d * d5 + d2) / d6;
            this.i = (d2 * d5 - d) / d6;
        }
        return this;
    }

    public static final Cmplx div(Cmplx cmplx, Cmplx cmplx2) {
        Cmplx cmplx3 = new Cmplx();
        if (Math.abs(cmplx2.r) >= Math.abs(cmplx2.i)) {
            double d = cmplx2.i / cmplx2.r;
            double d2 = cmplx2.r + d * cmplx2.i;
            cmplx3.r = (cmplx.r + d * cmplx.i) / d2;
            cmplx3.i = (cmplx.i - d * cmplx.r) / d2;
        } else {
            double d = cmplx2.r / cmplx2.i;
            double d3 = cmplx2.i + d * cmplx2.r;
            cmplx3.r = (cmplx.r * d + cmplx.i) / d3;
            cmplx3.i = (cmplx.i * d - cmplx.r) / d3;
        }
        return cmplx3;
    }

    public static final Cmplx conjg(Cmplx cmplx) {
        Cmplx cmplx2 = new Cmplx();
        cmplx2.r = cmplx.r;
        cmplx2.i = -cmplx.i;
        return cmplx2;
    }

    public final Cmplx conjg() {
        this.i = -this.i;
        return this;
    }

    public final String toString() {
        String string = "(" + this.r + "," + this.i + ")";
        return string;
    }

    public final double doubleValue() {
        double d = this.r;
        return d;
    }

    public final double imag() {
        double d = this.i;
        return d;
    }

    public final double mag() {
        return Math.sqrt(this.r * this.r + this.i * this.i);
    }

    public final double mag2() {
        return this.r * this.r + this.i * this.i;
    }

    public final double phs() {
        if (this.r == 0.0) {
            if (this.i == 0.0) {
                return 0.0;
            }
            return this.i / Math.abs(this.i) * 2.0 * Math.atan(1.0);
        }
        return Math.atan2(this.i, this.r);
    }

    public final Cmplx sqrt() {
        double d;
        double d2;
        Cmplx cmplx = new Cmplx();
        if (this.r == 0.0 && this.i == 0.0) {
            cmplx.i = 0.0;
            cmplx.r = 0.0;
            return cmplx;
        }
        double d3 = Math.abs(this.r);
        if (d3 >= (d2 = Math.abs(this.i))) {
            double d4 = d2 / d3;
            d = Math.sqrt(d3) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + d4 * d4)));
        } else {
            double d5 = d3 / d2;
            d = Math.sqrt(d2) * Math.sqrt(0.5 * (d5 + Math.sqrt(1.0 + d5 * d5)));
        }
        if (this.r >= 0.0) {
            cmplx.r = d;
            cmplx.i = this.i / (2.0 * d);
        } else {
            cmplx.i = this.i >= 0.0 ? d : -d;
            cmplx.r = this.i / (2.0 * cmplx.i);
        }
        return cmplx;
    }

    public static final Cmplx exp(Cmplx cmplx) {
        double d = Math.exp(cmplx.r);
        Cmplx cmplx2 = new Cmplx(Math.cos(cmplx.i), Math.sin(cmplx.i));
        return cmplx2.mul(d);
    }

    public static final Cmplx[] fft(float[] fArray) {
        int n;
        int n2;
        for (n2 = 1; n2 < fArray.length; n2 *= 2) {
        }
        if (data.length < 2 * n2) {
            data = new double[2 * n2];
        }
        int n3 = 0;
        for (n = 0; n < fArray.length; ++n) {
            Cmplx.data[n3++] = fArray[n];
            Cmplx.data[n3++] = 0.0;
        }
        while (n3 < 2 * n2) {
            Cmplx.data[n3] = 0.0;
            ++n3;
        }
        data = Cmplx.four1(data, 1, 2 * n2);
        Cmplx[] cmplxArray = new Cmplx[n2];
        n = 0;
        n3 = 0;
        while (n < n2) {
            cmplxArray[n] = new Cmplx(data[n3], data[n3 + 1]);
            ++n;
            n3 += 2;
        }
        return cmplxArray;
    }

    public static final float[] fftInverse(Cmplx[] cmplxArray, int n) {
        if (data.length < 2 * cmplxArray.length) {
            data = new double[2 * cmplxArray.length];
        }
        int n2 = 0;
        for (int i = 0; i < cmplxArray.length; ++i) {
            Cmplx.data[n2++] = cmplxArray[i].doubleValue();
            Cmplx.data[n2++] = cmplxArray[i].imag();
        }
        data = Cmplx.four1(data, -1, 2 * cmplxArray.length);
        float[] fArray = new float[n];
        n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            fArray[n2] = (float)data[n3];
            ++n2;
            n3 += 2;
        }
        return fArray;
    }

    public static final double[] four1(double[] dArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = n2 / 2;
        int n6 = n5 << 1;
        int n7 = 0;
        for (n4 = 0; n4 < n6; n4 += 2) {
            if (n7 > n4) {
                double d = dArray[n7];
                dArray[n7] = dArray[n4];
                dArray[n4] = d;
                d = dArray[n7 + 1];
                dArray[n7 + 1] = dArray[n4 + 1];
                dArray[n4 + 1] = d;
            }
            for (n3 = n6 >> 1; n3 >= 2 && n7 > n3 - 1; n7 -= n3, n3 >>= 1) {
            }
            n7 += n3;
        }
        int n8 = 2;
        while (n6 > n8) {
            int n9 = 2 * n8;
            double d = Math.PI * 2 / (double)(n * n8);
            double d2 = Math.sin(0.5 * d);
            double d3 = -2.0 * d2 * d2;
            double d4 = Math.sin(d);
            double d5 = 1.0;
            double d6 = 0.0;
            for (n3 = 0; n3 < n8; n3 += 2) {
                for (n4 = n3; n4 < n6; n4 += n9) {
                    n7 = n4 + n8;
                    double d7 = d5 * dArray[n7] - d6 * dArray[n7 + 1];
                    double d8 = d5 * dArray[n7 + 1] + d6 * dArray[n7];
                    dArray[n7] = dArray[n4] - d7;
                    dArray[n7 + 1] = dArray[n4 + 1] - d8;
                    int n10 = n4;
                    dArray[n10] = dArray[n10] + d7;
                    int n11 = n4 + 1;
                    dArray[n11] = dArray[n11] + d8;
                }
                d2 = d5;
                d5 = d2 * d3 - d6 * d4 + d5;
                d6 = d6 * d3 + d2 * d4 + d6;
            }
            n8 = n9;
        }
        if (n == -1) {
            for (n3 = 0; n3 < 2 * n5; n3 += 2) {
                int n12 = n3;
                dArray[n12] = dArray[n12] / (double)n5;
            }
        }
        return dArray;
    }
}

