/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.multicomp;

import net.alomax.math.TimeSeries;
import net.alomax.multicomp.MultiCompException;
import net.alomax.multicomp.MultiCompProcess;
import net.alomax.multicomp.MultiCompText;
import net.alomax.util.PhysicalUnits;

public class MultiCompProcesses
implements MultiCompProcess {
    protected static final double RAD2DEG = 57.29577951308232;
    protected static int ndx = -1;
    public static final int UNDEF = ndx++;
    public static final int MAGNITUDE = ndx++;
    public static final int MULTIPLY = ndx++;
    public static final int DIVIDE = ndx++;
    public static final int ADD = ndx++;
    public static final int SUBTRACT = ndx++;
    public static final int DOT_PRODUCT = ndx++;
    public static final int CROSS_PRODUCT = ndx++;
    public static final int ANGLES = ndx++;
    public int processID = UNDEF;

    public MultiCompProcesses(int n) {
        this.processID = n;
    }

    public final float[][] apply(double d, float[][] fArray, int[] nArray, double d2, float[][] fArray2, int[] nArray2) throws Exception {
        if (this.processID == MAGNITUDE) {
            return this.applyMagnitude(d, fArray, nArray, d2, fArray2, nArray2);
        }
        if (this.processID == MULTIPLY) {
            return this.applyMultiply(d, fArray, nArray, d2, fArray2, nArray2);
        }
        if (this.processID == DIVIDE) {
            return this.applyDivide(d, fArray, nArray, d2, fArray2, nArray2);
        }
        if (this.processID == ADD) {
            return this.applyAddSubtract(d, fArray, nArray, d2, fArray2, nArray2, 1.0f);
        }
        if (this.processID == SUBTRACT) {
            return this.applyAddSubtract(d, fArray, nArray, d2, fArray2, nArray2, -1.0f);
        }
        if (this.processID == DOT_PRODUCT) {
            return this.applyDotProduct(d, fArray, nArray, d2, fArray2, nArray2);
        }
        if (this.processID == CROSS_PRODUCT) {
            return this.applyCrossProduct(d, fArray, nArray, d2, fArray2, nArray2);
        }
        if (this.processID == ANGLES) {
            return this.applyAngles(d, fArray, nArray, d2, fArray2, nArray2);
        }
        return fArray;
    }

    public final float[][] applyMagnitude(double d, float[][] fArray, int[] nArray, double d2, float[][] fArray2, int[] nArray2) throws Exception {
        String string = "";
        int n = 0;
        if (n > 0) {
            throw new MultiCompException(string + ".");
        }
        float[][] fArrayArray = new float[][]{new float[fArray[0].length]};
        for (int i = 0; i < fArray[0].length; ++i) {
            fArrayArray[0][i] = 0.0f;
            for (int j = 0; j < fArray.length; ++j) {
                int n2 = i + nArray[j];
                if (n2 < 0 || n2 >= fArray[j].length) continue;
                float[] fArray3 = fArrayArray[0];
                int n3 = i;
                fArray3[n3] = fArray3[n3] + fArray[j][n2] * fArray[j][n2];
            }
            fArrayArray[0][i] = (float)Math.sqrt(fArrayArray[0][i]);
        }
        return fArrayArray;
    }

    public final float[][] applyDotProduct(double d, float[][] fArray, int[] nArray, double d2, float[][] fArray2, int[] nArray2) throws Exception {
        String string = "";
        int n = 0;
        String string2 = this.checkBasicSettings(d, fArray, nArray, d2, fArray2, nArray2);
        if (string2 != null) {
            string = string + string2;
            ++n;
        }
        if (n > 0) {
            throw new MultiCompException(string + ".");
        }
        float[][] fArrayArray = new float[][]{new float[fArray[0].length]};
        for (int i = 0; i < fArray[0].length; ++i) {
            fArrayArray[0][i] = 0.0f;
            for (int j = 0; j < fArray.length; ++j) {
                int n2;
                int n3 = i + nArray[j];
                if (n3 < 0 || n3 >= fArray[j].length || (n2 = i + nArray2[j]) < 0 || n2 >= fArray2[j].length) continue;
                float[] fArray3 = fArrayArray[0];
                int n4 = i;
                fArray3[n4] = fArray3[n4] + fArray[j][n3] * fArray2[j][n2];
            }
        }
        return fArrayArray;
    }

    public final float[][] applyCrossProduct(double d, float[][] fArray, int[] nArray, double d2, float[][] fArray2, int[] nArray2) throws Exception {
        String string;
        String string2 = "";
        int n = 0;
        if (fArray.length != 3 || fArray2.length != 3) {
            string2 = string2 + ": " + MultiCompText.error_not_3_components;
            ++n;
        }
        if ((string = this.checkBasicSettings(d, fArray, nArray, d2, fArray2, nArray2)) != null) {
            string2 = string2 + string;
            ++n;
        }
        if (n > 0) {
            throw new MultiCompException(string2 + ".");
        }
        float[][] fArrayArray = new float[][]{new float[fArray[0].length], new float[fArray[0].length], new float[fArray[0].length]};
        int n2 = nArray[0];
        int n3 = nArray2[0];
        int n4 = nArray[1];
        int n5 = nArray2[1];
        int n6 = nArray[2];
        int n7 = nArray2[2];
        for (int i = 0; i < fArray[0].length; ++i) {
            if (n2 < 0 || n2 >= fArray[0].length || ++n3 < 0 || n3 >= fArray2[0].length || ++n4 < 0 || n4 >= fArray[1].length || ++n5 < 0 || n5 >= fArray2[1].length || ++n2 < 2 || ++n6 >= fArray[2].length || n3 < 2 || ++n7 >= fArray2[2].length) {
                fArrayArray[2][i] = 0.0f;
                fArrayArray[1][i] = 0.0f;
                fArrayArray[0][i] = 0.0f;
                continue;
            }
            fArrayArray[0][i] = fArray[1][n4] * fArray2[2][n7] - fArray[2][n6] * fArray2[1][n5];
            fArrayArray[1][i] = fArray[2][n6] * fArray2[0][n3] - fArray[0][n2] * fArray2[2][n7];
            fArrayArray[2][i] = fArray[0][n2] * fArray2[1][n5] - fArray[1][n4] * fArray2[0][n3];
        }
        return fArrayArray;
    }

    public final float[][] applyMultiply(double d, float[][] fArray, int[] nArray, double d2, float[][] fArray2, int[] nArray2) throws Exception {
        int n;
        String string = "";
        int n2 = 0;
        String string2 = this.checkBasicSettings(d, fArray, nArray, d2, fArray2, nArray2);
        if (string2 != null) {
            string = string + string2;
            ++n2;
        }
        if (n2 > 0) {
            throw new MultiCompException(string + ".");
        }
        float[][] fArrayArray = new float[fArray.length][];
        for (n = 0; n < fArray.length; ++n) {
            fArrayArray[n] = new float[fArray[0].length];
        }
        for (n = 0; n < fArray[0].length; ++n) {
            for (int i = 0; i < fArray.length; ++i) {
                int n3;
                int n4 = n + nArray[i];
                fArrayArray[i][n] = n4 < 0 || n4 >= fArray[i].length ? 0.0f : ((n3 = n + nArray2[i]) < 0 || n3 >= fArray2[i].length ? 0.0f : fArray[i][n4] * fArray2[i][n3]);
            }
        }
        return fArrayArray;
    }

    public final float[][] applyDivide(double d, float[][] fArray, int[] nArray, double d2, float[][] fArray2, int[] nArray2) throws Exception {
        int n;
        String string = "";
        int n2 = 0;
        String string2 = this.checkBasicSettings(d, fArray, nArray, d2, fArray2, nArray2);
        if (string2 != null) {
            string = string + string2;
            ++n2;
        }
        if (n2 > 0) {
            throw new MultiCompException(string + ".");
        }
        float[][] fArrayArray = new float[fArray.length][];
        for (n = 0; n < fArray.length; ++n) {
            fArrayArray[n] = new float[fArray[0].length];
        }
        for (n = 0; n < fArray[0].length; ++n) {
            for (int i = 0; i < fArray.length; ++i) {
                int n3;
                int n4 = n + nArray[i];
                fArrayArray[i][n] = n4 < 0 || n4 >= fArray[i].length ? 0.0f : ((n3 = n + nArray2[i]) < 0 || n3 >= fArray2[i].length ? 0.0f : (Math.abs(fArray2[i][n3]) <= Float.MIN_VALUE ? 0.0f : fArray[i][n4] / fArray2[i][n3]));
            }
        }
        return fArrayArray;
    }

    public final float[][] applyAddSubtract(double d, float[][] fArray, int[] nArray, double d2, float[][] fArray2, int[] nArray2, float f) throws Exception {
        int n;
        boolean bl = true;
        String string = "";
        int n2 = 0;
        String string2 = "";
        string2 = bl ? this.checkBasicSettings(1.0, fArray, nArray, 1.0, fArray2, nArray2) : this.checkBasicSettings(d, fArray, nArray, d2, fArray2, nArray2);
        if (string2 != null) {
            string = string + string2;
            ++n2;
        }
        if (n2 > 0) {
            throw new MultiCompException(string + ".");
        }
        boolean bl2 = Math.abs(d - d2) > d / (double)fArray[0].length;
        float[][] fArrayArray = new float[fArray.length][];
        for (n = 0; n < fArray.length; ++n) {
            fArrayArray[n] = new float[fArray[0].length];
        }
        if (!bl2) {
            for (n = 0; n < fArray[0].length; ++n) {
                for (int i = 0; i < fArray.length; ++i) {
                    int n3;
                    fArrayArray[i][n] = 0.0f;
                    int n4 = n + nArray[i];
                    if (n4 >= 0 && n4 < fArray[i].length) {
                        float[] fArray3 = fArrayArray[i];
                        int n5 = n;
                        fArray3[n5] = fArray3[n5] + fArray[i][n4];
                    }
                    if ((n3 = n + nArray2[i]) < 0 || n3 >= fArray2[i].length) continue;
                    float[] fArray4 = fArrayArray[i];
                    int n6 = n;
                    fArray4[n6] = fArray4[n6] + f * fArray2[i][n3];
                }
            }
        }
        for (n = 0; n < fArray[0].length; ++n) {
            for (int i = 0; i < fArray.length; ++i) {
                int n7;
                fArrayArray[i][n] = 0.0f;
                int n8 = n + nArray[i];
                if (n8 >= 0 && n8 < fArray[i].length) {
                    float[] fArray5 = fArrayArray[i];
                    int n9 = n;
                    fArray5[n9] = fArray5[n9] + fArray[i][n8];
                }
                if ((n7 = (int)((double)n * d / d2) + nArray2[i]) < 0 || n7 >= fArray2[i].length) continue;
                float[] fArray6 = fArrayArray[i];
                int n10 = n;
                fArray6[n10] = fArray6[n10] + f * fArray2[i][n7];
            }
        }
        return fArrayArray;
    }

    public final float[][] applyAngles(double d, float[][] fArray, int[] nArray, double d2, float[][] fArray2, int[] nArray2) throws Exception {
        String string = "";
        int n = 0;
        if (fArray.length != 3) {
            string = string + ": " + MultiCompText.error_not_3_components;
            ++n;
        }
        if (n > 0) {
            throw new MultiCompException(string + ".");
        }
        float[][] fArrayArray = new float[][]{new float[fArray[0].length], new float[fArray[0].length]};
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        for (int i = 0; i < fArray[0].length; ++i) {
            double d3;
            if (++n2 < 0 || n2 >= fArray[0].length || ++n3 < 0 || n3 >= fArray[1].length || n2 < 2 || ++n4 >= fArray[2].length) {
                fArrayArray[1][i] = 0.0f;
                fArrayArray[0][i] = 0.0f;
                continue;
            }
            fArrayArray[0][i] = 90.0f - (float)(57.29577951308232 * Math.atan2(fArray[1][n3], fArray[2][n4]));
            if ((double)fArrayArray[0][i] < 0.0) {
                float[] fArray3 = fArrayArray[0];
                int n5 = i;
                fArray3[n5] = (float)((double)fArray3[n5] + 360.0);
            }
            fArrayArray[1][i] = (d3 = Math.sqrt(fArray[1][n3] * fArray[1][n3] + fArray[2][n4] * fArray[2][n4])) > Double.MIN_VALUE ? (float)(57.29577951308232 * Math.atan((double)fArray[0][n2] / d3)) : 0.0f;
        }
        return fArrayArray;
    }

    protected String checkBasicSettings(double d, float[][] fArray, int[] nArray, double d2, float[][] fArray2, int[] nArray2) {
        String string = "";
        int n = 0;
        if (fArray.length != fArray2.length) {
            string = string + ": " + MultiCompText.error_array_components_not_equal;
            ++n;
        }
        if (Math.abs(d - d2) > d / (double)fArray[0].length) {
            string = string + ": " + MultiCompText.error_sample_interval_not_equal;
            ++n;
        }
        if (n > 0) {
            return string;
        }
        return null;
    }

    public void updateFields(TimeSeries timeSeries, int n) {
        if (this.processID == MULTIPLY || this.processID == DOT_PRODUCT || this.processID == CROSS_PRODUCT) {
            timeSeries.ampUnits = PhysicalUnits.square(timeSeries.ampUnits);
        } else if (this.processID == DIVIDE) {
            timeSeries.ampUnits = "counts";
        } else if (this.processID == ANGLES) {
            timeSeries.ampUnits = "deg";
        }
    }

    public void checkSettings() throws MultiCompException {
        String string = "";
        int n = 0;
        if (this.processID == UNDEF) {
            string = string + ": " + MultiCompText.invalid_multi_comp_process;
            ++n;
        }
        if (n > 0) {
            throw new MultiCompException(string + ".");
        }
    }

    public boolean isHomogeneousData() {
        return this.processID != ANGLES;
    }
}

