/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.multicomp;

import JSci.maths.Complex;
import JSci.maths.LinearMath;
import JSci.maths.matrices.AbstractComplexSquareMatrix;
import JSci.maths.matrices.AbstractDoubleSquareMatrix;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.ComplexVector;
import JSci.maths.vectors.DoubleVector;
import net.alomax.freq.FrequencyProcesses;
import net.alomax.math.Cmplx;
import net.alomax.math.TimeSeries;
import net.alomax.multicomp.MultiCompException;
import net.alomax.multicomp.MultiCompProcess;
import net.alomax.multicomp.MultiCompText;

public class PolarisationAnalysis
implements MultiCompProcess {
    protected static final double RAD2DEG = 57.29577951308232;
    protected static int NUM_TYPES = 0;
    public static final int COVARIANCE = NUM_TYPES++;
    public static final int COHERENCY = NUM_TYPES++;
    public int type = COVARIANCE;
    public static final String NAME_COVARIANCE = "COVARIANCE";
    public static final String NAME_COHERENCY = "COHERENCY";
    public int windowWidth = 10;
    private static final int WINDOW_MIN = 1;
    private static final int WINDOW_MAX = Integer.MAX_VALUE;

    public PolarisationAnalysis(String string, int n, int n2) {
        this.type = n;
        this.windowWidth = n2;
        MultiCompText.setLocale(string);
    }

    public float[][] apply(double d, float[][] fArray, int[] nArray, double d2, float[][] fArray2, int[] nArray2) throws Exception {
        if (this.type == COVARIANCE) {
            return this.applyCovariance(d, fArray, nArray, this.windowWidth);
        }
        if (this.type == COHERENCY) {
            return this.applyCoherency(d, fArray, nArray, this.windowWidth);
        }
        return fArray;
    }

    public float[][] applyCoherency(double d, float[][] fArray, int[] nArray, int n) throws Exception {
        int n2;
        ComplexSquareMatrix complexSquareMatrix;
        String string = "";
        int n3 = 0;
        if (fArray.length != 3) {
            string = string + ": " + MultiCompText.error_not_3_components;
            ++n3;
        }
        if (n3 > 0) {
            throw new MultiCompException(string + ".");
        }
        float[][] fArrayArray = new float[][]{new float[fArray[0].length], new float[fArray[0].length], new float[fArray[0].length], new float[fArray[0].length]};
        float[][] fArrayArray2 = new float[3][];
        Complex[][] complexArray = new Complex[3][3];
        ComplexSquareMatrix[] complexSquareMatrixArray = new ComplexSquareMatrix[n];
        ComplexSquareMatrix complexSquareMatrix2 = complexSquareMatrix = new ComplexSquareMatrix(3);
        FrequencyProcesses frequencyProcesses = new FrequencyProcesses(FrequencyProcesses.HILBERT);
        for (n2 = 0; n2 < 3; ++n2) {
            Cmplx[] cmplxArray = Cmplx.fft(fArray[n2]);
            cmplxArray = frequencyProcesses.apply(d, cmplxArray);
            fArrayArray2[n2] = Cmplx.fftInverse(cmplxArray, fArray[n2].length);
        }
        n2 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < fArray[0].length; ++i) {
            double d4;
            double d5;
            double d6;
            double d7;
            int n7;
            fArrayArray[3][i] = 0.0f;
            fArrayArray[2][i] = 0.0f;
            fArrayArray[1][i] = 0.0f;
            fArrayArray[0][i] = 0.0f;
            if (++n2 < 0 || n2 >= fArray[0].length || ++n4 < 0 || n4 >= fArray[1].length || ++n5 < 0 || n5 >= fArray[2].length) {
                n6 = 0;
                complexSquareMatrix2 = complexSquareMatrix;
                continue;
            }
            if (n6 > n - 1) {
                complexSquareMatrix2 = complexSquareMatrix2.subtract(complexSquareMatrixArray[0]);
            }
            for (int j = 0; j < n - 1; ++j) {
                complexSquareMatrixArray[j] = complexSquareMatrixArray[j + 1];
            }
            ++n6;
            Complex complex = new Complex((double)fArray[2][n5], (double)fArrayArray2[2][n5]);
            Complex complex2 = complex.conjugate();
            Complex complex3 = new Complex((double)fArray[1][n4], (double)fArrayArray2[1][n4]);
            Complex complex4 = complex3.conjugate();
            Complex complex5 = new Complex((double)fArray[0][n2], (double)fArrayArray2[0][n2]);
            Complex complex6 = complex5.conjugate();
            complexArray[0][0] = complex.multiply(complex2);
            complexArray[0][1] = complex.multiply(complex4);
            complexArray[0][2] = complex.multiply(complex6);
            complexArray[1][0] = complex3.multiply(complex2);
            complexArray[1][1] = complex3.multiply(complex4);
            complexArray[1][2] = complex3.multiply(complex6);
            complexArray[2][0] = complex5.multiply(complex2);
            complexArray[2][1] = complex5.multiply(complex4);
            complexArray[2][2] = complex5.multiply(complex6);
            complexSquareMatrixArray[n - 1] = new ComplexSquareMatrix(complexArray);
            complexSquareMatrixArray[n - 1] = (ComplexSquareMatrix)complexSquareMatrixArray[n - 1].scalarDivide((double)n);
            complexSquareMatrix2 = complexSquareMatrix2.add(complexSquareMatrixArray[n - 1]);
            if (n6 < n) continue;
            ComplexVector[] complexVectorArray = new ComplexVector[3];
            double[] dArray = null;
            dArray = LinearMath.eigenSolveHermitian((AbstractComplexSquareMatrix)complexSquareMatrix2, (AbstractComplexVector[])complexVectorArray);
            int n8 = -1;
            double d8 = -4.9E-324;
            for (int j = 0; j < 3; ++j) {
                if (!(dArray[j] > d8)) continue;
                d8 = dArray[j];
                n8 = j;
            }
            if (d8 < Double.MIN_VALUE) continue;
            ComplexVector complexVector = complexVectorArray[n8];
            int n9 = -1;
            double d9 = -4.9E-324;
            for (n7 = 0; n7 < 3; ++n7) {
                if (n7 == n8 || !(dArray[n7] > d9)) continue;
                d9 = dArray[n7];
                n9 = n7;
            }
            n7 = -1;
            double d10 = -4.9E-324;
            for (int j = 0; j < 3; ++j) {
                if (j == n8 || j == n9) continue;
                d10 = dArray[j];
                n7 = j;
            }
            double d11 = 1.0E-10 * d8;
            for (int j = 0; j < 3; ++j) {
                if (Math.abs(dArray[j]) < d11) {
                    dArray[j] = 0.0;
                    continue;
                }
                if (!(dArray[j] < 0.0)) continue;
                throw new MultiCompException("ERROR: applyCoherency: negative eigenvalue(s): " + dArray[0] + " " + dArray[1] + " " + dArray[2]);
            }
            double d12 = complexVector.norm();
            if (d12 > Double.MIN_VALUE) {
                complexVector = (ComplexVector)complexVector.scalarDivide(d12);
            }
            Complex complex7 = complexVector.getComponent(0);
            Complex complex8 = complexVector.getComponent(1);
            Complex complex9 = complexVector.getComponent(2);
            double d13 = -1.7976931348623157E308;
            double d14 = -1.0;
            for (double d15 = 0.0; d15 < Math.PI; d15 += Math.PI / 180) {
                Complex complex10 = new Complex(Math.cos(d15), Math.sin(d15));
                d7 = complex7.multiply(complex10).real();
                d4 = d7 * d7 + (d6 = complex8.multiply(complex10).real()) * d6 + (d5 = complex9.multiply(complex10).real()) * d5;
                if (!(d4 > d13)) continue;
                d13 = d4;
                d14 = d15;
            }
            d13 = Math.sqrt(d13);
            Complex complex11 = new Complex(Math.cos(d14), Math.sin(d14));
            complex7 = complex7.multiply(complex11);
            complex8 = complex8.multiply(complex11);
            complex9 = complex9.multiply(complex11);
            double d16 = complex7.real();
            d7 = complex8.real();
            d6 = complex9.real();
            d5 = complex7.imag();
            d4 = complex8.imag();
            double d17 = complex9.imag();
            if (d6 < 0.0) {
                d16 *= -1.0;
                d7 *= -1.0;
                d6 *= -1.0;
            }
            int n10 = i - n / 2;
            double d18 = d2;
            double d19 = d3;
            if (d7 * d7 + d16 * d16 > 0.001 * (d4 * d4 + d5 * d5)) {
                d18 = 90.0 - 57.29577951308232 * Math.atan2(d7, d16);
                if (d18 < 0.0) {
                    d18 += 360.0;
                } else if (d18 > 360.0) {
                    d18 -= 360.0;
                }
                d2 = d18;
                double d20 = Math.sqrt(d16 * d16 + d7 * d7);
                d19 = d20 > Double.MIN_VALUE ? (double)((float)(57.29577951308232 * Math.atan(d6 / d20))) : d3;
                d3 = d19;
            }
            fArrayArray[0][n10] = (float)d18;
            fArrayArray[1][n10] = (float)d19;
            fArrayArray[2][n10] = d13 > Double.MIN_VALUE ? (float)(1.0 - Math.sqrt(1.0 - d13 * d13) / d13) : 0.0f;
            fArrayArray[3][n10] = d8 > Double.MIN_VALUE ? (float)(1.0 - d10 / d9) : 0.0f;
        }
        return fArrayArray;
    }

    public float[][] applyCovariance(double d, float[][] fArray, int[] nArray, int n) throws Exception {
        DoubleSquareMatrix doubleSquareMatrix;
        String string = "";
        int n2 = 0;
        if (fArray.length != 3) {
            string = string + ": " + MultiCompText.error_not_3_components;
            ++n2;
        }
        if (n2 > 0) {
            throw new MultiCompException(string + ".");
        }
        float[][] fArrayArray = new float[][]{new float[fArray[0].length], new float[fArray[0].length], new float[fArray[0].length], new float[fArray[0].length]};
        double[][] dArray = new double[3][3];
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[n];
        DoubleSquareMatrix doubleSquareMatrix2 = doubleSquareMatrix = new DoubleSquareMatrix(3);
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < fArray[0].length; ++i) {
            int n7;
            fArrayArray[3][i] = 0.0f;
            fArrayArray[2][i] = 0.0f;
            fArrayArray[1][i] = 0.0f;
            fArrayArray[0][i] = 0.0f;
            if (++n3 < 0 || n3 >= fArray[0].length || ++n4 < 0 || n4 >= fArray[1].length || ++n5 < 0 || n5 >= fArray[2].length) {
                n6 = 0;
                doubleSquareMatrix2 = doubleSquareMatrix;
                continue;
            }
            if (n6 > n - 1) {
                doubleSquareMatrix2 = doubleSquareMatrix2.subtract(doubleSquareMatrixArray[0]);
            }
            for (int j = 0; j < n - 1; ++j) {
                doubleSquareMatrixArray[j] = doubleSquareMatrixArray[j + 1];
            }
            ++n6;
            double d4 = fArray[2][n5];
            double d5 = fArray[1][n4];
            double d6 = fArray[0][n3];
            dArray[0][0] = d4 * d4;
            dArray[0][1] = d4 * d5;
            dArray[0][2] = d4 * d6;
            dArray[1][0] = d5 * d4;
            dArray[1][1] = d5 * d5;
            dArray[1][2] = d5 * d6;
            dArray[2][0] = d6 * d4;
            dArray[2][1] = d6 * d5;
            dArray[2][2] = d6 * d6;
            doubleSquareMatrixArray[n - 1] = new DoubleSquareMatrix(dArray);
            doubleSquareMatrixArray[n - 1] = (DoubleSquareMatrix)doubleSquareMatrixArray[n - 1].scalarDivide((double)n);
            doubleSquareMatrix2 = doubleSquareMatrix2.add(doubleSquareMatrixArray[n - 1]);
            if (n6 < n) continue;
            DoubleVector[] doubleVectorArray = new DoubleVector[3];
            double[] dArray2 = null;
            dArray2 = LinearMath.eigenSolveSymmetric((AbstractDoubleSquareMatrix)doubleSquareMatrix2, (AbstractDoubleVector[])doubleVectorArray);
            int n8 = -1;
            double d7 = -4.9E-324;
            for (int j = 0; j < 3; ++j) {
                if (!(dArray2[j] > d7)) continue;
                d7 = dArray2[j];
                n8 = j;
            }
            if (d7 < Double.MIN_VALUE) continue;
            DoubleVector doubleVector = doubleVectorArray[n8];
            int n9 = -1;
            double d8 = -4.9E-324;
            for (n7 = 0; n7 < 3; ++n7) {
                if (n7 == n8 || !(dArray2[n7] > d8)) continue;
                d8 = dArray2[n7];
                n9 = n7;
            }
            n7 = -1;
            double d9 = -4.9E-324;
            for (int j = 0; j < 3; ++j) {
                if (j == n8 || j == n9) continue;
                d9 = dArray2[j];
                n7 = j;
            }
            double d10 = 1.0E-10 * d7;
            for (int j = 0; j < 3; ++j) {
                if (Math.abs(dArray2[j]) < d10) {
                    dArray2[j] = 0.0;
                    continue;
                }
                if (!(dArray2[j] < 0.0)) continue;
                throw new MultiCompException("ERROR: applyCovariance: negative eigenvalue(s): " + dArray2[0] + " " + dArray2[1] + " " + dArray2[2]);
            }
            double d11 = doubleVector.getComponent(0);
            double d12 = doubleVector.getComponent(1);
            double d13 = doubleVector.getComponent(2);
            if (d13 < 0.0) {
                d11 *= -1.0;
                d12 *= -1.0;
                d13 *= -1.0;
            }
            int n10 = i - n / 2;
            double d14 = d2;
            double d15 = d3;
            d14 = 90.0 - 57.29577951308232 * Math.atan2(d12, d11);
            if (d14 < 0.0) {
                d14 += 360.0;
            } else if (d14 > 360.0) {
                d14 -= 360.0;
            }
            d2 = d14;
            double d16 = Math.sqrt(d11 * d11 + d12 * d12);
            d15 = d16 > Double.MIN_VALUE ? (double)((float)(57.29577951308232 * Math.atan(d13 / d16))) : d3;
            d3 = d15;
            fArrayArray[0][n10] = (float)d14;
            fArrayArray[1][n10] = (float)d15;
            fArrayArray[2][n10] = d7 > Double.MIN_VALUE ? (float)(1.0 - d8 / d7) : 0.0f;
            fArrayArray[3][n10] = d7 > Double.MIN_VALUE ? (float)(1.0 - d9 / d8) : 0.0f;
        }
        return fArrayArray;
    }

    public void setWindowWidth(int n) throws MultiCompException {
        if (n < 1 || n > Integer.MAX_VALUE) {
            throw new MultiCompException(MultiCompText.invalid_polarisation_window_width_value + ": " + n);
        }
        this.windowWidth = n;
    }

    public void setWindowWidth(String string) throws MultiCompException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MultiCompException(MultiCompText.invalid_polarisation_window_width_value + ": " + string);
        }
        this.setWindowWidth(n);
    }

    public void setType(String string) throws MultiCompException {
        if (NAME_COVARIANCE.startsWith(string.toUpperCase())) {
            this.type = COVARIANCE;
        } else if (NAME_COHERENCY.startsWith(string.toUpperCase())) {
            this.type = COHERENCY;
        } else {
            throw new MultiCompException(MultiCompText.invalid_polarisation_type + ": " + string);
        }
    }

    public void setType(int n) throws MultiCompException {
        if (n < 0 || n >= NUM_TYPES) {
            throw new MultiCompException(MultiCompText.invalid_polarisation_type + ": " + n);
        }
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    protected String checkBasicSettings(double d, float[][] fArray, int[] nArray, double d2, float[][] fArray2, int[] nArray2) {
        String string = "";
        int n = 0;
        if (n > 0) {
            return string;
        }
        return null;
    }

    public void updateFields(TimeSeries timeSeries, int n) {
        block3: {
            block2: {
                if (this.type == COVARIANCE) break block2;
                if (this.type != COHERENCY) break block3;
            }
            timeSeries.ampUnits = n < 2 ? "deg" : "counts";
        }
    }

    public void checkSettings() throws MultiCompException {
        String string = "";
        int n = 0;
        this.setWindowWidth(this.windowWidth);
        this.setType(this.type);
        if (n > 0) {
            throw new MultiCompException(string + ".");
        }
    }

    public boolean isHomogeneousData() {
        block3: {
            block2: {
                if (this.type == COVARIANCE) break block2;
                if (this.type != COHERENCY) break block3;
            }
            return false;
        }
        return true;
    }
}

