/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.io.IOException;
import java.util.StringTokenizer;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicItem;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import net.alomax.util.TimeInstant;
import sdsu.io.ASCIIInputStream;

public class SeisDataGSE21
extends SeisData {
    private static final boolean DEBUG = false;
    protected String date;
    protected String time;
    protected String station;
    protected String channel;
    protected String auxid;
    protected String subFormat;
    protected int numSamples = -1;
    protected double sampleRate;
    protected double calibFactor = 0.0;
    protected double calibFactorRefPeriod = 0.0;
    protected String instType = "-";
    protected double horizOrientation = 0.0;
    protected double verticalOrientation = 0.0;
    protected String network;
    protected double lat;
    protected double lon;
    protected String coordsys;
    protected double elev;
    protected double edepth;
    protected float[] sample;
    protected String dataUnits = "counts";
    String calibFactorString = BasicItem.UNDEF_STRING;

    public void read(ASCIIInputStream aSCIIInputStream) throws Exception {
        try {
            String string;
            while ((string = aSCIIInputStream.readLine()) != null) {
                if (string.startsWith("(")) continue;
                if (string.startsWith("WID2")) {
                    this.readLineWID2(string);
                    continue;
                }
                if (string.startsWith("STA2")) {
                    this.readLineSTA2(string);
                    continue;
                }
                if (!string.startsWith("DAT2")) continue;
                if (this.numSamples < 1) {
                    System.out.println("ERROR: GSE 2.1: DAT2 line present before WID2 line read.");
                }
                if (!this.subFormat.equals("CM6")) {
                    System.out.println("ERROR: GSE 2.1: data sub format is not CM6.");
                }
                StringBuffer stringBuffer = new StringBuffer(4096);
                while ((string = aSCIIInputStream.readLine()) != null && !string.startsWith("CHK2 ")) {
                    stringBuffer.append(string);
                }
                byte[] byArray = stringBuffer.toString().getBytes();
                int[] nArray = this.Decomp6(byArray, this.numSamples);
                if (nArray.length != this.numSamples) {
                    System.out.println("ERROR: GSE 2.1: Bad sample count after decompression: " + nArray.length + " shuld be: " + this.numSamples);
                }
                this.RemDiff(nArray, 2);
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                int n = Integer.valueOf(stringTokenizer.nextToken());
                int n2 = this.ChecksumGse2(nArray);
                if (n != n2) {
                    System.out.println("ERROR: GSE 2.1: Bad checksum: " + n2 + " shuld be: " + n + " diff: " + (n2 - n));
                }
                this.sample = new float[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    this.sample[i] = nArray[i];
                }
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readLineWID2(String string) {
        try {
            this.date = string.substring(5, 15).trim();
            if (this.date.length() < 1) {
                this.date = UNDEF_STRING;
            }
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: date: " + exception + " in: " + string);
        }
        try {
            this.time = string.substring(16, 28).trim();
            if (this.time.length() < 1) {
                this.time = UNDEF_STRING;
            }
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: time: " + exception + " in: " + string);
        }
        try {
            this.station = string.substring(29, 34).trim();
            if (this.station.length() < 1) {
                this.station = UNDEF_STRING;
            }
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: station: " + exception + " in: " + string);
        }
        try {
            this.channel = string.substring(35, 38).trim();
            if (this.channel.length() < 1) {
                this.channel = UNDEF_STRING;
            }
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: channel: " + exception + " in: " + string);
        }
        try {
            this.auxid = string.substring(39, 43).trim();
            if (this.auxid.length() < 1) {
                this.auxid = UNDEF_STRING;
            }
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: auxid: " + exception + " in: " + string);
        }
        try {
            this.subFormat = string.substring(44, 47).trim();
            if (this.subFormat.length() < 1) {
                this.subFormat = UNDEF_STRING;
            }
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: subFormat: " + exception + " in: " + string);
        }
        try {
            this.numSamples = Integer.valueOf(string.substring(48, 56).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: numSamples: " + exception + " in: " + string);
        }
        try {
            this.sampleRate = Double.valueOf(string.substring(57, 68).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: sampleRate: " + exception + " in: " + string);
        }
        try {
            this.calibFactorString = string.substring(69, 79).trim();
            this.calibFactor = Double.valueOf(this.calibFactorString);
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: calibFactor: " + exception + " in: " + string);
        }
        try {
            this.calibFactorRefPeriod = Double.valueOf(string.substring(80, 87).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: calibFactorRefPeriod: " + exception + " in: " + string);
        }
        try {
            this.instType = string.substring(88, 94).trim();
            if (this.instType.length() < 1) {
                this.instType = UNDEF_STRING;
            }
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: instType: " + exception + " in: " + string);
        }
        try {
            this.horizOrientation = Double.valueOf(string.substring(95, 100).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: horizOrientation: " + exception + " in: " + string);
        }
        try {
            this.verticalOrientation = Double.valueOf(string.substring(101, 105).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: verticalOrientation: " + exception + " in: " + string);
        }
    }

    public void readLineSTA2(String string) {
        try {
            this.network = string.substring(5, 14).trim();
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: network: " + exception + " in: " + string);
        }
        try {
            this.lat = Double.valueOf(string.substring(15, 24).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: lat: " + exception + " in: " + string);
        }
        try {
            this.lon = Double.valueOf(string.substring(25, 35).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: lon: " + exception + " in: " + string);
        }
        try {
            this.coordsys = string.substring(36, 48).trim();
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: coordsys: " + exception + " in: " + string);
        }
        try {
            this.elev = Double.valueOf(string.substring(49, 54).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: elev: " + exception + " in: " + string);
        }
        try {
            this.edepth = Double.valueOf(string.substring(55, 60).trim());
        }
        catch (Exception exception) {
            System.out.println("WARNING: Parse error: edepth: " + exception + " in: " + string);
        }
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
    }

    public void setSeismogramFields() {
        SeisDataGSE21 seisDataGSE21 = this;
        this.timeSeries = new TimeSeriesFloat(seisDataGSE21.sample, 1.0 / seisDataGSE21.sampleRate, 0.0, this.dataUnits, "sec");
        this.timeMin = 0.0;
        String string = this.date;
        int n = Integer.parseInt(string.substring(0, string.indexOf(47)).trim());
        string = string.substring(string.indexOf(47) + 1);
        int n2 = Integer.parseInt(string.substring(0, string.indexOf(47)).trim());
        string = string.substring(string.indexOf(47) + 1);
        int n3 = Integer.parseInt(string);
        string = this.time;
        int n4 = Integer.parseInt(string.substring(0, string.indexOf(58)).trim());
        string = string.substring(string.indexOf(58) + 1);
        int n5 = Integer.parseInt(string.substring(0, string.indexOf(58)).trim());
        string = string.substring(string.indexOf(58) + 1);
        double d = new Double(string.trim());
        TimeInstant timeInstant = new TimeInstant(n, n2, n3);
        int n6 = timeInstant.getDoY();
        this.iyear = n;
        this.ijday = n6;
        this.ihour = n4;
        this.imin = n5;
        this.sec = d;
        ((SeisData)this).channel.network = seisDataGSE21.network;
        ((SeisData)this).channel.staName = seisDataGSE21.station;
        ((SeisData)this).channel.instName = seisDataGSE21.instType;
        ((SeisData)this).channel.chanName = seisDataGSE21.channel;
        ((SeisData)this).channel.compName = seisDataGSE21.auxid;
        ((SeisData)this).channel.auxChannelIdName = seisDataGSE21.calibFactorString;
        this.evtName = " ";
        ((SeisData)this).channel.azimuth = this.horizOrientation;
        ((SeisData)this).channel.inclination = this.verticalOrientation;
    }

    public static int canRead(ASCIIInputStream aSCIIInputStream) {
        try {
            String string = aSCIIInputStream.readWord();
            if (string.startsWith("WID2")) {
                return 1;
            }
            if (string.startsWith("STA2")) {
                return 1;
            }
            if (string.startsWith("DATA_TYPE")) {
                return 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    public int[] Decomp6(byte[] byArray, int n) {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 0, 0, 0, 0, 0, 0, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 0, 0, 0, 0, 0, 0, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 0, 0, 0, 0, 0, 0};
        byte by = 32;
        byte by2 = 10;
        byte by3 = 13;
        int n2 = 16;
        int n3 = 32;
        int n4 = 15;
        int n5 = 31;
        int n6 = n + 4;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int[] nArray2 = new int[n];
        while (n14 < byArray.length && byArray[n11] != by) {
            if (byArray[n11] == by2) {
                ++n11;
                continue;
            }
            if (byArray[n11] == by3) {
                ++n11;
                continue;
            }
            n7 = nArray[byArray[n11]];
            ++n11;
            ++n14;
            n8 = n7 & n2;
            n9 = n7 & n3;
            n10 = n7 & n4;
            while (n9 != 0) {
                if (byArray[n11] == by2) {
                    ++n11;
                    continue;
                }
                if (byArray[n11] == by3) {
                    ++n11;
                    continue;
                }
                n10 *= 32;
                n7 = nArray[byArray[n11]];
                ++n11;
                ++n14;
                n9 = n7 & n3;
                n13 = n7 & n5;
                n10 += n13;
            }
            if (n8 != 0) {
                n10 = -n10;
            }
            nArray2[n12] = n10;
            if (++n12 <= n6) continue;
            System.out.println("ERROR: Decomp6: exceeded max num samples: " + n12);
            break;
        }
        return nArray2;
    }

    public int Compr6(int[] nArray, int n, byte[] byArray) {
        int n2;
        byte[] byArray2 = new byte[]{32, 43, 45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        int n3 = 16;
        int n4 = 32;
        int n5 = 31;
        int n6 = 64;
        int n7 = 512;
        int n8 = 1024;
        int n9 = 1023;
        int n10 = 16384;
        int n11 = 32768;
        int n12 = Short.MAX_VALUE;
        int n13 = 524288;
        int n14 = 0x100000;
        int n15 = 1048575;
        int n16 = 0x1000000;
        int n17 = 0x2000000;
        int n18 = 0x1FFFFFF;
        int n19 = 0x8000000;
        int n20 = 0x7FFFFFF;
        int n21 = 32;
        int n22 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            int n23;
            int n24 = 1;
            int n25 = nArray[n2];
            if (n25 < 0) {
                n24 += n3;
                n25 = -n25;
            }
            if (n25 >= n3) {
                if (n25 >= n7) {
                    if (n25 >= n10) {
                        if (n25 >= n13) {
                            if (n25 >= n16) {
                                if (n25 >= n20) {
                                    n25 = n20;
                                }
                                n23 = n25 / n17 + n24 + n21;
                                byArray[n22] = byArray2[n23];
                                ++n22;
                                n25 &= n18;
                                n24 = 1;
                            }
                            n23 = n25 / n14 + n24 + n21;
                            byArray[n22] = byArray2[n23];
                            ++n22;
                            n25 &= n15;
                            n24 = 1;
                        }
                        n23 = n25 / n11 + n24 + n21;
                        byArray[n22] = byArray2[n23];
                        ++n22;
                        n25 &= n12;
                        n24 = 1;
                    }
                    n23 = n25 / n8 + n24 + n21;
                    byArray[n22] = byArray2[n23];
                    ++n22;
                    n25 &= n9;
                    n24 = 1;
                }
                n23 = n25 / n4 + n24 + n21;
                byArray[n22] = byArray2[n23];
                ++n22;
                n25 &= n5;
                n24 = 1;
            }
            n23 = n25 + n24;
            byArray[n22] = byArray2[n23];
            ++n22;
        }
        int n26 = 80 - n22 % 80;
        if (n26 < 2) {
            n26 += 80;
        }
        for (n2 = 0; n2 < n26; ++n2) {
            byArray[n22] = byArray2[0];
            ++n22;
        }
        return n22;
    }

    public int ChecksumGse2(int[] nArray) {
        int n = 100000000;
        int n2 = 0;
        int n3 = n;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            if (Math.abs(n4) >= n3) {
                n4 -= n4 / n3 * n3;
            }
            if (Math.abs(n2 += n4) < n3) continue;
            n2 -= n2 / n3 * n3;
        }
        n2 = Math.abs(n2);
        return n2;
    }

    public void RemDiff(int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = 1; j < nArray.length; ++j) {
                int n2 = j;
                nArray[n2] = nArray[n2] + nArray[j - 1];
            }
        }
    }
}

