/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.SeedObject;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.exception.SeedException;
import java.util.Vector;
import net.alomax.seis.BasicChannel;
import net.alomax.seis.SampleRateSEEDException;
import net.alomax.seis.SeisData;

public abstract class SeisDataSEEDBase
extends SeisData {
    protected float[] sample;
    protected double sampleRate;
    protected String dataUnits = "counts";
    protected int beginningOfData = 0;
    protected int totNumSamples = 0;

    protected float[] getSampleArray(Vector vector, Vector vector2) throws Exception {
        int n;
        int n2;
        int[] nArray = new int[vector.size()];
        int n3 = 0;
        int n4 = 0;
        SeedObject seedObject = null;
        for (int i = 0; i < vector.size(); ++i) {
            SeedObject seedObject2;
            nArray[i] = 0;
            if (vector2 != null) {
                seedObject2 = (Btime)vector2.elementAt(i);
                if (seedObject != null) {
                    double d = ((Btime)seedObject2).diffSeconds((Btime)seedObject);
                    double d2 = (d /= 10000.0) - (double)n4 / this.sampleRate;
                    n2 = (int)(d2 * this.sampleRate);
                    if (n2 > 0) {
                        nArray[i] = n2;
                        System.out.println("WARNING: gap in data of " + d2 + " seconds = " + n2 + " sample points, at " + seedObject2 + " : filled with constant value.");
                    } else if (n2 < 0) {
                        System.out.println("ERROR: overlap in data of " + d2 + " seconds = " + n2 + " sample points, at " + seedObject2 + " : not corrected!");
                    }
                }
                seedObject = seedObject2;
            }
            seedObject2 = (Waveform)vector.elementAt(i);
            n = ((Waveform)seedObject2).getNumSamples();
            n3 += n + nArray[i];
            n4 = n;
        }
        float[] fArray = new float[n3];
        float f = 0.0f;
        n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Waveform waveform = (Waveform)vector.elementAt(i);
            int[] nArray2 = waveform.getDecodedIntegers();
            if (nArray[i] > 0) {
                for (n2 = 0; n2 < nArray[i]; ++n2) {
                    fArray[n + n2] = f;
                }
                n += nArray[i];
            }
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                fArray[n + n2] = nArray2[n2];
            }
            f = fArray[(n += nArray2.length) - 1];
            vector.setElementAt(null, i);
        }
        return fArray;
    }

    protected void setHeaderFields(Blockette blockette) throws Exception {
        SeisDataSEEDBase seisDataSEEDBase = this;
        char c = ((String)blockette.getFieldVal(12)).charAt(0);
        boolean bl = (c & 2) != 0;
        this.channel.network = (String)blockette.getFieldVal(7);
        this.channel.staName = this.getStationName(blockette);
        this.channel.instName = BasicChannel.UNDEF_STRING;
        this.channel.chanName = (String)blockette.getFieldVal(6);
        this.channel.locName = (String)blockette.getFieldVal(5);
        Btime btime = (Btime)blockette.getFieldVal(8);
        int n = btime.getYear();
        int n2 = btime.getDayOfYear();
        int n3 = btime.getHour();
        int n4 = btime.getMinute();
        double d = (double)btime.getSecond() + (double)btime.getTenthMill() / 10000.0;
        long l = (Long)blockette.getFieldVal(16);
        if (!bl) {
            d += (double)l / 10000.0;
        }
        while (d < 0.0) {
            d += 60.0;
            --n4;
        }
        while (n4 < 0) {
            n4 += 60;
            --n3;
        }
        while (n3 < 0) {
            n3 += 24;
            --n2;
        }
        while (d >= 60.0) {
            d -= 60.0;
            ++n4;
        }
        while (n4 > 59) {
            n4 -= 60;
            ++n3;
        }
        while (n3 > 23) {
            n3 -= 24;
            ++n2;
        }
        this.iyear = n;
        this.ijday = n2;
        this.ihour = n3;
        this.imin = n4;
        this.sec = d;
        this.sampleRate = this.evaluateSampleRateSEED(blockette);
    }

    public double evaluateSampleRateSEED(Blockette blockette) throws Exception {
        int n = (Integer)blockette.getFieldVal(10);
        int n2 = (Integer)blockette.getFieldVal(11);
        if (n > 0 && n2 > 0) {
            return (double)n * (double)n2;
        }
        if (n > 0 && n2 < 0) {
            return (double)(-n) / (double)n2;
        }
        if (n < 0 && n2 > 0) {
            return (double)(-n2) / (double)n;
        }
        if (n < 0 && n2 < 0) {
            return 1.0 / ((double)n * (double)n2);
        }
        throw new SampleRateSEEDException("ERROR: evaluating SEED sample rate in blockette: " + blockette.toString() + ": sampleRateFactor: " + n + " sampleRateMultiplier: " + n2);
    }

    public String getStationName(Blockette blockette) throws SeedException {
        String string = (String)blockette.getFieldVal(4);
        return string;
    }
}

