/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.SeedObject;
import java.io.EOFException;
import java.util.Vector;
import net.alomax.io.BinaryInputStream;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SEEDVolumeParser;
import net.alomax.seis.SeisDataSEEDBase;
import net.alomax.seis.SeisException;

public class SeisDataSEEDMini
extends SeisDataSEEDBase {
    protected String headerFieldString = "";
    protected int numBlockettesRead = 0;

    public void read(BinaryInputStream binaryInputStream) throws Exception {
        SEEDVolumeParser sEEDVolumeParser = new SEEDVolumeParser(binaryInputStream, true);
        Vector<SeedObject> vector = new Vector<SeedObject>();
        Vector<Btime> vector2 = new Vector<Btime>();
        String string = System.getProperty("line.separator");
        boolean bl = true;
        this.numBlockettesRead = 0;
        while (true) {
            SeedObject seedObject;
            Blockette blockette;
            char c;
            sEEDVolumeParser.mark(Integer.MAX_VALUE);
            if (!bl) {
                try {
                    sEEDVolumeParser.readControlHeaderIdentifier();
                }
                catch (EOFException eOFException) {
                    break;
                }
            }
            boolean bl2 = ((c = ((String)(blockette = sEEDVolumeParser.getFixedSectionDataHeader()).getFieldVal(13)).charAt(0)) & 8) != 0;
            boolean bl3 = (c & 0x10) != 0;
            this.beginningOfData = (Integer)blockette.getFieldVal(17);
            this.beginningOfData += sEEDVolumeParser.getRecordPosition() - 48;
            if (bl) {
                this.setHeaderFields(blockette);
                this.headerFieldString = "Blockette " + this.numBlockettesRead + ": type=" + blockette.getType() + ": name=" + blockette.getName() + ": " + string + blockette.toString() + string;
            } else if (!this.isSameTrace(blockette)) {
                sEEDVolumeParser.reset();
                break;
            }
            ++this.numBlockettesRead;
            String string2 = null;
            int n = 0;
            while (sEEDVolumeParser.getRecordPosition() < this.beginningOfData) {
                boolean bl4 = false;
                seedObject = sEEDVolumeParser.readBlockette(true, bl4);
                if (seedObject == null) {
                    throw new SeisException("ERROR: unexpected blank characters reading SEED blockette: starting at byte= " + sEEDVolumeParser.getFilePosition());
                }
                if (bl) {
                    this.headerFieldString = this.headerFieldString + "Blockette " + this.numBlockettesRead + ": type=" + ((Blockette)seedObject).getType() + ": name=" + ((Blockette)seedObject).getName() + ": (first occurence): " + string + ((Blockette)seedObject).toString() + string;
                }
                ++this.numBlockettesRead;
                int n2 = ((Blockette)seedObject).getType();
                block1 : switch (n2) {
                    case 1000: {
                        int n3;
                        int n4 = Integer.valueOf((String)((Blockette)seedObject).getFieldVal(5));
                        n = 1;
                        for (n3 = 0; n3 < n4; ++n3) {
                            n *= 2;
                        }
                        n3 = new Byte((String)((Blockette)seedObject).getFieldVal(3)).byteValue();
                        switch (n3) {
                            case 10: {
                                string2 = "Steim1";
                                break block1;
                            }
                            case 11: {
                                string2 = "Steim2";
                                break block1;
                            }
                        }
                        string2 = "UNKNOWN";
                        break;
                    }
                }
                long l = sEEDVolumeParser.getNextBlocketteByteNumber();
                long l2 = l > 0L ? l - (long)sEEDVolumeParser.getRecordPosition() : (long)(this.beginningOfData - sEEDVolumeParser.getRecordPosition());
                sEEDVolumeParser.skipBytesCheckHeaders((int)l2);
            }
            Btime btime = (Btime)blockette.getFieldVal(8);
            seedObject = sEEDVolumeParser.readDataRecord(n, string2, blockette);
            vector.addElement(seedObject);
            vector2.addElement(btime);
            bl = false;
        }
        this.sample = this.getSampleArray(vector, vector2);
    }

    protected boolean isSameTrace(Blockette blockette) throws Exception {
        if (!this.channel.chanName.equals(UNDEF_STRING) && !this.channel.chanName.equals((String)blockette.getFieldVal(6))) {
            return false;
        }
        if (!this.channel.staName.equals(UNDEF_STRING) && !this.channel.staName.equals(this.getStationName(blockette))) {
            return false;
        }
        if (!this.channel.network.equals(UNDEF_STRING) && !this.channel.network.equals((String)blockette.getFieldVal(7))) {
            return false;
        }
        return this.evtName.equals(UNDEF_STRING) || this.evtName.equals((String)blockette.getFieldVal(5));
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
    }

    public void setSeismogramFields() {
        SeisDataSEEDMini seisDataSEEDMini = this;
        String string = "counts";
        this.timeSeries = new TimeSeriesFloat(seisDataSEEDMini.sample, 1.0 / this.sampleRate, 0.0, string, "sec");
        this.timeMin = 0.0;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        if (this.channel.chanName.toUpperCase().endsWith("Z")) {
            d = 0.0;
            if (!(d2 > 179.99999) || !(d2 < 180.00001)) {
                d2 = 0.0;
            }
        } else if (this.channel.chanName.toUpperCase().endsWith("N")) {
            d = 0.0;
            d2 = 90.0;
        } else if (this.channel.chanName.toUpperCase().endsWith("E")) {
            d = 90.0;
            d2 = 90.0;
        }
        this.channel.azimuth = d;
        this.channel.inclination = d2;
    }

    public String getHeaderFieldsAsString() {
        String string = System.getProperty("line.separator");
        String string2 = "# [mini-SEED Data Format]" + string;
        string2 = string2 + "# Total number of blockettes read: " + this.numBlockettesRead + string;
        string2 = string2 + this.headerFieldString + string;
        return string2;
    }

    public static int canRead(BinaryInputStream binaryInputStream) {
        try {
            byte[] byArray = new byte[8];
            int n = binaryInputStream.read(byArray);
            if (n == 8) {
                String string = new String(byArray).substring(0, 6);
                int n2 = new Integer(string);
                if (n2 < 0) {
                    return -1;
                }
                if (new String("DRQ ").indexOf(byArray[6]) < 0) {
                    return -1;
                }
                if (new String("PS ").indexOf(byArray[7]) < 0) {
                    return -1;
                }
                return 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }
}

