/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import net.alomax.geog.DistanceAzimuth;
import net.alomax.geog.Position;
import net.alomax.geog.SphericalTrig;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import net.alomax.util.PhysicalUnits;
import net.alomax.util.TimeInstant;
import sdsu.io.ASCIIInputStream;

public class SeisDataSEESLO
extends SeisData {
    public void read(ASCIIInputStream aSCIIInputStream) throws Exception {
        double d;
        int n = -1;
        float[] fArray = new float[]{};
        double d2 = -1.0;
        String string = "?";
        String string2 = "?";
        int n2 = 0;
        int n3 = (int)Math.round(Double.parseDouble(aSCIIInputStream.readWord()));
        if (DEBUG_LEVEL > 0) {
            System.out.println("maxhed " + n3);
        }
        ++n2;
        double d3 = Double.parseDouble(aSCIIInputStream.readWord());
        this.channel.staPosition.longitude = d3 * 0.009;
        if (DEBUG_LEVEL > 0) {
            System.out.println("longitude " + this.channel.staPosition.longitude);
        }
        ++n2;
        double d4 = Double.parseDouble(aSCIIInputStream.readWord());
        this.channel.staPosition.latitude = d4 * 0.009;
        if (DEBUG_LEVEL > 0) {
            System.out.println("latitude " + this.channel.staPosition.latitude);
        }
        ++n2;
        int n4 = (int)Math.round(Double.parseDouble(aSCIIInputStream.readWord()));
        if (DEBUG_LEVEL > 0) {
            System.out.println("icomp " + n4);
        }
        ++n2;
        float f = 1.0f;
        if (n4 == 1) {
            this.channel.azimuth = 90.0;
            this.channel.inclination = 90.0;
            this.channel.compName = "X";
        } else if (n4 == 2) {
            this.channel.azimuth = 0.0;
            this.channel.inclination = 90.0;
            this.channel.compName = "y";
            f = -1.0f;
        } else if (n4 == 3) {
            this.channel.azimuth = 0.0;
            this.channel.inclination = 0.0;
            this.channel.compName = "Z";
            f = -1.0f;
        }
        this.timeMin = Double.parseDouble(aSCIIInputStream.readWord());
        if (DEBUG_LEVEL > 0) {
            System.out.println("timeMin " + this.timeMin);
        }
        ++n2;
        d2 = Double.parseDouble(aSCIIInputStream.readWord());
        if (DEBUG_LEVEL > 0) {
            System.out.println("sampleInt " + d2);
        }
        ++n2;
        n = (int)Math.round(Double.parseDouble(aSCIIInputStream.readWord()));
        if (DEBUG_LEVEL > 0) {
            System.out.println("npoints " + n);
        }
        ++n2;
        int n5 = (int)Math.round(Double.parseDouble(aSCIIInputStream.readWord()));
        if (DEBUG_LEVEL > 0) {
            System.out.println("itype " + n5);
        }
        ++n2;
        if (n5 == 0) {
            string = "m";
        } else if (n5 == 1) {
            string = PhysicalUnits.timeDerivative("m");
        }
        this.channel.staPosition.depth = d = Double.parseDouble(aSCIIInputStream.readWord());
        if (DEBUG_LEVEL > 0) {
            System.out.println("staPosition.depth " + this.channel.staPosition.depth);
        }
        ++n2;
        this.evtName = "SEESLO";
        this.iyear = 2000;
        this.ijday = 1;
        this.ihour = 0;
        this.imin = 0;
        this.sec = 0.0;
        String string3 = "" + Math.round(d3);
        while (string3.length() < 3) {
            string3 = "0" + string3;
        }
        String string4 = "" + Math.round(d4);
        while (string4.length() < 3) {
            string4 = "0" + string4;
        }
        String string5 = "" + Math.round(d);
        while (string5.length() < 3) {
            string5 = "0" + string5;
        }
        this.channel.staName = "" + string3 + "_" + string4 + "_" + string5;
        this.channel.instName = "SYNTH";
        string2 = "sec";
        this.hypocenter.position.latitude = 20.0 / Math.tan(0.17453292519943295) * 0.009;
        this.hypocenter.position.longitude = 0.0;
        this.hypocenter.position.depth = 30.0;
        this.hypocenter.otime = TimeInstant.create("2000,01,01,00,00,00,00", ",");
        Position position = this.hypocenter.position;
        Position position2 = this.channel.staPosition;
        DistanceAzimuth distanceAzimuth = SphericalTrig.distAz(position, position2);
        this.gcarc = distanceAzimuth.toDegrees().distance;
        this.dist = distanceAzimuth.toKilometers().distance;
        this.az = distanceAzimuth.toDegrees().azimuth;
        this.baz = SphericalTrig.distAz((Position)position2, (Position)position).azimuth;
        while (n2 < n3) {
            aSCIIInputStream.readWord();
            ++n2;
        }
        fArray = new float[n];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f * Float.parseFloat(aSCIIInputStream.readWord());
        }
        if (fArray.length < 1) {
            System.out.println("WARNING: no data points read.");
        }
        this.timeSeries = new TimeSeriesFloat(fArray, d2, 0.0, string, string2);
    }

    public static int canRead(ASCIIInputStream aSCIIInputStream) {
        try {
            int n = 0;
            while (n++ < 5) {
                String string = aSCIIInputStream.readWord();
                if (string.indexOf("SG2K_ASCII") < 0) continue;
                return 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    public void setSeismogramFields() {
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
        this.timeSeries = basicSeismogram.timeSeries;
        this.channel = basicSeismogram.channel;
        this.evtName = basicSeismogram.evtName;
        this.hypocenter = basicSeismogram.hypocenter;
        this.gcarc = basicSeismogram.gcarc;
        this.dist = basicSeismogram.dist;
        this.az = basicSeismogram.az;
        this.baz = basicSeismogram.baz;
        this.iyear = basicSeismogram.iyear;
        this.ijday = basicSeismogram.ijday;
        this.ihour = basicSeismogram.ihour;
        this.imin = basicSeismogram.imin;
        this.sec = basicSeismogram.sec;
        this.timeMin = basicSeismogram.timeMin;
    }
}

