/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.io.IOException;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicHypocenter;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import net.alomax.seis.SeisException;
import net.alomax.util.PhysicalUnits;
import net.alomax.util.TimeInstant;
import sdsu.io.ASCIIInputStream;

public class SeisDataSMC
extends SeisData {
    protected static boolean VERBOSE = false;
    protected int index = 0;
    String[] textHeader = null;
    int[] integerHeader = null;
    double[] realHeader = null;
    protected float[] sample;
    double undefinedRealValue = -1.0;
    double undefinedIntegerValue = -1.0;
    double sampleRate = -1.0;
    String dataUnits = "counts";

    public void read(ASCIIInputStream aSCIIInputStream) throws Exception {
        try {
            int n;
            int n2;
            this.textHeader = new String[11];
            for (n2 = 0; n2 < 11; ++n2) {
                this.textHeader[n2] = aSCIIInputStream.readLine();
                if (!VERBOSE) continue;
                System.out.println("textHeader[" + n2 + "]: " + this.textHeader[n2]);
            }
            this.integerHeader = new int[48];
            if (VERBOSE) {
                System.out.print("integerHeader:  ");
            }
            for (n2 = 0; n2 < 48; ++n2) {
                this.integerHeader[n2] = Integer.parseInt(aSCIIInputStream.readWord());
                if (!VERBOSE) continue;
                System.out.print("[" + n2 + "] " + this.integerHeader[n2] + ",  ");
            }
            aSCIIInputStream.flushLine();
            if (VERBOSE) {
                System.out.println("");
            }
            this.realHeader = new double[50];
            if (VERBOSE) {
                System.out.print("realHeader:  ");
            }
            for (n2 = 0; n2 < 50; ++n2) {
                this.realHeader[n2] = Double.parseDouble(aSCIIInputStream.readWord());
                if (!VERBOSE) continue;
                System.out.print("[" + n2 + "] " + this.realHeader[n2] + ",  ");
            }
            aSCIIInputStream.flushLine();
            if (VERBOSE) {
                System.out.println("");
            }
            n2 = this.integerHeader[15];
            for (n = 0; n < n2; ++n) {
                aSCIIInputStream.flushLine();
            }
            n = this.integerHeader[16];
            this.sample = new float[n];
            int n3 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                this.sample[n3] = aSCIIInputStream.readFloat();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.undefinedRealValue = this.realHeader[0];
        this.undefinedIntegerValue = this.integerHeader[0];
        this.sampleRate = this.realHeader[1];
        if (this.sampleRate == this.undefinedRealValue) {
            throw new SeisException("ERROR: unevenly-sampled time series not supported: Sampling rate = " + this.realHeader[1]);
        }
        int n = Integer.parseInt(this.textHeader[0].substring(0, 1));
        if (n == 0) {
            this.dataUnits = "counts";
        } else if (n == 1) {
            this.dataUnits = PhysicalUnits.timeDerivative(PhysicalUnits.timeDerivative("cm"));
        } else if (n == 2) {
            this.dataUnits = PhysicalUnits.timeDerivative(PhysicalUnits.timeDerivative("cm"));
        } else if (n == 3) {
            this.dataUnits = PhysicalUnits.timeDerivative("cm");
        } else if (n == 4) {
            this.dataUnits = "cm";
        } else {
            throw new SeisException("ERROR: data type not supported: data type = " + this.textHeader[0]);
        }
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
    }

    public void setSeismogramFields() {
        SeisDataSMC seisDataSMC = this;
        this.timeSeries = new TimeSeriesFloat(seisDataSMC.sample, 1.0 / this.sampleRate, 0.0, this.dataUnits, "sec");
        this.timeMin = 0.0;
        this.iyear = this.integerHeader[1];
        this.ijday = this.integerHeader[2];
        this.ihour = this.integerHeader[3];
        this.imin = this.integerHeader[4];
        this.sec = (double)this.integerHeader[5] + (double)this.integerHeader[6] / 1000.0;
        this.channel.network = this.textHeader[7].substring(35).trim();
        this.channel.staName = this.textHeader[2].substring(0, 4).trim();
        this.channel.instName = this.textHeader[7].substring(10, 15).trim();
        this.channel.chanName = "" + this.integerHeader[5];
        this.channel.compName = this.textHeader[5].substring(52).trim();
        this.evtName = this.textHeader[3].substring(26).trim();
        if ((double)this.integerHeader[13] == this.undefinedIntegerValue) {
            this.channel.azimuth = 0.0;
        } else {
            this.channel.azimuth = this.integerHeader[13];
            if (this.channel.azimuth >= 360.0) {
                this.channel.azimuth -= 360.0;
            }
        }
        this.channel.inclination = (double)this.integerHeader[12] == this.undefinedIntegerValue ? 90.0 : (double)this.integerHeader[12];
        this.channel.staPosition.latitude = this.realHeader[10];
        this.channel.staPosition.longitude = this.realHeader[11];
        this.channel.staPosition.elevation = this.realHeader[12] / 1000.0;
        this.channel.staPosition.depth = this.realHeader[15] / 1000.0;
        int n = Integer.parseInt(this.textHeader[3].substring(5, 9));
        int n2 = Integer.parseInt(this.textHeader[3].substring(11, 13));
        int n3 = Integer.parseInt(this.textHeader[3].substring(15, 17));
        int n4 = Integer.parseInt(this.textHeader[3].substring(21, 23));
        int n5 = Integer.parseInt(this.textHeader[3].substring(23, 25));
        double d = 0.0;
        try {
            this.hypocenter.otime = new TimeInstant(n, n2, n3, n4, n5, d);
        }
        catch (Exception exception) {
            this.hypocenter.otime = BasicHypocenter.UNDEF_OTIME;
        }
        this.hypocenter.position.latitude = this.realHeader[2];
        this.hypocenter.position.longitude = this.realHeader[3];
        this.hypocenter.position.elevation = 0.0;
        this.hypocenter.position.depth = this.realHeader[4];
        this.dist = this.realHeader[16];
        this.gcarc = this.realHeader[16] * 90.0 / 10000.0;
        this.az = this.realHeader[17];
    }

    public static int canRead(ASCIIInputStream aSCIIInputStream) {
        try {
            byte[] byArray = new byte[100];
            aSCIIInputStream.read(byArray);
            String string = new String(byArray);
            if (VERBOSE) {
                System.out.println("canRead.line: <" + string + ">");
            }
            if (string.indexOf("0 UNKNOWN") >= 0 || string.indexOf("1 UNCORRECTED ACCELEROGRAM") >= 0 || string.indexOf("2 CORRECTED ACCELEROGRAM") >= 0 || string.indexOf("3 VELOCITY") >= 0 || string.indexOf("4 DISPLACEMENT") >= 0 || string.indexOf("5 RESPONSE SPECTRA") >= 0 || string.indexOf("6 FOURIER AMPLITUDE") >= 0) {
                return 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }
}

